/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.microarray;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.Selector;
import ca.ucalgary.bluejay.gui.VisibilityManager;
import ca.ucalgary.bluejay.gui.microarray.CentroidViewer;
import ca.ucalgary.bluejay.gui.microarray.HTMLWriter;
import ca.ucalgary.bluejay.gui.painter.AbstractLinearPainter;
import ca.ucalgary.bluejay.gui.util.DescriptiveFileFilter;
import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;

public class MicroArrayClusterRatioGUI
extends JFrame
implements HyperlinkListener,
MouseListener,
ActionListener,
MouseMotionListener {
    public static final String DEFAULT_STATUS_MSG = "Click a hyperlink to connect to Gene Card information";
    public static final String SAVE_GENE_LIST_CMD = "Save Gene List";
    public static final String SAVE_GENE_LIST_TITLE = "Save Gene List to File";
    public static final String GENE_LIST_FILE_DESC = "Expression text file";
    public static final String GENE_LIST_FILE_EXT = ".txt";
    private BluejayDObjectList dlist;
    private JEditorPane editorPane;
    private JLabel status;
    private JButton saveButton;
    private JButton saveListButton;
    private JButton closeButton;
    private JToolBar toolbar;
    private boolean isClusterFile = false;
    private HTMLWriter writer;
    private URI clusterImageFile;
    private TreeMap geneDistances;
    private JSlider slide;
    private CentroidViewer viewer;

    public MicroArrayClusterRatioGUI(HTMLWriter hTMLWriter, CentroidViewer centroidViewer, TreeMap treeMap, BluejayDObjectList bluejayDObjectList) {
        this.setTitle("Gene Cluster");
        this.setSize(900, 900);
        this.setResizable(false);
        this.writer = hTMLWriter;
        this.setDList(bluejayDObjectList);
        this.geneDistances = treeMap;
        this.viewer = centroidViewer;
        this.buildGUIElements();
    }

    public URI createClusterImage() {
        JComponent jComponent = this.viewer.getContentComponent();
        File file = null;
        try {
            file = File.createTempFile("cluster", ".jpeg");
            file.deleteOnExit();
        }
        catch (IOException iOException) {
            System.err.println("Cluster image file could not be created.");
            iOException.printStackTrace();
        }
        try {
            int n = ((Component)jComponent).getWidth();
            int n2 = ((Component)jComponent).getHeight();
            BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            ((Component)jComponent).paint(graphics2D);
            graphics2D.dispose();
            ImageIO.write((RenderedImage)bufferedImage, "jpeg", file);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        return file.toURI();
    }

    private void buildGUIElements() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        this.toolbar = new JToolBar();
        this.saveButton = new JButton("Save Report");
        this.saveButton.setActionCommand("Save");
        this.saveButton.addActionListener(this);
        this.toolbar.add(this.saveButton);
        this.saveListButton = new JButton(SAVE_GENE_LIST_CMD);
        this.saveListButton.setActionCommand(SAVE_GENE_LIST_CMD);
        this.saveListButton.addActionListener(this);
        this.toolbar.add(this.saveListButton);
        this.toolbar.addSeparator();
        this.closeButton = new JButton("Close");
        this.closeButton.setActionCommand("Close");
        this.closeButton.addActionListener(this);
        this.toolbar.add(this.closeButton);
        this.getContentPane().add((Component)this.toolbar, "North");
        this.viewer.setMinimumSize(new Dimension(400, 400));
        this.viewer.setPreferredSize(new Dimension(400, 400));
        this.viewer.setCutoffRatio(1.0f);
        jPanel.add(this.viewer);
        this.slide = new JSlider();
        this.slide.setBorder(BorderFactory.createEtchedBorder());
        this.slide.setOrientation(0);
        this.slide.setValue(this.slide.getMaximum());
        this.slide.addMouseListener(this);
        this.slide.addMouseMotionListener(this);
        jPanel.add(this.slide);
        this.viewer.repaint();
        this.editorPane = new JEditorPane();
        this.editorPane.setEditable(false);
        this.editorPane.addMouseListener(this);
        this.editorPane.addHyperlinkListener(this);
        this.editorPane.setContentType("text/html");
        JScrollPane jScrollPane = new JScrollPane(this.editorPane);
        jPanel.add(jScrollPane);
        this.getContentPane().add((Component)jPanel, "Center");
        this.status = new JLabel(DEFAULT_STATUS_MSG);
        this.status.setAlignmentX(0.0f);
        this.getContentPane().add((Component)this.status, "South");
        this.setDefaultCloseOperation(2);
    }

    public void displayPage(URI uRI) {
        try {
            Document document = this.editorPane.getDocument();
            document.putProperty("stream", null);
            this.editorPane.setPage(uRI.toURL());
            this.editorPane.scrollToReference("start");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        URL uRL = hyperlinkEvent.getURL();
        if (uRL == null) {
            this.status.setText("Failed: could not parse hyperlink: " + hyperlinkEvent.getDescription());
            System.err.println("Failed: could not parse hyperlink: " + hyperlinkEvent.getDescription());
        }
        String string = uRL.getRef();
        String string2 = "(\\/\\d+)+";
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (string != null && string.matches(string2)) {
                DTDElementInstance dTDElementInstance = this.dlist.getDTDElementInstance(string);
                Selector selector = this.dlist.getSelector();
                if (dTDElementInstance == null) {
                    System.err.println("No element was found in the document for the xPointer " + string);
                    return;
                }
                AbstractLinearPainter abstractLinearPainter = dTDElementInstance.getPainter();
                if (abstractLinearPainter == null) {
                    System.err.println("Feature has no painter, could not refocus canvas");
                    return;
                }
                int[] nArray = abstractLinearPainter.getFeatureRange(dTDElementInstance);
                if (nArray == null) {
                    System.err.println("Feature has no position range, could not refocus canvas");
                    return;
                }
                int n = (nArray[0] + nArray[1]) / 2;
                selector.setSelection(dTDElementInstance, false);
                VisibilityManager visibilityManager = this.dlist.getVisibilityManager();
                if (visibilityManager.isCompleteTargetDrawn(dTDElementInstance.getTarget()) && visibilityManager.getScale() >= 100.0) {
                    visibilityManager.setPropagation(false);
                    visibilityManager.setFocusPosition(dTDElementInstance.getTarget(), n);
                    visibilityManager.setPropagation(true);
                    visibilityManager.setScale(100.0);
                } else {
                    if (visibilityManager.isPositionDrawn(dTDElementInstance.getTarget(), nArray[0])) {
                        this.dlist.repaint(true);
                    }
                    visibilityManager.setFocusPosition(dTDElementInstance.getTarget(), n);
                }
            } else {
                this.status.setText("Launching Web browser for external link...");
                try {
                    BrowserLauncher.openURL(uRL.toString());
                }
                catch (IOException iOException) {
                    this.status.setText("Couldn't launch external browser");
                    System.err.println("Couldn't launch external browser for " + uRL + " because of I/O exception: " + iOException);
                }
            }
        }
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            if (string != null && string.matches(string2)) {
                this.status.setText("Click to go to this gene in the genome");
            } else {
                this.status.setText("Click to find out more");
            }
        }
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.status.setText(DEFAULT_STATUS_MSG);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof JSlider) {
            this.displayPage(this.writer.createHTMLFile(this.viewer.getShownCluster()));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.saveButton) {
            this.saveReportFile();
        } else if (actionEvent.getSource() == this.saveListButton) {
            this.saveGeneList();
        } else if (actionEvent.getActionCommand().equals("Close")) {
            this.dispose();
        }
    }

    private void saveGeneList() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.addChoosableFileFilter(new DescriptiveFileFilter(GENE_LIST_FILE_EXT, GENE_LIST_FILE_DESC));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setDialogTitle(SAVE_GENE_LIST_TITLE);
        int n = jFileChooser.showSaveDialog(null);
        if (n != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        String string = file.getName();
        if (string.indexOf(GENE_LIST_FILE_EXT) != string.length() - GENE_LIST_FILE_EXT.length()) {
            file = new File(file.getParent(), string + GENE_LIST_FILE_EXT);
        }
        try {
            ExperimentUtil.saveGeneCluster(file, this.viewer.getData(), this.viewer.getShownCluster());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "The gene list could not be saved to file (" + file + "):\n" + exception, "Save Error", 0);
        }
    }

    private void saveReportFile() {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showSaveDialog(null);
        if (n == 0) {
            String string = jFileChooser.getSelectedFile().toString();
            string = string + ".html";
            URI uRI = this.createClusterImage();
            this.writer.setClusterImage(uRI);
            this.writer.moveTemporaryFile(string, this.editorPane.getPage());
            try {
                URL uRL = new URL("file://" + string);
                try {
                    BrowserLauncher.openURL(uRL.toString());
                }
                catch (IOException iOException) {
                    System.err.println("Cannot make BrowserLauncher to launch url " + uRL + ", " + iOException.getMessage());
                    iOException.printStackTrace();
                }
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
    }

    public void setDList(BluejayDObjectList bluejayDObjectList) {
        this.dlist = bluejayDObjectList;
        this.writer.setDList(this.dlist);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof JSlider) {
            float f = this.slide.getMaximum();
            float f2 = this.slide.getValue();
            float f3 = f2 / f;
            this.viewer.setCutoffRatio(f3);
            this.viewer.repaint();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

