/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.microarray;

import ca.ucalgary.bluejay.client.URLLoader;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.menu.BookmarksMenuManager;
import ca.ucalgary.bluejay.gui.menu.ComparisonMenuManager;
import ca.ucalgary.bluejay.gui.menu.ViewMenuManager;
import ca.ucalgary.bluejay.gui.microarray.ExperimentInfo;
import ca.ucalgary.bluejay.gui.microarray.MicroarrayMutableTreeNode;
import ca.ucalgary.bluejay.gui.microarray.StringSplitter;
import ca.ucalgary.bluejay.session.SessionManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.microarray.mev.file.ExpressionFileLoader;
import org.tigr.microarray.mev.file.StanfordFileLoader;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;

public class MicroArrayOpenProjectGUI
implements TreeSelectionListener,
ActionListener,
MouseListener {
    private SessionManager sessionManager;
    private BookmarksMenuManager bookmarksManager;
    private ComparisonMenuManager comparisonManager;
    private ViewMenuManager viewManager;
    private FileWriter writer;
    private BufferedWriter bWriter;
    private FileReader reader;
    private BufferedReader bReader;
    private MultipleArrayViewer arrayViewer;
    private static File rootDir;
    private ClassLoader cl;
    private File temporaryFile;
    private JFrame mainFrame;
    private JPanel bottomPanel;
    private JTabbedPane tabbedPane;
    private JLabel dirLabel;
    private JButton changeData;
    private JButton loadData;
    private JButton addData;
    private JButton removeData;
    private JButton cancel;
    private JEditorPane infoPane;
    private JTree existingDataTree;
    private DefaultMutableTreeNode top;
    private ExpressionFileLoader[] fileLoaders;
    private ExpressionFileLoader selectedFileLoader;
    private SuperExpressionFileLoader superLoader = new SuperExpressionFileLoader(true);
    private BluejayDObjectList dlist;
    private URLLoader urlLoader;
    private Hashtable dataHashTable;
    private String[] header;

    public MicroArrayOpenProjectGUI(BookmarksMenuManager bookmarksMenuManager) {
        this.bookmarksManager = bookmarksMenuManager;
        if (rootDir == null) {
            rootDir = new File("MicroarrayData");
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MicroArrayOpenProjectGUI.this.initializeGUI();
            }
        });
        this.cl = this.getClass().getClassLoader();
    }

    private void setRootDir(File file) throws IllegalArgumentException {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Path provided to setRootDir(..) was not a directory: " + file);
        }
        rootDir = file;
        this.dirLabel.setText(rootDir.getAbsolutePath());
        this.tabbedPane.removeAll();
        this.tabbedPane.addTab("Projects", this.createOpenProjectGUI());
    }

    private void initializeGUI() {
        this.mainFrame = new JFrame("Microarray Project Loader");
        this.mainFrame.setSize(1000, 650);
        this.initializeFileLoaders();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("Projects", this.createOpenProjectGUI());
        this.mainFrame.getContentPane().add(this.tabbedPane);
        this.bottomPanel = new JPanel();
        this.dirLabel = new JLabel(rootDir.getAbsolutePath());
        this.bottomPanel.add(this.dirLabel);
        this.changeData = new JButton("Change Data Source");
        this.changeData.setEnabled(true);
        this.changeData.setActionCommand("Change");
        this.changeData.addActionListener(this);
        this.bottomPanel.add(this.changeData);
        this.bottomPanel.add(new JSeparator(1));
        this.removeData = new JButton("Disable Data");
        this.removeData.setEnabled(true);
        this.removeData.setActionCommand("Disable");
        this.removeData.addActionListener(this);
        this.bottomPanel.add(this.removeData);
        this.loadData = new JButton("Load Data");
        this.loadData.setEnabled(false);
        this.loadData.setActionCommand("Load");
        this.loadData.addActionListener(this);
        this.bottomPanel.add(this.loadData);
        this.cancel = new JButton("Cancel");
        this.cancel.setEnabled(true);
        this.cancel.setActionCommand("Cancel");
        this.cancel.addActionListener(this);
        this.bottomPanel.add(this.cancel);
        this.mainFrame.getContentPane().add((Component)this.bottomPanel, "South");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.mainFrame.setLocation((dimension.width - this.mainFrame.getSize().width) / 2, (dimension.height - this.mainFrame.getSize().height) / 2);
        this.mainFrame.setVisible(true);
    }

    private JPanel createOpenProjectGUI() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.infoPane = new JEditorPane();
        this.existingDataTree = this.createProjectTree();
        this.existingDataTree.addTreeSelectionListener(this);
        this.existingDataTree.addMouseListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.existingDataTree);
        this.infoPane.setEditable(false);
        JScrollPane jScrollPane2 = new JScrollPane(this.infoPane);
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setTopComponent(jScrollPane);
        jSplitPane.setBottomComponent(jScrollPane2);
        Dimension dimension = new Dimension(100, 100);
        jScrollPane.setMinimumSize(dimension);
        jScrollPane2.setMinimumSize(dimension);
        jSplitPane.setDividerLocation(300);
        jSplitPane.setPreferredSize(new Dimension(700, 500));
        jPanel.add(jSplitPane);
        return jPanel;
    }

    private JTree createProjectTree() {
        this.top = null;
        this.getList(this.top, rootDir, null);
        JTree jTree = new JTree(this.top);
        jTree.getSelectionModel().setSelectionMode(1);
        jTree.addTreeSelectionListener(this);
        return jTree;
    }

    public void getList(DefaultMutableTreeNode defaultMutableTreeNode, File file, URL uRL) {
        if (!file.isDirectory()) {
            try {
                ExperimentInfo experimentInfo = new ExperimentInfo(file.getName(), file.getAbsolutePath(), 1, uRL);
                experimentInfo.setStartColumn(1);
                experimentInfo.setStartRow(1);
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(experimentInfo);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (file.getName().lastIndexOf("CVS") == -1) {
            int n;
            Object[] objectArray;
            File[] fileArray;
            Object object = null;
            if (defaultMutableTreeNode == null) {
                object = new DefaultMutableTreeNode(file.getName());
                this.top = object;
            } else {
                fileArray = defaultMutableTreeNode.toString();
                object = this.bookmarksManager.getBookmarkHashTable().containsKey(fileArray) ? (objectArray = new MicroarrayMutableTreeNode(file.getName())) : new DefaultMutableTreeNode(file.getName());
                defaultMutableTreeNode.add((MutableTreeNode)object);
            }
            fileArray = file.listFiles();
            objectArray = new TimeSeriesFile[fileArray.length];
            for (n = 0; n < fileArray.length; ++n) {
                objectArray[n] = new TimeSeriesFile(fileArray[n]);
            }
            Arrays.sort(objectArray);
            for (n = 0; n < objectArray.length; ++n) {
                URL uRL2 = null;
                if (uRL == null) {
                    try {
                        uRL2 = new URL((String)this.bookmarksManager.getBookmarkHashTable().get(file.getName()));
                    }
                    catch (Exception exception) {
                        if (uRL2 != null) {
                            exception.printStackTrace();
                        }
                    }
                } else {
                    uRL2 = uRL;
                }
                this.getList((DefaultMutableTreeNode)object, (File)objectArray[n], uRL2);
            }
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.existingDataTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (defaultMutableTreeNode.isLeaf()) {
            this.loadData.setEnabled(true);
            ExperimentInfo experimentInfo = (ExperimentInfo)object;
            this.infoPane.setText(experimentInfo.getOutput());
        } else if (defaultMutableTreeNode instanceof MicroarrayMutableTreeNode) {
            this.loadData.setEnabled(true);
        } else {
            this.infoPane.setText("");
            this.loadData.setEnabled(false);
        }
    }

    public void setURLLoader(URLLoader uRLLoader) {
        this.urlLoader = uRLLoader;
    }

    private void getRootDirChoice() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Choose a root directory for microarray data");
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showOpenDialog(this.mainFrame);
        if (n == 0) {
            try {
                this.setRootDir(jFileChooser.getSelectedFile());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.mainFrame, "Could not change the data directory:\n" + exception, "Error Changing Data Directory", 0);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.existingDataTree.getModel();
            if (actionEvent.getActionCommand().equals("Load")) {
                this.fetchData(defaultTreeModel);
            } else if (actionEvent.getSource() == this.changeData) {
                this.getRootDirChoice();
            } else if (actionEvent.getActionCommand().equals("Disable")) {
                MutableTreeNode mutableTreeNode = (MutableTreeNode)this.existingDataTree.getLastSelectedPathComponent();
                if (mutableTreeNode == defaultTreeModel.getRoot() || mutableTreeNode == null) {
                    JOptionPane.showMessageDialog(null, "Cannot delete Experiments", "Error", 0);
                } else {
                    int n = JOptionPane.showConfirmDialog(null, "Do you want to disable \"" + mutableTreeNode + "\" from being loaded?", "Disable Data", 1);
                    if (n == 0) {
                        defaultTreeModel.removeNodeFromParent(mutableTreeNode);
                        this.loadData.setEnabled(false);
                        this.infoPane.setText("");
                    }
                }
            } else if (actionEvent.getActionCommand().equals("Cancel")) {
                this.mainFrame.dispose();
            }
        }
    }

    public void fetchData(DefaultTreeModel defaultTreeModel) {
        block24: {
            Object object;
            boolean bl = true;
            if (this.arrayViewer.isDataLoaded()) {
                object = new String[]{"Append", "Replace", "Cancel"};
                int n = JOptionPane.showOptionDialog(null, "There is still data loaded.  Do you want to append to this data?  NOTE: Selecting '" + (String)object[1] + "' will unload the currently loaded data", "Data Replacement Status", 1, 3, null, (Object[])object, object[2]);
                if (n == 0) {
                    bl = true;
                } else if (n == 1) {
                    this.dlist.enableMicroArrayMenu();
                    this.arrayViewer.unloadAllData();
                    bl = true;
                } else if (n == 2) {
                    bl = false;
                }
            }
            if (bl) {
                Cloneable cloneable;
                object = null;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.existingDataTree.getLastSelectedPathComponent();
                ExperimentInfo experimentInfo = null;
                int n = 0;
                if (defaultMutableTreeNode instanceof MicroarrayMutableTreeNode) {
                    try {
                        object = File.createTempFile("temp", null);
                        ((File)object).deleteOnExit();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    cloneable = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild();
                    experimentInfo = (ExperimentInfo)cloneable.getUserObject();
                    n = experimentInfo.getFileFormat();
                    this.arrayViewer.setExperimentName(defaultMutableTreeNode.toString());
                    this.parseData(defaultTreeModel, (File)object);
                } else if (defaultMutableTreeNode instanceof DefaultMutableTreeNode) {
                    this.arrayViewer.setExperimentName(defaultMutableTreeNode.getParent().toString());
                    experimentInfo = (ExperimentInfo)defaultMutableTreeNode.getUserObject();
                    object = new File(experimentInfo.getFileLocation());
                    experimentInfo = (ExperimentInfo)defaultMutableTreeNode.getUserObject();
                    n = experimentInfo.getFileFormat();
                }
                this.dlist.getExperimentSelector().setExperimentName(" Experiment Name : " + this.arrayViewer.getExperimentName());
                this.selectedFileLoader = this.fileLoaders[n];
                cloneable = null;
                if (this.selectedFileLoader instanceof StanfordFileLoader) {
                    try {
                        JFileChooser jFileChooser;
                        Object object2 = object;
                        ((StanfordFileLoader)this.selectedFileLoader).setXColumns(experimentInfo.getStartColumn());
                        ((StanfordFileLoader)this.selectedFileLoader).setXRows(experimentInfo.getStartRow());
                        cloneable = ((StanfordFileLoader)this.selectedFileLoader).loadStanfordExpressionFile((File)object2);
                        this.mainFrame.dispose();
                        if (cloneable != null) {
                            this.arrayViewer.fireDataLoaded(this.toISlideDataArray((Vector)cloneable), n);
                        }
                        if (this.sessionManager.isConnected()) {
                            if (this.dlist.getWaypointsWidget().getNumWaypoints() > 0) {
                                this.dlist.getWaypointsWidget().selectAllWaypoints(true);
                                this.dlist.getWaypointsWidget().removeSelectedWaypoints(false);
                                if (this.dlist.getWaypointsTab() != null) {
                                    this.viewManager.getTabbedPane().remove(this.dlist.getWaypointsTab());
                                }
                                this.dlist.setWaypointsTab(null);
                            }
                            if (this.dlist.getAbstractLinearGraphics().isInTextMode()) {
                                this.viewManager.setDefaultView();
                            }
                            this.viewManager.enableInitiallyDisabledViewMenus();
                            if (ComparisonMenuManager.isComparison) {
                                // empty if block
                            }
                            this.comparisonManager.setMasterURL(experimentInfo.getURL());
                            this.comparisonManager.enableAddMenu();
                            this.urlLoader.gotoURL(experimentInfo.getURL(), true);
                            break block24;
                        }
                        int n2 = JOptionPane.showConfirmDialog(null, "No connection to internet.  Please load manual genome file.", "Error", 2);
                        if (n2 != 0 || (n2 = (jFileChooser = new JFileChooser()).showOpenDialog(null)) != 0) break block24;
                        try {
                            URL uRL = jFileChooser.getSelectedFile().toURL();
                            if (!uRL.equals(this.urlLoader.getActualURLName())) {
                                this.urlLoader.gotoURL(uRL, true);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
    }

    public void parseData(DefaultTreeModel defaultTreeModel, File file) {
        String[] stringArray;
        Object object;
        Object object2;
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        int n4 = 0;
        StringSplitter stringSplitter = new StringSplitter('\t');
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.existingDataTree.getLastSelectedPathComponent();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        int[] nArray = new int[defaultMutableTreeNode.getChildCount() + 1];
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            object2 = (ExperimentInfo)defaultMutableTreeNode2.getUserObject();
            try {
                object = new File(((ExperimentInfo)object2).getFileLocation());
                this.reader = new FileReader((File)object);
                this.bReader = new BufferedReader(this.reader);
                stringSplitter.init(this.bReader.readLine());
                nArray[n2] = n4 += stringSplitter.countTokens();
                ++n2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        enumeration = defaultMutableTreeNode.children();
        defaultMutableTreeNode2 = null;
        n = 0;
        this.dataHashTable = new Hashtable();
        this.header = new String[++n4];
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            object2 = (ExperimentInfo)defaultMutableTreeNode2.getUserObject();
            n2 = 0;
            try {
                object = new File(((ExperimentInfo)object2).getFileLocation());
                this.reader = new FileReader((File)object);
                this.bReader = new BufferedReader(this.reader);
                stringSplitter.init(this.bReader.readLine());
                n3 = stringSplitter.countTokens();
                int n5 = 0;
                while (stringSplitter.hasMoreTokens()) {
                    if (n5 == 0) {
                        this.header[0] = stringSplitter.nextToken();
                        n5 = n3;
                        ++n2;
                    }
                    this.header[nArray[n] + n2] = stringSplitter.nextToken();
                    ++n2;
                    ++n5;
                }
                String string = this.bReader.readLine();
                while (string != null) {
                    String[] stringArray2;
                    stringSplitter.init(string);
                    n2 = 0;
                    stringArray = stringSplitter.nextToken();
                    if (!this.dataHashTable.containsKey(stringArray)) {
                        stringArray2 = new String[n4 - 1];
                        this.dataHashTable.put(stringArray, stringArray2);
                    }
                    stringArray2 = (String[])this.dataHashTable.get(stringArray);
                    while (stringSplitter.hasMoreTokens()) {
                        stringArray2[nArray[n] + n2] = stringSplitter.nextToken();
                        ++n2;
                    }
                    string = this.bReader.readLine();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
        object2 = this.dataHashTable.keys();
        object = "";
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedOutputStream(new FileOutputStream(file), 65536));
            object = (String)object + this.header[0];
            for (int i = 1; i < this.header.length; ++i) {
                object = (String)object + "\t";
                object = (String)object + this.header[i];
            }
            object = ((String)object).trim();
            object = (String)object + "\n";
            printWriter.write((String)object);
            object = "";
            while (object2.hasMoreElements()) {
                String string = (String)object2.nextElement();
                stringArray = (String[])this.dataHashTable.get(string);
                object = (String)object + string;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] != null) {
                        object = (String)object + "\t";
                        object = (String)object + stringArray[i];
                        continue;
                    }
                    object = (String)object + "\t";
                }
                object = ((String)object).trim();
                object = (String)object + "\n";
                printWriter.write((String)object);
                object = "";
            }
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setComparisonManager(ComparisonMenuManager comparisonMenuManager) {
        this.comparisonManager = comparisonMenuManager;
    }

    public void setViewManager(ViewMenuManager viewMenuManager) {
        this.viewManager = viewMenuManager;
    }

    public void setDList(BluejayDObjectList bluejayDObjectList) {
        this.dlist = bluejayDObjectList;
        this.arrayViewer = this.dlist.getAbstractLinearGraphics().getArrayViewer();
    }

    protected void initializeFileLoaders() {
        int n = 0;
        this.fileLoaders = new ExpressionFileLoader[5];
        this.fileLoaders[1] = new StanfordFileLoader(this.superLoader);
        this.selectedFileLoader = this.fileLoaders[n];
    }

    private ISlideData[] toISlideDataArray(Vector vector) {
        if (vector == null || vector.size() < 1) {
            return null;
        }
        ISlideData[] iSlideDataArray = new ISlideData[vector.size()];
        for (int i = 0; i < iSlideDataArray.length; ++i) {
            iSlideDataArray[i] = (ISlideData)vector.elementAt(i);
        }
        return iSlideDataArray;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.existingDataTree.getModel();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.existingDataTree.getLastSelectedPathComponent();
            if (defaultMutableTreeNode.isLeaf()) {
                this.fetchData(defaultTreeModel);
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private class TimeSeriesFile
    extends File {
        public TimeSeriesFile(File file) {
            super(file.toURI());
        }

        public int compareTo(File file) {
            if (this.getName().matches("\\A.*?([0-9\\.]+)[ _-]?([smhdjt]).*\\Z") && file.getName().matches("\\A.*?([0-9\\.]+)[ _-]?([smhdjt]).*\\Z")) {
                Double d = this.nameToTime(this.getName());
                return d.compareTo(this.nameToTime(file.getName()));
            }
            return super.compareTo(file);
        }

        public Double nameToTime(String string) {
            int n = 1;
            String string2 = string.replaceAll("\\A.*?([0-9\\.]+)[ _-]?([smhdjt]).*\\Z", "$2");
            if ("m".equals(string2)) {
                n = 60;
            }
            if ("h".equals(string2)) {
                n = 3600;
            }
            if ("d".equals(string2) || "j".equals(string2) || "t".equals(string2)) {
                n = 86400;
            }
            return new Double(Double.parseDouble(string.replaceAll("\\A.*?([0-9\\.]+)[ _-]?([smhdjt]).*\\Z", "$1")) * (double)n);
        }
    }
}

