/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.painter;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.client.LinearTarget;
import ca.ucalgary.bluejay.client.impl.BluejayDTDElementInstance;
import ca.ucalgary.bluejay.client.impl.BluejayNestedContentsDTDElementInstance;
import ca.ucalgary.bluejay.client.lineartarget.CircularLinearTarget;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.BluejayAbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.Legend;
import ca.ucalgary.bluejay.gui.MaskPainter;
import ca.ucalgary.bluejay.gui.comparison.ComparisonPool;
import ca.ucalgary.bluejay.gui.comparison.Genome;
import ca.ucalgary.bluejay.gui.comparison.LinkingLineInfo;
import ca.ucalgary.bluejay.gui.menu.ComparisonMenuManager;
import ca.ucalgary.bluejay.gui.painter.AGAVEPainter;
import ca.ucalgary.bluejay.gui.painter.BasicTargetPainter;
import ca.ucalgary.bluejay.gui.painter.LaneManager;
import ca.ucalgary.bluejay.gui.painter.LinkingLinePainter;
import ca.ucalgary.bluejay.gui.painter.TranslationPainter;
import ca.ucalgary.bluejay.gui.painter.WaypointsPainter;
import ca.ucalgary.bluejay.gui.util.ColorGenerator;
import ca.ucalgary.bluejay.gui.util.Debug;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import java.util.Vector;

public class AGAVEGenePainter
extends AGAVEPainter {
    private static final Color colorNoType = Color.gray;
    private static final String DEFAULT_LEGEND_LABEL = "No assigned type";
    private static final Color colorSmallType = Color.black;
    private static final String SMALL_ORF_LEGEND_LABEL = "Small unconfirmed ORF";
    private static final String SMALL_ORF_ATTR = "is_small";
    private static final int NUM_COLORS = 4096;
    private static final int NO_FRAME = -200;
    private static final boolean DO_NOT_ADD_LEGEND_ITEM = false;
    private Hashtable classColorMapping;
    private Hashtable legendSwatches;
    private LaneManager laneMgr;

    public AGAVEGenePainter(LaneManager laneManager) {
        this.laneMgr = laneManager;
        this.classColorMapping = new Hashtable(4096, 0.95f);
        this.legendSwatches = new Hashtable(4096, 0.95f);
        BufferedImage bufferedImage = new BufferedImage(Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT, 1);
        Graphics graphics = ((Image)bufferedImage).getGraphics();
        graphics.setColor(colorNoType);
        graphics.fillRect(0, 0, Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
        this.legendSwatches.put(DEFAULT_LEGEND_LABEL, bufferedImage);
        BufferedImage bufferedImage2 = new BufferedImage(Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT, 1);
        graphics = ((Image)bufferedImage2).getGraphics();
        graphics.setColor(colorSmallType);
        graphics.fillRect(0, 0, Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
        this.legendSwatches.put(SMALL_ORF_LEGEND_LABEL, bufferedImage2);
    }

    public void paint(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        LinkingLineInfo[] linkingLineInfoArray;
        Object object;
        Object object2;
        Object object3;
        if (!dTDElementInstance.isModelVisible() || dTDElementInstance == null) {
            return;
        }
        int n = dTDElementInstance.getTarget();
        int n2 = abstractLinearGraphics.getLOD();
        if (n == -1) {
            System.err.println("Ooops.  parent of " + dTDElementInstance.getLocalName() + " was not a target");
            return;
        }
        int n3 = dTDElementInstance.getSlaveNum();
        LinearTarget linearTarget = abstractLinearGraphics.getTarget(n);
        if (ComparisonMenuManager.isComparison && abstractLinearGraphics.getVisibilityManager().getDList().getComparisonPool().getPoolSize() > 1) {
            object3 = abstractLinearGraphics.getVisibilityManager().getDList().getComparisonPool();
            Genome genome = ((ComparisonPool)object3).getSeqsFromPool().elementAt(n3);
            if (linearTarget instanceof CircularLinearTarget) {
                double d = genome.getStartAngle();
                ((CircularLinearTarget)linearTarget).setMainStartAngle(d);
            }
        }
        object3 = abstractLinearGraphics.isInTextMode() ? this.getOrigFeatureRange(dTDElementInstance) : this.getFeatureRange(dTDElementInstance);
        boolean bl = object3[1] < object3[0];
        Object object4 = bl ? object3[1] : object3[0];
        Object object5 = bl ? object3[0] : object3[1];
        String string = ((BluejayDTDElementInstance)dTDElementInstance).getGoClass();
        double[] dArray = ((BluejayDTDElementInstance)dTDElementInstance).getLane();
        int n4 = ((BluejayDTDElementInstance)dTDElementInstance).getFrame();
        DTDElementInstance dTDElementInstance2 = ((BluejayDTDElementInstance)dTDElementInstance).getLinkDei();
        APPEARFRAME = n4;
        boolean bl2 = !bl;
        boolean bl3 = n2 == 80 && abstractLinearGraphics.getTarget(n).getScale() <= 1.0 && dTDElementInstance2 != null;
        String string2 = this.getPrimaryID(dTDElementInstance);
        if (string2 != null && abstractLinearGraphics.getArrayViewer().getGBToLocMap() != null) {
            if (abstractLinearGraphics.getArrayViewer().isPlayerSelected()) {
                abstractLinearGraphics.getArrayPlayerPainter().paint(abstractLinearGraphics, dTDElementInstance, this.laneMgr);
            } else if (abstractLinearGraphics.getArrayViewer().isComparisonSelected()) {
                abstractLinearGraphics.getArrayComparisonPainter().paint(abstractLinearGraphics, dTDElementInstance, this.laneMgr);
            } else {
                abstractLinearGraphics.getArrayPainter().paint(abstractLinearGraphics, dTDElementInstance, this.laneMgr);
            }
        }
        if (abstractLinearGraphics.getWaypointsWidget().getNumWaypoints() > 0) {
            object2 = ((BluejayDTDElementInstance)dTDElementInstance).getWaypointElementID();
            if (abstractLinearGraphics.getWaypointsWidget().getWaypointElementIds().contains(object2)) {
                object = abstractLinearGraphics.getWaypointsPainter();
                ((WaypointsPainter)object).setGeneLane(dArray);
                ((WaypointsPainter)object).paint(abstractLinearGraphics, dTDElementInstance, this.laneMgr);
            }
        }
        if (abstractLinearGraphics.isInTextMode() && (abstractLinearGraphics.isTwoFrameTranslation() || abstractLinearGraphics.isSixFrameTranslation())) {
            TranslationPainter.getInstance().paint(abstractLinearGraphics, dTDElementInstance);
        }
        object2 = abstractLinearGraphics.getColor();
        object = this.requestLegendItem(abstractLinearGraphics, dTDElementInstance, string, false);
        abstractLinearGraphics.setColor((Color)object);
        if (bl3) {
            abstractLinearGraphics.startHyperlink(dTDElementInstance2, true);
        }
        if (abstractLinearGraphics.isArrowShape()) {
            abstractLinearGraphics.fillArrowShape(n, (int)object4, (int)object5, dArray[0], dArray[1]);
        } else {
            if (dArray == null) {
                System.err.printf(">AGAVEGenePainter.paint(): Gene lane is null\n", new Object[0]);
            }
            if (dTDElementInstance.getAttribute("label").equals("gap")) {
                abstractLinearGraphics.setColor(Color.WHITE);
                abstractLinearGraphics.fillRect(n, (int)object4, (int)object5, dArray[1], dArray[1] - (dArray[0] - dArray[1]) / 2.0);
                abstractLinearGraphics.setColor((Color)object2);
                return;
            }
            abstractLinearGraphics.fillRect(n, (int)object4, (int)object5, dArray[0], dArray[1]);
        }
        if (bl3) {
            double d = dArray[0] > 0.0 ? dArray[0] : dArray[1];
            abstractLinearGraphics.updateHyperlink(abstractLinearGraphics.getPoint(n, (int)object4, d));
            abstractLinearGraphics.endHyperlink();
        }
        if (n2 == 80) {
            this.drawGeneLabel(abstractLinearGraphics, n, n3, dTDElementInstance.getAttribute("label"), (int)object4, (int)object5, bl2);
        }
        LinkingLinePainter linkingLinePainter = ((BluejayAbstractLinearGraphics)abstractLinearGraphics).getLLPainter();
        if (ComparisonMenuManager.isComparison && abstractLinearGraphics.getVisibilityManager().getDList().getComparisonPool().getPoolSize() > 1) {
            double d;
            double d2;
            double[] dArray2;
            int n5;
            int n6;
            Object object6;
            if (linkingLinePainter.isUsingParsomeColors() && ((String)(object6 = dTDElementInstance.getAttribute("paralogous_region"))).length() > 0) {
                abstractLinearGraphics.setColor(abstractLinearGraphics.getVisibilityManager().getDList().getParColor((String)object6));
            }
            if (linkingLinePainter.isLinkingOut() && (object6 = ((BluejayDTDElementInstance)dTDElementInstance).getLinkingLineInfo()) != null && (linkingLinePainter.isLinkingAll() || linkingLinePainter.isLinkingSame() && ((LinkingLineInfo)object6).getLinkDistPercent() == 0.0 || linkingLinePainter.isLinkingClose() && ((LinkingLineInfo)object6).getLinkDistPercent() < linkingLinePainter.getMaxLinkDistPercent())) {
                n6 = ((LinkingLineInfo)object6).getStart();
                n5 = ((LinkingLineInfo)object6).getEnd();
                dArray2 = ((LinkingLineInfo)object6).getLane();
                d2 = ((LinkingLineInfo)object6).getAngle();
                d = ((BluejayDTDElementInstance)dTDElementInstance).getAngle();
                abstractLinearGraphics.drawLinkingLine(n, (int)object4, (int)object5, dArray[0], dArray[1], d, n6, n5, dArray2[0], dArray2[1], d2);
            }
            if (linkingLinePainter.isLinkingIn() && (object6 = ((BluejayDTDElementInstance)dTDElementInstance).getLinkingLineReverseInfo()) != null && (linkingLinePainter.isLinkingAll() || linkingLinePainter.isLinkingSame() && ((LinkingLineInfo)object6).getLinkDistPercent() == 0.0 || linkingLinePainter.isLinkingClose() && ((LinkingLineInfo)object6).getLinkDistPercent() < linkingLinePainter.getMaxLinkDistPercent())) {
                n6 = ((LinkingLineInfo)object6).getStart();
                n5 = ((LinkingLineInfo)object6).getEnd();
                dArray2 = ((LinkingLineInfo)object6).getLane();
                d2 = ((LinkingLineInfo)object6).getAngle();
                d = ((BluejayDTDElementInstance)dTDElementInstance).getAngle();
                abstractLinearGraphics.drawLinkingLine(n, (int)object4, (int)object5, dArray[0], dArray[1], d, n6, n5, dArray2[0], dArray2[1], d2);
            }
        } else if (linkingLinePainter.isLinkingSelf() && (linkingLineInfoArray = ((BluejayDTDElementInstance)dTDElementInstance).getLinkingLineInfoArray()) != null && linkingLinePainter.isShowingFamily(linkingLineInfoArray[0].getCopyNumber()) && linkingLinePainter.isShowingParsome(dTDElementInstance.getAttribute("paralogous_region"))) {
            if (linkingLinePainter.isUsingParsomeColors()) {
                abstractLinearGraphics.setColor(abstractLinearGraphics.getVisibilityManager().getDList().getParColor(dTDElementInstance.getAttribute("paralogous_region")));
            }
            for (int i = 0; i < linkingLineInfoArray.length; ++i) {
                if (linkingLinePainter.isLinkAlreadyDrawn(linkingLineInfoArray[i].getStart(), (int)object4, linkingLineInfoArray[i].getGeneFamily())) continue;
                abstractLinearGraphics.drawLinkingLine(n, (int)object4, (int)object5, dArray[0], dArray[1], ((BluejayDTDElementInstance)dTDElementInstance).getAngle(), linkingLineInfoArray[i].getStart(), linkingLineInfoArray[i].getEnd(), linkingLineInfoArray[i].getLane()[0], linkingLineInfoArray[i].getLane()[1], linkingLineInfoArray[i].getAngle());
                linkingLinePainter.addLinkToDrawnLinks((int)object4, linkingLineInfoArray[i].getStart(), linkingLineInfoArray[i].getGeneFamily());
            }
        }
        abstractLinearGraphics.setColor((Color)object2);
    }

    public int getPriority() {
        return 60;
    }

    public void preProcess(AbstractLinearGraphics abstractLinearGraphics, MaskPainter maskPainter, DTDElementInstance dTDElementInstance) {
        super.preProcess(abstractLinearGraphics, maskPainter, dTDElementInstance);
        if (abstractLinearGraphics.getArrayViewer().isDataLoaded()) {
            abstractLinearGraphics.getArrayPainter().preProcess(abstractLinearGraphics, maskPainter, dTDElementInstance);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double[] getGeneLane(AbstractLinearGraphics abstractLinearGraphics, int n, boolean bl) throws Exception {
        String string = null;
        if (abstractLinearGraphics.isSingleFrameMode()) {
            string = "Single Frame lane";
            return this.laneMgr.getLane(string, abstractLinearGraphics.getLOD());
        } else if (bl) {
            if (n == -200 || !abstractLinearGraphics.isSixFrameMode()) {
                string = "Positive no-frame lane";
                return this.laneMgr.getLane(string, abstractLinearGraphics.getLOD());
            } else if (n == 1) {
                string = "Positive 1st frame lane";
                return this.laneMgr.getLane(string, abstractLinearGraphics.getLOD());
            } else if (n == 2) {
                string = "Positive 2nd frame lane";
                return this.laneMgr.getLane(string, abstractLinearGraphics.getLOD());
            } else {
                if (n != 3) throw new Exception("Cannot get lane in positive strand for frame " + n);
                string = "Positive 3rd frame lane";
            }
            return this.laneMgr.getLane(string, abstractLinearGraphics.getLOD());
        } else if (n == -200 || !abstractLinearGraphics.isSixFrameMode()) {
            string = "Negative no-frame lane";
            return this.laneMgr.getLane(string, abstractLinearGraphics.getLOD());
        } else if (n == -1) {
            string = "Negative 1st frame lane";
            return this.laneMgr.getLane(string, abstractLinearGraphics.getLOD());
        } else if (n == -2) {
            string = "Negative 2nd frame lane";
            return this.laneMgr.getLane(string, abstractLinearGraphics.getLOD());
        } else {
            if (n != -3) throw new Exception("Cannot get lane in negative strand for frame " + n);
            string = "Negative 3rd frame lane";
        }
        return this.laneMgr.getLane(string, abstractLinearGraphics.getLOD());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double[] getSlaveGeneLane(AbstractLinearGraphics abstractLinearGraphics, int n, boolean bl, int n2) throws Exception {
        String string = null;
        if (abstractLinearGraphics.isSingleFrameMode()) {
            string = "slave_single_frame" + n2;
            return this.laneMgr.getLane(string, abstractLinearGraphics.getLOD());
        } else if (bl) {
            if (n == -200 || !abstractLinearGraphics.isSixFrameMode()) {
                string = "slave_positive_noframe" + n2;
                return this.laneMgr.getLane(string, abstractLinearGraphics.getLOD());
            } else if (n == 1) {
                string = "slave_positive_oneframe" + n2;
                return this.laneMgr.getLane(string, abstractLinearGraphics.getLOD());
            } else if (n == 2) {
                string = "slave_positive_twoframe" + n2;
                return this.laneMgr.getLane(string, abstractLinearGraphics.getLOD());
            } else {
                if (n != 3) throw new Exception("Cannot get lane in positive strand for frame " + n);
                string = "slave_positive_threeframe" + n2;
            }
            return this.laneMgr.getLane(string, abstractLinearGraphics.getLOD());
        } else if (n == -200 || !abstractLinearGraphics.isSixFrameMode()) {
            string = "slave_negative_noframe" + n2;
            return this.laneMgr.getLane(string, abstractLinearGraphics.getLOD());
        } else if (n == -1) {
            string = "slave_negative_oneframe" + n2;
            return this.laneMgr.getLane(string, abstractLinearGraphics.getLOD());
        } else if (n == -2) {
            string = "slave_negative_twoframe" + n2;
            return this.laneMgr.getLane(string, abstractLinearGraphics.getLOD());
        } else {
            if (n != -3) throw new Exception("Cannot get lane in negative strand for frame " + n);
            string = "slave_negative_threeframe" + n2;
        }
        return this.laneMgr.getLane(string, abstractLinearGraphics.getLOD());
    }

    private void drawGeneLabel(AbstractLinearGraphics abstractLinearGraphics, int n, int n2, String string, int n3, int n4, boolean bl) throws Exception {
        String string2 = n2 != 0 ? (bl ? "slave_positive_gene_label" + n2 : "slave_negative_gene_label" + n2) : (bl ? "Positive gene label lane" : "Negative gene label lane");
        double[] dArray = this.laneMgr.getLane(string2, abstractLinearGraphics.getLOD());
        if (abstractLinearGraphics.getLOD() == 80 && abstractLinearGraphics.getTarget(n).getScale() <= 1.0) {
            int n5;
            double d = (double)(n4 - n3 + 1) * abstractLinearGraphics.getTarget(n).getScale();
            String string3 = string;
            if (string3.length() > abstractLinearGraphics.getMaxLabelLength()) {
                n5 = abstractLinearGraphics.getMaxLabelLength() - 3;
                string3 = n5 > 0 ? string3.substring(0, n5) : "";
                string3 = string3 + "...";
            }
            if (d >= 12.0) {
                int n6;
                n5 = (n3 + n4) / 2;
                int n7 = n6 = bl ? 30 : 40;
                if (abstractLinearGraphics.isLabelSpaceAvailable(n, string3, null, n5, dArray[0], dArray[1], n6)) {
                    abstractLinearGraphics.drawString(n, string3, null, n5, dArray[0], dArray[1], n6);
                }
            }
        }
    }

    public void updateLegendItem(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        Object object;
        String[] stringArray;
        if (!dTDElementInstance.isModelVisible() || dTDElementInstance == null) {
            return;
        }
        DTDElementInstance dTDElementInstance2 = null;
        int n = abstractLinearGraphics.getLOD();
        String string = null;
        int n2 = -200;
        int[] nArray = abstractLinearGraphics.isInTextMode() ? this.getOrigFeatureRange(dTDElementInstance) : this.getFeatureRange(dTDElementInstance);
        boolean bl = nArray[1] < nArray[0];
        int n3 = bl ? nArray[1] : nArray[0];
        int n4 = bl ? nArray[0] : nArray[1];
        int n5 = abstractLinearGraphics.getLOD();
        block4: for (stringArray = dTDElementInstance.getFirstChild(); stringArray != null; stringArray = stringArray.getNextSibling()) {
            Object object2;
            if (!(stringArray instanceof DTDElementInstance)) continue;
            if (((DTDElementInstance)stringArray).getLocalName().equals("seq_location")) {
                object2 = ((DTDElementInstance)stringArray).getAttribute("frame");
                if (object2 == null || ((String)object2).length() == 0) continue;
                try {
                    n2 = Integer.parseInt((String)object2);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println(numberFormatException.getMessage());
                }
                continue;
            }
            if (((DTDElementInstance)stringArray).getLocalName().equals("classification")) {
                if (!(stringArray instanceof BluejayNestedContentsDTDElementInstance)) continue;
                string = ((BluejayNestedContentsDTDElementInstance)stringArray).getNestedValue();
                continue;
            }
            if (n != 80 || !((DTDElementInstance)stringArray).getLocalName().equals("xrefs")) continue;
            for (object2 = ((DTDElementInstance)stringArray).getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
                if (!(object2 instanceof DTDElementInstance)) continue;
                dTDElementInstance2 = (DTDElementInstance)object2;
                continue block4;
            }
        }
        if (abstractLinearGraphics.getWaypointsWidget().getNumWaypoints() > 0) {
            int n6;
            if (this.laneMgr.getLane("waypoint lane", n5) == null) {
                stringArray = new String[]{"waypoint lane"};
                AGAVEGenePainter.requestLanes(this.laneMgr, this, n5, stringArray);
            }
            if ((n6 = abstractLinearGraphics.getVisibilityManager().getDList().getComparisonPool().getPoolSize()) > 1) {
                for (int i = 1; i < n6; ++i) {
                    if (this.laneMgr.getLane("slave_waypoint" + i, n5) != null) continue;
                    String[] stringArray2 = new String[]{"slave_waypoint" + i};
                    AGAVEGenePainter.requestLanes(this.laneMgr, this, n5, stringArray2);
                }
            }
        }
        APPEARFRAME = n2;
        boolean bl2 = !bl;
        int n7 = ((BluejayDTDElementInstance)dTDElementInstance).getSlaveNum();
        if (n5 == 80) {
            if (n7 != 0) {
                object = new String[]{"slave_positive_gene_label" + n7, "slave_negative_gene_label" + n7};
                AGAVEGenePainter.requestLanes(this.laneMgr, this, n5, (String[])object);
            } else {
                object = new String[]{"Positive gene label lane", "Negative gene label lane"};
                AGAVEGenePainter.requestLanes(this.laneMgr, this, n5, (String[])object);
            }
        }
        double[] dArray = n7 != 0 ? this.getSlaveGeneLane(abstractLinearGraphics, APPEARFRAME, bl2, n7) : this.getGeneLane(abstractLinearGraphics, APPEARFRAME, bl2);
        ((BluejayDTDElementInstance)dTDElementInstance).setStart(n3);
        ((BluejayDTDElementInstance)dTDElementInstance).setEnd(n4);
        ((BluejayDTDElementInstance)dTDElementInstance).setLane(dArray);
        ((BluejayDTDElementInstance)dTDElementInstance).setGoClass(string);
        ((BluejayDTDElementInstance)dTDElementInstance).setLinkDei(dTDElementInstance2);
        ((BluejayDTDElementInstance)dTDElementInstance).setFrame(n2);
        ((BluejayDTDElementInstance)dTDElementInstance).setIsComplement(bl);
        ((BluejayDTDElementInstance)dTDElementInstance).setLinked(false);
        ((BluejayDTDElementInstance)dTDElementInstance).setLinkedReverse(false);
        if (ComparisonMenuManager.isComparison && abstractLinearGraphics.getVisibilityManager().getDList().getComparisonPool().getPoolSize() > 1) {
            object = abstractLinearGraphics.getVisibilityManager().getDList().getComparisonPool().getSeqsFromPool();
            double d = ((Genome)((Vector)object).elementAt(0)).getGenomeLen();
            double d2 = (n3 + n4) / 2;
            double d3 = ((Genome)((Vector)object).elementAt(n7)).getStartAngle();
            double d4 = (d2 / d * 360.0 + d3) % 360.0;
            ((BluejayDTDElementInstance)dTDElementInstance).setAngle(d4);
            Object[] objectArray = new Object[]{dTDElementInstance, dArray, new Integer(n3), new Integer(n4), new Double(d4)};
            if (string != null && objectArray != null) {
                ((BluejayAbstractLinearGraphics)abstractLinearGraphics).getLLPainter().addDeiToPool(objectArray, string);
            }
        } else if (((BluejayAbstractLinearGraphics)abstractLinearGraphics).getLLPainter().isLinkingSelf()) {
            double d = (double)(n3 + n4) / 2.0;
            double d5 = (d / (double)BasicTargetPainter.targetLength * 360.0 + 270.0) % 360.0;
            ((BluejayDTDElementInstance)dTDElementInstance).setAngle(d5);
            Object[] objectArray = new Object[]{dTDElementInstance, dArray, new Integer(n3), new Integer(n4), new Double(d5)};
            if (string != null && objectArray != null) {
                ((BluejayAbstractLinearGraphics)abstractLinearGraphics).getLLPainter().addDeiToPoolSingle(objectArray, string);
            }
        }
        boolean bl3 = abstractLinearGraphics.getLegend().isAddingItems();
        Color color = this.requestLegendItem(abstractLinearGraphics, dTDElementInstance, string, bl3);
        try {
            if (abstractLinearGraphics.getArrayViewer().isDataLoaded()) {
                if (abstractLinearGraphics.getArrayViewer().isPlayerSelected()) {
                    abstractLinearGraphics.getArrayPlayerPainter().updateLegendItem(abstractLinearGraphics, dTDElementInstance, this.laneMgr);
                } else if (abstractLinearGraphics.getArrayViewer().isComparisonSelected()) {
                    abstractLinearGraphics.getArrayComparisonPainter().updateLegendItem(abstractLinearGraphics, dTDElementInstance, this.laneMgr);
                } else {
                    abstractLinearGraphics.getArrayPainter().updateLegendItem(abstractLinearGraphics, dTDElementInstance, this.laneMgr);
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Andrew is a bad boy: " + exception);
        }
        if (abstractLinearGraphics.isTwoFrameTranslation() || abstractLinearGraphics.isSixFrameTranslation()) {
            TranslationPainter.getInstance().updateLegendItem(abstractLinearGraphics, dTDElementInstance);
        }
    }

    private Color requestLegendItem(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance, String string, boolean bl) {
        Color color = colorNoType;
        Image image = null;
        String string2 = string;
        if (string != null) {
            color = (Color)this.classColorMapping.get(string);
            if (color == null) {
                int n = this.classColorMapping.size() + 1;
                try {
                    color = ColorGenerator.getColor(4096, n);
                    this.classColorMapping.put(string, color);
                    image = abstractLinearGraphics.getLegend().createImage(Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
                    Graphics graphics = image.getGraphics();
                    graphics.setColor(color);
                    graphics.fillRect(0, 0, Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
                    this.legendSwatches.put(string, image);
                }
                catch (Exception exception) {
                    color = colorNoType;
                    image = (Image)this.legendSwatches.get(DEFAULT_LEGEND_LABEL);
                }
            } else {
                image = (Image)this.legendSwatches.get(string);
            }
        } else if (dTDElementInstance.getAttribute(SMALL_ORF_ATTR) != null && !dTDElementInstance.getAttribute(SMALL_ORF_ATTR).equals("")) {
            image = (Image)this.legendSwatches.get(SMALL_ORF_LEGEND_LABEL);
            string2 = SMALL_ORF_LEGEND_LABEL;
        } else {
            image = (Image)this.legendSwatches.get(DEFAULT_LEGEND_LABEL);
        }
        if (Debug.legend && bl) {
            if (SMALL_ORF_LEGEND_LABEL.equals(string2)) {
                abstractLinearGraphics.getLegend().addItem(image, string2, "//agave:gene[@agave:is_small=true]", dTDElementInstance.getXPointer(), color);
            } else if (string2 != null) {
                String string3 = string2.replaceAll("'", "&apos;");
                abstractLinearGraphics.getLegend().addItem(image, string2, "//agave:gene[.//agave:classification/agave:description = '" + string3 + "']", dTDElementInstance.getXPointer(), color);
            } else {
                abstractLinearGraphics.getLegend().addItem(image, DEFAULT_LEGEND_LABEL, "//agave:gene[not(./agave:classification) and not(@agave:is_small)]", dTDElementInstance.getXPointer(), color);
            }
        }
        return color;
    }

    public String getLegendLabel(DTDElementInstance dTDElementInstance) {
        Object object;
        String string = null;
        for (object = dTDElementInstance.getFirstChild(); object != null; object = object.getNextSibling()) {
            if (!(object instanceof BluejayNestedContentsDTDElementInstance) || !((DTDElementInstance)object).getLocalName().equals("classification")) continue;
            string = ((BluejayNestedContentsDTDElementInstance)object).getNestedValue();
        }
        object = string;
        if (string == null) {
            object = dTDElementInstance.getAttribute(SMALL_ORF_ATTR) != null && !dTDElementInstance.getAttribute(SMALL_ORF_ATTR).equals("") ? SMALL_ORF_LEGEND_LABEL : DEFAULT_LEGEND_LABEL;
        }
        return object;
    }
}

