/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.painter;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.gui.menu.ComparisonMenuManager;
import ca.ucalgary.bluejay.gui.painter.AGAVEOligoPainter;
import ca.ucalgary.bluejay.gui.painter.LaneGetter;
import java.util.SortedMap;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AGAVEPainter
extends LaneGetter {
    public static final String REPEAT_LANE = "AGAVE repeat lane";
    public static final String POSITIVE_RNA_LANE = "Positive RNA lane";
    public static final String NEGATIVE_RNA_LANE = "Negative RNA lane";
    public static final String POSITIVE_OLIGO_TICK_LANE = "Positive oligo lane";
    public static final String NEGATIVE_OLIGO_TICK_LANE = "Negative oligo lane";
    public static final String POSITIVE_OLIGO_LABEL_LANE = "Positive oligo label lane";
    public static final String NEGATIVE_OLIGO_LABEL_LANE = "Negative oligo label lane";
    public static final String POSITIVE_TRANSCRIPT_LABEL_LANE = "Positive transcript label lane";
    public static final String NEGATIVE_TRANSCRIPT_LABEL_LANE = "Negative transcript label lane";
    public static final String POSITIVE_TRANSCRIPT_LANE = "Positive transcript lane";
    public static final String NEGATIVE_TRANSCRIPT_LANE = "Negative transcript lane";
    public static final String POSITIVE_GENE_LABEL_LANE = "Positive gene label lane";
    public static final String NEGATIVE_GENE_LABEL_LANE = "Negative gene label lane";
    public static final String POSITIVE_MICROARRAY_LANE = "Positive microarray lane";
    public static final String NEGATIVE_MICROARRAY_LANE = "Negative microarray lane";
    public static final String POSITIVE_MICROARRAY_LANE1 = "Positive microarray lane1";
    public static final String NEGATIVE_MICROARRAY_LANE1 = "Negative microarray lane1";
    public static final String POSITIVE_MICROARRAY_LANE2 = "Positive microarray lane2";
    public static final String NEGATIVE_MICROARRAY_LANE2 = "Negative microarray lane2";
    public static final String POSITIVE_MICROARRAY_LANE3 = "Positive microarray lane3";
    public static final String NEGATIVE_MICROARRAY_LANE3 = "Negative microarray lane3";
    public static final String POSITIVE_MICROARRAY_LANE4 = "Positive microarray lane4";
    public static final String NEGATIVE_MICROARRAY_LANE4 = "Negative microarray lane4";
    public static final String POSITIVE_MICROARRAY_LANE5 = "Positive microarray lane5";
    public static final String NEGATIVE_MICROARRAY_LANE5 = "Negative microarray lane5";
    public static final String SLAVE_WAYPOINT = "slave_waypoint";
    public static final String SLAVE_WAYPOINT_LINE = "slave_waypoint_line";
    public static final String SLAVE_BACKBONE = "slave_backbone";
    public static final String SLAVE_LABEL = "slave_lable";
    public static final String SLAVE_TICK = "slave_tick";
    public static final String SLAVE_COMPASS_TICK = "slave_compass_tick";
    public static final String SLAVE_COMPASS_LABEL = "slave_compass_label";
    public static final String SLAVE_POSITIVE_GENE_LABEL = "slave_positive_gene_label";
    public static final String SLAVE_NEGATIVE_GENE_LABEL = "slave_negative_gene_label";
    public static final String SLAVE_REPEAT = "slave_repeat";
    public static final String SLAVE_POSITIVE_TR = "slave_positive_tr";
    public static final String SLAVE_NEGATIVE_TR = "slave_negative_tr";
    public static final String SLAVE_POSITIVE_TR_LABEL = "slave_positive_tr_label";
    public static final String SLAVE_NEGATIVE_TR_LABEL = "slave_negative_tr_label";
    public static final String SLAVE_POSITIVE_RNA = "slave_positive_rna";
    public static final String SLAVE_NEGATIVE_RNA = "slave_negative_rna";
    public static final String SLAVE_POSITIVE_NOFRAME = "slave_positive_noframe";
    public static final String SLAVE_NEGATIVE_NOFRAME = "slave_negative_noframe";
    public static final String SLAVE_POSITIVE_ONEFRAME = "slave_positive_oneframe";
    public static final String SLAVE_POSITIVE_TWOFRAME = "slave_positive_twoframe";
    public static final String SLAVE_POSITIVE_THREEFRAME = "slave_positive_threeframe";
    public static final String SLAVE_NEGATIVE_ONEFRAME = "slave_negative_oneframe";
    public static final String SLAVE_NEGATIVE_TWOFRAME = "slave_negative_twoframe";
    public static final String SLAVE_NEGATIVE_THREEFRAME = "slave_negative_threeframe";
    public static final String SLAVE_SINGLE_FRAME = "slave_single_frame";
    public static final String SLAVE_POS_OLIGO_LABEL = "slave_pos_oligo_label";
    public static final String SLAVE_NEG_OLIGO_LABEL = "slave_neg_oligo_label";
    public static final String SLAVE_POS_OLIGO_TICK = "slave_pos_oligo_tick";
    public static final String SLAVE_NEG_OLIGO_TICK = "slave_neg_oligo_tick";
    public static final String SLAVE_GC_LOCATION = "slave_gc_location";
    public static final String SLAVE_AG_LOCATION = "slave_ag_location";
    public static final String SLAVE_GCSkew_LOCATION = "slave_gcskew_location";
    public static final String SLAVE_POSITIVE_MICROARRAY_LANE = "slave_positive_microarray_lane";
    public static final String SLAVE_NEGATIVE_MICROARRAY_LANE = "slave_negative_microarray_lane";
    public static final String SLAVE_POSITIVE_MICROARRAY_LANE0 = "slave_positive_microarray_lane0";
    public static final String SLAVE_NEGATIVE_MICROARRAY_LANE0 = "slave_negative_microarray_lane0";
    public static final String SLAVE_POSITIVE_MICROARRAY_LANE1 = "slave_positive_microarray_lane1";
    public static final String SLAVE_NEGATIVE_MICROARRAY_LANE1 = "slave_negative_microarray_lane1";
    public static final String SLAVE_POSITIVE_MICROARRAY_LANE2 = "slave_positive_microarray_lane2";
    public static final String SLAVE_NEGATIVE_MICROARRAY_LANE2 = "slave_negative_microarray_lane2";
    public static final String SLAVE_POSITIVE_MICROARRAY_LANE3 = "slave_positive_microarray_lane3";
    public static final String SLAVE_NEGATIVE_MICROARRAY_LANE3 = "slave_negative_microarray_lane3";
    public static final String SLAVE_POSITIVE_MICROARRAY_LANE4 = "slave_positive_microarray_lane4";
    public static final String SLAVE_NEGATIVE_MICROARRAY_LANE4 = "slave_negative_microarray_lane4";
    public static final String SLAVE_POSITIVE_MICROARRAY_LANE5 = "slave_positive_microarray_lane5";
    public static final String SLAVE_NEGATIVE_MICROARRAY_LANE5 = "slave_negative_microarray_lane5";
    public static final String WAYPOINT_LANE = "waypoint lane";
    private static int currentLOD;
    private static final AGAVEPainter instance;
    public static final int SLAVE_BACKBONE_BASE = 150;

    protected AGAVEPainter() {
        currentLOD = 80;
    }

    protected void setLOD(int n) throws IllegalArgumentException {
        if (n == currentLOD) {
            return;
        }
        switch (n) {
            case 60: {
                break;
            }
            case 70: {
                break;
            }
            case 80: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Level of Detail must be one of AbstractLinearGraphics .MAJOR_FEATURES .MINOR_FEATURES or .DETAILED_FEATURES");
            }
        }
    }

    public static int[] getLane(int n, String string) {
        if (string == null) {
            return null;
        }
        int[] nArray = (int[])laneMap.get(string);
        if (nArray == null) {
            nArray = LaneGetter.getLane(n, string);
        }
        return nArray;
    }

    public static AGAVEPainter getInstance() {
        return instance;
    }

    public String getToolTip(DTDElementInstance dTDElementInstance) {
        String string = dTDElementInstance.getAttribute("label");
        if (string == null || string.length() == 0) {
            return super.getToolTip(dTDElementInstance);
        }
        String[] stringArray = this.getIDs(dTDElementInstance);
        if (stringArray == null || stringArray.length == 0) {
            return string;
        }
        string = string + " (";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + (i == 0 ? "" : " ") + stringArray[i];
        }
        string = string + ")";
        return string;
    }

    public boolean isDescriptionEditable(DTDElementInstance dTDElementInstance) {
        return dTDElementInstance.getAttribute("label") != null;
    }

    public void setDescription(DTDElementInstance dTDElementInstance, String string) {
        if (this.isDescriptionEditable(dTDElementInstance)) {
            dTDElementInstance.setAttribute("label", string);
        }
    }

    public String getDescription(DTDElementInstance dTDElementInstance) {
        String string = dTDElementInstance.getAttribute("label");
        if (string == null || string.length() == 0) {
            return super.getDescription(dTDElementInstance);
        }
        return string;
    }

    public String getPrimaryID(DTDElementInstance dTDElementInstance) {
        String string = dTDElementInstance.getAttribute("element_id");
        if (string == null || string.length() == 0) {
            return super.getPrimaryID(dTDElementInstance);
        }
        return string;
    }

    public String[] getIDs(DTDElementInstance dTDElementInstance) {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        for (object = dTDElementInstance.getFirstChild(); object != null; object = object.getNextSibling()) {
            if (!(object instanceof Element) || !((Element)object).getLocalName().equals("xrefs")) continue;
            for (Node node = object.getFirstChild(); node != null; node = node.getNextSibling()) {
                String string;
                if (!(node instanceof Element) || !((Element)node).getLocalName().equals("db_id") || (string = ((Element)node).getAttribute("id")) == null || string.length() <= 0) continue;
                vector.add(string);
            }
        }
        object = this.getPrimaryID(dTDElementInstance);
        if (!vector.contains(object)) {
            vector.insertElementAt(object, 0);
        }
        return vector.toArray(new String[0]);
    }

    public int[] getLaneNonStatic(int n, String string) {
        return AGAVEPainter.getLane(n, string);
    }

    public SortedMap getLaneMap() {
        return laneMap;
    }

    public void setFeatureRange(DTDElementInstance dTDElementInstance, int n, int n2) {
        boolean bl;
        boolean bl2 = bl = n > n2;
        if (bl) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        for (Node node = dTDElementInstance.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !((Element)node).getLocalName().equals("seq_location")) continue;
            ((Element)node).setAttribute("least_start", "" + n);
            ((Element)node).setAttribute("greatest_end", "" + n2);
            ((Element)node).setAttribute("is_on_complement", bl ? "true" : "");
        }
    }

    public boolean isFeatureComplemented(DTDElementInstance dTDElementInstance) {
        int[] nArray = new int[2];
        for (Node node = dTDElementInstance.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !((Element)node).getLocalName().equals("seq_location")) continue;
            String string = ((Element)node).getAttribute("is_on_complement");
            return string == null || string.length() != 0 && string.equals("true");
        }
        return false;
    }

    public int[] getFeatureRange(DTDElementInstance dTDElementInstance) {
        String string = null;
        String string2 = null;
        boolean bl = false;
        int[] nArray = new int[2];
        for (Node node = dTDElementInstance.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !((Element)node).getLocalName().equals("seq_location")) continue;
            string = ((Element)node).getAttribute("least_start");
            string2 = ((Element)node).getAttribute("greatest_end");
            String string3 = ((Element)node).getAttribute("is_on_complement");
            bl = string3 == null || string3.length() != 0 && string3.equals("true");
        }
        try {
            if (string == null || string.length() == 0) {
                System.err.println("Cannot paint a " + dTDElementInstance.getNodeName() + ": attribute 'start' is missing");
                return null;
            }
            if (string2 == null || string2.length() == 0) {
                System.err.println("Cannot paint a " + dTDElementInstance.getNodeName() + ": attribute 'end' is missing");
                return null;
            }
            if (bl) {
                nArray[0] = new Integer(string2);
                nArray[1] = new Integer(string);
            } else {
                nArray[0] = new Integer(string);
                nArray[1] = new Integer(string2);
            }
        }
        catch (Exception exception) {
            return null;
        }
        if (dTDElementInstance.getSlaveNum() > 0 && ComparisonMenuManager.isScaling) {
            if (nArray[0] != 1) {
                nArray[0] = (int)((double)nArray[0] / dTDElementInstance.getLenRatio());
            }
            if (nArray[1] != 1) {
                nArray[1] = (int)((double)nArray[1] / dTDElementInstance.getLenRatio());
            }
        }
        return nArray;
    }

    public int[] getOrigFeatureRange(DTDElementInstance dTDElementInstance) {
        String string = null;
        String string2 = null;
        boolean bl = false;
        int[] nArray = new int[2];
        for (Node node = dTDElementInstance.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !((Element)node).getLocalName().equals("seq_location")) continue;
            string = ((Element)node).getAttribute("least_start");
            string2 = ((Element)node).getAttribute("greatest_end");
            String string3 = ((Element)node).getAttribute("is_on_complement");
            bl = string3 == null || string3.length() != 0 && string3.equals("true");
        }
        try {
            if (string == null || string.length() == 0) {
                return null;
            }
            if (string2 == null || string2.length() == 0) {
                System.err.println("Cannot paint a " + dTDElementInstance.getNodeName() + ": attribute 'end' is missing");
                return null;
            }
            if (bl) {
                nArray[0] = Integer.parseInt(string2);
                nArray[1] = Integer.parseInt(string);
            } else {
                nArray[0] = Integer.parseInt(string);
                nArray[1] = Integer.parseInt(string2);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return nArray;
    }

    public static void allocateSlaveLane(int n) {
        int n2 = 150 + (n - 1) * 100;
        laneMap.put(SLAVE_WAYPOINT + n, new int[]{n2 + 51, 40});
        laneMap.put(SLAVE_WAYPOINT_LINE + n, new int[]{n2 + 50, 30});
        laneMap.put(SLAVE_POSITIVE_TR_LABEL + n, new int[]{n2 + 33, 30});
        laneMap.put(SLAVE_POSITIVE_TR + n, new int[]{n2 + 32, 10});
        laneMap.put(SLAVE_POSITIVE_GENE_LABEL + n, new int[]{n2 + 31, 40});
        laneMap.put(SLAVE_POSITIVE_THREEFRAME + n, new int[]{n2 + 30, 10});
        laneMap.put(SLAVE_POSITIVE_TWOFRAME + n, new int[]{n2 + 20, 10});
        laneMap.put(SLAVE_POSITIVE_ONEFRAME + n, new int[]{n2 + 10, 10});
        laneMap.put(SLAVE_SINGLE_FRAME + n, new int[]{n2 + 9, 10});
        laneMap.put(SLAVE_POSITIVE_NOFRAME + n, new int[]{n2 + 9, 10});
        laneMap.put(SLAVE_BACKBONE + n, new int[]{n2, 5});
        laneMap.put(SLAVE_NEGATIVE_ONEFRAME + n, new int[]{n2 - 10, 10});
        laneMap.put(SLAVE_NEGATIVE_NOFRAME + n, new int[]{n2 - 11, 10});
        laneMap.put(SLAVE_NEGATIVE_TWOFRAME + n, new int[]{n2 - 20, 10});
        laneMap.put(SLAVE_NEGATIVE_THREEFRAME + n, new int[]{n2 - 30, 10});
        laneMap.put(SLAVE_NEGATIVE_GENE_LABEL + n, new int[]{n2 - 37, 40});
        laneMap.put(SLAVE_NEGATIVE_TR + n, new int[]{n2 - 38, 10});
        laneMap.put(SLAVE_NEGATIVE_TR_LABEL + n, new int[]{n2 - 39, 30});
        laneMap.put(SLAVE_POSITIVE_RNA + n, new int[]{n2 - 40, 10});
        laneMap.put(SLAVE_NEGATIVE_RNA + n, new int[]{n2 - 41, 10});
        laneMap.put(SLAVE_POS_OLIGO_LABEL + n, new int[]{n2 - 42, 40});
        laneMap.put(SLAVE_POS_OLIGO_TICK + n, new int[]{n2 - 43, 5});
        laneMap.put(SLAVE_NEG_OLIGO_TICK + n, new int[]{n2 - 44, 5});
        laneMap.put(SLAVE_NEG_OLIGO_LABEL + n, new int[]{n2 - 45, 40});
        laneMap.put(SLAVE_GC_LOCATION + n, new int[]{n2 - 46, 15});
        laneMap.put(SLAVE_AG_LOCATION + n, new int[]{n2 - 47, 15});
        laneMap.put(SLAVE_GCSkew_LOCATION + n, new int[]{n2 - 48, 15});
        laneMap.put(SLAVE_POSITIVE_MICROARRAY_LANE0 + n, new int[]{n2 - 51, 25});
        laneMap.put(SLAVE_NEGATIVE_MICROARRAY_LANE0 + n, new int[]{n2 - 52, 25});
        laneMap.put(SLAVE_POSITIVE_MICROARRAY_LANE1 + n, new int[]{n2 - 53, 25});
        laneMap.put(SLAVE_NEGATIVE_MICROARRAY_LANE1 + n, new int[]{n2 - 54, 25});
        laneMap.put(SLAVE_POSITIVE_MICROARRAY_LANE2 + n, new int[]{n2 - 55, 25});
        laneMap.put(SLAVE_NEGATIVE_MICROARRAY_LANE2 + n, new int[]{n2 - 56, 25});
        laneMap.put(SLAVE_POSITIVE_MICROARRAY_LANE3 + n, new int[]{n2 - 57, 25});
        laneMap.put(SLAVE_NEGATIVE_MICROARRAY_LANE3 + n, new int[]{n2 - 58, 25});
        laneMap.put(SLAVE_POSITIVE_MICROARRAY_LANE4 + n, new int[]{n2 - 59, 25});
        laneMap.put(SLAVE_NEGATIVE_MICROARRAY_LANE4 + n, new int[]{n2 - 60, 25});
        laneMap.put(SLAVE_POSITIVE_MICROARRAY_LANE5 + n, new int[]{n2 - 61, 25});
        laneMap.put(SLAVE_NEGATIVE_MICROARRAY_LANE5 + n, new int[]{n2 - 62, 25});
        laneMap.put(SLAVE_REPEAT + n, new int[]{n2 - 63, 10});
        laneMap.put(SLAVE_COMPASS_TICK + n, new int[]{n2 - 64, 5});
        laneMap.put(SLAVE_COMPASS_LABEL + n, new int[]{n2 - 65, 70});
    }

    static {
        instance = new AGAVEOligoPainter(null);
        laneMap.put(POSITIVE_GENE_LABEL_LANE, new int[]{25, 40});
        laneMap.put(NEGATIVE_GENE_LABEL_LANE, new int[]{-25, 40});
        laneMap.put(REPEAT_LANE, new int[]{-85, 10});
        laneMap.put(POSITIVE_RNA_LANE, new int[]{-1000, 10});
        laneMap.put(NEGATIVE_RNA_LANE, new int[]{-2000, 10});
        laneMap.put(POSITIVE_OLIGO_LABEL_LANE, new int[]{-90, 70});
        laneMap.put(POSITIVE_OLIGO_TICK_LANE, new int[]{-91, 5});
        laneMap.put(NEGATIVE_OLIGO_TICK_LANE, new int[]{-92, 5});
        laneMap.put(NEGATIVE_OLIGO_LABEL_LANE, new int[]{-93, 70});
        laneMap.put(POSITIVE_TRANSCRIPT_LABEL_LANE, new int[]{31, 32});
        laneMap.put(POSITIVE_TRANSCRIPT_LANE, new int[]{30, 9});
        laneMap.put(NEGATIVE_TRANSCRIPT_LANE, new int[]{-30, 9});
        laneMap.put(NEGATIVE_TRANSCRIPT_LABEL_LANE, new int[]{-31, 32});
        laneMap.put(POSITIVE_MICROARRAY_LANE, new int[]{-70, 25});
        laneMap.put(NEGATIVE_MICROARRAY_LANE, new int[]{-71, 25});
        laneMap.put(POSITIVE_MICROARRAY_LANE1, new int[]{-73, 25});
        laneMap.put(NEGATIVE_MICROARRAY_LANE1, new int[]{-74, 25});
        laneMap.put(POSITIVE_MICROARRAY_LANE2, new int[]{-76, 25});
        laneMap.put(NEGATIVE_MICROARRAY_LANE2, new int[]{-77, 25});
        laneMap.put(POSITIVE_MICROARRAY_LANE3, new int[]{-78, 25});
        laneMap.put(NEGATIVE_MICROARRAY_LANE3, new int[]{-79, 25});
        laneMap.put(POSITIVE_MICROARRAY_LANE4, new int[]{-80, 25});
        laneMap.put(NEGATIVE_MICROARRAY_LANE4, new int[]{-81, 25});
        laneMap.put(POSITIVE_MICROARRAY_LANE5, new int[]{-82, 25});
        laneMap.put(NEGATIVE_MICROARRAY_LANE5, new int[]{-83, 25});
        laneMap.put(WAYPOINT_LANE, new int[]{101, 40});
        laneMap.put("Backbone lane", new int[]{1, 5});
        laneMap.put("Waypoint line lane", new int[]{100, 30});
        laneMap.put("Positive no-frame lane", new int[]{9, 10});
        laneMap.put("Negative no-frame lane", new int[]{-9, 10});
        laneMap.put("Single Frame lane", new int[]{9, 10});
        laneMap.put("Positive 1st frame lane", new int[]{10, 10});
        laneMap.put("Positive 2nd frame lane", new int[]{15, 10});
        laneMap.put("Positive 3rd frame lane", new int[]{20, 10});
        laneMap.put("Negative 1st frame lane", new int[]{-10, 10});
        laneMap.put("Negative 2nd frame lane", new int[]{-15, 10});
        laneMap.put("Negative 3rd frame lane", new int[]{-20, 10});
        laneMap.put("Positive 1st frame translation lane", new int[]{21, 10});
        laneMap.put("Positive 2nd frame translation lane", new int[]{22, 10});
        laneMap.put("Positive 3rd frame translation lane", new int[]{23, 10});
        laneMap.put("Negative 1st frame translation lane", new int[]{-21, 10});
        laneMap.put("Negative 2nd frame translation lane", new int[]{-22, 10});
        laneMap.put("Negative 3rd frame translation lane", new int[]{-23, 10});
    }
}

