/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.painter;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.client.LinearTarget;
import ca.ucalgary.bluejay.client.TargetAppearance;
import ca.ucalgary.bluejay.client.lineartarget.CircularLinearTarget;
import ca.ucalgary.bluejay.client.lineartarget.StraightLinearTarget;
import ca.ucalgary.bluejay.client.lineartarget.TextLinearTarget;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.BluejayAbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.MaskPainter;
import ca.ucalgary.bluejay.gui.VisibilityManager;
import ca.ucalgary.bluejay.gui.comparison.ComparisonPool;
import ca.ucalgary.bluejay.gui.comparison.Genome;
import ca.ucalgary.bluejay.gui.menu.ComparisonMenuManager;
import ca.ucalgary.bluejay.gui.painter.AGAVEPainter;
import ca.ucalgary.bluejay.gui.painter.AbstractTargetPainter;
import ca.ucalgary.bluejay.gui.painter.BasicPainter;
import ca.ucalgary.bluejay.gui.painter.BasicSequencePainter;
import ca.ucalgary.bluejay.gui.painter.LaneGetter;
import ca.ucalgary.bluejay.gui.painter.LaneManager;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.SortedMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class BasicTargetPainter
extends BasicPainter
implements AbstractTargetPainter,
PropertyChangeListener {
    private LaneManager laneMng;
    private LaneGetter laneGetter;
    protected MaskPainter maskPainter;
    private VisibilityManager vizMgr;
    private BluejayDObjectList dlist;
    private Font labelFont;
    private Color tickColor;
    private Color backboneColor;
    private int targetNum;
    private int targetStart;
    public static int targetLength;
    private int numSeqs;
    private String[] sequences;
    private ComparisonPool cmpPool;
    private double labelPos;
    private int tickPixels;
    private double labelAngle;
    private int labelAlign;
    private float posPerPixelScale;
    protected int LOD;
    protected LinearTarget target;
    private int shapeID;
    private double tickTop;
    private double tickBottom;
    private double labelTop;
    private double labelBottom;
    private double backboneTop;
    private double backboneBottom;
    private double positiveOneFrame;
    private double positiveTwoFrame;
    private double positiveThreeFrame;
    private double negativeOneFrame;
    private double negativeTwoFrame;
    private double negativeThreeFrame;
    private double singleFrame;
    public static final int DEFAULT_INIT_ANGLE = 270;
    public static final String LabelLocation = "Waypoint line lane";
    public static final String BackboneLocation = "Backbone lane";
    public static final String TickLocation = "Backbone tick lane";
    public static final String positiveNoFrameLocation = "Positive no-frame lane";
    public static final String negativeNoFrameLocation = "Negative no-frame lane";
    public static final String positiveOneFrameLocation = "Positive 1st frame lane";
    public static final String positiveTwoFrameLocation = "Positive 2nd frame lane";
    public static final String positiveThreeFrameLocation = "Positive 3rd frame lane";
    public static final String negativeOneFrameLocation = "Negative 1st frame lane";
    public static final String negativeTwoFrameLocation = "Negative 2nd frame lane";
    public static final String negativeThreeFrameLocation = "Negative 3rd frame lane";
    public static final String singleFrameLocation = "Single Frame lane";
    public static final String positiveOneFrameTranslationLocation = "Positive 1st frame translation lane";
    public static final String positiveTwoFrameTranslationLocation = "Positive 2nd frame translation lane";
    public static final String positiveThreeFrameTranslationLocation = "Positive 3rd frame translation lane";
    public static final String negativeOneFrameTranslationLocation = "Negative 1st frame translation lane";
    public static final String negativeTwoFrameTranslationLocation = "Negative 2nd frame translation lane";
    public static final String negativeThreeFrameTranslationLocation = "Negative 3rd frame translation lane";
    public static final String COMPASS_TICK_LANE = "Compass lane";
    public static final String COMPASS_LABEL_LANE = "Compass label lane";
    public static final String RESTRICTION_ENZYME_LANE = "Restriction enzyme lane";
    public static final String RESTRICTION_ENZYME_LABEL_LANE = "Restriction enzyme label lane";
    private double[] slaveBackbone = new double[2];
    private static Logger logger;
    private static final Color aquamarine;
    private static final Color blue;
    private static final Color blueViolet;
    private static final Color brown;
    private static final Color burlywood;
    private static final Color cadetBlue;
    private static final Color chartreuse;
    private static final Color coral;
    private static final Color cornflowerBlue;
    private static final Color cyan;
    private static final Color darkCyan;
    private static final Color darkGreen;
    private static final Color darkKhaki;
    private static final Color darkMagenta;
    private static final Color darkOliveGreen;
    private static final Color darkOrange;
    private static final Color darkSalmon;
    private static final Color darkSeaGreen;
    private static final Color darkSlateBlue;
    private static final Color darkViolet;
    private static final Color deepPink;
    private static final Color deepSkyBlue;
    private static final Color dimGray;
    private static final Color dodgerBlue;
    private static final Color firebrick;
    private static final Color forestGreen;
    private static final Color fuschia;
    private static final Color gold;
    private static final Color goldenrod;
    private static final Color gray;
    private static final Color hotPink;
    private static final Color indianRed;
    private static final Color lightBlue;
    private static final Color lightPink;
    private static final Color lightSeaGreen;
    private static final Color lightSlateBlue;
    private static final Color mediumAquamarine;
    private static final Color mediumBlue;
    private static final Color mediumOrchid;
    private static final Color mediumPurple;
    private static final Color mediumSeaGreen;
    private static final Color mediumSlateBlue;
    private static final Color mediumSpringGreen;
    private static final Color mediumTurquoise;
    private static final Color mediumVioletRed;
    private static final Color midnightBlue;
    private static final Color olive;
    private static final Color oliveDrab;
    private static final Color orange;
    private static final Color orangeRed;
    private static final Color orchid;
    private static final Color pink;
    private static final Color plum;
    private static final Color powderBlue;
    private static final Color purple;
    private static final Color red;
    private static final Color rosyBrown;
    private static final Color royalBlue;
    private static final Color salmon;
    private static final Color seaGreen;
    private static final Color sienna;
    private static final Color skyBlue;
    private static final Color slateBlue;
    private static final Color slateGray;
    private static final Color springGreen;
    private static final Color steelBlue;
    private static final Color tan;
    private static final Color teal;
    private static final Color thistle;
    private static final Color tomato;
    private static final Color violet;
    private static final Color violetRed;
    private static final Color yellowGreen;
    private static Color[] chrColorPool;
    private static Color[] parColorPool;
    DecimalFormat df;

    public BasicTargetPainter(LaneManager laneManager, VisibilityManager visibilityManager) {
        this.laneMng = laneManager;
        this.targetNum = -1;
        this.targetStart = 0;
        targetLength = 0;
        this.numSeqs = 0;
        this.sequences = null;
        this.tickColor = null;
        this.backboneColor = Color.green;
        this.tickPixels = 100;
        this.labelAngle = -45.0;
        this.labelAlign = 30;
        this.labelFont = null;
        this.vizMgr = visibilityManager;
        this.dlist = this.vizMgr.getDList();
        this.cmpPool = this.dlist.getComparisonPool();
        this.df = new DecimalFormat("0.#");
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == null) {
            return;
        }
        double[] dArray = this.laneMng.getLane(string);
        if (dArray == null || dArray.length != 2) {
            System.out.println("Received property change that could not be interpreted: " + string + ", lane=" + dArray);
            return;
        }
        if (string.equals(LabelLocation)) {
            this.setLabelLocation(dArray[0]);
        } else if (string.equals(BackboneLocation)) {
            logger.debug("Setting backbone coords " + dArray[0] + ", " + dArray[1]);
            this.setBackboneLocation(dArray[0], dArray[1]);
        }
    }

    protected void setLaneManager(LaneManager laneManager) {
        if (laneManager == this.laneMng) {
            return;
        }
        if (this.laneMng != null) {
            this.laneMng.removePropertyChangeListener(this);
        }
        this.laneMng = laneManager;
        if (this.laneMng != null) {
            this.laneMng.addPropertyChangeListener(this);
        }
    }

    public LaneManager getLaneManager() {
        return this.laneMng;
    }

    protected abstract void setupLaneGetter();

    protected void setLaneGetter(LaneGetter laneGetter) {
        this.laneGetter = laneGetter;
    }

    protected LaneGetter getLaneGetter() {
        return this.laneGetter;
    }

    protected void setBackboneTickStep(int n) {
        this.tickPixels = n;
    }

    protected void setBackboneFillColor(Color color) {
        this.backboneColor = color;
    }

    public void preProcess(AbstractLinearGraphics abstractLinearGraphics, MaskPainter maskPainter, DTDElementInstance dTDElementInstance) {
        if (!dTDElementInstance.isModelVisible()) {
            return;
        }
        if (maskPainter == null) {
            int[] nArray = abstractLinearGraphics.isInTextMode() ? this.getOrigFeatureRange(dTDElementInstance) : this.getFeatureRange(dTDElementInstance);
            this.maskPainter = new MaskPainter(this.targetNum, this.vizMgr, nArray[0], nArray[1]);
            this.maskPainter.setRootNode(abstractLinearGraphics, dTDElementInstance);
        } else {
            super.preProcess(abstractLinearGraphics, this.maskPainter, dTDElementInstance);
        }
    }

    public abstract LinearTarget createTarget(AbstractLinearGraphics var1, DTDElementInstance var2);

    protected LinearTarget createTarget(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance, int n, int n2, boolean bl) throws Exception {
        boolean bl2;
        boolean bl3;
        this.posPerPixelScale = (float)abstractLinearGraphics.getScale();
        TargetAppearance targetAppearance = null;
        if (abstractLinearGraphics.isPreserveTargetAppearances()) {
            targetAppearance = abstractLinearGraphics.getNextPreservedTargetAppearance();
            if (targetAppearance != null && !targetAppearance.getLocalName().equals(dTDElementInstance.getLocalName())) {
                targetAppearance = null;
                new Exception("ERROR: TargetAppearance name '" + targetAppearance.getLocalName() + "' does not match DEI name '" + dTDElementInstance.getLocalName() + "'").printStackTrace();
            }
        } else {
            System.out.println("AD:: <<BasicTargetPainter>> createTarget() alg.isPreserveTargetAppearance() is false!");
            targetAppearance = dTDElementInstance.getTargetAppearance();
        }
        if (targetAppearance == null) {
            logger.debug("Working with a brand new appearance");
            this.shapeID = bl ? 112 : 111;
            targetAppearance = new TargetAppearance(this.shapeID, n, n2, false, dTDElementInstance.getLocalName(), dTDElementInstance.getXPointer(), true);
            bl3 = false;
            bl2 = false;
        } else {
            this.shapeID = targetAppearance.getShape();
            bl2 = targetAppearance.isReverseComplement();
            bl3 = targetAppearance.isShifted();
            logger.debug("for this appearance isReverse is " + bl2);
        }
        dTDElementInstance.setTargetAppearance(targetAppearance);
        this.LOD = abstractLinearGraphics.getLOD();
        this.target = null;
        this.setRange(n, n2);
        if (this.shapeID == 112) {
            int n3 = (int)(-360.0 * (double)(targetAppearance.getTopPosition() - n) / (double)(n2 - n));
            this.target = new CircularLinearTarget(abstractLinearGraphics, this.targetStart, targetLength, this.laneMng.getAboveHeight(this.LOD), this.laneMng.getBelowHeight(this.LOD), 1.0f / this.posPerPixelScale, 270 + n3);
        } else if (this.shapeID == 111) {
            int n4 = 7500;
            abstractLinearGraphics.setBreakablePageWidth(n4);
            this.target = new StraightLinearTarget(abstractLinearGraphics, this.targetStart, targetLength, this.laneMng.getAboveHeight(this.LOD), this.laneMng.getBelowHeight(this.LOD), 1.0 / (double)this.posPerPixelScale, false, abstractLinearGraphics.isSVGExportGraphicsMode());
        } else if (this.shapeID == 119) {
            this.setSequences(dTDElementInstance);
            int n5 = abstractLinearGraphics.getPageWidth();
            abstractLinearGraphics.setBreakablePageWidth(n5);
            this.target = new TextLinearTarget(abstractLinearGraphics, this.targetStart, targetLength, this.laneMng.getAboveHeight(this.LOD), this.laneMng.getBelowHeight(this.LOD), 1.0f / this.posPerPixelScale, false, abstractLinearGraphics.isBreakable(), this.sequences, this.numSeqs);
        } else if (this.shapeID == 120) {
            this.setSequences(dTDElementInstance);
            int n6 = 7500;
            abstractLinearGraphics.setBreakablePageWidth(n6);
            this.target = new TextLinearTarget(abstractLinearGraphics, this.targetStart, targetLength, this.laneMng.getAboveHeight(this.LOD), this.laneMng.getBelowHeight(this.LOD), 1.0f / this.posPerPixelScale, true, false, this.sequences, this.numSeqs);
        }
        if (bl2) {
            this.target.addMode(1);
        } else {
            this.target.removeMode(1);
        }
        if (bl3) {
            this.target.addMode(2);
            this.target.setShift(targetAppearance.getShift());
        } else {
            this.target.removeMode(2);
            this.target.setShift(0);
        }
        if (this.vizMgr.getVisibleTargets() == null || this.vizMgr.getVisibleTargets().length == 0) {
            this.vizMgr.addVisibleTarget(this.target);
        } else {
            this.vizMgr.replaceVisibleTarget(0, this.target);
        }
        this.target.setMaskPainter(this.maskPainter);
        return this.target;
    }

    private void setSequences(DTDElementInstance dTDElementInstance) {
        this.setNumSeqs();
        this.sequences = new String[this.numSeqs];
        if (this.numSeqs > 1) {
            for (int i = 0; i < this.numSeqs; ++i) {
                Genome genome = this.cmpPool.getSeqsFromPool().elementAt(i);
                DTDElementInstance dTDElementInstance2 = (DTDElementInstance)genome.getRootNode().getFirstChild().getFirstChild();
                this.sequences[i] = this.getSequence(dTDElementInstance2);
                if (this.sequences[i].length() <= targetLength) continue;
                targetLength = this.sequences[i].length();
            }
        } else {
            this.sequences[0] = this.getSequence(dTDElementInstance);
        }
    }

    private void setNumSeqs() {
        int n = this.cmpPool.getPoolSize();
        this.numSeqs = n == 0 ? n + 1 : n;
    }

    public String getSequence(DTDElementInstance dTDElementInstance) {
        this.normalizeText(dTDElementInstance);
        ConcurrentLinkedQueue<Node> concurrentLinkedQueue = new ConcurrentLinkedQueue<Node>();
        String string = null;
        block0: for (Node node = dTDElementInstance.getFirstChild(); node != null; node = node.getNextSibling()) {
            concurrentLinkedQueue.add(node);
            logger.debug("Found a child node " + node);
            while (!concurrentLinkedQueue.isEmpty()) {
                Node node2 = (Node)concurrentLinkedQueue.poll();
                if (node2 instanceof Text || node2 instanceof CDATASection) {
                    string = node2.getNodeValue();
                    continue block0;
                }
                logger.debug("No match in child node: " + node2);
                NodeList nodeList = node2.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node3 = nodeList.item(i);
                    logger.debug("Found a child's child node " + node3);
                    concurrentLinkedQueue.add(node3);
                }
            }
        }
        return string;
    }

    public void setRange(int n, int n2) {
        this.targetStart = n;
        targetLength = n2;
    }

    public void paintPostTarget(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        this.LOD = abstractLinearGraphics.getLOD();
        double[] dArray = this.laneMng.getLane(BackboneLocation, this.LOD);
        if (dArray == null) {
            return;
        }
        this.setBackboneLocation(dArray[0], dArray[1]);
        dArray = this.laneMng.getLane(LabelLocation, this.LOD);
        this.setLabelLocation(dArray[1]);
        int n = (int)(this.posPerPixelScale * (float)this.tickPixels);
        this.setNumSeqs();
        this.drawBackbone(abstractLinearGraphics, dTDElementInstance, n);
        if (!this.vizMgr.getDList().isDrawingChromosomes()) {
            this.drawCompass(abstractLinearGraphics, dTDElementInstance, this.shapeID, n);
        }
        if (this.numSeqs > 1) {
            for (int i = 1; i < this.numSeqs; ++i) {
                Genome genome = this.cmpPool.getSeqsFromPool().elementAt(i);
                if (!genome.isCompleteSequence()) continue;
                this.drawSlaveCompass(abstractLinearGraphics, dTDElementInstance, this.shapeID, n, genome);
            }
        }
        if (abstractLinearGraphics.isSixFrameMode()) {
            this.drawFrames(abstractLinearGraphics, this.targetNum, targetLength, this.shapeID);
            if (ComparisonMenuManager.isComparison) {
                this.drawSlaveFrames(abstractLinearGraphics, this.targetNum, targetLength, this.shapeID);
            }
        }
    }

    public void updateLegendItem(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        String[] stringArray;
        this.setupLaneGetter();
        int n = abstractLinearGraphics.getLOD();
        String[] stringArray2 = new String[]{LabelLocation, BackboneLocation, COMPASS_TICK_LANE, COMPASS_LABEL_LANE};
        BasicTargetPainter.requestLanes(this.laneMng, this.laneGetter, n, stringArray2);
        int n2 = this.cmpPool.getPoolSize();
        if (n2 > 1) {
            for (int i = 1; i < n2; ++i) {
                String[] stringArray3 = new String[]{"slave_waypoint_line" + i, "slave_backbone" + i, "slave_compass_tick" + i, "slave_compass_label" + i};
                BasicTargetPainter.requestLanes(this.laneMng, this.laneGetter, n, stringArray3);
                if (abstractLinearGraphics.isSingleFrameMode()) {
                    stringArray = new String[]{"slave_single_frame" + i};
                    BasicTargetPainter.requestLanes(this.laneMng, this.laneGetter, n, stringArray);
                    continue;
                }
                if (abstractLinearGraphics.isSixFrameMode()) {
                    stringArray = new String[]{"slave_positive_oneframe" + i, "slave_positive_twoframe" + i, "slave_positive_threeframe" + i, "slave_negative_oneframe" + i, "slave_negative_twoframe" + i, "slave_negative_threeframe" + i};
                    BasicTargetPainter.requestLanes(this.laneMng, this.laneGetter, n, stringArray);
                    continue;
                }
                stringArray = new String[]{"slave_positive_noframe" + i, "slave_negative_noframe" + i};
                BasicTargetPainter.requestLanes(this.laneMng, this.laneGetter, n, stringArray);
            }
        }
        if (abstractLinearGraphics.isCleavageShown()) {
            String[] stringArray4;
            if (BasicSequencePainter.isSeparateCleavageLanes()) {
                stringArray4 = BasicSequencePainter.getShownRestrictionEnzymes();
                for (int i = 0; i < stringArray4.length; ++i) {
                    stringArray = new String[]{"Restriction enzyme lane " + stringArray4[i]};
                    BasicTargetPainter.requestLanes(this.laneMng, this.laneGetter, n, stringArray);
                }
            } else {
                stringArray4 = new String[]{RESTRICTION_ENZYME_LANE};
                BasicTargetPainter.requestLanes(this.laneMng, this.laneGetter, n, stringArray4);
            }
            stringArray4 = new String[]{RESTRICTION_ENZYME_LABEL_LANE};
            BasicTargetPainter.requestLanes(this.laneMng, this.laneGetter, n, stringArray4);
        }
        if (abstractLinearGraphics.isSingleFrameMode()) {
            String[] stringArray5 = new String[]{singleFrameLocation};
            BasicTargetPainter.requestLanes(this.laneMng, this.laneGetter, n, stringArray5);
        } else if (abstractLinearGraphics.isSixFrameMode()) {
            String[] stringArray6 = new String[]{positiveOneFrameLocation, positiveTwoFrameLocation, positiveThreeFrameLocation, negativeOneFrameLocation, negativeTwoFrameLocation, negativeThreeFrameLocation};
            BasicTargetPainter.requestLanes(this.laneMng, this.laneGetter, n, stringArray6);
        } else {
            String[] stringArray7 = new String[]{positiveNoFrameLocation, negativeNoFrameLocation};
            BasicTargetPainter.requestLanes(this.laneMng, this.laneGetter, n, stringArray7);
        }
        super.updateLegendItem(abstractLinearGraphics, dTDElementInstance);
    }

    public void setLabelLocation(double d) throws IllegalArgumentException {
        if (d < -1.0 || d > 1.0) {
            throw new IllegalArgumentException("Location must be in the range [-1,1], found " + d);
        }
        this.labelPos = d;
    }

    public void setBackboneLocation(double d, double d2) throws IllegalArgumentException {
        if (d2 < -1.0 || d > 1.0 || d2 > d) {
            throw new IllegalArgumentException("Top and bottom of Backbone must be in the range [-1,1], found " + d + ", " + d2);
        }
        this.backboneTop = d;
        this.backboneBottom = d2;
    }

    public void setTickLocation(double d, double d2) throws IllegalArgumentException {
        if (d2 < -1.0 || d > 1.0 || d2 > d) {
            throw new IllegalArgumentException("Top and bottom of Backbone must be in the range [-1,1], found " + d + ", " + d2);
        }
        this.tickTop = d;
        this.tickBottom = d2;
    }

    public void setLabelAlignment(int n) throws IllegalArgumentException {
        if (n != 30 && n != 40 && n != 0) {
            throw new IllegalArgumentException("Alignment value must be one of AbstractLinearGraphics's LEFT, RIGHT or CENTER values, found " + n);
        }
        this.labelAlign = n;
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
    }

    public void setLabelAngle(double d) {
        this.labelAngle = d;
    }

    public void setFramesLocation(double d, double d2, double d3, double d4, double d5, double d6) {
        this.positiveOneFrame = d;
        this.positiveTwoFrame = d2;
        this.positiveThreeFrame = d3;
        this.negativeOneFrame = d4;
        this.negativeTwoFrame = d5;
        this.negativeThreeFrame = d6;
    }

    protected void drawBackbone(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance, int n) throws Exception {
        abstractLinearGraphics.startHyperlink(dTDElementInstance, true);
        Vector vector = abstractLinearGraphics.getVisiblePositionRange(this.targetNum);
        if (vector != null && vector.size() != 0) {
            if (n < 0) {
                new Exception("WARNING: Incorrect range calculation in drawBackBone: tickStep=" + n).printStackTrace();
            } else {
                Color color = abstractLinearGraphics.getColor();
                for (int i = 0; i < vector.size(); ++i) {
                    int n2;
                    String string;
                    int[] nArray = (int[])vector.elementAt(i);
                    abstractLinearGraphics.setColor(this.numSeqs > 1 ? Color.red : this.backboneColor);
                    if (abstractLinearGraphics.isInTextMode()) {
                        ((TextLinearTarget)abstractLinearGraphics.getTarget(this.targetNum)).setContigSeq(0);
                    }
                    if ((string = dTDElementInstance.getAttribute("chromosomes")).equals("")) {
                        this.dlist.setDrawingChromosomes(false);
                        this.dlist.getCompMenuMan().getParalogyMenuManager().paralogySetEnabled(false);
                        ((BluejayAbstractLinearGraphics)abstractLinearGraphics).getLLPainter().setLinkingSelf(false);
                        abstractLinearGraphics.fillRect(this.targetNum, nArray[0], nArray[1], this.backboneTop, this.backboneBottom);
                    } else {
                        this.dlist.setDrawingChromosomes(true);
                        String string2 = dTDElementInstance.getAttribute("organism");
                        if (string2.length() == 0) {
                            string2 = "Organism";
                        }
                        n2 = 10000;
                        String string3 = dTDElementInstance.getAttribute("gap");
                        if (string3.length() > 0) {
                            n2 = Integer.parseInt(string3);
                        }
                        String[] stringArray = string.split(",");
                        int n3 = stringArray.length;
                        String[] stringArray2 = new String[n3];
                        String[] stringArray3 = new String[n3];
                        String[] stringArray4 = new String[n3];
                        Color[] colorArray = new Color[n3];
                        for (int j = 0; j < n3; ++j) {
                            String[] stringArray5 = stringArray[j].split(":");
                            if (j == 0) {
                                if (stringArray5.length == 3) {
                                    this.dlist.setDrawingCentromeres(true);
                                } else {
                                    this.dlist.setDrawingCentromeres(false);
                                }
                            }
                            stringArray2[j] = stringArray5[0];
                            stringArray3[j] = stringArray5[1];
                            if (this.dlist.isDrawingCentromeres()) {
                                stringArray4[j] = stringArray5[2];
                            }
                            colorArray[j] = chrColorPool[j % chrColorPool.length];
                        }
                        this.dlist.setOrganism(string2);
                        this.dlist.setChrNames(stringArray2);
                        this.dlist.setChrColors(colorArray);
                        SortedMap sortedMap = AGAVEPainter.getInstance().getLaneMap();
                        int n4 = ((int[])sortedMap.get(BackboneLocation))[0];
                        sortedMap.put(BackboneLocation, new int[]{n4, 10});
                        int[] nArray2 = new int[n3];
                        int[] nArray3 = new int[n3];
                        int[] nArray4 = new int[n3];
                        int[] nArray5 = new int[n3];
                        int[] nArray6 = new int[n3];
                        nArray2[0] = 1;
                        for (int j = 0; j < n3 - 1; ++j) {
                            nArray3[j] = nArray2[j] + Integer.parseInt(stringArray3[j]) - 1;
                            if (this.dlist.isDrawingCentromeres()) {
                                nArray6[j] = nArray2[j] + Integer.parseInt(stringArray4[j]) - 1;
                            }
                            nArray4[j] = nArray3[j] + 1;
                            nArray5[j] = nArray4[j] + n2 - 1;
                            nArray2[j + 1] = nArray5[j] + 1;
                        }
                        nArray3[n3 - 1] = nArray2[n3 - 1] + Integer.parseInt(stringArray3[n3 - 1]) - 1;
                        nArray4[n3 - 1] = nArray3[n3 - 1] + 1;
                        nArray5[n3 - 1] = nArray4[n3 - 1] + n2 - 1;
                        if (this.dlist.isDrawingCentromeres()) {
                            nArray6[n3 - 1] = nArray2[n3 - 1] + Integer.parseInt(stringArray4[n3 - 1]) - 1;
                            this.drawChromosomeBackbones(abstractLinearGraphics, nArray[0], nArray[1], nArray2, nArray3, nArray6, nArray4, nArray5, n2, colorArray);
                        } else {
                            this.drawChromosomeBackbones(abstractLinearGraphics, nArray[0], nArray[1], nArray2, nArray3, null, nArray4, nArray5, n2, colorArray);
                        }
                        String string4 = dTDElementInstance.getAttribute("paralogous_regions");
                        if (!string4.equals("")) {
                            String[] stringArray6 = string4.split(",");
                            int n5 = stringArray6.length;
                            this.dlist.setParColors(new Hashtable<String, Color>());
                            for (int j = 0; j < n5; ++j) {
                                this.dlist.setParColor(stringArray6[j], parColorPool[j % parColorPool.length]);
                            }
                            this.dlist.setParNames(stringArray6);
                        } else {
                            System.err.printf("Paralogous regions undefined!\n", new Object[0]);
                        }
                    }
                    abstractLinearGraphics.updateHyperlink(abstractLinearGraphics.getPoint(this.targetNum, nArray[0], this.backboneTop));
                    abstractLinearGraphics.setColor(color);
                    int n6 = 0;
                    if (abstractLinearGraphics.isInTextMode()) {
                        n6 = this.sequences[0].length();
                    }
                    for (n2 = nArray[0]; !(n2 >= nArray[1] || abstractLinearGraphics.isInTextMode() && n2 > n6); n2 += n) {
                        if (this.vizMgr.getDList().isDrawingChromosomes()) continue;
                        abstractLinearGraphics.drawLine(this.targetNum, n2, n2, this.backboneTop, this.backboneBottom);
                    }
                    if (this.numSeqs <= 1) continue;
                    Vector<Genome> vector2 = this.cmpPool.getSeqsFromPool();
                    for (int j = 1; j < this.numSeqs; ++j) {
                        this.slaveBackbone = this.laneMng.getLane("slave_backbone" + j, this.LOD);
                        Genome genome = vector2.elementAt(j);
                        int n7 = ComparisonMenuManager.isScaling ? nArray[1] : (int)(genome.getLenRatio() * (double)nArray[1]);
                        abstractLinearGraphics.setColor(genome.getGenomeColor());
                        if (abstractLinearGraphics.isInTextMode()) {
                            ((TextLinearTarget)abstractLinearGraphics.getTarget(this.targetNum)).setContigSeq(j);
                        }
                        abstractLinearGraphics.fillRect(this.targetNum, nArray[0], n7, this.slaveBackbone[0], this.slaveBackbone[1]);
                        abstractLinearGraphics.setColor(color);
                        if (!genome.isCompleteSequence()) continue;
                        n6 = genome.getGenomeLen();
                        for (int k = nArray[0]; !(k >= n7 || abstractLinearGraphics.isInTextMode() && k > n6); k += n) {
                            abstractLinearGraphics.drawLine(this.targetNum, k, k, this.slaveBackbone[0], this.slaveBackbone[1]);
                        }
                    }
                }
            }
        }
        abstractLinearGraphics.endHyperlink();
    }

    public void drawChromosomeBackbones(AbstractLinearGraphics abstractLinearGraphics, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int n3, Color[] colorArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (n <= nArray2[i] && n2 >= nArray[i]) {
                abstractLinearGraphics.setColor(colorArray[i]);
                abstractLinearGraphics.fillRect(this.targetNum, Math.max(n, nArray[i]), Math.min(n2, nArray2[i]), this.backboneTop, this.backboneBottom);
            }
            if (n <= nArray5[i] && n2 >= nArray4[i]) {
                abstractLinearGraphics.setColor(Color.WHITE);
                abstractLinearGraphics.fillRect(this.targetNum, Math.max(n, nArray4[i]), Math.min(n2, nArray5[i]), this.backboneTop, this.backboneBottom);
            }
            if (nArray3 == null) continue;
            int n4 = nArray3[i] - n3 / 7;
            int n5 = nArray3[i] + n3 / 7;
            if (n > n5 || n2 < n4) continue;
            abstractLinearGraphics.setColor(Color.BLACK);
            abstractLinearGraphics.fillRect(this.targetNum, Math.max(n, n4), Math.min(n2, n5), this.backboneTop, this.backboneBottom);
        }
    }

    private void drawFrames(AbstractLinearGraphics abstractLinearGraphics, int n, int n2, int n3) throws Exception {
        double[] dArray = this.laneMng.getLane(positiveOneFrameLocation, this.LOD);
        double[] dArray2 = this.laneMng.getLane(positiveTwoFrameLocation, this.LOD);
        double[] dArray3 = this.laneMng.getLane(positiveThreeFrameLocation, this.LOD);
        double[] dArray4 = this.laneMng.getLane(negativeOneFrameLocation, this.LOD);
        double[] dArray5 = this.laneMng.getLane(negativeTwoFrameLocation, this.LOD);
        double[] dArray6 = this.laneMng.getLane(negativeThreeFrameLocation, this.LOD);
        this.setFramesLocation(dArray[0], dArray2[0], dArray3[0], dArray4[1], dArray5[1], dArray6[1]);
        if (abstractLinearGraphics.isSixFrameMode()) {
            Color color = abstractLinearGraphics.getColor();
            abstractLinearGraphics.setColor(Color.gray);
            this.drawLaneLine(abstractLinearGraphics, n, this.positiveOneFrame);
            this.drawLaneLine(abstractLinearGraphics, n, this.positiveTwoFrame);
            this.drawLaneLine(abstractLinearGraphics, n, this.positiveThreeFrame);
            this.drawLaneLine(abstractLinearGraphics, n, this.negativeOneFrame);
            this.drawLaneLine(abstractLinearGraphics, n, this.negativeTwoFrame);
            this.drawLaneLine(abstractLinearGraphics, n, this.negativeThreeFrame);
            TargetAppearance targetAppearance = (TargetAppearance)abstractLinearGraphics.getTargetAppearances().elementAt(n);
            boolean bl = targetAppearance.isReverseComplement();
            abstractLinearGraphics.setColor(Color.black);
            if (n3 == 112) {
                this.drawFrameLabels(abstractLinearGraphics, n, null, 1, n3, bl);
                this.drawFrameLabels(abstractLinearGraphics, n, null, n2 / 4, n3, bl);
                this.drawFrameLabels(abstractLinearGraphics, n, null, n2 / 2, n3, bl);
                this.drawFrameLabels(abstractLinearGraphics, n, null, 3 * n2 / 4, n3, bl);
            } else if (n3 == 111) {
                this.drawFrameLabels(abstractLinearGraphics, n, null, 1, n3, bl);
                this.drawFrameLabels(abstractLinearGraphics, n, null, n2, n3, bl);
            } else if (n3 == 119 || n3 == 120) {
                this.drawFrameLabels(abstractLinearGraphics, n, null, 1, n3, bl);
                this.drawFrameLabels(abstractLinearGraphics, n, null, n2, n3, bl);
            }
            abstractLinearGraphics.setColor(color);
        }
    }

    private void drawSlaveFrames(AbstractLinearGraphics abstractLinearGraphics, int n, int n2, int n3) throws Exception {
        double[] dArray = this.laneMng.getLane("slave_positive_oneframe", this.LOD);
        double[] dArray2 = this.laneMng.getLane("slave_positive_twoframe", this.LOD);
        double[] dArray3 = this.laneMng.getLane("slave_positive_threeframe", this.LOD);
        double[] dArray4 = this.laneMng.getLane("slave_negative_oneframe", this.LOD);
        double[] dArray5 = this.laneMng.getLane("slave_negative_twoframe", this.LOD);
        double[] dArray6 = this.laneMng.getLane("slave_negative_threeframe", this.LOD);
        this.setFramesLocation(dArray[0], dArray2[0], dArray3[0], dArray4[1], dArray5[1], dArray6[1]);
        if (abstractLinearGraphics.isSixFrameMode()) {
            Color color = abstractLinearGraphics.getColor();
            abstractLinearGraphics.setColor(Color.gray);
            this.drawLaneLine(abstractLinearGraphics, n, this.positiveOneFrame);
            this.drawLaneLine(abstractLinearGraphics, n, this.positiveTwoFrame);
            this.drawLaneLine(abstractLinearGraphics, n, this.positiveThreeFrame);
            this.drawLaneLine(abstractLinearGraphics, n, this.negativeOneFrame);
            this.drawLaneLine(abstractLinearGraphics, n, this.negativeTwoFrame);
            this.drawLaneLine(abstractLinearGraphics, n, this.negativeThreeFrame);
            TargetAppearance targetAppearance = (TargetAppearance)abstractLinearGraphics.getTargetAppearances().elementAt(n);
            boolean bl = targetAppearance.isReverseComplement();
            abstractLinearGraphics.setColor(Color.black);
            if (n3 == 112) {
                this.drawFrameLabels(abstractLinearGraphics, n, null, 1, n3, bl);
                this.drawFrameLabels(abstractLinearGraphics, n, null, n2 / 4, n3, bl);
                this.drawFrameLabels(abstractLinearGraphics, n, null, n2 / 2, n3, bl);
                this.drawFrameLabels(abstractLinearGraphics, n, null, 3 * n2 / 4, n3, bl);
            } else if (n3 == 111) {
                this.drawFrameLabels(abstractLinearGraphics, n, null, 1, n3, bl);
                this.drawFrameLabels(abstractLinearGraphics, n, null, n2, n3, bl);
            } else if (n3 == 119 || n3 == 120) {
                this.drawFrameLabels(abstractLinearGraphics, n, null, 1, n3, bl);
                this.drawFrameLabels(abstractLinearGraphics, n, null, n2, n3, bl);
            }
            abstractLinearGraphics.setColor(color);
        }
    }

    private void drawFrameLabels(AbstractLinearGraphics abstractLinearGraphics, int n, Font font, int n2, int n3, boolean bl) throws Exception {
        String string = bl ? "-" : "+";
        String string2 = bl ? "+" : "-";
        double d = 0.5 * (double)abstractLinearGraphics.getFont().getSize();
        abstractLinearGraphics.drawString(n, string + "1", font, n2, this.positiveOneFrame + d * this.laneMng.getPixelToALGUnitScale(this.positiveOneFrame, this.LOD), 30);
        abstractLinearGraphics.drawString(n, string + "2", font, n2, this.positiveTwoFrame + d * this.laneMng.getPixelToALGUnitScale(this.positiveTwoFrame, this.LOD), 30);
        abstractLinearGraphics.drawString(n, string + "3", font, n2, this.positiveThreeFrame + d * this.laneMng.getPixelToALGUnitScale(this.positiveThreeFrame, this.LOD), 30);
        abstractLinearGraphics.drawString(n, string2 + "1", font, n2, this.negativeOneFrame + d * this.laneMng.getPixelToALGUnitScale(this.negativeOneFrame, this.LOD), 40);
        abstractLinearGraphics.drawString(n, string2 + "2", font, n2, this.negativeTwoFrame + d * this.laneMng.getPixelToALGUnitScale(this.negativeTwoFrame, this.LOD), 40);
        abstractLinearGraphics.drawString(n, string2 + "3", font, n2, this.negativeThreeFrame + d * this.laneMng.getPixelToALGUnitScale(this.negativeThreeFrame, this.LOD), 40);
    }

    public int getPriority() {
        return 60;
    }

    private void drawCompass(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance, int n, int n2) throws Exception {
        if (this.numSeqs > 1) {
            Genome genome = this.cmpPool.getSeqsFromPool().elementAt(0);
            LinearTarget linearTarget = abstractLinearGraphics.getTarget(this.targetNum);
            if (linearTarget instanceof CircularLinearTarget) {
                double d = genome.getStartAngle();
                ((CircularLinearTarget)linearTarget).setMainStartAngle(d);
            }
        }
        int n3 = abstractLinearGraphics.getLOD();
        double d = -45.0;
        String string = dTDElementInstance.getAttribute("scale").equals("1000") ? "M" : "K";
        double[] dArray = this.laneMng.getLane(COMPASS_TICK_LANE, n3);
        double[] dArray2 = this.laneMng.getLane(COMPASS_LABEL_LANE, n3);
        int n4 = 40;
        Vector vector = abstractLinearGraphics.getVisiblePositionRange(this.targetNum);
        if (vector != null && vector.size() != 0) {
            if (n2 < 0) {
                new Exception("WARNING: Incorrect range calculation in drawCompass(): tickStep=" + n2).printStackTrace();
            } else {
                double d2 = n == 112 ? (dArray[0] + dArray[1]) / 2.0 : dArray[0];
                block0: for (int i = 0; i < vector.size(); ++i) {
                    int[] nArray = (int[])vector.elementAt(i);
                    for (int j = nArray[0]; j < nArray[1]; j += n2) {
                        String string2 = "";
                        if (abstractLinearGraphics.isInTextMode()) {
                            if (j > this.sequences[0].length()) continue block0;
                            string2 = string2 + j;
                        } else {
                            string2 = j > 999 && targetLength > 10000 ? "" + this.df.format((float)j / 1000.0f) + string : "" + j;
                        }
                        abstractLinearGraphics.drawAngledString(this.targetNum, string2, null, j, dArray2[0], dArray2[1], n4, d);
                        abstractLinearGraphics.drawLine(this.targetNum, j, j, d2, dArray[1]);
                    }
                }
            }
        }
    }

    private void drawSlaveCompass(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance, int n, int n2, Genome genome) throws Exception {
        LinearTarget linearTarget = abstractLinearGraphics.getTarget(this.targetNum);
        if (linearTarget instanceof CircularLinearTarget) {
            double d = genome.getStartAngle();
            ((CircularLinearTarget)linearTarget).setMainStartAngle(d);
        }
        int n3 = abstractLinearGraphics.getLOD();
        double d = -45.0;
        String string = dTDElementInstance.getAttribute("scale").equals("1000") ? "M" : "K";
        int n4 = genome.getGenomeNum();
        int n5 = genome.getGenomeLen();
        double d2 = genome.getLenRatio();
        double[] dArray = this.laneMng.getLane("slave_compass_tick" + n4, n3);
        double[] dArray2 = this.laneMng.getLane("slave_compass_label" + n4, n3);
        int n6 = 40;
        Vector vector = abstractLinearGraphics.getVisiblePositionRange(this.targetNum);
        if (vector == null || vector.size() == 0) {
            System.out.println("&&&&&&&&&&& AD::<<BasicTargetPainter>> drawSlaveCompass() No ticks to paint for compass");
        } else if (n2 < 0) {
            new Exception("WARNING: Incorrect range calculation in drawSlaveCompass(): tickStep=" + n2).printStackTrace();
        } else {
            double d3 = n == 112 ? (dArray[0] + dArray[1]) / 2.0 : dArray[0];
            block0: for (int i = 0; i < vector.size(); ++i) {
                int[] nArray = (int[])vector.elementAt(i);
                int n7 = ComparisonMenuManager.isScaling ? nArray[1] : (int)(genome.getLenRatio() * (double)nArray[1]);
                for (int j = nArray[0]; j < n7; j += n2) {
                    String string2 = "";
                    if (j == 1) {
                        string2 = "1";
                    } else if (abstractLinearGraphics.isInTextMode()) {
                        if (j > n5) continue block0;
                        string2 = string2 + j;
                    } else {
                        int n8 = (int)(ComparisonMenuManager.isScaling ? (double)j * d2 : (double)j);
                        string2 = n8 > 999 && targetLength > 10000 ? "" + this.df.format((float)n8 / 1000.0f) + string : "" + n8;
                    }
                    abstractLinearGraphics.drawAngledString(this.targetNum, string2, null, j, dArray2[0], dArray2[1], n6, d);
                    abstractLinearGraphics.drawLine(this.targetNum, j, j, d3, dArray[1]);
                }
            }
        }
    }

    public int getTargetNumber() {
        return this.targetNum;
    }

    public void setTargetNumber(int n) {
        this.targetNum = n;
    }

    public void clearLayout() {
        this.laneMng.clear();
    }

    public MaskPainter getMaskPainter() {
        return this.maskPainter;
    }

    public void setMaskPainter(MaskPainter maskPainter) {
        this.maskPainter = maskPainter;
    }

    static {
        logger = Logger.getLogger(BasicTargetPainter.class);
        aquamarine = new Color(127, 255, 212);
        blue = new Color(0, 0, 255);
        blueViolet = new Color(138, 43, 226);
        brown = new Color(165, 42, 42);
        burlywood = new Color(222, 184, 135);
        cadetBlue = new Color(95, 158, 160);
        chartreuse = new Color(127, 255, 0);
        coral = new Color(255, 127, 80);
        cornflowerBlue = new Color(100, 149, 237);
        cyan = new Color(0, 255, 255);
        darkCyan = new Color(0, 139, 139);
        darkGreen = new Color(0, 100, 0);
        darkKhaki = new Color(189, 183, 107);
        darkMagenta = new Color(139, 0, 139);
        darkOliveGreen = new Color(85, 107, 47);
        darkOrange = new Color(255, 140, 0);
        darkSalmon = new Color(233, 150, 122);
        darkSeaGreen = new Color(143, 188, 143);
        darkSlateBlue = new Color(72, 61, 139);
        darkViolet = new Color(148, 0, 211);
        deepPink = new Color(255, 20, 147);
        deepSkyBlue = new Color(0, 191, 255);
        dimGray = new Color(105, 105, 105);
        dodgerBlue = new Color(30, 144, 255);
        firebrick = new Color(178, 34, 34);
        forestGreen = new Color(34, 139, 34);
        fuschia = new Color(255, 0, 255);
        gold = new Color(255, 215, 0);
        goldenrod = new Color(218, 165, 32);
        gray = new Color(128, 128, 128);
        hotPink = new Color(255, 105, 180);
        indianRed = new Color(205, 92, 92);
        lightBlue = new Color(173, 216, 230);
        lightPink = new Color(255, 182, 193);
        lightSeaGreen = new Color(32, 178, 170);
        lightSlateBlue = new Color(132, 112, 255);
        mediumAquamarine = new Color(102, 205, 170);
        mediumBlue = new Color(0, 0, 205);
        mediumOrchid = new Color(186, 85, 211);
        mediumPurple = new Color(147, 112, 219);
        mediumSeaGreen = new Color(60, 179, 113);
        mediumSlateBlue = new Color(123, 104, 238);
        mediumSpringGreen = new Color(0, 250, 154);
        mediumTurquoise = new Color(72, 209, 204);
        mediumVioletRed = new Color(199, 21, 133);
        midnightBlue = new Color(25, 25, 112);
        olive = new Color(128, 128, 0);
        oliveDrab = new Color(107, 142, 35);
        orange = new Color(255, 165, 0);
        orangeRed = new Color(255, 69, 0);
        orchid = new Color(218, 112, 214);
        pink = new Color(255, 192, 203);
        plum = new Color(221, 160, 221);
        powderBlue = new Color(176, 224, 230);
        purple = new Color(128, 0, 128);
        red = new Color(255, 0, 0);
        rosyBrown = new Color(188, 143, 143);
        royalBlue = new Color(65, 105, 225);
        salmon = new Color(250, 128, 114);
        seaGreen = new Color(46, 139, 87);
        sienna = new Color(160, 82, 45);
        skyBlue = new Color(135, 206, 235);
        slateBlue = new Color(106, 90, 205);
        slateGray = new Color(112, 128, 144);
        springGreen = new Color(0, 255, 127);
        steelBlue = new Color(70, 130, 180);
        tan = new Color(210, 180, 140);
        teal = new Color(0, 128, 128);
        thistle = new Color(216, 191, 216);
        tomato = new Color(255, 99, 71);
        violet = new Color(238, 130, 238);
        violetRed = new Color(208, 32, 144);
        yellowGreen = new Color(154, 205, 50);
        chrColorPool = new Color[]{mediumSeaGreen, mediumSlateBlue, mediumVioletRed, mediumTurquoise, olive, mediumSpringGreen, orange, orangeRed, oliveDrab, orchid, pink, powderBlue, purple, red, rosyBrown, royalBlue, salmon, seaGreen, sienna, skyBlue, slateBlue, springGreen, tomato, steelBlue, tan, teal, thistle, slateGray, violet, violetRed, yellowGreen, aquamarine, blue, blueViolet, brown, burlywood, cadetBlue, chartreuse, coral, cornflowerBlue, cyan, darkCyan, darkGreen, darkKhaki, darkMagenta, darkOliveGreen, darkOrange, darkSalmon, darkSeaGreen, darkSlateBlue, darkViolet, deepPink, deepSkyBlue, dimGray, dodgerBlue, firebrick, forestGreen, fuschia, gold, goldenrod, gray, hotPink, indianRed, lightBlue, lightPink, lightSeaGreen, lightSlateBlue, mediumAquamarine, mediumBlue, mediumOrchid, mediumPurple};
        parColorPool = new Color[]{dodgerBlue, orangeRed, Color.MAGENTA, goldenrod, forestGreen, purple, royalBlue, rosyBrown, blueViolet, teal, sienna, mediumTurquoise, pink, skyBlue, tan, slateGray, olive, orchid};
    }
}

