/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.painter;

import ca.ucalgary.bluejay.gui.painter.LaneGetter;
import ca.ucalgary.bluejay.gui.painter.ReadSeqFitemPainter;
import java.util.SortedMap;

public abstract class BioseqSetPainter
extends LaneGetter {
    public static final String POSITIVE_FEATURE_LANE = "Positive feature lane";
    public static final String NEGATIVE_FEATURE_LANE = "Negative negative lane";
    public static final String POSITIVE_FEATURE_LABEL_LANE = "Positive feature label lane";
    public static final String NEGATIVE_FEATURE_LABEL_LANE = "Negative feature label lane";
    public static final String POSITIVE_MICROARRAY_LANE = "Positive microarray lane";
    public static final String NEGATIVE_MICROARRAY_LANE = "Negative microarray lane";
    public static final String POSITIVE_MICROARRAY_LANE1 = "Positive microarray lane1";
    public static final String NEGATIVE_MICROARRAY_LANE1 = "Negative microarray lane1";
    public static final String POSITIVE_MICROARRAY_LANE2 = "Positive microarray lane2";
    public static final String NEGATIVE_MICROARRAY_LANE2 = "Negative microarray lane2";
    public static final String POSITIVE_MICROARRAY_LANE3 = "Positive microarray lane3";
    public static final String NEGATIVE_MICROARRAY_LANE3 = "Negative microarray lane3";
    public static final String POSITIVE_MICROARRAY_LANE4 = "Positive microarray lane4";
    public static final String NEGATIVE_MICROARRAY_LANE4 = "Negative microarray lane4";
    public static final String POSITIVE_MICROARRAY_LANE5 = "Positive microarray lane5";
    public static final String NEGATIVE_MICROARRAY_LANE5 = "Negative microarray lane5";
    public static final String WAYPOINT_LANE = "waypoint lane";
    private static int currentLOD;
    private static final BioseqSetPainter instance;
    public static int APPEARFRAME;

    protected BioseqSetPainter() {
        currentLOD = 80;
    }

    protected void setLOD(int n) throws IllegalArgumentException {
        if (n == currentLOD) {
            return;
        }
        switch (n) {
            case 60: {
                break;
            }
            case 70: {
                break;
            }
            case 80: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Level of Detail must be one of AbstractLinearGraphics .MAJOR_FEATURES .MINOR_FEATURES or .DETAILED_FEATURES");
            }
        }
    }

    public static int[] getLane(int n, String string) {
        if (string == null) {
            return null;
        }
        int[] nArray = (int[])laneMap.get(string);
        if (nArray == null) {
            nArray = LaneGetter.getLane(n, string);
        }
        return nArray;
    }

    public static BioseqSetPainter getInstance() {
        return instance;
    }

    public int[] getLaneNonStatic(int n, String string) {
        return BioseqSetPainter.getLane(n, string);
    }

    public SortedMap getLaneMap() {
        return laneMap;
    }

    static {
        instance = new ReadSeqFitemPainter(null);
        laneMap.put(POSITIVE_FEATURE_LABEL_LANE, new int[]{-90, 70});
        laneMap.put(POSITIVE_FEATURE_LANE, new int[]{-91, 5});
        laneMap.put(NEGATIVE_FEATURE_LANE, new int[]{-92, 5});
        laneMap.put(NEGATIVE_FEATURE_LABEL_LANE, new int[]{-93, 70});
        laneMap.put(POSITIVE_MICROARRAY_LANE, new int[]{-70, 25});
        laneMap.put(NEGATIVE_MICROARRAY_LANE, new int[]{-71, 25});
        laneMap.put(POSITIVE_MICROARRAY_LANE1, new int[]{-73, 25});
        laneMap.put(NEGATIVE_MICROARRAY_LANE1, new int[]{-74, 25});
        laneMap.put(POSITIVE_MICROARRAY_LANE2, new int[]{-76, 25});
        laneMap.put(NEGATIVE_MICROARRAY_LANE2, new int[]{-77, 25});
        laneMap.put(POSITIVE_MICROARRAY_LANE3, new int[]{-78, 25});
        laneMap.put(NEGATIVE_MICROARRAY_LANE3, new int[]{-79, 25});
        laneMap.put(POSITIVE_MICROARRAY_LANE4, new int[]{-80, 25});
        laneMap.put(NEGATIVE_MICROARRAY_LANE4, new int[]{-81, 25});
        laneMap.put(POSITIVE_MICROARRAY_LANE5, new int[]{-82, 25});
        laneMap.put(NEGATIVE_MICROARRAY_LANE5, new int[]{-83, 25});
        laneMap.put(WAYPOINT_LANE, new int[]{101, 40});
        laneMap.put("Backbone lane", new int[]{1, 5});
        laneMap.put("Waypoint line lane", new int[]{100, 30});
        laneMap.put("Positive no-frame lane", new int[]{9, 10});
        laneMap.put("Negative no-frame lane", new int[]{-9, 10});
        laneMap.put("Positive 1st frame lane", new int[]{10, 10});
        laneMap.put("Positive 2nd frame lane", new int[]{15, 10});
        laneMap.put("Positive 3rd frame lane", new int[]{20, 10});
        laneMap.put("Single Frame lane", new int[]{9, 10});
        laneMap.put("Negative 1st frame lane", new int[]{-10, 10});
        laneMap.put("Negative 2nd frame lane", new int[]{-15, 10});
        laneMap.put("Negative 3rd frame lane", new int[]{-20, 10});
    }
}

