/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.painter;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.client.LinearTarget;
import ca.ucalgary.bluejay.client.TargetAppearance;
import ca.ucalgary.bluejay.client.lineartarget.CircularLinearTarget;
import ca.ucalgary.bluejay.client.lineartarget.StraightLinearTarget;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.painter.AbstractBioPainter;
import ca.ucalgary.bluejay.gui.painter.BasicPainter;
import java.awt.Color;
import java.awt.Font;
import java.text.DecimalFormat;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class DNAPainter
extends BasicPainter
implements AbstractBioPainter {
    private int posPerPixelScale;
    private static final int DEFAULT_START = 1;
    private static final int DEFAULT_INIT_ANGLE = 270;
    private static final int PIXELS_NEEDED_FOR_LABEL = 70;
    private static int DNA_UPPER_BOUNDARY_PIXELS = 5;
    private static int DNA_LOWER_BOUNDARY_PIXELS = 5;
    private static final double STRAIGHT_LABEL_PIXELS = 30.0;
    private static final double INFINITE_TOP_RATIO = 111.1;
    private static final double INFINITE_BOTTOM_RATIO = -111.1;
    private static final double COMPASS_LINE_AT_RATIO = -1.1;
    private static final String UNBREAKABLE_STRING = "";
    private static Font fixed;
    DecimalFormat df;
    private static Logger logger;

    public DNAPainter() {
        fixed = new Font("Monospaced", 0, 12);
        this.posPerPixelScale = 0;
        this.df = new DecimalFormat("0.#");
    }

    public void paint(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            boolean bl;
            boolean bl2;
            int n5;
            String string;
            logger.debug("DNAPainter.paint() -- in DNAPAINTER");
            this.posPerPixelScale = (int)abstractLinearGraphics.getScale();
            if (this.posPerPixelScale == 0) {
                this.posPerPixelScale = 1;
            }
            int n6 = (string = dTDElementInstance.getAttribute("end")) != null && !string.equals(UNBREAKABLE_STRING) ? Integer.decode(string).intValue() : ((Object)dTDElementInstance).toString().length();
            TargetAppearance targetAppearance = null;
            if (abstractLinearGraphics.isPreserveTargetAppearances()) {
                targetAppearance = abstractLinearGraphics.getNextPreservedTargetAppearance();
                if (targetAppearance != null && !targetAppearance.getLocalName().equals(dTDElementInstance.getLocalName())) {
                    targetAppearance = null;
                    new Exception("ERROR: TargetAppearance name '" + targetAppearance.getLocalName() + "' does not match DEI name '" + dTDElementInstance.getLocalName() + "'").printStackTrace();
                }
            } else {
                targetAppearance = dTDElementInstance.getTargetAppearance();
            }
            if (targetAppearance == null) {
                boolean bl3 = "circular".equals(dTDElementInstance.getAttribute("shape"));
                n5 = bl3 ? 112 : 111;
                targetAppearance = new TargetAppearance(n5, 1, n6, false, dTDElementInstance.getLocalName(), dTDElementInstance.getXPointer(), true);
                bl2 = false;
                bl = false;
            } else {
                n5 = targetAppearance.getShape();
                bl2 = targetAppearance.isReverseComplement();
                bl = targetAppearance.isShifted();
                logger.debug("DNAPainter.paint() -- for this appearance isReverse is " + bl2);
            }
            dTDElementInstance.setTargetAppearance(targetAppearance);
            double d = (double)n6 / (double)this.posPerPixelScale;
            abstractLinearGraphics.setLOD(this.posPerPixelScale < 500 && d > 2000.0 ? 80 : 60);
            int n7 = abstractLinearGraphics.getLOD();
            if (n7 == 80) {
                n4 = 150;
                n3 = 150;
            } else if (n7 == 70) {
                n4 = 50;
                n3 = 50;
            } else {
                n4 = 50;
                n3 = 50;
            }
            LinearTarget linearTarget = null;
            if (n5 == 112) {
                n2 = (int)(-360.0 * (double)(targetAppearance.getTopPosition() - 1) / (double)(n6 - 1));
                linearTarget = new CircularLinearTarget(abstractLinearGraphics, 1, n6, n3, n4, 1.0 / (double)this.posPerPixelScale, 270 + n2);
            } else if (n5 == 111) {
                linearTarget = new StraightLinearTarget(abstractLinearGraphics, 1, n6, n3, n4, 1.0 / (double)this.posPerPixelScale, false, false);
            } else if (n5 == 119) {
                linearTarget = new StraightLinearTarget(abstractLinearGraphics, 1, n6, n3, n4, 1.0 / (double)this.posPerPixelScale, false, false);
            }
            if (bl2) {
                linearTarget.addMode(1);
            } else {
                linearTarget.removeMode(1);
            }
            if (bl) {
                linearTarget.addMode(2);
                linearTarget.setShift(targetAppearance.getShift());
            } else {
                linearTarget.removeMode(2);
                linearTarget.setShift(0);
            }
            n2 = abstractLinearGraphics.addTarget(linearTarget, dTDElementInstance, 20);
            abstractLinearGraphics.drawString("\n", UNBREAKABLE_STRING, null);
            logger.debug("DNAPainter.paint() -- got to after addTarget");
            String string2 = UNBREAKABLE_STRING;
            int n8 = this.posPerPixelScale * 100;
            Color color = abstractLinearGraphics.getColor();
            double d2 = (double)DNA_UPPER_BOUNDARY_PIXELS / (double)n3;
            double d3 = -((double)DNA_LOWER_BOUNDARY_PIXELS) / (double)n4;
            abstractLinearGraphics.startHyperlink(dTDElementInstance, true);
            abstractLinearGraphics.setColor(Color.yellow);
            abstractLinearGraphics.fillRect(n2, 1, n6, d2, d3);
            abstractLinearGraphics.updateHyperlink(abstractLinearGraphics.getPoint(n2, 1, d2));
            abstractLinearGraphics.setColor(color);
            for (int i = 1; i < n6; i += n8) {
                abstractLinearGraphics.drawLine(n2, i, i, d2, d3);
            }
            abstractLinearGraphics.endHyperlink();
            if (n5 == 112) {
                double d4 = -1.1 - 5.0 / (double)n4;
                double d5 = -1.1 - 10.0 / (double)n4;
                double d6 = (double)n6 / ((double)(this.posPerPixelScale * 2) * Math.PI) - -d5 * (double)n4;
                if (d6 >= 70.0) {
                    abstractLinearGraphics.drawLine(n2, 1, n6, -1.1, -1.1);
                    for (int i = 1; i < n6; i += n8) {
                        string2 = i != 1 && n6 > 20000 ? UNBREAKABLE_STRING + this.df.format(i / 1000) + (n8 > 3000 || (n = i % 1000 / 100) == 0 ? UNBREAKABLE_STRING : "." + n) + "K" : UNBREAKABLE_STRING + i;
                        abstractLinearGraphics.drawString(n2, string2, null, i, d5, -111.1, 40);
                        abstractLinearGraphics.drawLine(n2, i, i, -1.1, d4);
                    }
                }
            } else if (n5 == 111) {
                double d7 = 30.0 / (double)n3;
                for (int i = 1; i < n6; i += n8) {
                    string2 = i != 1 && n6 > 20000 ? UNBREAKABLE_STRING + this.df.format(i / 1000) + (n8 > 3000 || (n = i % 1000 / 100) == 0 ? UNBREAKABLE_STRING : "." + n) + "K" : UNBREAKABLE_STRING + i;
                    abstractLinearGraphics.drawString(n2, string2, null, i, 111.1, d7, 30);
                }
            } else if (n5 == 119) {
                double d8 = 30.0 / (double)n3;
                for (int i = 1; i < n6; i += n8) {
                    string2 = i != 1 && n6 > 20000 ? UNBREAKABLE_STRING + i / 1000 + (n8 > 3000 || (n = i % 1000 / 100) == 0 ? UNBREAKABLE_STRING : "." + n) + "K" : UNBREAKABLE_STRING + i;
                    abstractLinearGraphics.drawString(n2, string2, null, i, 111.1, d8, 30);
                }
            }
            for (Node node = dTDElementInstance.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof DTDElementInstance)) continue;
                logger.debug("DNAPainter.paint() -- DNA calling element paint for " + ((DTDElementInstance)node).getLocalName());
                ((DTDElementInstance)node).setTarget(n2);
                ((DTDElementInstance)node).paint(abstractLinearGraphics);
            }
            abstractLinearGraphics.drawString("\n", UNBREAKABLE_STRING, null);
            abstractLinearGraphics.setColor(Color.black);
        }
        catch (Exception exception) {
            logger.warn(exception.getMessage());
            throw exception;
        }
    }

    public void updateLegendItem(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
    }

    public String getLegendLabel(DTDElementInstance dTDElementInstance) {
        return null;
    }

    public String getToolTip(DTDElementInstance dTDElementInstance) {
        return null;
    }

    static {
        logger = Logger.getLogger(DNAPainter.class);
    }
}

