/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.painter;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.client.LinearTarget;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.VisibilityManager;
import ca.ucalgary.bluejay.gui.painter.BasicTargetPainter;
import ca.ucalgary.bluejay.gui.painter.LaneManager;
import ca.ucalgary.bluejay.gui.painter.TIGRModelPainter;
import ca.ucalgary.bluejay.gui.painter.TIGRPainter;
import java.awt.Color;
import java.util.Vector;
import org.apache.log4j.Logger;

public class TIGRAsmPainter
extends BasicTargetPainter {
    private static final String UNBREAKABLE_STRING = "";
    private TIGRPainter tigrPainterInstance;
    private static Logger logger = Logger.getLogger(TIGRAsmPainter.class);

    public TIGRAsmPainter(LaneManager laneManager, VisibilityManager visibilityManager) {
        super(laneManager, visibilityManager);
        this.setBackboneFillColor(Color.yellow);
        this.tigrPainterInstance = new TIGRModelPainter(null);
    }

    public LinearTarget createTarget(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) {
        int[] nArray = this.tigrPainterInstance.getFeatureRange(dTDElementInstance);
        int n = nArray[0];
        int n2 = nArray[1] - nArray[0] + 1;
        Color color = abstractLinearGraphics.getColor();
        logger.debug("Creating linear target starting at " + n + ", extending length " + n2);
        try {
            this.createTarget(abstractLinearGraphics, dTDElementInstance, n, n2, false);
            abstractLinearGraphics.drawString("\n", UNBREAKABLE_STRING, null);
        }
        catch (Exception exception) {
            logger.warn("ERROR: Cannot create linear target: " + exception.getMessage());
            System.err.println("ERROR: Cannot create linear target: " + exception);
            exception.printStackTrace();
        }
        abstractLinearGraphics.setColor(color);
        logger.debug("got to after addtarget");
        return this.target;
    }

    public void paint(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        double d;
        String string = this.getChildNodeText(dTDElementInstance, "ORGANISM");
        String string2 = this.getChildNodeText(dTDElementInstance, "CLONE_NAME");
        String string3 = UNBREAKABLE_STRING;
        if (string != null) {
            string3 = string;
        }
        if (string2 != null) {
            string3 = string3 + " " + string2;
        }
        if (string3.length() != 0) {
            abstractLinearGraphics.setTitle(string3);
        }
        abstractLinearGraphics.setLOD((d = abstractLinearGraphics.getScale()) < 200.0 && d != -5.898 ? 80 : (d < 2000.0 && d != -5.898 ? 70 : 60));
        if (this.maskPainter != null) {
            System.err.println("PG: Calling mask painter");
            Vector vector = abstractLinearGraphics.getTargetAppearances();
            if (vector.size() == 0) {
                this.maskPainter.paint(abstractLinearGraphics);
            } else {
                this.maskPainter.paint(abstractLinearGraphics);
            }
        }
    }

    protected void setupLaneGetter() {
        this.setLaneGetter(TIGRPainter.getInstance());
    }

    public void updateLegendItem(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        System.err.println("Calling updateLegendItem for TIGR assembly");
        double d = abstractLinearGraphics.getScale();
        abstractLinearGraphics.getVisibilityManager();
        if (d == -5.898) {
            abstractLinearGraphics.setLOD(60);
        } else {
            abstractLinearGraphics.setLOD(d < 200.0 ? 80 : (d < 2000.0 ? 70 : 60));
        }
        LaneManager laneManager = this.getLaneManager();
        int n = abstractLinearGraphics.getLOD();
        laneManager.setLOD(n);
        if (laneManager.getTargetLane(n) == 0) {
            System.err.println("Defining backbone in TIGR ASM");
            laneManager.setTargetLane("Backbone lane", n, TIGRPainter.getTargetLane(n));
            String[] stringArray = new String[]{"Waypoint line lane", "Compass lane", "Compass label lane"};
            TIGRAsmPainter.requestLanes(laneManager, TIGRPainter.getInstance(), n, stringArray);
        }
        super.updateLegendItem(abstractLinearGraphics, dTDElementInstance);
    }

    public int[] getFeatureRange(DTDElementInstance dTDElementInstance) {
        return this.tigrPainterInstance.getFeatureRange(dTDElementInstance);
    }

    public String getLegendLabel(DTDElementInstance dTDElementInstance) {
        return "Assembly";
    }
}

