/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.painter;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.painter.LaneManager;
import ca.ucalgary.bluejay.gui.painter.TIGRPainter;
import java.awt.Color;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TIGRCDSPainter
extends TIGRPainter {
    private LaneManager lm;
    private boolean isPosLinePresent = false;
    private boolean isNegLinePresent = false;
    private static final Color colorNoType = Color.gray;
    private static Logger logger = Logger.getLogger(TIGRCDSPainter.class);

    public TIGRCDSPainter(LaneManager laneManager) {
        this.lm = laneManager;
    }

    public void paint(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        int n = abstractLinearGraphics.getLOD();
        if (!dTDElementInstance.isModelVisible() || n != 80) {
            return;
        }
        int[] nArray = this.getFeatureRange(dTDElementInstance);
        int n2 = nArray[0];
        int n3 = nArray[1];
        logger.debug("Drawing CDS from " + n2 + "  to " + n3);
        Color color = abstractLinearGraphics.getColor();
        double[] dArray = null;
        int n4 = dTDElementInstance.getTarget();
        dArray = this.lm.getLane(n2 > n3 ? TIGRPainter.CDSNegLocation : TIGRPainter.CDSPosLocation, n);
        abstractLinearGraphics.setColor(Color.gray);
        if (!this.isPosLinePresent || !this.isNegLinePresent) {
            if (n2 > n3) {
                this.drawLaneLine(abstractLinearGraphics, n4, dArray[0]);
                this.isNegLinePresent = true;
            } else {
                this.drawLaneLine(abstractLinearGraphics, n4, dArray[1]);
                this.isPosLinePresent = true;
            }
        }
        if (dArray == null) {
            logger.debug("Whoa!!!!!!! No lane for CDS!");
        }
        String string = this.getDataClass(dTDElementInstance);
        Color color2 = colorNoType;
        if (string != null) {
            color2 = (Color)classColorMapping.get(string);
        }
        abstractLinearGraphics.setColor(color2);
        if (n2 > n3) {
            abstractLinearGraphics.fillRect(n4, n3, n2, dArray[0], dArray[1]);
        } else {
            abstractLinearGraphics.fillRect(n4, n2, n3, dArray[0], dArray[1]);
        }
        abstractLinearGraphics.setColor(color);
    }

    public String getDataClass(DTDElementInstance dTDElementInstance) throws Exception {
        NodeList nodeList = ((Element)dTDElementInstance.getParentNode().getParentNode().getParentNode()).getElementsByTagName("GENE_INFO");
        if (nodeList.getLength() == 0) {
            return null;
        }
        NodeList nodeList2 = ((Element)nodeList.item(0)).getElementsByTagName("GENE_ONTOLOGY");
        if (nodeList2.getLength() == 0) {
            return null;
        }
        NodeList nodeList3 = ((Element)nodeList2.item(0)).getElementsByTagName("GO_ID");
        if (nodeList3.getLength() == 0) {
            return null;
        }
        NodeList nodeList4 = ((Element)nodeList3.item(0)).getElementsByTagName("GO_TERM");
        if (nodeList4.getLength() == 0) {
            return null;
        }
        NodeList nodeList5 = ((Element)nodeList3.item(0)).getElementsByTagName("GO_TYPE");
        String string = "";
        String string2 = "";
        if (nodeList3.getLength() > 1) {
            for (int i = 0; i < nodeList3.getLength(); ++i) {
                ((Element)nodeList3.item(i)).getElementsByTagName("GO_TERM").item(0).normalize();
                string = ((Element)nodeList3.item(i)).getElementsByTagName("GO_TERM").item(0).getFirstChild().getNodeValue();
                string2 = ((Element)nodeList3.item(i)).getElementsByTagName("GO_TYPE").item(0).getFirstChild().getNodeValue();
                if (!string2.equals("function")) {
                    continue;
                }
                break;
            }
        } else {
            ((Element)nodeList4.item(0)).normalize();
            string = nodeList4.item(0).getFirstChild().getNodeValue();
            string2 = nodeList5.item(0).getFirstChild().getNodeValue();
        }
        if (!string2.equals("function")) {
            string = "molecular_function unknown";
        }
        return string.replaceAll("'", "&apos;");
    }

    public void updateLegendItem(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        this.isPosLinePresent = false;
        this.isNegLinePresent = false;
        int n = abstractLinearGraphics.getLOD();
        if (n == 80) {
            double[] dArray = this.lm.getLane(TIGRPainter.CDSPosLocation, n);
            if (dArray == null) {
                this.lm.addLane(TIGRPainter.CDSPosLocation, n, TIGRPainter.getLane(n, TIGRPainter.CDSPosLocation));
            }
            if ((dArray = this.lm.getLane(TIGRPainter.CDSNegLocation, n)) == null) {
                this.lm.addLane(TIGRPainter.CDSNegLocation, n, TIGRPainter.getLane(n, TIGRPainter.CDSNegLocation));
            }
        }
    }

    public String getLegendLabel(DTDElementInstance dTDElementInstance) {
        return "Protein Coding Sequence";
    }
}

