/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.painter;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.Legend;
import ca.ucalgary.bluejay.gui.painter.LaneManager;
import ca.ucalgary.bluejay.gui.painter.TIGRPainter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import org.apache.log4j.Logger;

public class TIGRUTRPainter
extends TIGRPainter {
    private LaneManager lm;
    private static Logger logger = Logger.getLogger(TIGRUTRPainter.class);

    public TIGRUTRPainter(LaneManager laneManager) {
        this.lm = laneManager;
    }

    public void paint(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        int n = abstractLinearGraphics.getLOD();
        if (!dTDElementInstance.isModelVisible() || n != 80) {
            return;
        }
        int[] nArray = this.getFeatureRange(dTDElementInstance);
        int n2 = nArray[0];
        int n3 = nArray[1];
        Color color = abstractLinearGraphics.getColor();
        abstractLinearGraphics.setColor(Color.red);
        double[] dArray = null;
        dArray = this.lm.getLane(n2 > n3 ? TIGRPainter.CDSNegLocation : TIGRPainter.CDSPosLocation, n);
        if (dArray == null) {
            logger.debug("Whoa!!!!!!! No lane for UTR!");
        }
        int n4 = dTDElementInstance.getTarget();
        if (n2 > n3) {
            abstractLinearGraphics.fillRect(n4, n3, n2, dArray[0], dArray[1]);
        } else {
            abstractLinearGraphics.fillRect(n4, n2, n3, dArray[0], dArray[1]);
        }
        abstractLinearGraphics.setColor(color);
    }

    public void updateLegendItem(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        String string = "UTR";
        String string2 = "//tigr:UTR";
        Color color = Color.red;
        Image image = abstractLinearGraphics.getLegend().createImage(Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
        Graphics graphics = image.getGraphics();
        graphics.setColor(color);
        graphics.fillRect(0, 0, Legend.SWATCH_WIDTH - 1, Legend.SWATCH_HEIGHT - 1);
        abstractLinearGraphics.getLegend().addItem(image, string, string2, dTDElementInstance.getXPointer(), color);
    }

    public String getLegendLabel(DTDElementInstance dTDElementInstance) {
        return "Untranslated transcript region";
    }
}

