/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.painter;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.client.LinearTarget;
import ca.ucalgary.bluejay.client.impl.BluejayDTDElementInstance;
import ca.ucalgary.bluejay.client.lineartarget.TextLinearTarget;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.painter.LaneGetter;
import ca.ucalgary.bluejay.gui.painter.LaneManager;
import ca.ucalgary.bluejay.gui.util.Conversion;
import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class TranslationPainter
extends LaneGetter {
    private int target;
    private int start;
    private int end;
    private Integer row;
    private int lastTarget;
    private static final Color colorNoType = Color.gray;
    private static final boolean ADD_LEGEND_ITEM = true;
    private static final int NUM_COLORS = 256;
    private Hashtable classColorMapping = new Hashtable(256, 0.95f);
    private Hashtable legendSwatches = new Hashtable(256, 0.95f);
    private static LaneManager laneManager;
    private double[] geneLane;
    private static TranslationPainter instance;
    private static Logger logger;

    private TranslationPainter() {
    }

    public static TranslationPainter getInstance() {
        if (instance == null) {
            instance = new TranslationPainter();
        }
        return instance;
    }

    public void paint(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        LinearTarget linearTarget;
        if (laneManager != null && dTDElementInstance.getTarget() >= 0 && (linearTarget = abstractLinearGraphics.getTarget(dTDElementInstance.getTarget())) instanceof TextLinearTarget) {
            String string = ((TextLinearTarget)linearTarget).getSequence(abstractLinearGraphics.getDTDElementInstance().getSlaveNum()).substring(((BluejayDTDElementInstance)dTDElementInstance).getStart() - 1, ((BluejayDTDElementInstance)dTDElementInstance).getEnd());
            if (abstractLinearGraphics.isTwoFrameTranslation()) {
                this.twoFrameTranslation(abstractLinearGraphics, dTDElementInstance, string);
            } else if (abstractLinearGraphics.isSixFrameTranslation()) {
                this.sixFrameTranslation(abstractLinearGraphics, dTDElementInstance, string);
            }
        }
    }

    public void sixFrameTranslation(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance, String string) {
        double[] dArray = ((BluejayDTDElementInstance)dTDElementInstance).getLane();
        double[] dArray2 = laneManager.getLane("Positive no-frame lane");
        int n = 0;
        n = dArray[0] == dArray2[0] ? 1 : -1;
        for (int i = 0; i < 3; ++i) {
            if (n > 0) {
                switch (i) {
                    case 0: {
                        dArray2 = laneManager.getLane("Positive 1st frame translation lane");
                        break;
                    }
                    case 1: {
                        dArray2 = laneManager.getLane("Positive 2nd frame translation lane");
                        break;
                    }
                    case 2: {
                        dArray2 = laneManager.getLane("Positive 3rd frame translation lane");
                        break;
                    }
                }
            } else if (n < 0) {
                switch (i) {
                    case 0: {
                        dArray2 = laneManager.getLane("Negative 1st frame translation lane");
                        break;
                    }
                    case 1: {
                        dArray2 = laneManager.getLane("Negative 2nd frame translation lane");
                        break;
                    }
                    case 2: {
                        dArray2 = laneManager.getLane("Negative 3rd frame translation lane");
                        break;
                    }
                }
            }
            this.drawColoredSequence(abstractLinearGraphics, dTDElementInstance, dArray2, string, i);
        }
    }

    public void drawColoredSequence(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance, double[] dArray, String string, int n) {
        Conversion conversion = new Conversion();
        int n2 = n;
        while (n2 + 3 <= string.length()) {
            String string2 = string.substring(n2, n2 + 3);
            Color color = Color.BLACK;
            if (abstractLinearGraphics.isOneLetter()) {
                color = conversion.getColor(conversion.toThree(string2));
                string2 = conversion.toOne(string2);
            } else if (abstractLinearGraphics.isThreeLetter()) {
                string2 = conversion.toThree(string2);
                color = conversion.getColor(string2);
            } else {
                logger.error("NOT ONE LETTER OR THREE LETTER AMINO ACID TRANSLATION");
                return;
            }
            if (n > 0) {
                color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 150);
            }
            abstractLinearGraphics.setColor(color);
            abstractLinearGraphics.drawAngledString(dTDElementInstance.getTarget(), string2, new Font("Monospaced", 0, 12), ((BluejayDTDElementInstance)dTDElementInstance).getStart() + n2, dArray[1], 30, abstractLinearGraphics.isTextHMode() ? 270.0 : 180.0);
            n2 += 3;
        }
    }

    public void twoFrameTranslation(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance, String string) {
        double[] dArray;
        Object var4_4 = null;
        double[] dArray2 = ((BluejayDTDElementInstance)dTDElementInstance).getLane();
        if (dArray2[0] == (dArray = laneManager.getLane("Positive no-frame lane"))[0]) {
            System.err.println("POSITIVE");
            dArray = laneManager.getLane("Positive 1st frame translation lane");
        } else {
            System.err.println("NEGATIVE");
            dArray = laneManager.getLane("Negative 1st frame translation lane");
        }
        this.drawColoredSequence(abstractLinearGraphics, dTDElementInstance, dArray, string, 0);
    }

    public void updateLegendItem(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) {
        if (laneManager == null) {
            laneManager = abstractLinearGraphics.getVisibilityManager().getMaskPainter(0).getLaneManager();
        }
        if (laneManager != null) {
            try {
                if (abstractLinearGraphics.isTwoFrameTranslation()) {
                    String[] stringArray = new String[]{"Positive 1st frame translation lane", "Negative 1st frame translation lane"};
                    TranslationPainter.requestLanes(laneManager, this, abstractLinearGraphics.getLOD(), stringArray);
                } else if (abstractLinearGraphics.isSixFrameTranslation()) {
                    String[] stringArray = new String[]{"Positive 1st frame translation lane", "Negative 1st frame translation lane", "Positive 2nd frame translation lane", "Positive 3rd frame translation lane", "Negative 2nd frame translation lane", "Negative 3rd frame translation lane"};
                    TranslationPainter.requestLanes(laneManager, this, abstractLinearGraphics.getLOD(), stringArray);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setGeneLane(double[] dArray) {
        this.geneLane = dArray;
    }

    static {
        logger = Logger.getLogger(TranslationPainter.class);
    }
}

