/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.util;

import ca.ucalgary.bluejay.gui.util.DescriptiveFileFilter;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.Writer;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.batik.apps.svgbrowser.JPEGOptionPanel;
import org.apache.batik.apps.svgbrowser.PNGOptionPanel;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.transcoder.image.TIFFTranscoder;
import org.apache.batik.transcoder.svg2svg.SVGTranscoder;
import org.w3c.dom.svg.SVGDocument;

public class JSVGExportUtility {
    public static final String TIF_DESC = "TIFF (Prepress Image)";
    public static final String PNG_DESC = "PNG (Web Image)";
    public static final String JPG_DESC = "JPEG (Lossy Web Image)";
    public static final String SVG_DESC = "SVG (Scalable Vector Graphics)";
    public static final String TIF_EXT = ".tif";
    public static final String PNG_EXT = ".png";
    public static final String JPG_EXT = ".jpg";
    public static final String SVG_EXT = ".svg";
    public static final int PNG_KEY_INDEXED = 256;
    private static File currentDir;

    public static void exportDocument(SVGDocument sVGDocument) {
        JSVGExportUtility.exportDocument(sVGDocument, null, null);
    }

    public static void exportDocument(final SVGDocument sVGDocument, final AffineTransform affineTransform, final Dimension dimension) {
        if (sVGDocument != null) {
            new Thread(){

                public void run() {
                    JFileChooser jFileChooser = new JFileChooser(currentDir);
                    jFileChooser.setDialogTitle("Export as raster image");
                    jFileChooser.setFileHidingEnabled(false);
                    jFileChooser.setFileSelectionMode(0);
                    jFileChooser.addChoosableFileFilter(new DescriptiveFileFilter(JSVGExportUtility.TIF_EXT, JSVGExportUtility.TIF_DESC));
                    jFileChooser.addChoosableFileFilter(new DescriptiveFileFilter(JSVGExportUtility.JPG_EXT, JSVGExportUtility.JPG_DESC));
                    jFileChooser.addChoosableFileFilter(new DescriptiveFileFilter(JSVGExportUtility.PNG_EXT, JSVGExportUtility.PNG_DESC));
                    jFileChooser.addChoosableFileFilter(new DescriptiveFileFilter(JSVGExportUtility.SVG_EXT, JSVGExportUtility.SVG_DESC));
                    jFileChooser.setAcceptAllFileFilterUsed(false);
                    int n = jFileChooser.showSaveDialog(null);
                    if (n == 0) {
                        String string;
                        Object object;
                        currentDir = jFileChooser.getCurrentDirectory();
                        if (affineTransform != null && dimension != null) {
                            object = sVGDocument.getRootElement();
                            string = "" + affineTransform.getTranslateX() * -1.0 + " " + affineTransform.getTranslateY() * -1.0 + " " + dimension.width + " " + dimension.height;
                            object.setAttribute("viewBox", string);
                        }
                        object = jFileChooser.getSelectedFile();
                        string = ((File)object).getName();
                        FileFilter fileFilter = jFileChooser.getFileFilter();
                        if (string.indexOf(JSVGExportUtility.JPG_EXT) == string.length() - JSVGExportUtility.JPG_EXT.length()) {
                            JSVGExportUtility.exportJPG(sVGDocument, (File)object);
                        } else if (string.indexOf(JSVGExportUtility.PNG_EXT) == string.length() - JSVGExportUtility.PNG_EXT.length()) {
                            JSVGExportUtility.exportPNG(sVGDocument, (File)object);
                        } else if (string.indexOf(JSVGExportUtility.TIF_EXT) == string.length() - JSVGExportUtility.TIF_EXT.length()) {
                            JSVGExportUtility.exportTIF(sVGDocument, (File)object);
                        } else if (string.indexOf(JSVGExportUtility.SVG_EXT) == string.length() - JSVGExportUtility.SVG_EXT.length()) {
                            JSVGExportUtility.exportSVG(sVGDocument, (File)object);
                        } else if (fileFilter.getDescription().equals(JSVGExportUtility.JPG_DESC)) {
                            JSVGExportUtility.exportJPG(sVGDocument, new File(((File)object).getParent(), string + JSVGExportUtility.JPG_EXT));
                        } else if (fileFilter.getDescription().equals(JSVGExportUtility.PNG_DESC)) {
                            JSVGExportUtility.exportPNG(sVGDocument, new File(((File)object).getParent(), string + JSVGExportUtility.PNG_EXT));
                        } else if (fileFilter.getDescription().equals(JSVGExportUtility.TIF_DESC)) {
                            JSVGExportUtility.exportTIF(sVGDocument, new File(((File)object).getParent(), string + JSVGExportUtility.TIF_EXT));
                        } else if (fileFilter.getDescription().equals(JSVGExportUtility.SVG_DESC)) {
                            JSVGExportUtility.exportSVG(sVGDocument, new File(((File)object).getParent(), string + JSVGExportUtility.SVG_EXT));
                        } else {
                            System.err.println("Could not determine file type for " + string);
                        }
                    }
                }
            }.start();
        }
    }

    public static void exportJPG(final SVGDocument sVGDocument, final File file) {
        float f = JPEGOptionPanel.showDialog(null);
        final JPEGTranscoder jPEGTranscoder = new JPEGTranscoder();
        jPEGTranscoder.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, new Float(f));
        new Thread(){

            public void run() {
                try {
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                    jPEGTranscoder.transcode(new TranscoderInput(sVGDocument), new TranscoderOutput(bufferedOutputStream));
                    ((OutputStream)bufferedOutputStream).flush();
                    ((OutputStream)bufferedOutputStream).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public static void exportPNG(final SVGDocument sVGDocument, final File file) {
        boolean bl = PNGOptionPanel.showDialog(null);
        final PNGTranscoder pNGTranscoder = new PNGTranscoder();
        pNGTranscoder.addTranscodingHint(PNGTranscoder.KEY_FORCE_TRANSPARENT_WHITE, new Boolean(true));
        if (bl) {
            pNGTranscoder.addTranscodingHint(PNGTranscoder.KEY_INDEXED, new Integer(256));
        }
        new Thread(){

            public void run() {
                try {
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                    pNGTranscoder.transcode(new TranscoderInput(sVGDocument), new TranscoderOutput(bufferedOutputStream));
                    ((OutputStream)bufferedOutputStream).flush();
                    ((OutputStream)bufferedOutputStream).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public static void exportTIF(final SVGDocument sVGDocument, final File file) {
        final TIFFTranscoder tIFFTranscoder = new TIFFTranscoder();
        new Thread(){

            public void run() {
                try {
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                    tIFFTranscoder.transcode(new TranscoderInput(sVGDocument), new TranscoderOutput(bufferedOutputStream));
                    ((OutputStream)bufferedOutputStream).flush();
                    ((OutputStream)bufferedOutputStream).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public static void exportSVG(final SVGDocument sVGDocument, final File file) {
        final SVGTranscoder sVGTranscoder = new SVGTranscoder();
        new Thread(){

            public void run() {
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                    sVGTranscoder.transcode(new TranscoderInput(sVGDocument), new TranscoderOutput(bufferedWriter));
                    ((Writer)bufferedWriter).flush();
                    ((Writer)bufferedWriter).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }
}

