/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.util;

import ca.ucalgary.bluejay.gui.util.GlassPane;
import ca.ucalgary.bluejay.gui.util.GlassPaneCreator;
import java.awt.Component;
import javax.swing.SwingUtilities;

public abstract class SwingWorkerVariant {
    private Object value;
    private Thread thread;
    private Thread oldThread;
    protected ThreadVar threadVar;
    protected static Component aComponent;

    public SwingWorkerVariant() {
        this.setAComponent();
        final Runnable runnable = new Runnable(){

            public void run() {
                SwingWorkerVariant.this.finished();
            }
        };
        Runnable runnable2 = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    SwingWorkerVariant.this.construct();
                }
                finally {
                    SwingWorkerVariant.this.threadVar.clear();
                }
                SwingUtilities.invokeLater(runnable);
            }
        };
        this.oldThread = null;
        Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable2);
        this.threadVar = new ThreadVar(thread);
    }

    protected synchronized Object getValue() {
        return this.value;
    }

    protected synchronized void setValue(Object object) {
        this.value = object;
    }

    public Thread getOldThread() {
        return this.oldThread;
    }

    public void join() throws InterruptedException {
        this.threadVar.get().join();
    }

    public Object get() {
        Thread thread;
        while ((thread = this.threadVar.get()) != null) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.getValue();
    }

    public boolean isHolding(Object object) {
        this.threadVar.get();
        return Thread.holdsLock(object);
    }

    protected void activateGlassPane() {
        if (this.getGlassPane() != null) {
            this.getGlassPane().setVisible(true);
        }
    }

    protected void construct() {
        try {
            this.doThings();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public abstract void doThings() throws RuntimeException;

    public void deactivateGlassPane() {
        if (this.getGlassPane() != null) {
            this.getGlassPane().setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() {
        try {
            this.deactivateGlassPane();
        }
        catch (RuntimeException runtimeException) {
            System.out.println("SwingWorkerVariant error" + runtimeException);
        }
        finally {
            if (this.getAComponent() != null) {
                this.getAComponent().requestFocus();
            }
        }
    }

    protected Component getAComponent() {
        return aComponent;
    }

    protected GlassPane getGlassPane() {
        return GlassPaneCreator.glassPane;
    }

    public void interrupt() {
        Thread thread = this.threadVar.get();
        if (thread != null) {
            thread.interrupt();
        }
        this.oldThread = thread;
        this.threadVar.clear();
    }

    protected void setAComponent() {
        aComponent = GlassPaneCreator.getAComponent();
    }

    public void start() {
        Thread thread = this.threadVar.get();
        if (thread != null) {
            thread.start();
        }
    }

    protected static class ThreadVar {
        private Thread thread;

        ThreadVar(Thread thread) {
            this.thread = thread;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

