/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.session;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.session.Entry;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CosineSimEngine {
    public Vector makeQueryVector(DTDElementInstance dTDElementInstance) {
        Entry entry = new Entry(dTDElementInstance, -1);
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = entry.getWordsAndOccurances().keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            vector.add(string);
        }
        return vector;
    }

    public Vector[] makeVectors(Vector vector, Hashtable hashtable) {
        Vector[] vectorArray = new Vector[2];
        Vector<Double> vector2 = new Vector<Double>(vector.size());
        Vector<Double> vector3 = new Vector<Double>(vector.size());
        for (String string : vector) {
            Double d = (Double)hashtable.get(string);
            if (d == null) {
                vector2.add(new Double(0.0));
            } else {
                vector2.add(d);
            }
            vector3.add(new Double(1.0));
        }
        vectorArray[0] = vector2;
        vectorArray[1] = vector3;
        return vectorArray;
    }

    public double dotProductSum(Vector<Double> vector, Vector<Double> vector2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < vector.size(); ++i) {
            d2 = vector.elementAt(i);
            d3 = vector2.elementAt(i);
            d4 = d2 * d3;
            d += d4;
        }
        return d;
    }

    public double squareSumSquareRoot(Vector<Double> vector) {
        double d = 0.0;
        double d22 = 0.0;
        for (double d22 : vector) {
            d22 *= d22;
            d += d22;
        }
        d = Math.sqrt(d);
        return d;
    }

    public double crossProduct(Vector vector, Vector vector2) {
        double d = this.squareSumSquareRoot(vector);
        double d2 = this.squareSumSquareRoot(vector2);
        return d * d2;
    }

    public double cosineSim(double d, double d2) {
        double d3 = 0.0;
        if (d2 != 0.0) {
            d3 = d / d2;
        }
        return d3;
    }

    public double getCosineSim(DTDElementInstance dTDElementInstance, Hashtable hashtable) {
        if (hashtable != null) {
            Vector[] vectorArray = this.makeVectors(this.makeQueryVector(dTDElementInstance), hashtable);
            double d = this.dotProductSum(vectorArray[0], vectorArray[1]);
            double d2 = this.crossProduct(vectorArray[0], vectorArray[1]);
            double d3 = this.cosineSim(d, d2);
            return d3;
        }
        return 0.0;
    }
}

