/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.session;

import ca.ucalgary.bluejay.client.NewClient;
import ca.ucalgary.bluejay.gui.WaypointsTab;
import ca.ucalgary.bluejay.gui.menu.BookmarksMenuManager;
import ca.ucalgary.bluejay.session.History;
import ca.ucalgary.bluejay.session.ICategories;
import ca.ucalgary.bluejay.session.LoginInfo;
import ca.ucalgary.bluejay.session.NameExistsException;
import ca.ucalgary.bluejay.session.PasswordMismatchException;
import ca.ucalgary.bluejay.session.PersonalizationController;
import ca.ucalgary.bluejay.session.SessionExpiredException;
import ca.ucalgary.bluejay.session.StateCollection;
import ca.ucalgary.bluejay.session.URLReturn;
import ca.ucalgary.bluejay.session.UserAlreadyExistsException;
import ca.ucalgary.bluejay.session.UserDoesNotExistException;
import ca.ucalgary.bluejay.session.WaypointsInfo;
import com.skaringa.javaxml.NoImplementationException;
import com.skaringa.javaxml.SerializerException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class SessionManager
implements PropertyChangeListener {
    public static final String CONNECTED_PROPERTY = "server_connection";
    public static final String LOGGED_IN_PROPERTY = "logged_in";
    public static final String NEW_LOGIN_STATUS = "newbie_just_logged_in";
    public static final String LOGGED_IN_STATUS = "oldie_just_logged_in";
    public static final String ANONYMOUS_STATUS = "guest_just_logged_in";
    private String loginStatus = "guest_just_logged_in";
    NewClient newSession = null;
    private static LoginInfo info = null;
    private Vector userInvestigationNames = null;
    private Vector userInvestigationIndices = null;
    private int userCurrentInvestigationID = 0;
    private static History sessionHistory = null;
    private static ICategories investigationCategories = null;
    private Vector iCategoryNames = null;
    private Vector iCategoryIDs = null;
    private URLReturn currentURLReturn = null;
    private Vector serverListeners;
    private Vector loginListeners;
    private String userName;
    private String currentURL;
    private BookmarksMenuManager bookmarksMenu;
    private WaypointsTab waypts;
    private PersonalizationController personalController;
    private static Logger logger = Logger.getLogger(SessionManager.class);

    public SessionManager() {
        investigationCategories = new ICategories();
        this.serverListeners = new Vector();
        this.loginListeners = new Vector();
    }

    public History initialSessionManagerLogin() {
        logger.debug("JS: Session Manager request for initialSessionManagerLogin");
        try {
            this.newSession = this.createNewSession();
            if (this.newSession != null) {
                this.anonymousLogin();
            }
            String string = "New";
            int n = 3;
            sessionHistory = this.createNewInvestigation(string, n);
        }
        catch (NameExistsException nameExistsException) {
            logger.warn(nameExistsException.getMessage());
            System.err.println("Caught a NameExistsE in initialSessionManagerLogin " + nameExistsException.getMessage());
        }
        logger.debug("JS: initialSessionManagerLogin completed");
        return sessionHistory;
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (string.equals(CONNECTED_PROPERTY)) {
            if (!this.serverListeners.contains(propertyChangeListener)) {
                this.serverListeners.add(propertyChangeListener);
            }
        } else if (string.equals(LOGGED_IN_PROPERTY)) {
            if (!this.loginListeners.contains(propertyChangeListener)) {
                this.loginListeners.add(propertyChangeListener);
            }
        } else {
            System.err.println("Bad property name in sessionManager.addPropertyChangeListener");
        }
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (string.equals(CONNECTED_PROPERTY)) {
            this.serverListeners.remove(propertyChangeListener);
        } else if (string.equals(LOGGED_IN_PROPERTY)) {
            this.loginListeners.remove(propertyChangeListener);
        } else {
            System.err.println("Bad property name in sessionManager.removePropertyChangeListener");
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(CONNECTED_PROPERTY)) {
            Enumeration enumeration = this.serverListeners.elements();
            while (enumeration.hasMoreElements()) {
                ((PropertyChangeListener)enumeration.nextElement()).propertyChange(propertyChangeEvent);
            }
        } else if (propertyChangeEvent.getPropertyName().equals(LOGGED_IN_PROPERTY)) {
            Enumeration enumeration = this.loginListeners.elements();
            while (enumeration.hasMoreElements()) {
                ((PropertyChangeListener)enumeration.nextElement()).propertyChange(propertyChangeEvent);
            }
        } else if (propertyChangeEvent.getPropertyName() == "Add/remove waypoint") {
            String[] stringArray = (String[])propertyChangeEvent.getOldValue();
            String[] stringArray2 = (String[])propertyChangeEvent.getNewValue();
            if (stringArray == null) {
                int n = this.addWaypoint(stringArray2[0], stringArray2[1]);
                this.waypts.setWID(stringArray2[0], n);
            } else if (stringArray2 == null) {
                this.removeWaypoint(Integer.parseInt(stringArray[0]));
            } else {
                this.changeWaypointName(Integer.parseInt(stringArray[0]), stringArray2[0]);
            }
        } else {
            System.err.println("Bad property name in sessionManager.propertyChange");
            return;
        }
    }

    public void requestNewSession() {
        logger.debug("JS: Session Manager request for requestNewSession!!!");
        String string = null;
        try {
            this.newSession.stopPing();
            this.newSession = new NewClient();
            this.newSession.addPropertyChangeListener(this);
            string = this.tryServerConnection();
        }
        catch (ServiceException serviceException) {
            logger.warn("Internet connection was not available" + serviceException.getMessage());
            System.err.println("Internet connection was not available" + serviceException.getMessage());
            this.newSession = null;
        }
        catch (Exception exception) {
            logger.warn("General exception occured in requestNewSession " + exception.getMessage());
            System.err.println("General exception occured in requestNewSession " + exception.getMessage());
        }
    }

    private NewClient createNewSession() {
        logger.debug("JS: Session Manager request for createNewSession");
        Object var1_1 = null;
        try {
            this.newSession = new NewClient();
            this.newSession.addPropertyChangeListener(this);
        }
        catch (ServiceException serviceException) {
            logger.warn("Internet connection was not available" + serviceException.getMessage());
            System.err.println("Internet connection was not available" + serviceException.getMessage());
            this.newSession = null;
        }
        catch (Exception exception) {
            logger.warn("General exception occured in createNewSession " + exception.getMessage());
            System.err.println("General exception occured in createNewSession " + exception.getMessage());
        }
        return this.newSession;
    }

    private String tryServerConnection() {
        String string = new String();
        try {
            string = this.newSession.noOP();
            logger.debug("Return from server is: " + string);
        }
        catch (Exception exception) {
            logger.warn("General exception occured in isConnected " + exception.getMessage());
            System.err.println("General exception occured in isConnected " + exception.getMessage());
        }
        return string;
    }

    public boolean isConnected() {
        boolean bl = false;
        logger.debug("JS: Someone wants to know if we are connected");
        if (this.tryServerConnection().equals(NewClient.CONNECTION_STRING)) {
            bl = true;
        }
        return bl;
    }

    public Vector getUserInvestigations() {
        logger.debug("JS: Request for getUserInvestigations");
        if (this.userInvestigationNames.size() <= 0) {
            return null;
        }
        return this.userInvestigationNames;
    }

    public History getCurrentSessionHistory() {
        logger.debug("JS: Request for getCurrentSessionHistory");
        try {
            sessionHistory = this.newSession.resumeInvestigation(info.getCurrInvesID());
            Vector vector = sessionHistory.getInternetURLs();
            logger.debug("\n\nLoading URL History: " + vector.toString());
        }
        catch (SessionExpiredException sessionExpiredException) {
            logger.warn(sessionExpiredException.getMessage());
            System.err.println(sessionExpiredException.getMessage());
        }
        catch (SQLException sQLException) {
            logger.warn(sQLException.getMessage());
            System.err.println(sQLException.getMessage());
        }
        catch (Exception exception) {
            logger.warn(exception.getMessage());
            System.err.println("Caught in load current investigation " + exception);
            exception.printStackTrace();
        }
        return sessionHistory;
    }

    public Vector getICategoryNames() {
        logger.debug("JS: Request for getICategoryNames");
        this.iCategoryNames = investigationCategories.getNames();
        if (this.iCategoryNames.size() <= 0) {
            return null;
        }
        return this.iCategoryNames;
    }

    public Vector getICategoryIDs() {
        logger.debug("JS: Request for getICategoryIDs");
        this.iCategoryIDs = investigationCategories.getIDs();
        if (this.iCategoryNames.size() <= 0) {
            return null;
        }
        return this.iCategoryNames;
    }

    public History createNewInvestigation(String string, int n) throws NameExistsException {
        int n2 = -1;
        try {
            n2 = this.newSession.newInvestigation(string, n);
            sessionHistory = this.newSession.resumeInvestigation(n2);
            info.addInvestigation(string, n2);
        }
        catch (SessionExpiredException sessionExpiredException) {
            logger.warn(sessionExpiredException.getMessage());
            System.err.println(sessionExpiredException.getMessage());
        }
        catch (Exception exception) {
            logger.warn("Crazy EXCeption here" + exception.getMessage());
            System.err.println("Crazy EXCeption here" + exception.getMessage());
            exception.printStackTrace();
        }
        return sessionHistory;
    }

    public URL sessionRequestURL(URL uRL) {
        return uRL;
    }

    public int sessionRequestVisitID() {
        if (this.currentURLReturn != null) {
            return this.currentURLReturn.getVID();
        }
        return -1;
    }

    public int sessionRevisitURL(Integer n) {
        int n2 = 0;
        try {
            n2 = this.newSession.goTo(n);
        }
        catch (SessionExpiredException sessionExpiredException) {
            logger.warn(sessionExpiredException.getMessage());
            System.err.println(sessionExpiredException.getMessage());
        }
        catch (Exception exception) {
            logger.warn(exception.getMessage());
            System.err.println(exception.getMessage());
        }
        return n2;
    }

    public void leavingPage(Integer n) {
        int n2 = sessionHistory.getTimeSpent();
        StateCollection stateCollection = new StateCollection();
        String string = stateCollection.getCacheAppearance();
        int n3 = stateCollection.getRating();
        try {
            this.newSession.leavingPage(n, n2, string);
            this.newSession.ratePage(n, n3);
        }
        catch (SQLException sQLException) {
            logger.warn(sQLException.getMessage());
            System.err.println("Session Manager: SQLException in leavingPage");
            sQLException.printStackTrace();
        }
        catch (IOException iOException) {
            logger.warn(iOException.getMessage());
            System.err.println("Session Manager: IOException in leavingPage");
            iOException.printStackTrace();
        }
    }

    public void saveUserInfo() {
        try {
            this.newSession.setBookmarks(this.bookmarksMenu.getStringBookmarksXMLFormat());
            logger.debug("Bookmarks that were saved: " + this.newSession.getBookmarks());
        }
        catch (SQLException sQLException) {
            logger.warn(sQLException.getMessage());
            System.err.println("SQL Exception in Session Manager:saveUserInfo.");
            sQLException.printStackTrace();
        }
        catch (SessionExpiredException sessionExpiredException) {
            logger.warn(sessionExpiredException.getMessage());
            System.err.println("Session Expired Exception in Session Manager:saveUserInfo.");
            sessionExpiredException.printStackTrace();
        }
    }

    public void logout() {
        try {
            this.newSession.logout();
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, LOGGED_IN_PROPERTY, this.loginStatus, ANONYMOUS_STATUS);
            this.propertyChange(propertyChangeEvent);
            this.loginStatus = ANONYMOUS_STATUS;
        }
        catch (IllegalStateException illegalStateException) {
            logger.warn(illegalStateException.getMessage());
            System.err.println("IllegalStateException in SessionManager:logout");
            illegalStateException.printStackTrace();
        }
        catch (SessionExpiredException sessionExpiredException) {
            logger.warn(sessionExpiredException.getMessage());
            System.err.println("Session Expired Exception in Session Manager:logout.");
            sessionExpiredException.printStackTrace();
        }
    }

    private static String createAnonymousUser() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeZone(TimeZone.getTimeZone("MST"));
        Integer n = new Integer(gregorianCalendar.get(1));
        Integer n2 = new Integer(gregorianCalendar.get(2) + 1);
        Integer n3 = new Integer(gregorianCalendar.get(5));
        Integer n4 = new Integer(gregorianCalendar.get(10));
        Integer n5 = new Integer(gregorianCalendar.get(12));
        Integer n6 = new Integer(gregorianCalendar.get(13));
        Integer n7 = new Integer(gregorianCalendar.get(14));
        String string = n.toString() + n2.toString() + n3.toString() + n4.toString() + n5.toString() + n6.toString();
        return string;
    }

    private void anonymousLogin() {
        logger.debug("JS: Request for anonymous login");
        String string = SessionManager.createAnonymousUser();
        this.userName = new String(string);
        String string2 = "anonymous";
        try {
            if (this.isConnected()) {
                this.newSession.addUser(string, string2);
                info = this.newSession.startUpInfo(string, string2);
                this.loginStatus = ANONYMOUS_STATUS;
            }
        }
        catch (NoImplementationException noImplementationException) {
            logger.warn(noImplementationException.getMessage());
            System.err.println(noImplementationException.getMessage());
        }
        catch (SerializerException serializerException) {
            logger.warn(serializerException.getMessage());
            System.err.println(serializerException.getMessage());
        }
        catch (UserAlreadyExistsException userAlreadyExistsException) {
            logger.warn(userAlreadyExistsException.getMessage());
            System.err.println(userAlreadyExistsException.getMessage());
        }
        catch (SQLException sQLException) {
            logger.warn(sQLException.getMessage());
            System.err.println(sQLException.getMessage());
        }
        catch (UserDoesNotExistException userDoesNotExistException) {
            logger.warn(userDoesNotExistException.getMessage());
            System.err.println(userDoesNotExistException.getMessage());
        }
        catch (PasswordMismatchException passwordMismatchException) {
            logger.warn(passwordMismatchException.getMessage());
            System.err.println(passwordMismatchException.getMessage());
        }
    }

    public void createNewUserAccount(String string, String string2) throws UserAlreadyExistsException, UserDoesNotExistException, UserDoesNotExistException, PasswordMismatchException {
        logger.debug("JS: Request for createNewUserAccount");
        try {
            this.newSession.addUser(string, string2);
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, LOGGED_IN_PROPERTY, this.loginStatus, NEW_LOGIN_STATUS);
            this.propertyChange(propertyChangeEvent);
            this.loginStatus = NEW_LOGIN_STATUS;
            info = this.newSession.startUpInfo(string, string2);
            this.userName = new String(string);
            this.userInvestigationNames = new Vector();
            this.userInvestigationIndices = new Vector();
        }
        catch (NoImplementationException noImplementationException) {
            logger.warn(noImplementationException.getMessage());
            System.err.println(noImplementationException.getMessage());
        }
        catch (SerializerException serializerException) {
            logger.warn(serializerException.getMessage());
            System.err.println(serializerException.getMessage());
        }
        catch (SQLException sQLException) {
            logger.warn(sQLException.getMessage());
            System.err.println(sQLException.getMessage());
        }
    }

    public int changeEmail(String string) {
        int n = -1;
        try {
            n = this.newSession.changeEmail(string);
            if (n == 0) {
                this.userName = new String(string);
            }
        }
        catch (SessionExpiredException sessionExpiredException) {
            logger.warn(sessionExpiredException.getMessage());
            System.err.println("SessionManager: SessionExpiredException in changeEmail.");
            sessionExpiredException.printStackTrace();
        }
        catch (SQLException sQLException) {
            logger.warn(sQLException.getMessage());
            System.err.println("SessionManager: SQLException in changeEmail.");
            sQLException.printStackTrace();
        }
        catch (Exception exception) {
            logger.warn(exception.getMessage());
            System.err.println("SessionManager: General exception in changeEmail.");
            exception.printStackTrace();
        }
        return n;
    }

    public int changePassword(String string, String string2) throws PasswordMismatchException {
        int n = -1;
        try {
            n = this.newSession.changePassword(string, string2);
        }
        catch (SessionExpiredException sessionExpiredException) {
            logger.warn(sessionExpiredException.getMessage());
            System.err.println("SessionManager: SessionExpiredException in changeEmail.");
            sessionExpiredException.printStackTrace();
        }
        catch (SQLException sQLException) {
            logger.warn(sQLException.getMessage());
            System.err.println("SessionManager: SQLException in changeEmail.");
            sQLException.printStackTrace();
        }
        return n;
    }

    public void loginExistingUser(String string, String string2) throws UserDoesNotExistException, PasswordMismatchException {
        try {
            info = this.newSession.startUpInfo(string, string2);
            this.userName = new String(string);
            this.userInvestigationNames = info.getInvesNames();
            this.userInvestigationIndices = info.getInvesIndices();
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, LOGGED_IN_PROPERTY, this.loginStatus, LOGGED_IN_STATUS);
            this.propertyChange(propertyChangeEvent);
            this.loginStatus = LOGGED_IN_STATUS;
        }
        catch (SQLException sQLException) {
            logger.warn(sQLException.getMessage());
            System.err.println(sQLException.getMessage());
        }
        catch (NoImplementationException noImplementationException) {
            logger.warn(noImplementationException.getMessage());
            System.err.println(noImplementationException.getMessage());
        }
        catch (SerializerException serializerException) {
            logger.warn(serializerException.getMessage());
            System.err.println(serializerException.getMessage());
        }
    }

    public String getUserName() {
        return new String(this.userName);
    }

    public void setBookmarksMenuManager(BookmarksMenuManager bookmarksMenuManager) {
        this.bookmarksMenu = bookmarksMenuManager;
    }

    public void loadBookmarks() {
        String string = null;
        try {
            string = this.newSession.getBookmarks();
        }
        catch (SQLException sQLException) {
            logger.warn(sQLException.getMessage());
            sQLException.printStackTrace();
        }
        catch (SessionExpiredException sessionExpiredException) {
            logger.warn(sessionExpiredException.getMessage());
            sessionExpiredException.printStackTrace();
        }
        if (string == null) {
            string = BookmarksMenuManager.NEW_BOOKMARKS;
        }
        this.bookmarksMenu.setLoggedIn(true);
        this.bookmarksMenu.loadBookmarks(string);
    }

    public void loadNewBookmarks() {
        this.bookmarksMenu.setLoggedIn(true);
        this.bookmarksMenu.loadBookmarks(BookmarksMenuManager.NEW_BOOKMARKS);
    }

    public void setWaypointsWidget(WaypointsTab waypointsTab) {
        this.waypts = waypointsTab;
        this.waypts.addPropertyChangeListener(this);
    }

    public int changeWaypointName(int n, String string) {
        int n2 = 0;
        try {
            n2 = this.newSession.changeWaypointName(n, string);
        }
        catch (SessionExpiredException sessionExpiredException) {
            logger.warn(sessionExpiredException.getMessage());
            System.err.println("SessionManager.addWaypoint:ca.ucalgary.bluejay.session.SessionExpiredException");
            sessionExpiredException.printStackTrace();
        }
        catch (SQLException sQLException) {
            logger.warn(sQLException.getMessage());
            System.err.println("SessionManager.addWaypoint:java.sql.SQLException");
            sQLException.printStackTrace();
        }
        catch (IOException iOException) {
            logger.warn(iOException.getMessage());
            System.err.println("SessionManager.addWaypoint:java.io.IOException");
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            logger.warn(exception.getMessage());
            System.err.println("SessionManager.addWaypoint: Unknown Exception");
            exception.printStackTrace();
        }
        return n2;
    }

    public int addWaypoint(String string, String string2) {
        String string3 = null;
        int n = 0;
        try {
            n = this.newSession.addWaypoint(string2, string, this.currentURL, string3);
        }
        catch (SessionExpiredException sessionExpiredException) {
            logger.warn(sessionExpiredException.getMessage());
            System.err.println("SessionManager.addWaypoint:ca.ucalgary.bluejay.session.SessionExpiredException");
            sessionExpiredException.printStackTrace();
        }
        catch (SQLException sQLException) {
            logger.warn(sQLException.getMessage());
            System.err.println("SessionManager.addWaypoint:java.sql.SQLException");
            sQLException.printStackTrace();
        }
        catch (IOException iOException) {
            logger.warn(iOException.getMessage());
            System.err.println("SessionManager.addWaypoint:java.io.IOException");
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            logger.warn(exception.getMessage());
            System.err.println("SessionManager.addWaypoint: Unknown Exception");
            exception.printStackTrace();
        }
        return n;
    }

    public int removeWaypoint(int n) {
        int n2 = 0;
        try {
            n2 = this.newSession.removeWaypoint(n);
        }
        catch (SessionExpiredException sessionExpiredException) {
            logger.warn(sessionExpiredException.getMessage());
            System.err.println("SessionManager.addWaypoint:ca.ucalgary.bluejay.session.SessionExpiredException");
            sessionExpiredException.printStackTrace();
        }
        catch (SQLException sQLException) {
            logger.warn(sQLException.getMessage());
            System.err.println("SessionManager.addWaypoint:java.sql.SQLException");
            sQLException.printStackTrace();
        }
        catch (IOException iOException) {
            logger.warn(iOException.getMessage());
            System.err.println("SessionManager.addWaypoint:java.io.IOException");
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            logger.warn(exception.getMessage());
            System.err.println("SessionManager.addWaypoint: Unknown Exception");
            exception.printStackTrace();
        }
        return n2;
    }

    public void loadGenomeInformation(String string) {
        logger.debug("Loading Genome Information");
        this.currentURL = string;
        this.waypts.resetWaypoints();
        try {
            WaypointsInfo waypointsInfo = this.newSession.loadWaypointsInfo(this.currentURL);
            this.waypts.loadElementIds(waypointsInfo.getWaypointElementIDs());
            this.waypts.loadNames(waypointsInfo.getWaypointNames());
            this.waypts.loadIDs(waypointsInfo.getWaypointIDs());
        }
        catch (NoImplementationException noImplementationException) {
            logger.warn(noImplementationException.getMessage());
            System.err.println("SessionManager.loadGenomeInformation: NoImplementationException");
            noImplementationException.printStackTrace();
        }
        catch (SerializerException serializerException) {
            logger.warn(serializerException.getMessage());
            System.err.println("SessionManager.loadGenomeInformation: SerializerException");
            serializerException.printStackTrace();
        }
        catch (SQLException sQLException) {
            logger.warn(sQLException.getMessage());
            System.err.println("SessionManager.loadGenomeInformation: SQLException");
            sQLException.printStackTrace();
        }
    }

    public void workOffline(boolean bl) {
        if (bl) {
            Boolean bl2 = Boolean.FALSE;
            if (this.isConnected()) {
                this.leavingPage(this.sessionRequestVisitID());
                this.saveUserInfo();
                this.logout();
                bl2 = Boolean.TRUE;
            }
            this.newSession.propertyChange(new PropertyChangeEvent(this, CONNECTED_PROPERTY, this.isConnected(), Boolean.FALSE));
            this.newSession.stopPing();
        } else {
            this.newSession.startPing();
            this.newSession.propertyChange(new PropertyChangeEvent(this, CONNECTED_PROPERTY, this.isConnected(), Boolean.TRUE));
        }
        this.newSession.workOffline(bl);
    }

    public void setPersonalizationController(PersonalizationController personalizationController) {
        this.personalController = personalizationController;
    }
}

