/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.session;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.session.Entry;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeMap;
import java.util.Vector;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TfIdfEngine {
    public static boolean DEBUG = false;

    public static TreeMap getTfIdfsForWord(String string, Vector<DTDElementInstance> vector) {
        if (vector.size() > 0) {
            Vector vector2 = TfIdfEngine.createEntries(vector);
            Hashtable<Entry, Double> hashtable = new Hashtable<Entry, Double>();
            double d = TfIdfEngine.getIdf(vector);
            double d2 = 0.0;
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                Entry entry = (Entry)enumeration.nextElement();
                d2 = TfIdfEngine.getTfIdfForEntry(string, entry, d);
                hashtable.put(entry, new Double(d2));
            }
            TfIdfEngine.printHashtable(hashtable);
        }
        return new TreeMap();
    }

    public static double getTfIdfForEntry(String string, Entry entry, double d) {
        double d2 = entry.getTf(string);
        double d3 = d2 * d;
        if (Double.isNaN(d3)) {
            d3 = 0.0;
        }
        return d3;
    }

    public static double getIdf(Vector<DTDElementInstance> vector) {
        int n = vector.size();
        DTDElementInstance dTDElementInstance = TfIdfEngine.getRoot(vector.firstElement());
        int n2 = TfIdfEngine.getTotalChildren(dTDElementInstance);
        double d = Math.log((double)n2 / (double)n);
        return d;
    }

    public static DTDElementInstance getRoot(DTDElementInstance dTDElementInstance) {
        DTDElementInstance dTDElementInstance2 = (DTDElementInstance)dTDElementInstance.getOwnerDocument().getDocumentElement();
        return dTDElementInstance2;
    }

    public static int getTotalChildren(DTDElementInstance dTDElementInstance) {
        int n = 0;
        n = TfIdfEngine.getNumberOfChildren(dTDElementInstance, n);
        return n;
    }

    private static int getNumberOfChildren(Node node, int n) {
        if (node instanceof DTDElementInstance) {
            ++n;
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (!(node2 instanceof DTDElementInstance)) continue;
            n = TfIdfEngine.getNumberOfChildren(node2, n);
        }
        return n;
    }

    public static Vector createEntries(Vector<DTDElementInstance> vector) {
        Vector<Entry> vector2 = new Vector<Entry>();
        Enumeration<DTDElementInstance> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Entry entry = new Entry(enumeration.nextElement(), -1);
            vector2.add(entry);
        }
        return vector2;
    }

    public static void printHashtable(Hashtable hashtable) {
        System.err.println("TF-IDF values:");
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object v = hashtable.get(k);
                System.err.println(k + " \t: " + v);
            }
        }
    }
}

