/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.datatypes.xsd;

import com.hp.hpl.jena.datatypes.xsd.AbstractDateTime;
import com.hp.hpl.jena.datatypes.xsd.IllegalDateTimeFieldException;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.TimeZone;

public class XSDDateTime
extends AbstractDateTime {
    public static final short YEAR_MASK = 1;
    public static final short MONTH_MASK = 2;
    public static final short DAY_MASK = 4;
    public static final short TIME_MASK = 8;
    public static final short FULL_MASK = 15;
    public static final HashMap maskMap = new HashMap();
    protected short mask;

    public XSDDateTime(Object value, int mask) {
        super(value);
        this.mask = (short)mask;
    }

    public XSDDateTime(Calendar date) {
        super(XSDDateTime.convertCalendar(date));
        this.mask = (short)15;
    }

    public XSDDatatype getNarrowedDatatype() {
        switch (this.mask) {
            case 8: {
                return XSDDatatype.XSDtime;
            }
            case 2: {
                return XSDDatatype.XSDgMonth;
            }
            case 4: {
                return XSDDatatype.XSDgDay;
            }
            case 1: {
                return XSDDatatype.XSDgYear;
            }
            case 6: {
                return XSDDatatype.XSDgMonthDay;
            }
            case 3: {
                return XSDDatatype.XSDgYearMonth;
            }
            case 7: {
                return XSDDatatype.XSDdate;
            }
        }
        return XSDDatatype.XSDdateTime;
    }

    private static int[] convertCalendar(Calendar date) {
        int[] data = new int[8];
        int offset = date.get(15) + date.get(16);
        Calendar cal = date;
        if (offset != 0) {
            cal = (Calendar)date.clone();
            cal.add(14, -offset);
        }
        data[0] = cal.get(1);
        data[1] = cal.get(2) + 1;
        data[2] = cal.get(5);
        data[3] = cal.get(11);
        data[4] = cal.get(12);
        data[5] = cal.get(13);
        data[6] = cal.get(14);
        data[7] = 90;
        return data;
    }

    public Calendar asCalendar() throws IllegalDateTimeFieldException {
        TimeZone tz = this.data[7] == 90 ? TimeZone.getTimeZone("GMT") : TimeZone.getDefault();
        GregorianCalendar calendar = new GregorianCalendar(tz);
        calendar.set(this.data[0], this.data[1] - 1, this.data[2], this.data[3], this.data[4], this.data[5]);
        calendar.set(14, this.data[6]);
        return calendar;
    }

    public int getYears() throws IllegalDateTimeFieldException {
        if ((this.mask & 1) == 0) {
            throw new IllegalDateTimeFieldException("Year not available");
        }
        return this.data[0];
    }

    public int getMonths() throws IllegalDateTimeFieldException {
        if ((this.mask & 2) == 0) {
            throw new IllegalDateTimeFieldException("Month not available");
        }
        return this.data[1];
    }

    public int getDays() throws IllegalDateTimeFieldException {
        if ((this.mask & 4) == 0) {
            throw new IllegalDateTimeFieldException("Day not available");
        }
        return this.data[2];
    }

    public int getHours() throws IllegalDateTimeFieldException {
        if ((this.mask & 8) == 0) {
            throw new IllegalDateTimeFieldException("Time not available");
        }
        return this.data[3];
    }

    public int getMinutes() throws IllegalDateTimeFieldException {
        if ((this.mask & 8) == 0) {
            throw new IllegalDateTimeFieldException("Time not available");
        }
        return this.data[4];
    }

    public int getFullSeconds() throws IllegalDateTimeFieldException {
        if ((this.mask & 8) == 0) {
            throw new IllegalDateTimeFieldException("Time not available");
        }
        return this.data[5];
    }

    public double getSeconds() throws IllegalDateTimeFieldException {
        if ((this.mask & 8) == 0) {
            throw new IllegalDateTimeFieldException("Time not available");
        }
        return (double)this.data[5] + this.fractionalSeconds;
    }

    public double getTimePart() throws IllegalDateTimeFieldException {
        if ((this.mask & 8) == 0) {
            throw new IllegalDateTimeFieldException("Time not available");
        }
        return (double)(((long)this.data[3] * 60L + (long)this.data[4]) * 60L) + this.getSeconds();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        if ((this.mask & 1) != 0) {
            buff.append(this.data[0]);
        } else {
            buff.append("-");
        }
        if ((this.mask & 6) != 0) {
            buff.append("-");
            if ((this.mask & 2) != 0) {
                if (this.data[1] <= 9) {
                    buff.append("0");
                }
                buff.append(this.data[1]);
            } else {
                buff.append("-");
            }
            if ((this.mask & 4) != 0) {
                if (this.mask != 4) {
                    buff.append("-");
                }
                if (this.data[2] <= 9) {
                    buff.append("0");
                }
                buff.append(this.data[2]);
            }
        }
        if ((this.mask & 8) != 0) {
            buff.append("T");
            buff.append(this.timeLexicalForm());
        }
        return buff.toString();
    }

    public String timeLexicalForm() {
        StringBuffer buff = new StringBuffer();
        if (this.data[3] < 10) {
            buff.append("0");
        }
        buff.append(this.data[3]);
        buff.append(":");
        if (this.data[4] < 10) {
            buff.append("0");
        }
        buff.append(this.data[4]);
        buff.append(":");
        if (this.data[5] < 10) {
            buff.append("0");
        }
        buff.append(this.data[5]);
        if (this.data[6] != 0) {
            buff.append(".");
            buff.append(this.data[6]);
        }
        buff.append("Z");
        return buff.toString();
    }
}

