/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.DBIDInt;
import com.hp.hpl.jena.db.impl.DriverRDB;
import com.hp.hpl.jena.db.impl.SQLCache;
import java.io.OutputStream;
import java.io.StringBufferInputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;

public class Driver_Oracle
extends DriverRDB {
    public Driver_Oracle() {
        String myPackageName = this.getClass().getPackage().getName();
        this.DATABASE_TYPE = "Oracle";
        this.DRIVER_NAME = "oracle.jdbc.driver.OracleDriver";
        this.ID_SQL_TYPE = "INTEGER";
        this.URI_COMPRESS = false;
        this.INDEX_KEY_LENGTH = 2000;
        this.INDEX_KEY_LENGTH_MAX = 2000;
        this.LONG_OBJECT_LENGTH_MAX = 2000;
        this.LONG_OBJECT_LENGTH = 250;
        this.TABLE_NAME_LENGTH_MAX = 30;
        this.IS_XACT_DB = true;
        this.PRE_ALLOCATE_ID = true;
        this.SKIP_DUPLICATE_CHECK = false;
        this.SQL_FILE = "etc/oracle.sql";
        this.m_psetClassName = myPackageName + ".PSet_TripleStore_RDB";
        this.m_psetReifierClassName = myPackageName + ".PSet_ReifStore_RDB";
        this.m_lsetClassName = myPackageName + ".SpecializedGraph_TripleStore_RDB";
        this.m_lsetReifierClassName = myPackageName + ".SpecializedGraphReifier_RDB";
        this.QUOTE_CHAR = (char)39;
        this.DB_NAMES_TO_UPPER = true;
        this.setTableNames(this.TABLE_NAME_PREFIX);
    }

    public void setConnection(IDBConnection dbcon) {
        this.m_dbcon = dbcon;
        try {
            this.m_sql = new SQLCache(this.SQL_FILE, null, dbcon, this.ID_SQL_TYPE);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            logger.error("Unable to set connection for Driver:", e);
        }
    }

    public int graphIdAlloc(String graphName) {
        Object result = null;
        int dbid = 0;
        try {
            String op = "insertGraph";
            dbid = this.getInsertID(this.GRAPH_TABLE);
            PreparedStatement ps = this.m_sql.getPreparedSQLStatement(op, this.GRAPH_TABLE);
            ps.setInt(1, dbid);
            ps.setString(2, graphName);
            ps.executeUpdate();
            this.m_sql.returnPreparedSQLStatement(ps);
        }
        catch (SQLException e) {
            throw new RDFRDBException("Failed to get last inserted ID: " + e);
        }
        return dbid;
    }

    public void graphIdDealloc(int graphId) {
        Object result = null;
        try {
            String op = "deleteGraph";
            PreparedStatement ps = this.m_sql.getPreparedSQLStatement(op, this.GRAPH_TABLE);
            ps.setInt(1, graphId);
            ps.executeUpdate();
            this.m_sql.returnPreparedSQLStatement(ps);
        }
        catch (SQLException e) {
            throw new RDFRDBException("Failed to delete graph ID: " + e);
        }
    }

    public int getInsertID(String tableName) {
        DBIDInt result = null;
        try {
            String op = "getInsertID";
            PreparedStatement ps = this.m_sql.getPreparedSQLStatement(op, tableName);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                throw new RDFRDBException("No insert ID");
            }
            result = this.wrapDBID(rs.getObject(1));
            this.m_sql.returnPreparedSQLStatement(ps);
        }
        catch (SQLException e) {
            throw new RDFRDBException("Failed to insert ID: " + e);
        }
        return result.getIntID();
    }

    protected void getTblParams(String[] param) {
        String headColType;
        if (this.LONG_OBJECT_LENGTH > 4000) {
            throw new RDFRDBException("Long object length specified (" + this.LONG_OBJECT_LENGTH + ") exceeds maximum sane length of 4000.");
        }
        if (this.INDEX_KEY_LENGTH > 4000) {
            throw new RDFRDBException("Index key length specified (" + this.INDEX_KEY_LENGTH + ") exceeds maximum sane length of 4000.");
        }
        String objColType = "VARCHAR2(" + this.LONG_OBJECT_LENGTH + ")";
        this.STRINGS_TRIMMED = false;
        param[0] = objColType;
        param[1] = headColType = "VARCHAR2(" + this.INDEX_KEY_LENGTH + ")";
        param[2] = this.TABLE_NAME_PREFIX;
    }

    protected String[] getCreateTableParams(int graphId, boolean isReif) {
        String[] parms = new String[3];
        String[] res = new String[2];
        this.getTblParams(parms);
        int tblCnt = this.getTableCount(graphId);
        res[0] = this.genTableName(graphId, tblCnt, isReif);
        res[1] = parms[0];
        return res;
    }

    protected String[] getDbInitTablesParams() {
        String[] res = new String[3];
        this.getTblParams(res);
        this.EOS_LEN = this.EOS.length();
        return res;
    }

    public DBIDInt addRDBLongObject(DriverRDB.RDBLongObject lobj, String table) throws RDFRDBException {
        DBIDInt longObjID = null;
        try {
            int argi = 1;
            boolean save = this.m_dbcon.getConnection().getAutoCommit();
            String opname = lobj.tail.length() > 0 ? "insertLongObjectEmptyTail" : "insertLongObject";
            PreparedStatement ps = this.m_sql.getPreparedSQLStatement(opname, table);
            int dbid = 0;
            if (this.PRE_ALLOCATE_ID) {
                dbid = this.getInsertID(table);
                ps.setInt(argi++, dbid);
                longObjID = this.wrapDBID(new Integer(dbid));
            }
            ps.setString(argi++, lobj.head);
            if (lobj.tail.length() > 0) {
                ps.setLong(argi++, lobj.hash);
            } else {
                ps.setNull(argi++, -5);
            }
            ps.executeUpdate();
            this.m_sql.returnPreparedSQLStatement(ps);
            if (lobj.tail.length() > 0) {
                if (!this.xactOp(3)) {
                    this.m_dbcon.getConnection().setAutoCommit(false);
                }
                opname = "getEmptyBLOB";
                String cmd = this.m_sql.getSQLStatement(opname, table, longObjID.getID().toString());
                Statement lobStmt = this.m_sql.getConnection().createStatement();
                ResultSet lrs = lobStmt.executeQuery(cmd);
                lrs.next();
                BLOB blob = ((OracleResultSet)lrs).getBLOB(1);
                OutputStream outstream = blob.getBinaryOutputStream();
                int size = blob.getBufferSize();
                int length = -1;
                StringBufferInputStream instream = new StringBufferInputStream(lobj.tail);
                byte[] buffer = new byte[size];
                while ((length = instream.read(buffer)) != -1) {
                    outstream.write(buffer, 0, length);
                }
                if (blob.isOpen()) {
                    blob.close();
                }
                instream.close();
                outstream.close();
                lobStmt.close();
                if (!this.xactOp(3)) {
                    this.m_dbcon.getConnection().setAutoCommit(save);
                }
            }
            if (!this.PRE_ALLOCATE_ID) {
                dbid = this.getInsertID(table);
                longObjID = this.wrapDBID(new Integer(dbid));
            }
        }
        catch (Exception e1) {
            System.out.println("Problem on long object (l=" + lobj.head + ") " + e1);
            throw new RDFRDBException("Failed to add long object ", e1);
        }
        return longObjID;
    }

    protected DriverRDB.RDBLongObject IDtoLongObject(int dbid, String table) {
        DriverRDB.RDBLongObject res = null;
        try {
            String opName = "getLongObject";
            PreparedStatement ps = this.m_sql.getPreparedSQLStatement(opName, table);
            ps.setInt(1, dbid);
            OracleResultSet rs = (OracleResultSet)ps.executeQuery();
            if (rs.next()) {
                res = new DriverRDB.RDBLongObject();
                res.head = rs.getString(1);
                BLOB blob = rs.getBLOB(2);
                if (blob != null) {
                    int len = (int)blob.length();
                    byte[] data = blob.getBytes(1L, len);
                    res.tail = new String(data, "UTF-8");
                } else {
                    res.tail = "";
                }
            }
            rs.close();
            this.m_sql.returnPreparedSQLStatement(ps);
        }
        catch (SQLException e1) {
            throw new RDFRDBException("Failed to retrieve long object (SQL Exception): ", e1);
        }
        catch (UnsupportedEncodingException e2) {
            throw new RDFRDBException("Failed to retrieve long object (UnsupportedEncoding): ", e2);
        }
        return res;
    }

    public void clearSequences() {
        Iterator seqIt = this.getSequences().iterator();
        while (seqIt.hasNext()) {
            this.removeSequence((String)seqIt.next());
        }
    }

    public String genSQLStringMatchLHS_IC(String var) {
        return "UPPER(" + var + ")";
    }

    public String genSQLStringMatchRHS_IC(String strToMatch) {
        return "UPPER(" + strToMatch + ")";
    }

    public String stringMatchEscapeChar() {
        return "\\";
    }

    public String genSQLStringMatchEscape() {
        return " " + this.genSQLEscapeKW() + " '" + this.stringMatchEscapeChar() + "'";
    }

    private static interface OracleResultSet
    extends ResultSet {
        public BLOB getBLOB(int var1);
    }

    public static interface BLOB
    extends Blob {
        public OutputStream getBinaryOutputStream();

        public int getBufferSize();

        public boolean isOpen();

        public void close();
    }
}

