/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.impl.XMLLiteralType;
import com.hp.hpl.jena.shared.impl.JenaParameters;

public final class LiteralLabel {
    private String lexicalForm;
    private Object value;
    private RDFDatatype dtype;
    private final String lang;
    private boolean wellformed = true;

    public static LiteralLabel createLiteralLabel(String lex, String lang, RDFDatatype dtype) throws DatatypeFormatException {
        return new LiteralLabel(lex, lang, dtype);
    }

    private LiteralLabel(String lex, String lang, RDFDatatype dtype) throws DatatypeFormatException {
        this.lexicalForm = lex;
        this.dtype = dtype;
        String string = this.lang = lang == null ? "" : lang;
        if (dtype == null) {
            this.value = lex;
        } else {
            this.setValue(lex);
        }
        this.normalize();
    }

    public LiteralLabel(String lex, String lang) {
        this(lex, lang, null);
    }

    public LiteralLabel(Object value, String lang, RDFDatatype dtype) throws DatatypeFormatException {
        this.dtype = dtype;
        String string = this.lang = lang == null ? "" : lang;
        if (value instanceof String) {
            String lex;
            this.lexicalForm = lex = (String)value;
            if (dtype == null) {
                value = lex;
            } else {
                this.setValue(lex);
            }
        } else {
            this.value = dtype == null ? value : dtype.cannonicalise(value);
        }
        this.normalize();
    }

    public LiteralLabel(String lex, Object value, String lang, RDFDatatype dtype) {
        this(value, lang, dtype);
        this.lexicalForm = lex;
    }

    public LiteralLabel(Object value) {
        this(value, "", TypeMapper.getInstance().getTypeByValue(value));
    }

    public LiteralLabel(String s, String lg, boolean xml) {
        this.lexicalForm = s;
        String string = this.lang = lg == null ? "" : lg;
        if (xml) {
            this.dtype = XMLLiteralType.theXMLLiteralType;
            this.value = s;
            this.wellformed = true;
        } else {
            this.value = s;
            this.dtype = null;
        }
    }

    private void setValue(String lex) throws DatatypeFormatException {
        try {
            this.value = this.dtype.parse(lex);
            this.wellformed = true;
        }
        catch (DatatypeFormatException e) {
            if (JenaParameters.enableEagerLiteralValidation) {
                e.fillInStackTrace();
                throw e;
            }
            this.wellformed = false;
        }
    }

    protected void normalize() {
        if (this.dtype != null && this.value != null) {
            this.dtype = this.dtype.getNarrowedDatatype(this.value);
        }
    }

    public boolean isXML() {
        return this.dtype == XMLLiteralType.theXMLLiteralType && this.wellformed;
    }

    public boolean isWellFormed() {
        return this.dtype != null && this.wellformed;
    }

    public String toString(boolean quoting) {
        StringBuffer b = new StringBuffer();
        if (quoting) {
            b.append('\"');
        }
        b.append(this.getLexicalForm());
        if (quoting) {
            b.append('\"');
        }
        if (this.lang != null && !this.lang.equals("")) {
            b.append("@").append(this.lang);
        }
        if (this.dtype != null) {
            b.append("^^").append(this.dtype.getURI());
        }
        return b.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public String getLexicalForm() {
        if (this.lexicalForm == null) {
            this.lexicalForm = this.dtype == null ? this.value.toString() : this.dtype.unparse(this.value);
        }
        return this.lexicalForm;
    }

    public Object getIndexingValue() {
        if (this.isXML()) {
            return this;
        }
        return this.wellformed ? this.getValue() : this.getLexicalForm();
    }

    public String language() {
        return this.lang;
    }

    public Object getValue() throws DatatypeFormatException {
        if (this.wellformed) {
            return this.value;
        }
        throw new DatatypeFormatException(this.lexicalForm, this.dtype, " in getValue()");
    }

    public RDFDatatype getDatatype() {
        return this.dtype;
    }

    public String getDatatypeURI() {
        if (this.dtype == null) {
            return null;
        }
        return this.dtype.getURI();
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof LiteralLabel)) {
            return false;
        }
        LiteralLabel otherLiteral = (LiteralLabel)other;
        boolean typeEqual = this.dtype == null ? otherLiteral.dtype == null : this.dtype.equals(otherLiteral.dtype);
        boolean langEqual = this.dtype == null ? this.lang.equalsIgnoreCase(otherLiteral.lang) : true;
        return typeEqual && langEqual && this.getLexicalForm().equals(otherLiteral.getLexicalForm());
    }

    public boolean sameValueAs(LiteralLabel other) {
        if (other == null) {
            return false;
        }
        if (!this.wellformed || !other.wellformed) {
            if (!other.wellformed) {
                return this.lexicalForm.equals(other.lexicalForm) && this.lang.equalsIgnoreCase(other.lang);
            }
            return false;
        }
        if (this.dtype == null) {
            if (other.dtype == null || JenaParameters.enablePlainLiteralSameAsString && other.dtype.equals(XSDDatatype.XSDstring)) {
                return this.lexicalForm.equals(other.lexicalForm) && this.lang.equalsIgnoreCase(other.lang);
            }
            return false;
        }
        return this.dtype.isEqual(this, other);
    }

    public int hashCode() {
        return (this.wellformed ? this.value : this.getLexicalForm()).hashCode();
    }
}

