/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdql.parser.Expr;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.vocabulary.XSD;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class QueryPrintUtils {
    static final String indentPrefix = "  ";
    public static boolean multiLineExpr = false;
    public static boolean printName = true;
    static int bNodeCounter = 0;
    static Map bNodeStrings = new HashMap();

    public static void print(PrintWriter pw, Expr expr) {
        pw.println(expr.asPrefixString());
    }

    public static String asInfixString1(Expr expr, String opName, String symbol2) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        sb.append(symbol2);
        sb.append(" ");
        sb.append(expr.asInfixString());
        sb.append(")");
        return sb.toString();
    }

    public static String asInfixString2(Expr left, Expr right, String opName, String symbol2) {
        StringBuffer sb = new StringBuffer();
        sb.append("( ");
        sb.append(left.asInfixString());
        sb.append(" ");
        sb.append(symbol2);
        sb.append(" ");
        sb.append(right.asInfixString());
        sb.append(" )");
        return sb.toString();
    }

    public static String asPrefixString(Expr left, Expr right, String opName, String symbol2) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        sb.append(printName ? opName : symbol2);
        sb.append(" ");
        sb.append(left.asPrefixString());
        if (right != null) {
            sb.append(" ");
            sb.append(right.asPrefixString());
        }
        sb.append(")");
        return sb.toString();
    }

    public static void print(PrintWriter pw, Expr left, Expr right, String opName, String symbol2, int level) {
        QueryPrintUtils.indent(pw, level);
        pw.println("(" + (printName ? opName : symbol2));
        left.print(pw, level + 1);
        if (right != null) {
            right.print(pw, level + 1);
        }
        QueryPrintUtils.indent(pw, level);
        pw.println(")");
    }

    public static void indent(PrintWriter pw, int level) {
        for (int i = 0; i < level; ++i) {
            pw.print(indentPrefix);
        }
    }

    public static String stringForObject(Object obj) {
        if (obj == null) {
            return "<<null>>";
        }
        if (obj instanceof RDFNode) {
            return QueryPrintUtils.stringForRDFNode((RDFNode)obj);
        }
        if (obj instanceof Node) {
            return QueryPrintUtils.stringForNode((Node)obj);
        }
        return obj.toString();
    }

    public static String stringForRDFNode(RDFNode obj) {
        if (obj == null) {
            return "<<null>>";
        }
        if (obj instanceof Literal) {
            return QueryPrintUtils.stringForLiteral((Literal)obj);
        }
        if (obj instanceof Resource) {
            return QueryPrintUtils.stringForResource((Resource)obj);
        }
        return ((Object)obj).toString();
    }

    public static String stringForLiteral(Literal literal) {
        return QueryPrintUtils.stringForLiteralLabel(literal.asNode().getLiteral());
    }

    public static String stringForLiteralLabel(LiteralLabel literal) {
        String datatype = literal.getDatatypeURI();
        String lang = literal.language();
        String s = literal.getLexicalForm();
        if (datatype != null) {
            if (datatype.equals(XSD.integer.getURI())) {
                try {
                    new BigInteger(s);
                    return s;
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (datatype.equals(XSD.xdouble.getURI()) && (s.indexOf(46) >= 0 || s.indexOf(101) >= 0 || s.indexOf(69) >= 0)) {
                try {
                    Double.parseDouble(s);
                    return s;
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("\"");
        sbuff.append(s);
        sbuff.append("\"");
        if (lang != null && lang.length() > 0) {
            sbuff.append("@");
            sbuff.append(lang);
        }
        return sbuff.toString();
    }

    public static String stringForResource(Resource r) {
        return QueryPrintUtils.stringForNode(r.asNode(), r.getModel());
    }

    public static String stringForNode(Node n) {
        return QueryPrintUtils.stringForNode(n, null);
    }

    public static String stringForNode(Node n, PrefixMapping mapping) {
        if (n == null) {
            return "<<null>>";
        }
        if (n.isBlank()) {
            AnonId a = n.getBlankNodeId();
            if (!bNodeStrings.containsKey(a)) {
                bNodeStrings.put(a, "_:b" + bNodeCounter++);
            }
            return (String)bNodeStrings.get(a);
        }
        if (n.isLiteral()) {
            LiteralLabel ll = n.getLiteral();
            return QueryPrintUtils.stringForLiteralLabel(ll);
        }
        if (n.isURI()) {
            String tmp;
            String uri = n.getURI();
            if (mapping != null && (tmp = mapping.shortForm(n.getURI())) != null && !tmp.equals(uri)) {
                return tmp;
            }
            return "<" + uri + ">";
        }
        if (n.isVariable()) {
            return "?" + n.getName();
        }
        return n.toString();
    }
}

