/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import com.hp.hpl.jena.reasoner.dig.DIGConnection;
import com.hp.hpl.jena.reasoner.dig.DIGQueryTranslator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DIGQueryDisjointTranslator
extends DIGQueryTranslator {
    public DIGQueryDisjointTranslator(String predicate) {
        super(null, predicate, null);
    }

    public Document translatePattern(TriplePattern pattern, DIGAdapter da) {
        DIGConnection dc = da.getConnection();
        Document query = dc.createDigVerb("asks", da.getProfile());
        Element disjoint = da.createQueryElement(query, "disjoint");
        da.addClassDescription(disjoint, pattern.getObject());
        da.addClassDescription(disjoint, pattern.getSubject());
        return query;
    }

    public ExtendedIterator translateResponseHook(Document response, TriplePattern query, DIGAdapter da) {
        ArrayList<Triple> answer = new ArrayList<Triple>();
        if (this.isTrue(response)) {
            answer.add(query.asTriple());
        }
        return WrappedIterator.create(answer.iterator());
    }

    public Document translatePattern(TriplePattern pattern, DIGAdapter da, Model premises) {
        return this.translatePattern(pattern, da);
    }

    public boolean checkSubject(Node subject, DIGAdapter da, Model premises) {
        return da.isConcept(subject, premises);
    }

    public boolean checkObject(Node object, DIGAdapter da, Model premises) {
        return da.isConcept(object, premises);
    }
}

