/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.util.iterator.Map1;
import org.w3c.dom.Element;

public class DIGValueToNodeMapper
implements Map1 {
    public Object map1(Object o) {
        if (o instanceof Element) {
            Element elem = (Element)o;
            if (elem.getNodeName().equals("ival")) {
                return Node.createLiteral(elem.getNodeValue(), null, XSDDatatype.XSDint);
            }
            if (elem.getNodeName().equals("sval")) {
                return Node.createLiteral(elem.getNodeValue(), null, XSDDatatype.XSDstring);
            }
            if (elem.hasAttribute("name")) {
                return this.convertNameToNode(elem.getAttribute("name"));
            }
        } else if (o instanceof String) {
            return this.convertNameToNode((String)o);
        }
        throw new IllegalArgumentException("Cannot map value " + o + " to an RDF node because it is not a recognised type");
    }

    private Object convertNameToNode(String name) {
        if (name.startsWith("anon:")) {
            String anonID = name.substring("anon:".length());
            return Node.createAnon(new AnonId(anonID));
        }
        return Node.createURI(name);
    }
}

