/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rdfsReasoner1;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.BRWRule;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveGraphCache;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PatternRouter {
    protected static Log logger = LogFactory.getLog(PatternRouter.class);
    Map patternIndex = new HashMap();

    public void register(TransitiveGraphCache cache) {
        this.register(new TriplePattern(null, cache.getClosedPredicate(), null), cache);
        this.register(new TriplePattern(null, cache.getDirectPredicate(), null), cache);
    }

    public void register(BRWRule rule) {
        this.register(rule.getHead(), rule);
    }

    public void register(TriplePattern pattern, Object satisfier) {
        PatternEntry entry = new PatternEntry(pattern, satisfier);
        Node predicate = pattern.getPredicate();
        if (predicate.isVariable()) {
            throw new ReasonerException("PatternRouter can't handle non-ground predicates in patterns: " + pattern);
        }
        HashSet<PatternEntry> sats = (HashSet<PatternEntry>)this.patternIndex.get(predicate);
        if (sats == null) {
            sats = new HashSet<PatternEntry>();
            this.patternIndex.put(predicate, sats);
        }
        sats.add(entry);
    }

    public ExtendedIterator find(TriplePattern pattern, Finder tripleCache, Finder data, InfGraph infGraph) {
        return this.find(pattern, tripleCache, data, infGraph, new HashSet());
    }

    public ExtendedIterator find(TriplePattern pattern, Finder tripleCache, Finder data, InfGraph infGraph, HashSet firedRules) {
        ExtendedIterator result = tripleCache.findWithContinuation(pattern, data);
        Node predicate = pattern.getPredicate();
        if (predicate.isVariable()) {
            Iterator i = this.patternIndex.values().iterator();
            while (i.hasNext()) {
                HashSet sats = (HashSet)i.next();
                result = this.doFind(sats, result, pattern, tripleCache, data, infGraph, firedRules);
            }
            return result;
        }
        HashSet sats = (HashSet)this.patternIndex.get(predicate);
        return this.doFind(sats, result, pattern, tripleCache, data, infGraph, firedRules);
    }

    private ExtendedIterator doFind(HashSet rules, ExtendedIterator result, TriplePattern pattern, Finder tripleCache, Finder data, InfGraph infGraph, HashSet firedRules) {
        if (rules != null) {
            PatternEntry entry;
            Iterator i = rules.iterator();
            while (i.hasNext()) {
                entry = (PatternEntry)i.next();
                if (!entry.completeFor(pattern)) continue;
                return entry.fire(pattern, data, infGraph, firedRules);
            }
            i = rules.iterator();
            while (i.hasNext()) {
                entry = (PatternEntry)i.next();
                if (!entry.shouldFire(pattern)) continue;
                result = result.andThen(entry.fire(pattern, data, infGraph, firedRules));
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer state = new StringBuffer();
        Iterator i = this.patternIndex.values().iterator();
        while (i.hasNext()) {
            HashSet ents = (HashSet)i.next();
            Iterator j = ents.iterator();
            while (j.hasNext()) {
                state.append(j.next().toString());
                state.append("\n");
            }
        }
        return state.toString();
    }

    static class PatternEntry {
        TriplePattern pattern;
        Object action;

        PatternEntry(TriplePattern pattern, Object action) {
            this.pattern = pattern;
            this.action = action;
        }

        public boolean completeFor(TriplePattern query) {
            if (this.action instanceof BRWRule) {
                return ((BRWRule)this.action).completeFor(query);
            }
            if (this.action instanceof TransitiveGraphCache) {
                TransitiveGraphCache tgc = (TransitiveGraphCache)this.action;
                Node prop = query.getPredicate();
                return prop.equals(tgc.getDirectPredicate()) || prop.equals(tgc.getClosedPredicate());
            }
            return false;
        }

        boolean shouldFire(TriplePattern query) {
            return this.pattern.compatibleWith(query);
        }

        public ExtendedIterator fire(TriplePattern query, Finder data, InfGraph infGraph, HashSet firedRules) {
            TriplePattern nquery = query;
            if (nquery.getPredicate().isVariable()) {
                nquery = new TriplePattern(query.getSubject(), this.pattern.getPredicate(), query.getObject());
            }
            if (this.action instanceof TransitiveGraphCache) {
                return ((TransitiveGraphCache)this.action).find(nquery);
            }
            if (this.action instanceof BRWRule) {
                logger.debug("Fire rule: " + this.action);
                return ((BRWRule)this.action).execute(nquery, infGraph, data, firedRules);
            }
            throw new ReasonerException("Illegal router action entry");
        }

        public String toString() {
            return this.pattern.toString() + " <- " + this.action;
        }

        public boolean equals(Object o) {
            return o instanceof PatternEntry && this.pattern.equals(((PatternEntry)o).pattern) && this.action.equals(((PatternEntry)o).action);
        }

        public int hashCode() {
            return this.pattern.hashCode() >> 1 ^ this.action.hashCode();
        }
    }
}

