/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rdfsReasoner1;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.BRWRule;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.RDFSInfGraph;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ResourceBRWRule
extends BRWRule {
    private static Node TYPE = RDF.Nodes.type;
    private static Node RESOURCE = RDFS.Nodes.Resource;

    public ResourceBRWRule() {
        super(new TriplePattern(null, TYPE, RESOURCE), new TriplePattern(null, null, null));
    }

    public ExtendedIterator execute(TriplePattern query, InfGraph infGraph, Finder data, HashSet firedRules) {
        RDFSInfGraph bRr = (RDFSInfGraph)infGraph;
        if (query.getSubject().isVariable()) {
            return new ResourceRewriteIterator(bRr.findRawWithContinuation(this.body, data));
        }
        Node subj = query.getSubject();
        TriplePattern pattern = new TriplePattern(subj, null, null);
        String var = "s";
        ExtendedIterator it = bRr.findRawWithContinuation(pattern, data);
        if (!it.hasNext()) {
            pattern = new TriplePattern(null, null, subj);
            var = "o";
            it = bRr.findRawWithContinuation(pattern, data);
            if (!it.hasNext()) {
                pattern = new TriplePattern(null, subj, null);
                var = "p";
                it = bRr.findRawWithContinuation(pattern, data);
            }
        }
        BRWRule rwrule = new BRWRule(new TriplePattern(Node.createVariable(var), TYPE, RESOURCE), this.body);
        return new BRWRule.RewriteIterator((Iterator)it, rwrule);
    }

    public boolean completeFor(TriplePattern query) {
        return this.head.subsumes(query);
    }

    static class ResourceRewriteIterator
    extends WrappedIterator {
        private Triple[] lookahead = new Triple[3];
        private short nAvailable = 0;
        protected HashSet seen = new HashSet();

        public ResourceRewriteIterator(Iterator underlying) {
            super(underlying);
        }

        private void push(Node resource) {
            if (this.seen.add(resource)) {
                short s = this.nAvailable;
                this.nAvailable = (short)(s + 1);
                this.lookahead[s] = new Triple(resource, TYPE, RESOURCE);
            }
        }

        public boolean hasNext() {
            while (this.nAvailable == 0 && super.hasNext()) {
                Triple value = (Triple)super.next();
                if (!this.seen.add(value)) continue;
                this.push(value.getSubject());
                this.push(value.getPredicate());
                Node object = value.getObject();
                if (object.isLiteral()) continue;
                this.push(object);
            }
            return this.nAvailable > 0;
        }

        public Object next() {
            if (this.nAvailable == 0 && !this.hasNext()) {
                throw new NoSuchElementException("No element available");
            }
            this.nAvailable = (short)(this.nAvailable - 1);
            return this.lookahead[this.nAvailable];
        }
    }
}

