/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.regression;

import com.hp.hpl.jena.rdf.arp.JenaReader;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.impl.NTripleReader;
import com.hp.hpl.jena.regression.ResourceReader;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.NoReaderForLangException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class testReaderInterface {
    protected static Log logger = LogFactory.getLog(testReaderInterface.class);
    private boolean inError = false;

    protected static void doTest(Model m1) {
        new testReaderInterface().test(m1);
    }

    void test(Model m1) {
        String test3 = "testReaderInterface";
        String filebase = "testing/regression/" + test3 + "/";
        int n = 0;
        try {
            ++n;
            RDFReader reader = m1.getReader();
            ++n;
            reader = m1.getReader("N-TRIPLE");
            if (!(reader instanceof NTripleReader)) {
                this.error(test3, n);
            }
            ++n;
            try {
                m1.setReaderClassName("foobar", "");
                reader = m1.getReader("foobar");
                this.error(test3, n);
            }
            catch (NoReaderForLangException jx) {
                // empty catch block
            }
            ++n;
            m1.setReaderClassName("foobar", JenaReader.class.getName());
            reader = m1.getReader("foobar");
            if (!(reader instanceof JenaReader)) {
                this.error(test3, n);
            }
            try {
                ++n;
                m1.read("http://www.w3.org/2000/10/rdf-tests/rdfcore/rdf-containers-syntax-vs-schema/test001.rdf");
                ++n;
                m1.read("http://www.w3.org/2000/10/rdf-tests/rdfcore/rdf-containers-syntax-vs-schema/test001.nt", "N-TRIPLE");
            }
            catch (JenaException jx) {
                if (jx.getCause() instanceof NoRouteToHostException || jx.getCause() instanceof UnknownHostException || jx.getCause() instanceof ConnectException || jx.getCause() instanceof IOException) {
                    logger.warn("Cannot access public internet - part of test not executed");
                }
                throw jx;
            }
            ++n;
            m1.read(ResourceReader.getInputStream(filebase + "1.rdf"), "http://example.org/");
            ++n;
            m1.read(ResourceReader.getInputStream(filebase + "2.nt"), "", "N-TRIPLE");
        }
        catch (Exception e) {
            this.inError = true;
            logger.error(" test " + test3 + "[" + n + "]", e);
        }
    }

    protected void error(String test3, int n) {
        System.out.println(test3 + ": failed test " + Integer.toString(n));
        this.inError = true;
    }

    public boolean getErrors() {
        return this.inError;
    }
}

