/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput.impl;

import com.hp.hpl.jena.JenaRuntime;
import com.hp.hpl.jena.rdf.arp.MalformedURIException;
import com.hp.hpl.jena.rdf.arp.URI;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NsIterator;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.RDFDefaultErrorHandler;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.shared.BadBooleanException;
import com.hp.hpl.jena.shared.BadURIException;
import com.hp.hpl.jena.shared.BrokenException;
import com.hp.hpl.jena.shared.InvalidPropertyURIException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.CharEncoding;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.DC;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.RDFSyntax;
import com.hp.hpl.jena.vocabulary.RSS;
import com.hp.hpl.jena.vocabulary.VCARD;
import com.hp.hpl.jena.xmloutput.RDFXMLWriterI;
import com.hp.hpl.jena.xmloutput.impl.Relation;
import com.hp.hpl.jena.xmloutput.impl.SimpleLogger;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.xerces.util.XMLChar;

public abstract class BaseXMLWriter
implements RDFXMLWriterI {
    private static final String newline_XMLNS = System.getProperty("line.separator") + "    xmlns";
    private static Log xlogger = LogFactory.getLog(BaseXMLWriter.class);
    protected static SimpleLogger logger = new SimpleLogger(){

        public void warn(String s) {
            xlogger.warn(s);
        }

        public void warn(String s, Exception e) {
            xlogger.warn(s, e);
        }
    };
    private String attributeQuoteChar = "\"";
    private static Set badRDF = new HashSet();
    private int jenaPrefixCount;
    static String RDFNS = RDF.getURI();
    private static Perl5Matcher matcher = new Perl5Matcher();
    private static Pattern jenaNamespace;
    String xmlBase = null;
    private URI baseURI;
    boolean longId = false;
    private boolean demandGoodURIs = true;
    int tab = 2;
    int width = 60;
    HashMap anonMap = new HashMap();
    int anonCount = 0;
    private static RDFDefaultErrorHandler defaultErrorHandler;
    RDFErrorHandler errorHandler = defaultErrorHandler;
    Boolean showXmlDeclaration = null;
    private boolean writingAllModelPrefixNamespaces = true;
    private Relation nameSpaces = new Relation();
    private Map ns;
    private Set namespacesNeeded;
    private static final int FAST = 1;
    private static final int START = 2;
    private static final int END = 3;
    private static final int ATTR = 4;
    private static final int FASTATTR = 5;
    public static boolean dbg;
    private static final char ESCAPE = 'X';
    static final char[] hexchar;
    private Resource[] blockedRules = new Resource[]{RDFSyntax.propertyAttr};
    private int relativeFlags = 29;

    public BaseXMLWriter() {
        this.setupMaps();
    }

    public static SimpleLogger setLogger(SimpleLogger lg) {
        SimpleLogger old = logger;
        logger = lg;
        return old;
    }

    abstract void unblockAll();

    abstract void blockRule(Resource var1);

    abstract void writeBody(Model var1, PrintWriter var2, String var3, boolean var4);

    protected String q(String s) {
        return this.attributeQuoteChar + s + this.attributeQuoteChar;
    }

    protected String qq(String s) {
        return this.q(Util.substituteStandardEntities(s));
    }

    String anonId(Resource r) {
        return this.longId ? this.longAnonId(r) : this.shortAnonId(r);
    }

    private String shortAnonId(Resource r) {
        String result = (String)this.anonMap.get(r.getId());
        if (result == null) {
            result = "A" + Integer.toString(this.anonCount++);
            this.anonMap.put(r.getId(), result);
        }
        return result;
    }

    private String longAnonId(Resource r) {
        String rid = r.getId().toString();
        return XMLChar.isValidNCName(rid) ? rid : BaseXMLWriter.escapedId(rid);
    }

    void addNameSpace(String uri) {
        this.namespacesNeeded.add(uri);
    }

    boolean isDefaultNamespace(String uri) {
        return "".equals(this.ns.get(uri));
    }

    private void addNameSpaces(Model model) {
        NsIterator nsIter = model.listNameSpaces();
        while (nsIter.hasNext()) {
            this.addNameSpace(nsIter.nextNs());
        }
    }

    private void primeNamespace(Model model) {
        Map m = model.getNsPrefixMap();
        Iterator it = m.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            String value = (String)e.getValue();
            String already = this.getPrefixFor(value);
            if (already != null) continue;
            this.setNsPrefix(model.getNsURIPrefix(value), value);
            if (!this.writingAllModelPrefixNamespaces) continue;
            this.addNameSpace(value);
        }
    }

    void setupMaps() {
        this.nameSpaces.set11(RDF.getURI(), "rdf");
        this.nameSpaces.set11(RDFS.getURI(), "rdfs");
        this.nameSpaces.set11(DC.getURI(), "dc");
        this.nameSpaces.set11(RSS.getURI(), "rss");
        this.nameSpaces.set11("http://www.daml.org/2001/03/daml+oil.daml#", "daml");
        this.nameSpaces.set11(VCARD.getURI(), "vcard");
        this.nameSpaces.set11("http://www.w3.org/2002/07/owl#", "owl");
    }

    void workOutNamespaces() {
        if (this.ns == null) {
            this.ns = new HashMap();
            HashSet prefixesUsed = new HashSet();
            this.setFromWriterSystemProperties(this.ns, prefixesUsed);
            this.setFromGivenNamespaces(this.ns, prefixesUsed);
        }
    }

    private void setFromWriterSystemProperties(Map ns, Set prefixesUsed) {
        Iterator it = this.namespacesNeeded.iterator();
        while (it.hasNext()) {
            String uri = (String)it.next();
            String val = JenaRuntime.getSystemProperty("com.hp.hpl.jena.nsprefix." + uri);
            if (val == null || !this.checkLegalPrefix(val) || prefixesUsed.contains(val)) continue;
            ns.put(uri, val);
            prefixesUsed.add(val);
        }
    }

    private void setFromGivenNamespaces(Map ns, Set prefixesUsed) {
        Iterator it = this.namespacesNeeded.iterator();
        while (it.hasNext()) {
            String uri = (String)it.next();
            if (ns.containsKey(uri)) continue;
            String val = null;
            Set s = this.nameSpaces.forward(uri);
            if (s != null) {
                Iterator it2 = s.iterator();
                if (it2.hasNext()) {
                    val = (String)it2.next();
                }
                if (prefixesUsed.contains(val)) {
                    val = null;
                }
            }
            if (val == null) {
                while (prefixesUsed.contains(val = "j." + this.jenaPrefixCount++)) {
                }
            }
            ns.put(uri, val);
            prefixesUsed.add(val);
        }
    }

    public final synchronized void setNsPrefix(String prefix, String ns) {
        if (this.checkLegalPrefix(prefix)) {
            this.nameSpaces.set11(ns, prefix);
        }
    }

    public final String getPrefixFor(String uri) {
        Set s = this.nameSpaces.backward(uri);
        if (s != null && s.size() == 1) {
            return (String)s.iterator().next();
        }
        return null;
    }

    String xmlnsDecl() {
        this.workOutNamespaces();
        StringBuffer rslt = new StringBuffer();
        Iterator it = this.ns.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry ent = it.next();
            String prefix = (String)ent.getValue();
            String uri = (String)ent.getKey();
            rslt.append(newline_XMLNS);
            if (prefix.length() > 0) {
                rslt.append(':').append(prefix);
            }
            rslt.append('=').append(this.qq(this.checkURI(uri)));
        }
        return rslt.toString();
    }

    String rdfEl(String local) {
        return this.tag(RDFNS, local, 1, true);
    }

    String startElementTag(String uri, String local) {
        return this.tag(uri, local, 2, false);
    }

    protected String startElementTag(String uriref) {
        return this.splitTag(uriref, 2);
    }

    String attributeTag(String uriref) {
        return this.splitTag(uriref, 4);
    }

    String attributeTag(String uri, String local) {
        return this.tag(uri, local, 4, false);
    }

    String rdfAt(String local) {
        return this.tag(RDFNS, local, 5, true);
    }

    String endElementTag(String uri, String local) {
        return this.tag(uri, local, 3, false);
    }

    protected String endElementTag(String uriref) {
        return this.splitTag(uriref, 3);
    }

    String splitTag(String uriref, int type) {
        int split = Util.splitNamespace(uriref);
        if (split == uriref.length()) {
            throw new InvalidPropertyURIException(uriref);
        }
        return this.tag(uriref.substring(0, split), uriref.substring(split), type, true);
    }

    String tag(String namespace, String local, int type, boolean localIsQname) {
        if (dbg) {
            System.err.println(namespace + " - " + local);
        }
        String prefix = (String)this.ns.get(namespace);
        if (type != 1 && type != 5) {
            if (!localIsQname && !XMLChar.isValidNCName(local)) {
                return this.splitTag(namespace + local, type);
            }
            if (namespace.equals(RDFNS) && badRDF.contains(local)) {
                logger.warn("The URI rdf:" + local + " cannot be serialized in RDF/XML.");
                throw new InvalidPropertyURIException("rdf:" + local);
            }
        }
        boolean cookUp = false;
        if (prefix == null) {
            this.checkURI(namespace);
            logger.warn("Internal error: unexpected QName URI: <" + namespace + ">.  Fixing up with j.cook.up code.", new BrokenException("unexpected QName URI " + namespace));
            cookUp = true;
        } else if (prefix.length() == 0) {
            if (type == 4 || type == 5) {
                cookUp = true;
            } else {
                return local;
            }
        }
        if (cookUp) {
            return this.cookUpAttribution(type, namespace, local);
        }
        return prefix + ":" + local;
    }

    private String cookUpAttribution(int type, String namespace, String local) {
        String prefix = "j.cook.up";
        switch (type) {
            case 4: 
            case 5: {
                return "xmlns:" + prefix + "=" + this.qq(namespace) + " " + prefix + ":" + local;
            }
            case 2: {
                return prefix + ":" + local + " xmlns:" + prefix + "=" + this.qq(namespace);
            }
            default: {
                return prefix + ":" + local;
            }
            case 1: 
        }
        throw new BrokenException("cookup reached final FAST");
    }

    public final void write(Model model, OutputStream out, String base) {
        this.write(model, FileUtils.asUTF8(out), base);
    }

    public synchronized void write(Model baseModel, Writer out, String base) {
        PrintWriter pw;
        Model model = ModelFactory.withHiddenStatements(baseModel);
        this.namespacesNeeded = new HashSet();
        this.ns = null;
        this.primeNamespace(baseModel);
        this.addNameSpace(RDF.getURI());
        this.addNameSpaces(model);
        this.jenaPrefixCount = 0;
        PrintWriter printWriter = pw = out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out);
        if (!Boolean.FALSE.equals(this.showXmlDeclaration)) {
            this.writeXMLDeclaration(out, pw);
        }
        this.writeXMLBody(model, pw, base);
        pw.flush();
    }

    private void writeXMLBody(Model model, PrintWriter pw, String base) {
        try {
            if (this.xmlBase == null) {
                this.baseURI = base == null || base.length() == 0 ? null : new URI(base);
                this.writeBody(model, pw, base, false);
            } else {
                this.baseURI = this.xmlBase.length() == 0 ? null : new URI(this.xmlBase);
                this.writeBody(model, pw, this.xmlBase, true);
            }
        }
        catch (MalformedURIException e) {
            throw new BadURIException(e.getMessage(), e);
        }
    }

    private void writeXMLDeclaration(Writer out, PrintWriter pw) {
        String javaEnc;
        String decl = null;
        if (out instanceof OutputStreamWriter && !(javaEnc = ((OutputStreamWriter)out).getEncoding()).equals("UTF8") && !javaEnc.equals("UTF-16")) {
            CharEncoding encodingInfo = CharEncoding.create(javaEnc);
            String ianaEnc = encodingInfo.name();
            decl = "<?xml version=" + this.q("1.0") + " encoding=" + this.q(ianaEnc) + "?>";
            if (!encodingInfo.isIANA()) {
                logger.warn(encodingInfo.warningMessage() + "\n" + "   It is better to use a FileOutputStream, in place of a FileWriter.");
            }
        }
        if (decl == null && this.showXmlDeclaration != null) {
            decl = "<?xml version=" + this.q("1.0") + "?>";
        }
        if (decl != null) {
            pw.println(decl);
        }
    }

    public synchronized RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        RDFErrorHandler rslt = this.errorHandler;
        if (rslt == defaultErrorHandler) {
            rslt = null;
        }
        this.errorHandler = errHandler == null ? defaultErrorHandler : errHandler;
        return rslt;
    }

    private static String escapedId(String id) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < id.length(); ++i) {
            char ch = id.charAt(i);
            if (ch != 'X' && (i == 0 ? XMLChar.isNCNameStart(ch) : XMLChar.isNCName(ch))) {
                result.append(ch);
                continue;
            }
            BaseXMLWriter.escape(result, ch);
        }
        return result.toString();
    }

    private static void escape(StringBuffer sb, char ch) {
        sb.append('X');
        int charcode = ch;
        do {
            sb.append(hexchar[charcode & 0xF]);
        } while ((charcode >>= 4) != 0);
        sb.append('X');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Object setProperty(String propName, Object propValue) {
        if (propName.equalsIgnoreCase("showXmlDeclaration")) {
            return this.setShowXmlDeclaration(propValue);
        }
        if (propName.equalsIgnoreCase("minimalPrefixes")) {
            Boolean bl;
            try {
                bl = new Boolean(!this.writingAllModelPrefixNamespaces);
            }
            catch (Throwable throwable) {
                this.writingAllModelPrefixNamespaces = !BaseXMLWriter.getBoolean(propValue);
                throw throwable;
            }
            this.writingAllModelPrefixNamespaces = !BaseXMLWriter.getBoolean(propValue);
            return bl;
        }
        if (propName.equalsIgnoreCase("xmlbase")) {
            String result = this.xmlBase;
            this.xmlBase = (String)propValue;
            return result;
        }
        if (propName.equalsIgnoreCase("tab")) {
            return this.setTab(propValue);
        }
        if (propName.equalsIgnoreCase("width")) {
            return this.setWidth(propValue);
        }
        if (propName.equalsIgnoreCase("longid")) {
            Boolean result = new Boolean(this.longId);
            this.longId = BaseXMLWriter.getBoolean(propValue);
            return result;
        }
        if (propName.equalsIgnoreCase("attributeQuoteChar")) {
            return this.setAttributeQuoteChar(propValue);
        }
        if (propName.equalsIgnoreCase("allowBadURIs")) {
            Boolean result = new Boolean(!this.demandGoodURIs);
            this.demandGoodURIs = !BaseXMLWriter.getBoolean(propValue);
            return result;
        }
        if (propName.equalsIgnoreCase("prettyTypes")) {
            return this.setTypes((Resource[])propValue);
        }
        if (propName.equalsIgnoreCase("relativeURIs")) {
            int old = this.relativeFlags;
            this.relativeFlags = BaseXMLWriter.str2flags((String)propValue);
            return BaseXMLWriter.flags2str(old);
        }
        if (propName.equalsIgnoreCase("blockRules")) {
            return this.setBlockRules(propValue);
        }
        logger.warn("Unsupported property: " + propName);
        return null;
    }

    private String setAttributeQuoteChar(Object propValue) {
        String result = this.attributeQuoteChar;
        if ("\"".equals(propValue) || "'".equals(propValue)) {
            this.attributeQuoteChar = (String)propValue;
        } else {
            logger.warn("attributeQutpeChar must be either \"\\\"\" or ', not \"" + propValue + "\"");
        }
        return result;
    }

    private Integer setWidth(Object propValue) {
        Integer result = new Integer(this.width);
        if (propValue instanceof Integer) {
            this.width = (Integer)propValue;
        } else {
            try {
                this.width = Integer.parseInt((String)propValue);
            }
            catch (Exception e) {
                logger.warn("Bad value for width: '" + propValue + "' [" + e.getMessage() + "]");
            }
        }
        return result;
    }

    private Integer setTab(Object propValue) {
        Integer result = new Integer(this.tab);
        if (propValue instanceof Integer) {
            this.tab = (Integer)propValue;
        } else {
            try {
                this.tab = Integer.parseInt((String)propValue);
            }
            catch (Exception e) {
                logger.warn("Bad value for tab: '" + propValue + "' [" + e.getMessage() + "]");
            }
        }
        return result;
    }

    private String setShowXmlDeclaration(Object propValue) {
        String oldValue = this.showXmlDeclaration == null ? null : this.showXmlDeclaration.toString();
        if (propValue == null) {
            this.showXmlDeclaration = null;
        } else if (propValue instanceof Boolean) {
            this.showXmlDeclaration = (Boolean)propValue;
        } else if (propValue instanceof String) {
            String propValueStr = (String)propValue;
            if (propValueStr.equalsIgnoreCase("default")) {
                this.showXmlDeclaration = null;
            }
            if (propValueStr.equalsIgnoreCase("true")) {
                this.showXmlDeclaration = Boolean.TRUE;
            } else if (propValueStr.equalsIgnoreCase("false")) {
                this.showXmlDeclaration = Boolean.FALSE;
            } else {
                throw new BadBooleanException(propValueStr);
            }
        }
        return oldValue;
    }

    private static boolean getBoolean(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return Boolean.valueOf((String)o);
    }

    Resource[] setTypes(Resource[] x) {
        logger.warn("prettyTypes is not a property on the Basic RDF/XML writer.");
        return null;
    }

    Resource[] setBlockRules(Object o) {
        Resource[] rslt = this.blockedRules;
        this.unblockAll();
        if (o instanceof Resource[]) {
            this.blockedRules = (Resource[])o;
        } else {
            StringTokenizer tkn = new StringTokenizer((String)o, ", ");
            Vector<Resource> v = new Vector<Resource>();
            while (tkn.hasMoreElements()) {
                String frag = tkn.nextToken();
                if (frag.equals("daml:collection")) {
                    v.add(DAML_OIL.collection);
                    continue;
                }
                v.add(new ResourceImpl(RDFSyntax.getURI() + frag));
            }
            this.blockedRules = new Resource[v.size()];
            v.copyInto(this.blockedRules);
        }
        for (int i = 0; i < this.blockedRules.length; ++i) {
            this.blockRule(this.blockedRules[i]);
        }
        return rslt;
    }

    protected String relativize(String uri) {
        return this.relativeFlags != 0 && this.baseURI != null ? this.relativize(this.baseURI, uri) : this.checkURI(uri);
    }

    private String relativize(URI base, String uri) {
        try {
            return base.relativize(uri, this.relativeFlags);
        }
        catch (MalformedURIException e) {
            throw new JenaException(e);
        }
    }

    private String checkURI(String uri) {
        if (this.demandGoodURIs) {
            try {
                new URI(uri);
            }
            catch (MalformedURIException e) {
                throw new BadURIException("Only well-formed absolute URIrefs can be included in RDF/XML output: " + uri, e);
            }
        }
        return uri;
    }

    private boolean checkLegalPrefix(String prefix) {
        if (prefix.equals("")) {
            return true;
        }
        if (prefix.toLowerCase().startsWith("xml")) {
            logger.warn("Namespace prefix '" + prefix + "' is reserved by XML.");
        } else if (!XMLChar.isValidNCName(prefix)) {
            logger.warn("'" + prefix + "' is not a legal namespace prefix.");
        } else if (matcher.matches(prefix, jenaNamespace)) {
            logger.warn("Namespace prefix '" + prefix + "' is reserved by Jena.");
        } else {
            return true;
        }
        return false;
    }

    private static String flags2str(int f) {
        StringBuffer oldValue = new StringBuffer(64);
        if ((f & 1) != 0) {
            oldValue.append("same-document, ");
        }
        if ((f & 2) != 0) {
            oldValue.append("network, ");
        }
        if ((f & 4) != 0) {
            oldValue.append("absolute, ");
        }
        if ((f & 8) != 0) {
            oldValue.append("relative, ");
        }
        if ((f & 0x10) != 0) {
            oldValue.append("parent, ");
        }
        if ((f & 0x20) != 0) {
            oldValue.append("grandparent, ");
        }
        if (oldValue.length() > 0) {
            oldValue.setLength(oldValue.length() - 2);
        }
        return oldValue.toString();
    }

    public static int str2flags(String pv) {
        StringTokenizer tkn = new StringTokenizer(pv, ", ");
        int rslt = 0;
        while (tkn.hasMoreElements()) {
            String flag = tkn.nextToken();
            if (flag.equals("same-document")) {
                rslt |= 1;
                continue;
            }
            if (flag.equals("network")) {
                rslt |= 2;
                continue;
            }
            if (flag.equals("absolute")) {
                rslt |= 4;
                continue;
            }
            if (flag.equals("relative")) {
                rslt |= 8;
                continue;
            }
            if (flag.equals("parent")) {
                rslt |= 0x10;
                continue;
            }
            if (flag.equals("grandparent")) {
                rslt |= 0x20;
                continue;
            }
            logger.warn("Incorrect property value for relativeURIs: " + flag);
        }
        return rslt;
    }

    static {
        try {
            jenaNamespace = new Perl5Compiler().compile("j\\.([1-9][0-9]*|cook\\.up)");
        }
        catch (MalformedPatternException malformedPatternException) {
            // empty catch block
        }
        badRDF.add("RDF");
        badRDF.add("Description");
        badRDF.add("li");
        badRDF.add("about");
        badRDF.add("aboutEach");
        badRDF.add("aboutEachPrefix");
        badRDF.add("ID");
        badRDF.add("nodeID");
        badRDF.add("parseType");
        badRDF.add("datatype");
        badRDF.add("bagID");
        badRDF.add("resource");
        defaultErrorHandler = new RDFDefaultErrorHandler();
        dbg = false;
        hexchar = "0123456789abcdef".toCharArray();
    }
}

