/*
 * Decompiled with CFR 0.152.
 */
package com.skaringa.javaxml.serializers;

import com.skaringa.javaxml.DeserializerException;
import com.skaringa.javaxml.SerializerException;
import com.skaringa.javaxml.handler.DocumentOutputHandlerInterface;
import com.skaringa.javaxml.serializers.AbstractSerializer;
import com.skaringa.util.ISO8601DateFormat;
import com.skaringa.util.ISO8601DateTimeFormat;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.xml.sax.Attributes;

public class DateSerializer
extends AbstractSerializer {
    private Date _dummy = new Date();
    private String _xmlTypeName = "xsd:dateTime";

    public DateSerializer() {
    }

    public DateSerializer(String string) {
        this._xmlTypeName = string;
    }

    public void serialize(Object object, Class clazz, String string, Map map, Set set, DocumentOutputHandlerInterface documentOutputHandlerInterface) throws SerializerException {
        this.startElement(object, this.getXMLTypeName(), string, map, documentOutputHandlerInterface);
        if (object != null) {
            documentOutputHandlerInterface.appendText(this.newFormatter(this._xmlTypeName).format((Date)object));
        }
        documentOutputHandlerInterface.endElement(string);
    }

    public String getXMLTypeName() {
        return this._xmlTypeName;
    }

    public Object startDeserialize(String string, Attributes attributes, Object object) throws DeserializerException {
        Date date = null;
        String string2 = attributes.getValue("xsi:nil");
        if (string2 == null || string2.equals("false")) {
            date = this._dummy;
        }
        return date;
    }

    public Object endDeserialize(Object object, String string) throws DeserializerException {
        if (object != null) {
            try {
                object = this.newFormatter(this._xmlTypeName).parse(string);
            }
            catch (ParseException parseException) {
                throw new DeserializerException(parseException.getMessage());
            }
        }
        return object;
    }

    public void setMember(Object object, String string, Object object2) throws DeserializerException {
        throw new DeserializerException("no child element allowed for java.util.Date");
    }

    public void writeXMLTypeDefinition(Class clazz, DocumentOutputHandlerInterface documentOutputHandlerInterface) throws SerializerException {
    }

    public void addUsedClasses(Class clazz, Set set) throws SerializerException {
    }

    private DateFormat newFormatter(String string) {
        if ("xsd:date".equals(string)) {
            return new ISO8601DateFormat(TimeZone.getDefault());
        }
        return new ISO8601DateTimeFormat(TimeZone.getDefault());
    }
}

