/*
 * Decompiled with CFR 0.152.
 */
package flybase;

import flybase.Debug;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URLConnection;

public class DocFormat {
    protected int format;
    protected String mimetype;
    public static final int TEXT = 1230;
    public static final int DATA = 1231;
    public static final int PICT = 1232;
    public static final int POSTSCRIPT = 1233;
    public static final int JPEG = 1234;
    public static final int GIF = 1235;
    public static final int HTML = 1236;
    public static final int PRINTJOB = 1237;
    public static final int PDF = 1238;

    public DocFormat() {
    }

    public DocFormat(int n) {
        this.format = n;
        this.mimetype = this.mycontentType(n);
    }

    public DocFormat(String string) {
        this.mimetype = string;
        this.format = this.myformatFromContentType(string);
    }

    public DocFormat(File file) {
        this.mimetype = DocFormat.guessContentType(file);
        this.format = this.myformatFromContentType(this.mimetype);
    }

    public DocFormat(InputStream inputStream) {
        this.mimetype = DocFormat.guessContentType(inputStream);
        this.format = this.myformatFromContentType(this.mimetype);
    }

    public int format() {
        return this.format;
    }

    public String contentType() {
        if (this.mimetype == null) {
            this.mimetype = this.mycontentType(this.format);
        }
        return this.mimetype;
    }

    public String mycontentType(int n) {
        return DocFormat.contentType(n);
    }

    public static String contentType(int n) {
        switch (n) {
            case 1230: {
                return "text/plain";
            }
            case 1236: {
                return "text/html";
            }
            case 1231: {
                return "*/*";
            }
            case 1232: {
                return "image/pict";
            }
            case 1238: {
                return "application/pdf";
            }
            case 1233: {
                return "application/postscript";
            }
            case 1234: {
                return "image/jpeg";
            }
            case 1235: {
                return "image/gif";
            }
            case 1237: {
                return "application/printer";
            }
        }
        return "*/*";
    }

    public int myformatFromContentType(String string) {
        return DocFormat.formatFromContentType(string);
    }

    public static int formatFromContentType(String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        if ((string = string.toLowerCase()).equals("application/printer")) {
            return 1237;
        }
        if (string.startsWith("text/html")) {
            return 1236;
        }
        if (string.startsWith("text")) {
            return 1230;
        }
        if (string.endsWith("pict")) {
            return 1232;
        }
        if (string.endsWith("jpeg")) {
            return 1234;
        }
        if (string.endsWith("jpg")) {
            return 1234;
        }
        if (string.endsWith("gif")) {
            return 1235;
        }
        if (string.endsWith("pdf")) {
            return 1238;
        }
        if (string.endsWith("postscript")) {
            return 1233;
        }
        if (string.endsWith("/ps")) {
            return 1233;
        }
        if (string.endsWith("printer")) {
            return 1237;
        }
        return 0;
    }

    public static int formatFromSuffix(String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        if ((string = string.toLowerCase()).endsWith("html")) {
            return 1236;
        }
        if (string.endsWith("text")) {
            return 1230;
        }
        if (string.endsWith("txt")) {
            return 1230;
        }
        if (string.endsWith("pict")) {
            return 1232;
        }
        if (string.endsWith("jpeg")) {
            return 1234;
        }
        if (string.endsWith("jpg")) {
            return 1234;
        }
        if (string.endsWith("gif")) {
            return 1235;
        }
        if (string.endsWith("pdf")) {
            return 1238;
        }
        if (string.endsWith("postscript")) {
            return 1233;
        }
        if (string.endsWith("ps")) {
            return 1233;
        }
        return 0;
    }

    public String suffix() {
        return this.mysuffix(this.format);
    }

    public String mysuffix(int n) {
        return DocFormat.suffix(n);
    }

    public static String suffix(int n) {
        switch (n) {
            case 1230: {
                return ".txt";
            }
            case 1236: {
                return ".html";
            }
            case 1231: {
                return ".data";
            }
            case 1232: {
                return ".pict";
            }
            case 1238: {
                return ".pdf";
            }
            case 1233: {
                return ".ps";
            }
            case 1234: {
                return ".jpeg";
            }
            case 1235: {
                return ".gif";
            }
        }
        return "";
    }

    public String macType() {
        return this.mymacType(this.format);
    }

    public String mymacType(int n) {
        return DocFormat.macType(n);
    }

    public static String macType(int n) {
        switch (n) {
            case 1230: {
                return "TEXT";
            }
            case 1236: {
                return "TEXT";
            }
            case 1232: {
                return "PICT";
            }
            case 1238: {
                return "PDF ";
            }
            case 1233: {
                return "POST";
            }
            case 1234: {
                return "JPEG";
            }
            case 1235: {
                return "GIFf";
            }
        }
        return null;
    }

    public String macSire() {
        return this.mymacSire(this.format);
    }

    public String mymacSire(int n) {
        return DocFormat.macSire(n);
    }

    public static String macSire(int n) {
        switch (n) {
            case 1230: {
                return "R*ch";
            }
            case 1236: {
                return "MOSS";
            }
            case 1232: {
                return "ttxt";
            }
            case 1238: {
                return "CARO";
            }
            case 1233: {
                return "????";
            }
            case 1234: {
                return "JVWR";
            }
            case 1235: {
                return "JVWR";
            }
        }
        return null;
    }

    public String myguessContentType(File file) {
        String string = "*/*";
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            string = this.myguessContentType(fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static String guessContentType(File file) {
        String string = "*/*";
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            string = DocFormat.guessContentType(fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public String myguessContentType(InputStream inputStream) {
        return DocFormat.guessContentType(inputStream);
    }

    public static String guessContentType(InputStream inputStream) {
        String string = "*/*";
        try {
            if (!(inputStream instanceof BufferedInputStream)) {
                inputStream = new BufferedInputStream(inputStream);
            }
            string = URLConnection.guessContentTypeFromStream(inputStream);
            Debug.println(" guessContentType =" + string);
        }
        catch (Exception exception) {
            Debug.println(" guessContentType failed: " + exception.getMessage());
        }
        return string;
    }
}

