/*
 * Decompiled with CFR 0.152.
 */
package flybase;

import flybase.FastVector;
import flybase.ObjectComparator;
import flybase.StringComparator;
import java.util.Enumeration;

public class SortedEnumeration {
    FastVector vec = new FastVector();
    ObjectComparator cmp;

    public SortedEnumeration(Enumeration enumeration) {
        this(enumeration, new StringComparator());
    }

    public SortedEnumeration(Enumeration enumeration, ObjectComparator objectComparator) {
        while (enumeration.hasMoreElements()) {
            this.vec.addElement(enumeration.nextElement());
        }
        this.resort(objectComparator);
    }

    public FastVector vector() {
        return this.vec;
    }

    public Enumeration elements() {
        return this.vec.elements();
    }

    public void resort(ObjectComparator objectComparator) {
        this.cmp = objectComparator;
        this.quickr(0, this.vec.size() - 1);
    }

    protected final int compare(int n, int n2) {
        return this.cmp.compareObjects(this.vec.elementAt(n), this.vec.elementAt(n2));
    }

    protected final void swap(int n, int n2) {
        Object object = this.vec.elementAt(n);
        this.vec.setElementAt(this.vec.elementAt(n2), n);
        this.vec.setElementAt(object, n2);
    }

    protected void quickr(int n, int n2) {
        if (n < n2) {
            int n3 = n;
            int n4 = n2;
            while (true) {
                if (n3 < n4 && this.compare(n3, n2) <= 0) {
                    ++n3;
                    continue;
                }
                while (n4 > n3 && this.compare(n4, n2) >= 0) {
                    --n4;
                }
                if (n3 < n4) {
                    this.swap(n3, n4);
                }
                if (n3 >= n4) break;
            }
            this.swap(n3, n2);
            if (n3 - n < n2 - n3) {
                this.quickr(n, n3 - 1);
                this.quickr(n3 + 1, n2);
            } else {
                this.quickr(n3 + 1, n2);
                this.quickr(n, n3 - 1);
            }
        }
    }
}

