/*
 * Decompiled with CFR 0.152.
 */
package iubio.bioseq;

public class BaseKind {
    public static char indelHard = (char)45;
    public static char indelSoft = (char)126;
    public static char indelEdge = (char)46;
    public static final int kBitA = 0;
    public static final int kMaskA = 1;
    public static final int kBitC = 1;
    public static final int kMaskC = 2;
    public static final int kBitG = 2;
    public static final int kMaskG = 4;
    public static final int kBitT = 3;
    public static final int kMaskT = 8;
    public static final int kMaskY = 10;
    public static final int kMaskK = 12;
    public static final int kMaskS = 6;
    public static final int kMaskR = 5;
    public static final int kMaskM = 3;
    public static final int kMaskW = 9;
    public static final int kMaskH = 11;
    public static final int kMaskB = 14;
    public static final int kMaskV = 7;
    public static final int kMaskD = 13;
    public static final int kMaskN = 15;
    public static final int kBitExtra = 4;
    public static final int kMaskExtra = 16;
    public static final int kMaskIndel = 16;
    public static final int kMaskU = 24;
    public static final int kMaskRna = 24;
    public static final int kMaskNucs = 15;
    public static final int kBit5 = 5;
    public static final int kMask5 = 32;
    public static final int kBit6 = 6;
    public static final int kMask6 = 64;
    public static final int kBit7 = 7;
    public static final int kMask7 = 128;
    public static final int primenucflag = 1;
    public static final int iubextraflag = 2;
    public static final int aminoflag = 8;
    public static final int protonlyflag = 16;
    public static final int seqsymflag = 32;
    public static final int digitflag = 64;
    public static final int otherprintflag = 128;
    public static final int iubnucflag = 3;
    public static final int iubsymflag = 35;
    public static final int alphaseqflag = 43;
    public static final int alnumseqflag = 107;
    public static final int allprintflag = 235;
    protected static final byte opf = -128;
    protected static final byte aseqf = 43;
    protected static final byte[] cflags = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 32, 32, -128, -128, 32, 32, 32, 32, 40, 32, -128, 32, 32, 32, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 32, 32, 32, 32, 32, 32, 32, 9, 10, 9, 10, 24, 24, 9, 10, 24, -128, 10, 8, 10, 43, -128, 24, 24, 10, 10, 9, 1, 10, 10, 10, 10, 24, 32, 32, 32, 32, 32, 32, 9, 10, 9, 10, 24, 24, 9, 10, 24, -128, 10, 8, 10, 43, -128, 24, 24, 10, 10, 9, 1, 10, 10, 10, 10, 24, 32, 32, 32, 32, 0};
    protected static final byte[] nucomp = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 84, 86, 71, 72, 0, 0, 67, 68, 0, 0, 77, 0, 75, 0, 0, 0, 0, 89, 0, 65, 65, 66, 0, 0, 82, 0, 0, 0, 0, 0, 0, 0, 116, 118, 103, 104, 0, 0, 99, 100, 0, 0, 109, 0, 107, 0, 0, 0, 0, 121, 0, 97, 97, 98, 0, 0, 114, 0, 0, 0, 0, 0, 0};
    public static long[] crctab = new long[]{0L, 1996959894L, 3993919788L, 2567524794L, 124634137L, 1886057615L, 3915621685L, 2657392035L, 249268274L, 2044508324L, 3772115230L, 2547177864L, 162941995L, 2125561021L, 3887607047L, 2428444049L, 498536548L, 1789927666L, 4089016648L, 2227061214L, 450548861L, 1843258603L, 4107580753L, 2211677639L, 325883990L, 1684777152L, 4251122042L, 2321926636L, 335633487L, 1661365465L, 4195302755L, 2366115317L, 997073096L, 1281953886L, 3579855332L, 2724688242L, 1006888145L, 1258607687L, 3524101629L, 2768942443L, 901097722L, 1119000684L, 3686517206L, 2898065728L, 853044451L, 1172266101L, 3705015759L, 2882616665L, 651767980L, 1373503546L, 3369554304L, 3218104598L, 565507253L, 1454621731L, 3485111705L, 3099436303L, 671266974L, 1594198024L, 3322730930L, 2970347812L, 795835527L, 1483230225L, 3244367275L, 3060149565L, 1994146192L, 31158534L, 2563907772L, 4023717930L, 1907459465L, 112637215L, 2680153253L, 3904427059L, 2013776290L, 251722036L, 2517215374L, 3775830040L, 2137656763L, 141376813L, 2439277719L, 3865271297L, 1802195444L, 476864866L, 2238001368L, 4066508878L, 1812370925L, 453092731L, 2181625025L, 4111451223L, 1706088902L, 314042704L, 2344532202L, 4240017532L, 1658658271L, 366619977L, 2362670323L, 4224994405L, 1303535960L, 984961486L, 2747007092L, 3569037538L, 1256170817L, 1037604311L, 2765210733L, 3554079995L, 1131014506L, 879679996L, 2909243462L, 3663771856L, 1141124467L, 855842277L, 2852801631L, 3708648649L, 1342533948L, 654459306L, 3188396048L, 3373015174L, 1466479909L, 544179635L, 3110523913L, 3462522015L, 1591671054L, 702138776L, 2966460450L, 3352799412L, 1504918807L, 783551873L, 3082640443L, 3233442989L, 3988292384L, 2596254646L, 62317068L, 1957810842L, 3939845945L, 2647816111L, 81470997L, 1943803523L, 3814918930L, 2489596804L, 225274430L, 2053790376L, 3826175755L, 2466906013L, 167816743L, 2097651377L, 4027552580L, 2265490386L, 503444072L, 1762050814L, 4150417245L, 2154129355L, 426522225L, 1852507879L, 4275313526L, 2312317920L, 282753626L, 1742555852L, 4189708143L, 2394877945L, 397917763L, 1622183637L, 3604390888L, 2714866558L, 953729732L, 1340076626L, 3518719985L, 2797360999L, 1068828381L, 1219638859L, 3624741850L, 2936675148L, 906185462L, 1090812512L, 3747672003L, 2825379669L, 829329135L, 1181335161L, 3412177804L, 3160834842L, 628085408L, 1382605366L, 3423369109L, 3138078467L, 570562233L, 1426400815L, 3317316542L, 2998733608L, 733239954L, 1555261956L, 3268935591L, 3050360625L, 752459403L, 1541320221L, 2607071920L, 3965973030L, 1969922972L, 40735498L, 2617837225L, 3943577151L, 1913087877L, 83908371L, 2512341634L, 3803740692L, 2075208622L, 213261112L, 2463272603L, 3855990285L, 2094854071L, 198958881L, 2262029012L, 4057260610L, 1759359992L, 534414190L, 2176718541L, 4139329115L, 1873836001L, 414664567L, 2282248934L, 4279200368L, 1711684554L, 285281116L, 2405801727L, 4167216745L, 1634467795L, 376229701L, 2685067896L, 3608007406L, 1308918612L, 956543938L, 2808555105L, 3495958263L, 1231636301L, 1047427035L, 2932959818L, 3654703836L, 1088359270L, 936918000L, 2847714899L, 3736837829L, 1202900863L, 817233897L, 3183342108L, 3401237130L, 1404277552L, 615818150L, 3134207493L, 3453421203L, 1423857449L, 601450431L, 3009837614L, 3294710456L, 1567103746L, 711928724L, 3020668471L, 3272380065L, 1510334235L, 755167117L};

    public static boolean isPrimenuc(int n) {
        return n > 127 || n < 0 ? false : (cflags[n] & 1) != 0;
    }

    public static boolean isIUBsym(int n) {
        return n > 127 || n < 0 ? false : (cflags[n] & 0x23) != 0;
    }

    public static boolean isDnanuc(int n) {
        return n > 127 || n < 0 ? false : (cflags[n] & 1) != 0 && n != 117 && n != 85;
    }

    public static boolean isRnanuc(int n) {
        return n > 127 || n < 0 ? false : (cflags[n] & 1) != 0 && n != 116 && n != 84;
    }

    public static boolean isAmino(int n) {
        return n > 127 || n < 0 ? false : (cflags[n] & 8) != 0;
    }

    public static boolean isProtonly(int n) {
        return n > 127 || n < 0 ? false : (cflags[n] & 0x10) != 0;
    }

    public static boolean isSeqsym(int n) {
        return n > 127 || n < 0 ? false : (cflags[n] & 0x20) != 0;
    }

    public static boolean isAlphaseq(int n) {
        return n > 127 || n < 0 ? false : (cflags[n] & 0x2B) != 0;
    }

    public static boolean isAlnumseq(int n) {
        return n > 127 || n < 0 ? false : (cflags[n] & 0x6B) != 0;
    }

    public static boolean isPrint(int n) {
        return n > 127 || n < 0 ? false : (cflags[n] & 0xEB) != 0;
    }

    public static boolean isIndel(int n) {
        return n > 127 || n < 0 ? false : n == indelHard || n == indelSoft || n == indelEdge;
    }

    public static boolean isBasekind(int n, int n2) {
        return n > 127 || n < 0 ? false : (cflags[n] & n2) != 0;
    }

    public static int isSeqChar(int n) {
        if (BaseKind.isAlphaseq(n)) {
            return n;
        }
        return 0;
    }

    public static int isGCGSeqChar(int n) {
        if (BaseKind.isAlphaseq(n)) {
            if (n == 46) {
                return 45;
            }
            return n;
        }
        return 0;
    }

    public static int isSeqNumChar(int n) {
        if (BaseKind.isAlnumseq(n)) {
            return n;
        }
        return 0;
    }

    public static int isAnyChar(int n) {
        if (BaseKind.isPrint(n)) {
            return n;
        }
        return 0;
    }

    public static final int nucleicBits(char c) {
        return BaseKind.nucleicBits((byte)c);
    }

    public static int nucleicBits(byte by) {
        switch (by) {
            case 65: 
            case 97: {
                return 1;
            }
            case 67: 
            case 99: {
                return 2;
            }
            case 71: 
            case 103: {
                return 4;
            }
            case 84: 
            case 116: {
                return 8;
            }
            case 85: 
            case 117: {
                return 24;
            }
            case 89: 
            case 121: {
                return 10;
            }
            case 75: 
            case 107: {
                return 12;
            }
            case 83: 
            case 115: {
                return 6;
            }
            case 82: 
            case 114: {
                return 5;
            }
            case 77: 
            case 109: {
                return 3;
            }
            case 87: 
            case 119: {
                return 9;
            }
            case 72: 
            case 104: {
                return 11;
            }
            case 66: 
            case 98: {
                return 14;
            }
            case 86: 
            case 118: {
                return 7;
            }
            case 68: 
            case 100: {
                return 13;
            }
            case 32: 
            case 95: {
                return 0;
            }
            case 0: {
                return 0;
            }
            case 78: 
            case 110: {
                return 15;
            }
        }
        if (by == indelHard || by == indelSoft) {
            return 16;
        }
        if (by == indelEdge) {
            return 0;
        }
        return 0;
    }

    public static byte nucleicComplement(byte by, boolean bl) {
        if (by < 0 || by > 127) {
            return by;
        }
        byte by2 = nucomp[by];
        if (by2 == 0) {
            return by;
        }
        if (bl) {
            if (by == 65) {
                return 85;
            }
            if (by == 97) {
                return 117;
            }
            return by2;
        }
        return by2;
    }

    public static boolean isNucleicMatch(int n, int n2) {
        return 0 != (0xF & n & (0xF & n2));
    }

    public static byte nucleicConsensus(int n, int n2) {
        boolean bl;
        boolean bl2 = bl = n == 16 || n2 == 16;
        if (n == 0 || n2 == 0) {
            return (byte)indelSoft;
        }
        switch (0xF & n | 0xF & n2) {
            case 1: {
                return (byte)(bl ? 97 : 65);
            }
            case 2: {
                return (byte)(bl ? 99 : 67);
            }
            case 4: {
                return (byte)(bl ? 103 : 71);
            }
            case 8: {
                boolean bl3;
                boolean bl4 = bl3 = 24 == n || 24 == n2;
                if (bl3) {
                    return (byte)(bl ? 117 : 85);
                }
                return (byte)(bl ? 116 : 84);
            }
            case 10: {
                return (byte)(bl ? 121 : 89);
            }
            case 12: {
                return (byte)(bl ? 107 : 75);
            }
            case 6: {
                return (byte)(bl ? 115 : 83);
            }
            case 5: {
                return (byte)(bl ? 114 : 82);
            }
            case 3: {
                return (byte)(bl ? 109 : 77);
            }
            case 9: {
                return (byte)(bl ? 119 : 87);
            }
            case 11: {
                return (byte)(bl ? 104 : 72);
            }
            case 14: {
                return (byte)(bl ? 98 : 66);
            }
            case 7: {
                return (byte)(bl ? 118 : 86);
            }
            case 13: {
                return (byte)(bl ? 100 : 68);
            }
        }
        return (byte)(bl ? 110 : 78);
    }

    public static String Amino123(char c) {
        switch (c) {
            case 'A': 
            case 'a': {
                return "Ala";
            }
            case 'M': 
            case 'm': {
                return "Met";
            }
            case 'R': 
            case 'r': {
                return "Arg";
            }
            case 'F': 
            case 'f': {
                return "Phe";
            }
            case 'N': 
            case 'n': {
                return "Asn";
            }
            case 'P': 
            case 'p': {
                return "Pro";
            }
            case 'D': 
            case 'd': {
                return "Asp";
            }
            case 'S': 
            case 's': {
                return "Ser";
            }
            case 'C': 
            case 'c': {
                return "Cys";
            }
            case 'T': 
            case 't': {
                return "Thr";
            }
            case 'Q': 
            case 'q': {
                return "Gln";
            }
            case 'W': 
            case 'w': {
                return "Trp";
            }
            case 'E': 
            case 'e': {
                return "Glu";
            }
            case 'Y': 
            case 'y': {
                return "Tyr";
            }
            case 'G': 
            case 'g': {
                return "Gly";
            }
            case 'V': 
            case 'v': {
                return "Val";
            }
            case 'H': 
            case 'h': {
                return "His";
            }
            case 'I': 
            case 'i': {
                return "Ile";
            }
            case 'B': 
            case 'b': {
                return "Asx";
            }
            case 'L': 
            case 'l': {
                return "Leu";
            }
            case 'Z': 
            case 'z': {
                return "Glx";
            }
            case 'K': 
            case 'k': {
                return "Lys";
            }
            case 'X': 
            case 'x': {
                return "Xaa";
            }
            case '*': {
                return "End";
            }
            case ' ': {
                return "   ";
            }
        }
        return "???";
    }

    public static char Amino321(String string) {
        char[] cArray = new char[3];
        int n = 0;
        char c = string.charAt(n);
        if (c > 'Z') {
            c = (char)(c - 32);
        }
        cArray[n] = c;
        if ((c = string.charAt(++n)) < 'a') {
            c = (char)(c + 32);
        }
        cArray[n] = c;
        if ((c = string.charAt(++n)) < 'a') {
            c = (char)(c + 32);
        }
        cArray[n] = c;
        string = new String(cArray);
        if (string.equals("Ala")) {
            return 'A';
        }
        if (string.equals("Met")) {
            return 'M';
        }
        if (string.equals("Arg")) {
            return 'R';
        }
        if (string.equals("Phe")) {
            return 'F';
        }
        if (string.equals("Asn")) {
            return 'N';
        }
        if (string.equals("Pro")) {
            return 'P';
        }
        if (string.equals("Asp")) {
            return 'D';
        }
        if (string.equals("Ser")) {
            return 'S';
        }
        if (string.equals("Cys")) {
            return 'C';
        }
        if (string.equals("Thr")) {
            return 'T';
        }
        if (string.equals("Gln")) {
            return 'Q';
        }
        if (string.equals("Trp")) {
            return 'W';
        }
        if (string.equals("Glu")) {
            return 'E';
        }
        if (string.equals("Tyr")) {
            return 'Y';
        }
        if (string.equals("Gly")) {
            return 'G';
        }
        if (string.equals("Val")) {
            return 'V';
        }
        if (string.equals("His")) {
            return 'H';
        }
        if (string.equals("Ile")) {
            return 'I';
        }
        if (string.equals("Asx")) {
            return 'B';
        }
        if (string.equals("Leu")) {
            return 'L';
        }
        if (string.equals("Glx")) {
            return 'Z';
        }
        if (string.equals("Lys")) {
            return 'K';
        }
        if (string.equals("End")) {
            return '*';
        }
        if (string.equals("   ")) {
            return ' ';
        }
        return 'X';
    }

    public static byte aminoConsensus(byte by, byte by2) {
        if (by == by2) {
            return by;
        }
        if (BaseKind.isIndel(by2)) {
            return (byte)Character.toLowerCase((char)by2);
        }
        if (BaseKind.isIndel(by)) {
            return (byte)Character.toLowerCase((char)by);
        }
        return by;
    }
}

