/*
 * Decompiled with CFR 0.152.
 */
package iubio.bioseq;

import iubio.bioseq.BaseKind;
import iubio.bioseq.SeqInfo;

public class Bioseq
implements Cloneable {
    public static final short kOtherSeq = 0;
    public static final short kDNA = 1;
    public static final short kRNA = 2;
    public static final short kNucleic = 3;
    public static final short kAmino = 4;
    public static final int baseOnly = 0;
    public static final int maskOnly = 1;
    public static final int nucAndMask = 2;
    public static final int maskOnlyAsText = 3;
    public static boolean gUseByteArray = true;
    public int gBaseType = 0;
    protected byte[] bSeq;

    public Bioseq() {
        this(0);
    }

    public Bioseq(int n) {
        this.bSeq = new byte[n];
    }

    public Bioseq(byte[] byArray) {
        this.copyFrom(byArray);
    }

    public Bioseq(byte[] byArray, int n, int n2) {
        this.copyFrom(byArray, n, n2);
    }

    public Bioseq(char[] cArray) {
        this.copyFrom(cArray);
    }

    public Bioseq(char[] cArray, int n, int n2) {
        this.copyFrom(cArray, n, n2);
    }

    public Bioseq(String string) {
        this.copyFrom(string);
    }

    public Bioseq(Object object) {
        this.copyFrom(object);
    }

    public void copyFrom(Object object) {
        if (object instanceof byte[]) {
            this.copyFrom((byte[])object);
        } else if (object instanceof char[]) {
            this.copyFrom((char[])object);
        } else if (object instanceof String) {
            this.copyFrom((String)object);
        }
    }

    public final void copyFrom(byte[] byArray) {
        this.copyFrom(byArray, 0, byArray.length);
    }

    public void copyFrom(byte[] byArray, int n, int n2) {
        this.bSeq = new byte[n2];
        System.arraycopy(byArray, n, this.bSeq, 0, n2);
    }

    public final void copyFrom(char[] cArray) {
        this.copyFrom(cArray, 0, cArray.length);
    }

    public void copyFrom(char[] cArray, int n, int n2) {
        this.bSeq = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            this.bSeq[i] = (byte)cArray[i + n];
        }
    }

    public void copyFrom(String string) {
        this.bSeq = string.getBytes();
    }

    public int length() {
        return this.bSeq.length;
    }

    public void setbases(byte[] byArray) {
        this.bSeq = byArray;
    }

    public void setbase(int n, byte by) {
        this.bSeq[n] = by;
    }

    public void setbase(int n, char c) {
        this.setbase(n, (byte)c);
    }

    public byte basebyte(int n) {
        return this.bSeq[n];
    }

    public char basechar(int n) {
        return (char)this.basebyte(n);
    }

    public char base(int n, int n2) {
        return (char)this.basebyte(n);
    }

    public boolean isBytes() {
        return true;
    }

    public byte[] bases() {
        return this.toBytes(0);
    }

    public final byte[] toBytes() {
        return this.toBytes(this.gBaseType);
    }

    public byte[] toBytes(int n) {
        return this.bSeq;
    }

    public byte[] toBytes(int n, int n2, int n3) {
        if (n < 0) {
            n = 0;
        }
        if (this.bSeq != null) {
            if (n == 0 && n2 == this.bSeq.length) {
                return this.bSeq;
            }
            int n4 = this.bSeq.length - n;
            if (n2 > 0 && n2 < n4) {
                n4 = n2;
            }
            byte[] byArray = new byte[n4];
            System.arraycopy(this.bSeq, n, byArray, 0, n4);
            return byArray;
        }
        return null;
    }

    public final char[] toChars() {
        return this.toChars(this.gBaseType);
    }

    public final char[] toChars(int n) {
        return this.toChars(0, -1, n);
    }

    public char[] toChars(int n, int n2, int n3) {
        if (n < 0) {
            n = 0;
        }
        if (this.bSeq != null) {
            int n4 = this.bSeq.length - n;
            if (n2 > 0 && n2 < n4) {
                n4 = n2;
            }
            char[] cArray = new char[n4];
            for (int i = 0; i < n4; ++i) {
                cArray[i] = (char)this.bSeq[i + n];
            }
            return cArray;
        }
        return null;
    }

    public String toString() {
        return new String(this.toChars());
    }

    public Object clone() {
        try {
            Bioseq bioseq = (Bioseq)super.clone();
            byte[] byArray = new byte[this.bSeq.length];
            System.arraycopy(this.bSeq, 0, byArray, 0, this.bSeq.length);
            bioseq.bSeq = byArray;
            return bioseq;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error(cloneNotSupportedException.toString());
        }
    }

    public int getSeqtype() {
        int n = this.length();
        SeqInfo seqInfo = SeqInfo.getSeqInfo(n, true, false);
        seqInfo.add(this.bSeq, 0, n);
        return seqInfo.getKind();
    }

    public static int getSeqtype(String string, int n, int n2) {
        SeqInfo seqInfo = SeqInfo.getSeqInfo(n2, true, false);
        seqInfo.add(string, n, n2);
        return seqInfo.getKind();
    }

    public static int getSeqtype(byte[] byArray, int n, int n2) {
        SeqInfo seqInfo = SeqInfo.getSeqInfo(n2, true, false);
        seqInfo.add(byArray, n, n2);
        return seqInfo.getKind();
    }

    public final SeqInfo getSeqStats() {
        return this.getSeqStats(0, this.length());
    }

    public SeqInfo getSeqStats(int n, int n2) {
        SeqInfo seqInfo = SeqInfo.getSeqInfo(n2, false, true);
        seqInfo.add(this.bSeq, n, n2);
        return seqInfo;
    }

    public void reverseComplement() {
        this.reverseComplement(0, this.length());
    }

    public void reverseComplement(int n, int n2) {
        byte[] byArray = new byte[n2];
        byte[] byArray2 = this.toBytes(n, n2, 0);
        int n3 = this.getSeqtype();
        boolean bl = n3 == 4;
        boolean bl2 = n3 == 2;
        int n4 = n2 - 1;
        if (bl) {
            for (int i = 0; i < n2; ++i) {
                byArray[n4 - i] = byArray2[i];
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                byArray[n4 - i] = BaseKind.nucleicComplement(byArray2[i], bl2);
            }
        }
        this.setbases(byArray);
    }

    public final boolean equals(Bioseq bioseq) {
        return Bioseq.equals(this.bSeq, bioseq.bases());
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (n == byArray2.length) {
            while (n-- != 0) {
                if (byArray[n] == byArray2[n]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean equalsIgnoreCase(Bioseq bioseq) {
        return Bioseq.equalsIgnoreCase(this.bSeq, bioseq.bases());
    }

    public static boolean equalsIgnoreCase(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (n == byArray2.length) {
            while (n-- != 0) {
                if (Character.toUpperCase((char)byArray[n]) == Character.toUpperCase((char)byArray2[n])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final void compress(byte by) {
        byte[] byArray = Bioseq.compress(this.bSeq, 0, this.bSeq.length, by);
        this.setbases(byArray);
    }

    public final void compress(int n, int n2, byte by) {
        byte[] byArray = Bioseq.compress(this.bSeq, n, n2, by);
        this.setbases(byArray);
    }

    public static byte[] compress(byte[] byArray, int n, int n2, byte by) {
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (byArray[i + n] == by) continue;
            byArray2[n3++] = byArray[i + n];
        }
        if (n3 != n2) {
            return Bioseq.expand(byArray2, n3);
        }
        return byArray2;
    }

    public final void replace(int n, char c, char c2) {
        Bioseq.replace(this, n, c, c2);
    }

    public static void replace(Bioseq bioseq, int n, char c, char c2) {
        for (int i = 0; i < n; ++i) {
            if (bioseq.bSeq[i] != (byte)c) continue;
            bioseq.bSeq[i] = (byte)c2;
        }
    }

    public final void replace(int n, String string, String string2) {
        Bioseq.replace(this, n, string, string2);
    }

    public static void replace(Bioseq bioseq, int n, String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            byte by = (byte)string.charAt(i);
            byte by2 = (byte)string2.charAt(i);
            for (int j = 0; j < n; ++j) {
                if (bioseq.bSeq[j] != by) continue;
                bioseq.bSeq[j] = by2;
            }
        }
    }

    public final void expand(int n) {
        byte[] byArray = Bioseq.expand(this.bSeq, n);
        this.setbases(byArray);
    }

    public static byte[] expand(byte[] byArray, int n) {
        int n2 = byArray.length;
        if (n2 > n) {
            n2 = n;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        for (int i = n2; i < n; ++i) {
            byArray2[i] = 63;
        }
        return byArray2;
    }

    public final byte[] dup() {
        return Bioseq.dup(this.bSeq);
    }

    public static byte[] dup(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    public final int cmp(Bioseq bioseq, int n) {
        return Bioseq.cmp(this.bSeq, bioseq.bases(), n);
    }

    public static int cmp(byte[] byArray, byte[] byArray2, int n) {
        for (int i = 0; i < n; ++i) {
            if (byArray[i] < byArray2[i]) {
                return -1;
            }
            if (byArray[i] <= byArray2[i]) continue;
            return 1;
        }
        return 0;
    }

    public final int indexOf(byte by, int n) {
        return Bioseq.indexOf(this.bSeq, by, n);
    }

    public static int indexOf(byte[] byArray, byte by, int n) {
        for (int i = 0; i < n; ++i) {
            if (byArray[i] != by) continue;
            return i;
        }
        return -1;
    }

    public final void copy(byte[] byArray, int n, int n2) {
        Bioseq.copy(this.bSeq, 0, byArray, n, n2);
    }

    public static void copy(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        System.arraycopy(byArray, n, byArray2, n2, n3);
    }
}

