/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.OpenString;
import iubio.readseq.BioseqFormat;
import iubio.readseq.BioseqReaderIface;
import iubio.readseq.BlastOutputReader;

public class BlastOutputFormat
extends BioseqFormat {
    protected boolean hasblast;
    protected boolean hasquery;
    protected boolean hasdb;
    public static String blastKey = "blast";
    public static String queryKey = "query=";
    public static String dbKey = "database:";

    public String formatName() {
        return "BLAST";
    }

    public String formatSuffix() {
        return ".blast";
    }

    public String contentType() {
        return "biosequence/blast";
    }

    public boolean canread() {
        return true;
    }

    public boolean canwrite() {
        return false;
    }

    public boolean interleaved() {
        return true;
    }

    public boolean needsamelength() {
        return true;
    }

    public BioseqReaderIface newReader() {
        return new BlastOutputReader();
    }

    public void formatTestInit() {
        super.formatTestInit();
        this.hasquery = false;
        this.hasdb = false;
        this.hasblast = false;
    }

    public boolean formatTestLine(OpenString openString, int n, int n2) {
        String string = openString.toLowerCase();
        if (string.startsWith(blastKey)) {
            this.hasblast = true;
            this.formatLikelihood = 40;
            this.recordStartline = n;
            return true;
        }
        if (string.startsWith(queryKey)) {
            this.hasquery = true;
            this.formatLikelihood += 35;
            this.recordStartline = n;
            return true;
        }
        if (string.startsWith(dbKey)) {
            this.hasdb = true;
            if (this.hasquery && this.hasblast) {
                this.formatLikelihood = 95;
            } else if (this.hasquery) {
                this.formatLikelihood = 90;
            }
            this.recordStartline = n;
            return true;
        }
        return false;
    }
}

