/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.FastHashtable;
import flybase.OpenString;
import iubio.bioseq.BaseKind;
import iubio.readseq.BioseqReader;
import java.io.IOException;

class BlastOutputReader
extends BioseqReader {
    protected char matchchar = '\u0000';
    protected final int kMinSeqline = 30;
    protected boolean firstSeqline;
    protected boolean atname;
    protected boolean domatch;
    protected boolean done;
    protected OpenString saveseq;
    protected String sid1;
    protected int atbase;
    protected int alignmentLine;
    protected int iline;
    protected int seqindent;
    protected int seqendindent;
    protected FastHashtable idhash = new FastHashtable();
    static final int kEndOfSequence = -1;
    static final int kSkipLine = 0;
    static final int kSequenceLine = 1;

    public BlastOutputReader() {
        this.margin = 0;
        this.addfirst = false;
        this.addend = false;
        this.ungetend = true;
    }

    protected void read() throws IOException {
        if (this.alignmentLine == 0) {
            this.alignmentLine = this.findAlignments();
        }
        if (this.alignmentLine < 0) {
            return;
        }
        this.readAlignments();
    }

    public void skipPastHeader(int n) {
        super.skipPastHeader(n);
        try {
            if (this.alignmentLine > 0) {
                for (int i = this.alignmentLine - 1; i > 0; --i) {
                    this.getline();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected int findAlignments() throws IOException {
        int n = 0;
        while (!this.endOfFile()) {
            char c;
            int n2;
            this.getline();
            ++n;
            int n3 = this.sWaiting.indexOf(32);
            if (n3 <= 0) continue;
            int n4 = this.nWaiting;
            boolean bl = false;
            boolean bl2 = true;
            while (!bl && bl2) {
                if (++n3 >= n4) {
                    bl2 = false;
                    continue;
                }
                n2 = this.sWaiting.charAt(n3);
                if (n2 <= 32) continue;
                if (BaseKind.isAlphaseq(n2)) {
                    bl = true;
                    continue;
                }
                if (BaseKind.isIndel(n2) || n2 >= 48 && n2 <= 57) continue;
                bl2 = false;
            }
            if (!bl) continue;
            for (n2 = n3; n2 < n4 && (c = this.sWaiting.charAt(n2)) > ' '; ++n2) {
                if (BaseKind.isAlphaseq(c) || BaseKind.isIndel(c)) continue;
                bl2 = false;
                break;
            }
            if (!bl2 || n2 <= n3 + 30) continue;
            this.seqindent = n3;
            this.seqendindent = n2;
            return n;
        }
        return -1;
    }

    public boolean endOfSequence() {
        return this.isSequenceLine() == -1;
    }

    protected int isSequenceLine() {
        if (this.nWaiting == 0) {
            return 0;
        }
        char c = this.sWaiting.charAt(0);
        if (Character.isLetterOrDigit(c)) {
            if (this.nWaiting > this.seqindent) {
                return 1;
            }
            return -1;
        }
        if (c == ' ') {
            int n;
            for (n = 0; n < this.nWaiting && this.sWaiting.charAt(n) <= ' '; ++n) {
            }
            if (n == this.nWaiting) {
                return 0;
            }
            if (n < this.seqindent) {
                return -1;
            }
            return 0;
        }
        return 0;
    }

    protected void readAlignments() throws IOException {
        this.atname = true;
        this.firstSeqline = true;
        this.domatch = true;
        boolean bl = this.addit = this.choice > 0;
        if (this.addit) {
            this.seqlen = 0;
        }
        this.iline = 0;
        this.seqlencount = 0;
        this.atbase = 0;
        this.seqoffset = 0;
        this.readIndata();
        do {
            this.getline();
            this.done = this.endOfFile();
            if (this.done && this.nWaiting == 0) break;
            switch (this.isSequenceLine()) {
                case 0: {
                    break;
                }
                case -1: {
                    this.done = true;
                    break;
                }
                case 1: {
                    this.readIndata();
                }
            }
        } while (!this.done);
        this.nseq = this.idhash.size();
        this.setNseq(this.nseq);
        this.allDone = true;
    }

    protected void fixmatchchar(int n) {
        int n2;
        int n3;
        if (this.matchchar == '\u0000') {
            n3 = 0;
            n2 = 0;
            int n4 = this.nWaiting - n;
            for (int i = 0; i < n4; ++i) {
                char c = this.getreadbuf(n + i);
                if (c == '.') {
                    ++n3;
                    continue;
                }
                if (c != '-') continue;
                ++n2;
            }
            this.matchchar = n2 > n3 ? (char)45 : (char)46;
        }
        for (n3 = 0; n3 < this.saveseq.length(); ++n3) {
            n2 = this.getreadbuf(n + n3);
            if (n2 == 32) {
                this.setreadbuf(n + n3, BaseKind.indelEdge);
                continue;
            }
            if (n2 != this.matchchar) continue;
            this.setreadbuf(n + n3, this.saveseq.charAt(n3));
        }
    }

    protected void readIndata() {
        OpenString openString = this.sWaiting;
        if (this.nWaiting > 0) {
            int n;
            int n2 = openString.indexOf(32);
            if (n2 <= 0) {
                return;
            }
            String string = openString.substring(0, n2).trim().toString();
            if (this.idhash.get(string) == null) {
                ++this.nseq;
                this.idhash.put(string, new SeqIndex(this.nseq, this.seqoffset));
                if (this.choice == -1) {
                    this.addinfo(string);
                }
            }
            SeqIndex seqIndex = (SeqIndex)this.idhash.get(string);
            this.atseq = seqIndex.atseq;
            if (this.atseq == this.choice) {
                this.seqid = string;
            }
            if (this.atseq == 1) {
                this.sid1 = string;
            }
            if ((n = this.seqindent) >= this.nWaiting) {
                return;
            }
            int n3 = this.seqendindent;
            if (n3 >= this.nWaiting) {
                n3 = this.nWaiting;
            }
            int n4 = 1;
            while (n4 != 0 && n3 > n) {
                char c = openString.charAt(n3 - 1);
                if (c > ' ' && (BaseKind.isAlphaseq(c) || BaseKind.isIndel(c))) {
                    n4 = 0;
                    continue;
                }
                --n3;
            }
            if (string.equals(this.seqid)) {
                if (this.domatch) {
                    if (string.equals(this.sid1)) {
                        this.saveseq = openString.substring(n, n3);
                    } else {
                        this.fixmatchchar(n);
                    }
                }
                if (this.firstSeqline && this.atseq != 1 && this.seqoffset > 0) {
                    this.setSeqoffset(this.seqoffset);
                }
                this.addseq(this.getreadchars(), this.getreadcharofs() + n, n3 - n);
                if (this.atseq == 1) {
                    this.seqoffset = this.atbase;
                    this.atbase = this.seqlen;
                }
                this.firstSeqline = false;
            } else if (string.equals(this.sid1)) {
                if (this.domatch) {
                    this.saveseq = openString.substring(n, n3);
                }
                this.seqoffset = this.atbase;
                n4 = this.countseqline(this.getreadchars(), this.getreadcharofs() + n, n3 - n);
                this.atbase += n4;
            }
            ++this.iline;
        }
    }

    class SeqIndex {
        int atseq;
        int atbase;

        SeqIndex(int n, int n2) {
            this.atseq = n;
            this.atbase = n2;
        }
    }
}

