/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.Debug;
import flybase.FastVector;
import iubio.bioseq.SeqRange;
import iubio.bioseq.SeqRangeException;
import iubio.readseq.DocItem;
import iubio.readseq.FeatureNote;
import java.util.StringTokenizer;

public class FeatureItem
extends DocItem {
    protected SeqRange location;
    protected FastVector notes;
    protected DocItem curnote;

    public FeatureItem(String string, SeqRange seqRange) {
        super(string, seqRange.toString(), 71, 4);
        this.location = seqRange;
    }

    public FeatureItem(String string, SeqRange seqRange, int n) {
        super(string, seqRange.toString(), 71, n);
        this.location = seqRange;
    }

    public FeatureItem(String string, String string2, int n) {
        super(string, string2, 71, n);
        this.setValue(string2);
    }

    public FeatureItem(String string, String string2, String string3, int n) {
        super(string, string2, string3, 71, n);
        this.setValue(string2);
    }

    public FeatureItem() {
        super("", "", 71, 4);
    }

    public void set(String string, SeqRange seqRange) {
        this.name = string;
        this.setValue(seqRange.toString());
    }

    public Object clone() {
        FeatureItem featureItem = (FeatureItem)super.clone();
        if (this.notes != null) {
            featureItem.notes = (FastVector)this.notes.clone();
        }
        if (this.location != null) {
            featureItem.location = (SeqRange)this.location.clone();
        }
        featureItem.curnote = null;
        return featureItem;
    }

    public boolean equals(Object object) {
        if (object instanceof FeatureItem) {
            FeatureItem featureItem = (FeatureItem)object;
            return this.getName().equals(featureItem.getName()) && this.location.equals(featureItem.getLocation());
        }
        return false;
    }

    public String getValue() {
        return this.getLocationString();
    }

    public void setValue(String string) {
        super.setValue(string);
        try {
            this.location = SeqRange.parse(this.value);
        }
        catch (SeqRangeException seqRangeException) {
            System.err.println(seqRangeException.getMessage());
        }
    }

    public void appendValue(String string) {
        super.appendValue("", string);
    }

    public SeqRange getLocation() {
        return this.location;
    }

    public String getLocationString() {
        return this.location.toString();
    }

    public void updateRange(int n, int n2, int n3, byte[] byArray) {
        this.location.updateRange(n, n2, n3, byArray);
    }

    public FastVector getNotes() {
        return this.notes;
    }

    public String getNotesText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName());
        stringBuffer.append("=");
        stringBuffer.append(this.getLocationString());
        stringBuffer.append('\n');
        if (this.notes != null) {
            for (int i = 0; i < this.notes.size(); ++i) {
                DocItem docItem = (DocItem)this.notes.elementAt(i);
                stringBuffer.append(docItem.getName());
                stringBuffer.append('=');
                stringBuffer.append(docItem.getValue());
                stringBuffer.append('\n');
            }
        }
        return stringBuffer.toString();
    }

    public void setNotesText(String string, boolean bl) {
        if (!bl && this.notes != null) {
            this.notes.removeAllElements();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(61);
            if (n <= 0) continue;
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1).trim();
            if ("name".equals(string3)) {
                this.name = string4;
                continue;
            }
            if ("location".equals(string3)) {
                this.setValue(string4);
                continue;
            }
            if (!string3.startsWith("/")) {
                string3 = "/" + string3;
            }
            this.putNote(new FeatureNote(string3, string4));
        }
    }

    public void putNote(DocItem docItem) {
        if (this.notes == null) {
            this.notes = new FastVector();
        }
        this.notes.addElement(docItem);
        this.curnote = docItem;
    }

    public void appendNote(String string) {
        if (this.curnote != null && string != null) {
            if ("/translation".equals(this.curnote.getName())) {
                this.curnote.appendValue("", string.trim());
            } else {
                this.curnote.appendValue(DocItem.sAppendBreak, string);
            }
        }
    }

    public DocItem getNote(String string) {
        if (this.notes == null) {
            return null;
        }
        String string2 = string.startsWith("/") ? null : "/" + string;
        for (int i = 0; i < this.notes.size(); ++i) {
            DocItem docItem = (DocItem)this.notes.elementAt(i);
            if (docItem.sameName(string)) {
                return docItem;
            }
            if (string2 == null || !docItem.sameName(string2)) continue;
            return docItem;
        }
        return null;
    }

    public String getNoteValue(String string) {
        DocItem docItem = this.getNote(string);
        if (docItem != null) {
            return docItem.getValue();
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (Debug.isOn) {
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append(": ");
        }
        stringBuffer.append(this.name);
        stringBuffer.append("=");
        stringBuffer.append(this.value);
        if (this.notes != null) {
            for (int i = 0; i < this.notes.size(); ++i) {
                stringBuffer.append('\n');
                stringBuffer.append(this.notes.elementAt(i));
            }
        }
        return stringBuffer.toString();
    }
}

