/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.Debug;
import flybase.FastHashtable;
import flybase.FastProperties;
import flybase.FastVector;
import iubio.bioseq.SeqRange;
import iubio.readseq.BioseqDoc;
import iubio.readseq.BioseqDocImpl;
import iubio.readseq.DocItem;
import iubio.readseq.FeatureItem;
import iubio.readseq.FeatureNote;

class FlatFeatDoc
extends BioseqDocImpl {
    public static final String gnomapprop = "FlatFeatDoc";
    public static final String gnomapvers = "gnomap-version ";
    public static final String flatfeatvers = "flatfeat-version ";
    public static final String featurecmt = "Features for ";
    static final String featheadline1 = "# Feature\tgene\tmap\trange\tid\tdb_xref\tnotes";
    static final String featheadline2 = "Key\tLocation\tQualifiers";
    public String species = "";
    public String chromosome = "";
    public String datadate = "";
    public String datasource = "";
    public static String attribOutSeparator = " ; ";
    private static FastHashtable elabel2keys = new FastHashtable();
    private static FastProperties keys2elabel = new FastProperties();
    public static int kWriteVersion = 2;
    public String sversion;
    public int dataversion = 1;
    int dataline;
    int origin = 1;
    int firstSource;
    protected static final int kClassFld = 0;
    protected static final int kNameFld = 1;
    protected static final int kMapFld = 2;
    protected static final int kRangeFld = 3;
    protected static final int kIdFld = 4;
    protected static final int kDbxFld = 5;
    protected static final int kNotesFld = 6;
    protected static final int kNvals = 7;
    protected String[] vals = new String[7];
    protected int[] valcols;
    protected String keyvalsep;
    protected int keyvalat;
    protected DocItem accItem;
    protected DocItem idItem;
    int lastkind;
    int partid;
    boolean didtop;

    public static final String getMagicString() {
        return FlatFeatDoc.getMagicString(kWriteVersion);
    }

    public static String getMagicString(int n) {
        return "# flatfeat-version " + String.valueOf(n);
    }

    public static final String getColumnHeader() {
        return FlatFeatDoc.getColumnHeader(kWriteVersion);
    }

    public static String getColumnHeader(int n) {
        switch (n) {
            default: {
                return featheadline2;
            }
            case 1: 
        }
        return featheadline1;
    }

    public FlatFeatDoc() {
    }

    public FlatFeatDoc(BioseqDoc bioseqDoc) {
        super(bioseqDoc);
        this.fFromForeignFormat = !(bioseqDoc instanceof FlatFeatDoc);
    }

    public FlatFeatDoc(String string) {
        this.addBasicName(string);
    }

    public void setSourceDoc(BioseqDoc bioseqDoc) {
        super.setSourceDoc(bioseqDoc);
        this.fFromForeignFormat = !(bioseqDoc instanceof FlatFeatDoc);
    }

    public void addDocLine(String string) {
        FeatureItem featureItem = this.processLine(string);
        if (featureItem != null) {
            this.inFeatures = 2;
            this.addFeature(featureItem);
            this.lastfld = featureItem.getName();
            this.lastlev = 4;
            if (this.firstSource == 1 && (this.species.length() > 0 || this.chromosome.length() > 0)) {
                String string2 = this.species + "_" + this.chromosome;
                this.replaceDocField(10, string2);
                ++this.firstSource;
            }
        }
    }

    protected void getColumnVals(String string) {
        int n = 0;
        for (int i = 0; i < 7; ++i) {
            if (n < 0) {
                this.vals[i] = null;
                continue;
            }
            int n2 = string.indexOf(9, n);
            if (n2 < 0) {
                this.vals[i] = string.substring(n);
                n = -1;
                continue;
            }
            this.vals[i] = string.substring(n, n2);
            n = n2 + 1;
        }
    }

    protected int getFieldColumn2(String string) {
        if (string == null) {
            return -1;
        }
        if ("feature".equals(string = string.toLowerCase())) {
            return 0;
        }
        if ("key".equals(string)) {
            return 0;
        }
        if ("location".equals(string)) {
            return 3;
        }
        if ("range".equals(string)) {
            return 3;
        }
        if ("qualifiers".equals(string)) {
            return 6;
        }
        if ("notes".equals(string)) {
            return 6;
        }
        if ("attributes".equals(string)) {
            return 6;
        }
        if ("gene".equals(string)) {
            return 1;
        }
        if ("symbol".equals(string)) {
            return 1;
        }
        if ("name".equals(string)) {
            return 1;
        }
        if ("map".equals(string)) {
            return 2;
        }
        if ("id".equals(string)) {
            return 4;
        }
        if ("db_xref".equals(string)) {
            return 5;
        }
        return -1;
    }

    protected void getColumnKeys2(String string) {
        FastVector fastVector = new FastVector();
        int n = 0;
        int n2 = 0;
        while (n >= 0) {
            String string2;
            int n3 = string.indexOf(9, n);
            if (n3 < 0) {
                string2 = string.substring(n);
                n = -1;
            } else {
                string2 = string.substring(n, n3);
                n = n3 + 1;
            }
            int n4 = this.getFieldColumn2(string2);
            fastVector.addElement(new Integer(n4));
            ++n2;
        }
        this.valcols = new int[fastVector.size()];
        for (n = 0; n < fastVector.size(); ++n) {
            this.valcols[n] = (Integer)fastVector.elementAt(n);
        }
    }

    protected void getColumnVals2(String string) {
        int n;
        for (n = 0; n < 7; ++n) {
            this.vals[n] = null;
        }
        n = 0;
        for (int i = 0; n >= 0 && i < this.valcols.length; ++i) {
            String string2;
            int n2 = string.indexOf(9, n);
            if (n2 < 0) {
                string2 = string.substring(n);
                n = -1;
            } else {
                string2 = string.substring(n, n2);
                n = n2 + 1;
            }
            int n3 = this.valcols[i];
            if (n3 < 0) continue;
            this.vals[n3] = string2;
        }
    }

    protected void processComment(String string) {
        String string2 = flatfeatvers;
        int n = string.indexOf(string2);
        if (n < 0) {
            string2 = gnomapvers;
            n = string.indexOf(string2);
        }
        if (n >= 0) {
            try {
                this.sversion = string.substring(n + string2.length()).trim();
                Debug.println("flatfeat vers=" + this.sversion);
                int n2 = Integer.parseInt(this.sversion);
                if (n2 > 0) {
                    this.dataversion = n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        if (string.indexOf(featurecmt) >= 0) {
            String string3 = "";
            String string4 = "";
            n = string.indexOf(featurecmt);
            int n3 = (string = string.substring(n + featurecmt.length())).indexOf(" from");
            if (n3 > 0) {
                this.species = string.substring(0, n3).trim();
                if ((n3 = (string = string.substring(n3 + " from".length())).indexOf("[")) > 0) {
                    string3 = string.substring(0, n3).trim();
                    n = (string = string.substring(n3)).indexOf(",");
                    if (n >= 0) {
                        n3 = string.indexOf("]", n);
                    }
                    if (n >= 0 && n3 > n) {
                        string4 = string.substring(n + 1, n3).trim();
                    }
                }
            }
            if (string3.length() > 0 || string4.length() > 0) {
                if (string3.length() > 0) {
                    this.datasource = string3;
                }
                if (string4.length() > 0) {
                    this.datadate = string4;
                }
                String string5 = "Data source: " + this.datasource;
                if (this.datadate.length() > 0) {
                    string5 = string5 + ", " + this.datadate;
                }
            }
        }
    }

    protected boolean processNondataLine(String string) {
        if (string.length() == 0) {
            return true;
        }
        if (string.startsWith("#")) {
            this.processComment(string);
            return true;
        }
        if (this.dataversion >= 2 && this.dataline == 0) {
            this.getColumnKeys2(string);
            ++this.dataline;
            return true;
        }
        return false;
    }

    protected FeatureItem processLine(String string) {
        if (this.processNondataLine(string = string.trim())) {
            return null;
        }
        String string2 = null;
        FeatureItem featureItem = new FeatureItem();
        SeqRange seqRange = new SeqRange();
        String string3 = null;
        boolean bl = false;
        if (this.dataversion >= 2) {
            if (this.dataline == 0) {
                this.getColumnKeys2(string);
            } else {
                this.getColumnVals2(string);
            }
            ++this.dataline;
        } else {
            this.getColumnVals(string);
        }
        block11: for (int i = 0; i < 7; ++i) {
            String string4 = this.vals[i];
            if (i > 0 && (string4 == null || "-".equals(string4) || string4.length() == 0)) continue;
            switch (i) {
                case 0: {
                    if (string4 == null || "-".equals(string4) || string4.length() == 0) {
                        return null;
                    }
                    string3 = string4;
                    if (!"source".equals(string3)) continue block11;
                    ++this.firstSource;
                    continue block11;
                }
                case 1: {
                    featureItem.putNote(new FeatureNote("name", string4));
                    if (!"source".equals(string3)) continue block11;
                    this.species = string4;
                    continue block11;
                }
                case 2: {
                    featureItem.putNote(new FeatureNote("map", string4));
                    if (!"source".equals(string3)) continue block11;
                    int n = string4.indexOf("Chr ");
                    if (n >= 0) {
                        string4 = string4.substring(n + 4);
                    }
                    this.chromosome = string4;
                    bl = true;
                    continue block11;
                }
                case 3: {
                    try {
                        int n = 1;
                        if (!bl) {
                            n = seqRange.setDisplayOrigin(this.origin);
                        }
                        seqRange.parse1(string4);
                        if (bl) continue block11;
                        seqRange.setDisplayOrigin(n);
                    }
                    catch (Exception exception) {}
                    continue block11;
                }
                case 4: {
                    featureItem.putNote(new FeatureNote("ID", string4));
                    string2 = string4;
                    continue block11;
                }
                case 5: {
                    this.getDbxRefs(featureItem, string4, string3);
                    continue block11;
                }
                case 6: {
                    this.getQualifiers(featureItem, string4, string3);
                }
            }
        }
        if (string3 == null) {
            return null;
        }
        featureItem.set(string3, seqRange);
        return featureItem;
    }

    protected void getQualifiers(FeatureItem featureItem, String string, String string2) {
        int n = 0;
        while (n >= 0) {
            String string3;
            String string4 = "";
            int n2 = string.length();
            int n3 = string.indexOf(61, n);
            if (n3 < 0) {
                n3 = string.indexOf(32, n);
            }
            if (n3 < 0) {
                string3 = string.substring(n);
                n = -1;
            } else {
                string3 = string.substring(n, n3);
                n = n3 + 1;
            }
            string3 = string3.trim();
            if (n > 0) {
                int n4 = -1;
                n3 = -1;
                for (int i = n; i > 0 && i < n2 && n3 < 0; ++i) {
                    char c = string.charAt(i);
                    if (c == '\"') {
                        i = string.indexOf(c, i + 1);
                        continue;
                    }
                    if (c == '\'') {
                        i = string.indexOf(c, i + 1);
                        continue;
                    }
                    if (c != ';' && c != ',' && c != ' ') continue;
                    n3 = i;
                    while (i < n2 && n4 < 0) {
                        c = string.charAt(i);
                        if (c == '/' || Character.isLetterOrDigit(c)) {
                            n4 = i;
                        }
                        ++i;
                    }
                    if (n4 >= 0) continue;
                    n4 = n2;
                }
                if (n3 > 0) {
                    string4 = string.substring(n, n3);
                    n = n4;
                } else {
                    string4 = string.substring(n);
                    n = -1;
                }
                string4 = string4.trim();
            }
            if (string3.length() <= 0) continue;
            String string5 = string3;
            if (!string3.startsWith("/")) {
                string3 = "/" + string3;
            }
            FeatureNote featureNote = new FeatureNote(string3, string4);
            featureItem.putNote(featureNote);
        }
    }

    protected void getDbxRefs(FeatureItem featureItem, String string, String string2) {
        int n = 0;
        while (n >= 0) {
            String string3;
            int n2 = string.indexOf(44, n);
            if (n2 < 0) {
                string3 = string.substring(n);
                n = -1;
            } else {
                string3 = string.substring(n, n2);
                n = n2 + 1;
            }
            if ((string3 = string3.trim()).length() <= 0) continue;
            featureItem.putNote(new FeatureNote("db_xref", string3));
        }
    }

    public void addDocField(String string, String string2, int n, boolean bl) {
        int n2 = 0;
        if (n == 1 || n == 2 || n == 3) {
            n2 = this.getBiodocKind(string);
            switch (n2) {
                case 80: 
                case 90: {
                    n = 1;
                    bl = false;
                    break;
                }
            }
        }
        super.addDocField(string, string2, n2, n, bl);
    }

    protected boolean writeKeyValue(DocItem docItem) {
        if (this.lastkind == 70) {
            return true;
        }
        String string = this.getFieldLabel(docItem);
        String string2 = this.getFieldValue(docItem);
        if (string != null) {
            if (this.keyvalat > 0 && this.keyvalsep != null) {
                this.pr.print(this.keyvalsep);
            }
            ++this.keyvalat;
            this.pr.print(string);
            string2 = string2.replace('\n', ' ');
            this.pr.print(string2);
            return true;
        }
        return false;
    }

    protected void writeFeatureVers1(FeatureItem featureItem) {
        Object object;
        int n;
        String string = featureItem.getName();
        String string2 = "-";
        String string3 = "-";
        String string4 = "-";
        FastVector fastVector = featureItem.notes;
        if (fastVector != null) {
            fastVector = (FastVector)fastVector.clone();
            for (n = 0; n < fastVector.size(); ++n) {
                DocItem docItem = (DocItem)fastVector.elementAt(n);
                object = docItem.getName();
                boolean bl = false;
                if ("ID".equals(object)) {
                    string2 = docItem.getValue();
                    bl = true;
                } else if ("name".equals(object)) {
                    string3 = docItem.getValue();
                    bl = true;
                } else if ("map".equals(object)) {
                    string4 = docItem.getValue();
                    bl = true;
                }
                if (!bl) continue;
                fastVector.removeElementAt(n);
            }
        }
        this.pr.print(string);
        this.pr.print("\t");
        this.pr.print(string3);
        this.pr.print("\t");
        this.pr.print(string4);
        this.pr.print("\t");
        this.pr.print(featureItem.getLocation());
        this.pr.print("\t");
        this.pr.print(string2);
        this.pr.print("\t");
        if (fastVector != null) {
            int n2 = 0;
            for (n = 0; n < fastVector.size(); ++n) {
                object = (DocItem)fastVector.elementAt(n);
                String string5 = ((DocItem)object).getName();
                if (!"db_xref".equals(string5)) continue;
                if (n2 > 0) {
                    this.pr.print(",");
                }
                this.pr.print(((DocItem)object).getValue());
                ++n2;
                fastVector.removeElementAt(n);
            }
        }
        this.pr.print("\t");
        if (fastVector != null) {
            this.keyvalat = 0;
            this.keyvalsep = attribOutSeparator;
            this.writeDocVector(fastVector, false);
            this.keyvalsep = null;
        }
        this.pr.println();
        ++this.linesout;
    }

    protected void writeFeatureVers2(FeatureItem featureItem) {
        String string = featureItem.getName();
        FastVector fastVector = featureItem.notes;
        this.pr.print(string);
        this.pr.print("\t");
        this.pr.print(featureItem.getLocation());
        this.pr.print("\t");
        if (fastVector != null) {
            this.keyvalat = 0;
            this.keyvalsep = attribOutSeparator;
            this.writeDocVector(fastVector, false);
            this.keyvalsep = null;
        }
        this.pr.println();
        ++this.linesout;
    }

    protected void writeDocItem(DocItem docItem, boolean bl) {
        int n;
        this.lastkind = n = docItem.getKind();
        switch (n) {
            case 30: {
                this.accItem = docItem;
                break;
            }
            case 10: {
                this.idItem = docItem;
                break;
            }
            case 70: {
                super.writeDocItem(docItem, bl);
                break;
            }
            case 72: {
                super.writeDocItem(docItem, bl);
                break;
            }
            case 71: {
                if (!(docItem instanceof FeatureItem) || !this.wantFeature(docItem)) break;
                FeatureItem featureItem = (FeatureItem)docItem;
                if ("source".equals(featureItem.getName())) {
                    if (featureItem.getNote("/AC") != null) {
                        this.accItem = null;
                    }
                    if (this.accItem != null) {
                        featureItem.putNote(new FeatureNote(this.accItem));
                    }
                    this.accItem = null;
                    if (featureItem.getNote("/ID") != null) {
                        this.idItem = null;
                    }
                    if (this.idItem != null) {
                        featureItem.putNote(new FeatureNote(this.idItem));
                    }
                    this.idItem = null;
                }
                if (kWriteVersion == 1) {
                    this.writeFeatureVers1(featureItem);
                    break;
                }
                this.writeFeatureVers2(featureItem);
                break;
            }
        }
    }

    protected String getFieldValue(DocItem docItem) {
        switch (docItem.getKind()) {
            case 70: {
                return "";
            }
            case 10: {
                String string = docItem.getValue();
                return string;
            }
            case 30: {
                String string = docItem.getValue();
                return string;
            }
            case 62: {
                String string = docItem.getValue();
                return string;
            }
        }
        return super.getFieldValue(docItem);
    }

    protected String getFieldLabel(int n, DocItem docItem) {
        String string = null;
        this.indent = 0;
        this.subindent = 0;
        switch (n) {
            default: {
                string = this.fFromForeignFormat ? this.getFieldName(docItem.getKind()) : docItem.getName();
                if (string == null || string.length() == 0) {
                    return null;
                }
                return "#" + string + " ";
            }
            case 4: {
                return docItem.getName() + " ";
            }
            case 5: {
                string = docItem.getName();
                if (docItem.hasValue()) {
                    string = string + "=";
                }
                if (!string.startsWith("/")) {
                    string = "/" + string;
                }
                return string;
            }
            case 6: 
        }
        return "";
    }

    public String getBiodockey(String string) {
        return (String)elabel2keys.get(string);
    }

    public String getFieldName(int n) {
        String string = null;
        String string2 = FlatFeatDoc.getBiodockey(n);
        if (string2 != null) {
            string = (String)keys2elabel.get(string2);
        }
        return string;
    }

    static {
        String string = System.getProperty(gnomapprop, gnomapprop);
        FlatFeatDoc.getDocProperties(string, keys2elabel, elabel2keys);
    }
}

