/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.Debug;
import flybase.FastHashtable;
import flybase.FastProperties;
import flybase.FastVector;
import flybase.Utils;
import iubio.bioseq.SeqRange;
import iubio.readseq.BioseqDoc;
import iubio.readseq.BioseqDocImpl;
import iubio.readseq.DocItem;
import iubio.readseq.FeatureItem;

class GFFDoc
extends BioseqDocImpl {
    public static String gffprop = "GFFDoc";
    public static String attribInSeparator = "; ";
    public static String attribOutSeparator = " ; ";
    private static FastHashtable elabel2keys = new FastHashtable();
    private static FastProperties keys2elabel = new FastProperties();
    String sversion;
    float version;
    String lastgroup;
    FastVector vattr = new FastVector();
    protected String keyvalsep;
    protected int keyvalat;
    protected DocItem accItem;
    protected DocItem idItem;
    int lastkind;
    int partid;
    boolean didtop;
    String lastId;

    public GFFDoc() {
    }

    public GFFDoc(BioseqDoc bioseqDoc) {
        super(bioseqDoc);
        this.fFromForeignFormat = !(bioseqDoc instanceof GFFDoc);
    }

    public GFFDoc(String string) {
        this.addBasicName(string);
    }

    public void setSourceDoc(BioseqDoc bioseqDoc) {
        super.setSourceDoc(bioseqDoc);
        this.fFromForeignFormat = !(bioseqDoc instanceof GFFDoc);
    }

    boolean goodval(String string) {
        return string != null && (string.length() > 1 || string.length() == 1 && !"-".equals(string) && !".".equals(string) && !" ".equals(string));
    }

    public void addDocLine(String string) {
        if ((string = string.trim()).length() >= 1) {
            if (string.startsWith("#")) {
                if (string.startsWith("#gff-version")) {
                    this.sversion = string = string.substring("#gff-version".length()).trim();
                    try {
                        this.version = new Float(this.sversion).floatValue();
                    }
                    catch (Exception exception) {
                        this.version = 0.0f;
                    }
                }
            } else {
                int n;
                Object object;
                Object object2;
                boolean bl = false;
                int n2 = 4;
                this.inFeatures = 2;
                String[] stringArray = Utils.splitString(string, "\t");
                if (stringArray.length < 7) {
                    Debug.println("GFFDoc: read malformed line:" + string);
                    return;
                }
                String string2 = stringArray[2];
                String string3 = stringArray[3] + ".." + stringArray[4];
                if ("-".equals(stringArray[6])) {
                    string3 = "complement(" + string3 + ")";
                }
                Object object3 = "";
                this.vattr.removeAllElements();
                if (stringArray.length > 8) {
                    object2 = null;
                    object = stringArray[8];
                    n = 0;
                    while (n >= 0) {
                        String string4;
                        int n3 = ((String)object).indexOf(attribInSeparator, n);
                        if (n3 >= n) {
                            string4 = ((String)object).substring(n, n3);
                            n = n3 + attribInSeparator.length();
                        } else {
                            string4 = ((String)object).substring(n);
                            n = -1;
                            if (string4.endsWith(";")) {
                                string4 = string4.substring(0, string4.length() - 1);
                            }
                        }
                        if ((string4 = string4.trim()).length() == 0) continue;
                        if (string4.startsWith("group")) {
                            object2 = string4;
                            continue;
                        }
                        this.vattr.addElement(string4);
                        if (object2 != null || string4.indexOf("group") <= 0) continue;
                        object2 = string4;
                    }
                    if (object2 != null) {
                        object3 = object2;
                    }
                }
                if (((String)object3).length() > 0 && ((String)object3).equals(this.lastgroup)) {
                    try {
                        object2 = SeqRange.parse(string3);
                        object = this.curFieldItem.getLocation();
                        ((SeqRange)object).add((SeqRange)object2);
                    }
                    catch (Exception exception) {
                        if (Debug.isOn) {
                            exception.printStackTrace();
                        }
                    }
                } else {
                    this.addFeature(string2, string3, 4, false);
                    object2 = this.vattr.elements();
                    while (object2.hasMoreElements()) {
                        object = (String)object2.nextElement();
                        if (!this.goodval((String)object)) continue;
                        n = ((String)object).indexOf(32);
                        if (n > 0) {
                            object = ((String)object).substring(0, n) + "=" + ((String)object).substring(n + 1);
                        }
                        if (!((String)object).startsWith("/")) {
                            object = "/" + (String)object;
                        }
                        this.addFeature(string2, (String)object, 5, true);
                    }
                    if ("source".equals(string2) && this.goodval(stringArray[0]) && ((object = this.curFieldItem.getNoteValue("/ID")) == null || !((String)object).equals(stringArray[0]))) {
                        this.addFeature(string2, "/ID=" + stringArray[0], 5, true);
                    }
                    if (this.goodval(stringArray[1])) {
                        this.addFeature(string2, "/source=" + stringArray[1], 5, true);
                    }
                    if (this.goodval(stringArray[5])) {
                        this.addFeature(string2, "/score=" + stringArray[5], 5, true);
                    }
                }
                this.lastgroup = object3;
                this.lastfld = string2;
                this.lastlev = 4;
            }
        }
    }

    public void addDocField(String string, String string2, int n, boolean bl) {
        int n2 = 0;
        if (n == 1 || n == 2 || n == 3) {
            n2 = this.getBiodocKind(string);
            switch (n2) {
                case 110: {
                    return;
                }
                case 80: 
                case 90: {
                    n = 1;
                    bl = false;
                    break;
                }
            }
        }
        super.addDocField(string, string2, n2, n, bl);
    }

    protected boolean writeKeyValue(DocItem docItem) {
        if (this.lastkind == 70) {
            return true;
        }
        String string = this.getFieldLabel(docItem);
        String string2 = this.getFieldValue(docItem);
        if (string != null) {
            if (this.keyvalat > 0 && this.keyvalsep != null) {
                this.pr.print(this.keyvalsep);
            }
            ++this.keyvalat;
            this.pr.print(string);
            string2 = string2.replace('\n', ' ');
            this.pr.print(string2);
            return true;
        }
        return false;
    }

    protected void writeDocItem(DocItem docItem, boolean bl) {
        int n;
        if (this.linesout == 0) {
            this.partid = 0;
        }
        this.lastkind = n = docItem.getKind();
        switch (n) {
            case 30: {
                this.accItem = docItem;
                break;
            }
            case 10: {
                this.idItem = docItem;
                break;
            }
            case 70: {
                super.writeDocItem(docItem, bl);
                break;
            }
            case 72: {
                super.writeDocItem(docItem, bl);
                break;
            }
            case 71: {
                DocItem docItem2;
                if (!(docItem instanceof FeatureItem) || !this.wantFeature(docItem)) break;
                FeatureItem featureItem = (FeatureItem)docItem;
                SeqRange seqRange = featureItem.getLocation();
                String string = ".";
                String string2 = featureItem.getName();
                String string3 = null;
                if ("source".equals(string2) && (docItem2 = this.findDocItem(featureItem.notes, "ID", 0)) != null) {
                    string3 = this.getTrimFieldValue(docItem2);
                }
                if (string3 == null) {
                    string3 = this.lastId != null ? this.lastId : (this.idItem != null ? this.getTrimFieldValue(this.idItem) : this.getID());
                }
                this.lastId = string3;
                int n2 = seqRange.origin();
                boolean bl2 = seqRange.next() != null;
                int n3 = 1;
                while (seqRange != null) {
                    boolean bl3;
                    string = seqRange.isComplement() ? "-" : "+";
                    this.pr.print(string3);
                    this.pr.print("\t-\t");
                    this.pr.print(string2);
                    this.pr.print("\t");
                    this.pr.print(seqRange.start() + n2);
                    this.pr.print("\t");
                    this.pr.print(seqRange.stop() + n2);
                    this.pr.print("\t.\t");
                    this.pr.print(string);
                    this.pr.print("\t.");
                    this.keyvalat = 0;
                    boolean bl4 = bl3 = n3 == 1 && featureItem.notes != null;
                    if (bl2 || bl3) {
                        this.pr.print("\t");
                    }
                    if (bl2) {
                        if (n3 == 1) {
                            ++this.partid;
                        }
                        this.pr.print("group " + string2 + "_" + this.partid);
                        ++this.keyvalat;
                    }
                    if (bl3) {
                        this.keyvalsep = attribOutSeparator;
                        this.writeDocVector(featureItem.notes, false);
                        this.keyvalsep = null;
                    }
                    this.pr.println();
                    ++this.linesout;
                    ++n3;
                    seqRange = seqRange.next();
                }
                break;
            }
        }
    }

    protected String getFieldValue(DocItem docItem) {
        switch (docItem.getKind()) {
            case 70: {
                return "";
            }
            case 10: {
                String string = docItem.getValue();
                return string;
            }
            case 30: {
                String string = docItem.getValue();
                return string;
            }
            case 62: {
                String string = docItem.getValue();
                return string;
            }
        }
        return super.getFieldValue(docItem);
    }

    protected String getFieldLabel(int n, DocItem docItem) {
        String string = null;
        this.indent = 0;
        this.subindent = 0;
        switch (n) {
            default: {
                string = this.fFromForeignFormat ? this.getFieldName(docItem.getKind()) : docItem.getName();
                if (string == null || string.length() == 0) {
                    return null;
                }
                return "#" + string + " ";
            }
            case 4: {
                return docItem.getName() + " ";
            }
            case 5: {
                string = docItem.getName();
                if (docItem.hasValue()) {
                    string = string + " ";
                }
                if (string.startsWith("/")) {
                    string = string.substring(1);
                }
                return string;
            }
            case 6: 
        }
        return "";
    }

    public String getBiodockey(String string) {
        return (String)elabel2keys.get(string);
    }

    public String getFieldName(int n) {
        String string = null;
        String string2 = GFFDoc.getBiodockey(n);
        if (string2 != null) {
            string = (String)keys2elabel.get(string2);
        }
        return string;
    }

    static {
        String string = System.getProperty(gffprop, gffprop);
        GFFDoc.getDocProperties(string, keys2elabel, elabel2keys);
    }
}

