/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import iubio.readseq.BioseqWriter;
import iubio.readseq.FileIndex;
import iubio.readseq.Readseq;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;

public abstract class InterleavedSeqWriter
extends BioseqWriter {
    protected File tempFile;
    protected FileIndex fileIndex;
    protected String saveLineEnd;
    protected boolean interleaved = true;

    public void finalize() throws Throwable {
        if (this.tempFile != null) {
            this.tempFile.delete();
            this.tempFile = null;
        }
        super.finalize();
    }

    public boolean interleaved() {
        return this.interleaved;
    }

    public void setinterleaved(boolean bl) {
        this.interleaved = bl;
    }

    public void writeRecordStart() {
        if (this.interleaved()) {
            this.fileIndex.indexit();
        }
        super.writeRecordStart();
    }

    public void writeHeader() throws IOException {
        super.writeHeader();
        if (this.interleaved()) {
            try {
                this.tempFile = Readseq.tempFile();
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.tempFile));
                this.fileIndex = new FileIndex(bufferedWriter);
                this.douts = this.fileIndex;
                this.saveLineEnd = this.lineSeparator;
                this.lineSeparator = "\n";
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void writeTrailer() {
        if (this.interleaved()) {
            this.lineSeparator = this.saveLineEnd;
            this.fileIndex.indexEOF();
            try {
                this.douts.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.setOutput(this.outs);
            this.interleaveHeader();
            this.interleaveOutput();
        }
        super.writeTrailer();
    }

    protected void interleaveHeader() {
    }

    protected void interleaf(int n) {
    }

    protected void interleaveOutput() {
        int n = this.fileIndex.indexCount();
        long[] lArray = this.fileIndex.indices();
        int n2 = this.linesout;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.tempFile, "r");
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    String string = "";
                    randomAccessFile.seek(lArray[j]);
                    for (int k = 0; k <= i; ++k) {
                        string = randomAccessFile.readLine();
                        if (string != null) continue;
                        string = "";
                    }
                    if (randomAccessFile.getFilePointer() > lArray[j + 1]) continue;
                    this.writeString(string);
                    this.writeln();
                }
                this.interleaf(i);
            }
            randomAccessFile.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.tempFile.delete();
        this.tempFile = null;
    }
}

