/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.OpenString;
import iubio.readseq.BioseqFormat;
import iubio.readseq.BioseqReaderIface;
import iubio.readseq.BioseqWriterIface;
import iubio.readseq.MsfSeqReader;
import iubio.readseq.MsfSeqWriter;

public class MsfSeqFormat
extends BioseqFormat {
    public String formatName() {
        return "MSF";
    }

    public String formatSuffix() {
        return ".msf";
    }

    public String contentType() {
        return "biosequence/msf";
    }

    public boolean canread() {
        return true;
    }

    public boolean canwrite() {
        return true;
    }

    public boolean interleaved() {
        return true;
    }

    public BioseqWriterIface newWriter() {
        return new MsfSeqWriter();
    }

    public BioseqReaderIface newReader() {
        return new MsfSeqReader();
    }

    public boolean formatTestLine(OpenString openString, int n, int n2) {
        int n3;
        if (openString.startsWith("!!")) {
            if ((openString.startsWith("!!NA") || openString.startsWith("!!AA")) && openString.indexOf("MULTIPLE_ALIGNMENT") >= 0) {
                this.formatLikelihood += 92;
                return true;
            }
            return false;
        }
        int n4 = openString.indexOf("MSF:");
        if (n4 >= 0 && (n3 = openString.indexOf("Type:", n4)) > n4 && openString.indexOf("Check:", n3) > n3) {
            this.formatLikelihood += 95;
            if (this.recordStartline == 0) {
                this.recordStartline = n;
            }
            return true;
        }
        return false;
    }
}

