/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.Debug;
import flybase.OpenString;
import iubio.bioseq.SeqInfo;
import iubio.readseq.BioseqFormat;
import iubio.readseq.BioseqReaderIface;
import iubio.readseq.BioseqWriterIface;
import iubio.readseq.NumSppBases;
import iubio.readseq.Phylip2SeqReader;
import iubio.readseq.PhylipSeqReader;
import iubio.readseq.PhylipSeqWriter;

public class PhylipSeqFormat
extends BioseqFormat {
    protected SeqInfo seqkind = SeqInfo.getSeqInfo(99999, false, false);
    protected boolean formatDetermined;
    protected boolean interleaved = true;
    protected int isleaf;
    protected int isseq;
    protected NumSppBases nsppb = new NumSppBases();

    public String formatName() {
        this.getsubformat();
        if (this.interleaved) {
            return "Phylip|Phylip4";
        }
        return "Phylip3.2|Phylip2";
    }

    public String formatSuffix() {
        return ".phylip";
    }

    public String contentType() {
        return "biosequence/phylip";
    }

    public boolean canread() {
        return true;
    }

    public boolean canwrite() {
        return true;
    }

    public boolean interleaved() {
        this.getsubformat();
        return this.interleaved;
    }

    public boolean needsamelength() {
        return true;
    }

    public BioseqWriterIface newWriter() {
        this.getsubformat();
        PhylipSeqWriter phylipSeqWriter = new PhylipSeqWriter();
        phylipSeqWriter.setinterleaved(this.interleaved);
        return phylipSeqWriter;
    }

    public BioseqReaderIface newReader() {
        this.getsubformat();
        PhylipSeqReader phylipSeqReader = this.interleaved ? new PhylipSeqReader() : new Phylip2SeqReader();
        return phylipSeqReader;
    }

    protected void getsubformat() {
        if (!this.formatDetermined) {
            this.interleaved = this.isleaf > this.isseq ? true : this.isleaf >= this.isseq;
            this.formatDetermined = true;
        }
    }

    public void formatTestInit() {
        super.formatTestInit();
        this.isseq = 0;
        this.isleaf = 0;
        this.interleaved = true;
        this.formatDetermined = false;
        this.nsppb.init();
    }

    public boolean formatTestLine(OpenString openString, int n, int n2) {
        if ((n -= n2) == 1) {
            this.nsppb = PhylipSeqFormat.readSpeciesLength(openString);
        } else if (n == 2 && this.nsppb.good && openString.length() > 10) {
            this.seqkind.add(openString.getValue(), openString.getOffset() + 10, openString.length() - 10);
            int n3 = this.seqkind.getKind();
            if (Character.isLetter(openString.charAt(0)) && n3 != 0) {
                this.formatLikelihood = 85;
                this.formatDetermined = false;
            }
        } else if (n > 2 && this.nsppb.good) {
            int n4;
            for (n4 = 0; Character.isWhitespace(openString.charAt(n4)) && n4 < 10; ++n4) {
            }
            if (n - 1 <= this.speciesCount()) {
                if (n4 < 9) {
                    ++this.isleaf;
                } else {
                    ++this.isseq;
                }
            } else if (n4 >= 9) {
                ++this.isleaf;
            } else {
                ++this.isseq;
            }
        }
        return false;
    }

    public final int speciesCount() {
        return this.nsppb.nospp;
    }

    public final int sequenceLength() {
        return this.nsppb.baselen;
    }

    public static NumSppBases readSpeciesLength(OpenString openString) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = openString.length();
        for (n2 = 0; n2 < n5 && Character.isWhitespace(openString.charAt(n2)); ++n2) {
        }
        for (n = n2; n < n5 && Character.isDigit(openString.charAt(n)); ++n) {
        }
        try {
            if (n2 < n5) {
                n3 = Integer.parseInt(openString.substring(n2, n).toString());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n3 > 0) {
            for (n2 = n + 1; n2 < n5 && Character.isWhitespace(openString.charAt(n2)); ++n2) {
            }
            for (n = n2; n < n5 && Character.isDigit(openString.charAt(n)); ++n) {
            }
            try {
                if (n2 < n5) {
                    n4 = Integer.parseInt(openString.substring(n2, n).toString());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (n3 > 0 && n4 > 0) {
            Debug.println("phylip nspp=" + n3 + ", nbase=" + n4);
        }
        return new NumSppBases(n3, n4);
    }
}

