/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import Acme.Fmt;
import iubio.readseq.BioseqReader;
import iubio.readseq.InterleavedSeqWriter;
import iubio.readseq.Readseq;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

class PhylipSeqWriter
extends InterleavedSeqWriter {
    BufferedWriter tempOs;
    int lastlen;
    String lenerr;

    PhylipSeqWriter() {
    }

    public void writeHeader() throws IOException {
        super.writeHeader();
        if (!this.interleaved()) {
            this.tempFile = Readseq.tempFile();
            this.tempOs = new BufferedWriter(new FileWriter(this.tempFile));
            this.douts = this.tempOs;
        }
    }

    public void writeRecordStart() {
        super.writeRecordStart();
        this.opts.spacer = 10;
        this.opts.tab = 12;
        this.l1 = -1;
    }

    public void writeDoc() {
        super.writeDoc();
        this.writeString(Fmt.fmt(this.idword, 10, 34) + "  ");
    }

    protected void interleaf(int n) {
        this.writeln();
    }

    protected void interleaveHeader() {
        this.writeString(" " + this.nseq);
        this.writeString(" " + this.seqlen);
        if (this.interleaved()) {
            this.writeln();
        } else {
            this.writeln(" I ");
        }
    }

    public boolean setSeq(Object object, int n, int n2, String string, Object object2, int n3, int n4) {
        if (this.lastlen > 0 && n2 != this.lastlen) {
            if (this.lenerr == null) {
                this.lenerr = String.valueOf(this.lastlen) + " != ";
            }
            this.lenerr = this.lenerr + String.valueOf(n2) + ", ";
            n2 = this.lastlen;
        } else {
            this.lastlen = n2;
        }
        return super.setSeq(object, n, n2, string, object2, n3, n4);
    }

    public void writeTrailer() {
        if (this.lenerr != null) {
            BioseqReader.message("Warning: this format requires equal sequence lengths.");
            BioseqReader.message("       : lengths are padded/truncated to " + this.lastlen);
            BioseqReader.message("       : " + this.lenerr);
        }
        if (!this.interleaved()) {
            try {
                this.douts.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.setOutput(this.outs);
            this.interleaveHeader();
            this.sequentialOutput();
        }
        super.writeTrailer();
    }

    protected void sequentialOutput() {
        try {
            int n;
            FileReader fileReader = new FileReader(this.tempFile);
            char[] cArray = new char[2048];
            while ((n = fileReader.read(cArray)) >= 0) {
                this.douts.write(cArray, 0, n);
            }
            ((Reader)fileReader).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.tempFile.delete();
        this.tempFile = null;
    }
}

