/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.Debug;
import iubio.bioseq.Bioseq;
import iubio.readseq.BioseqReaderIface;
import iubio.readseq.BioseqWriterIface;
import iubio.readseq.GenbankDoc;
import iubio.readseq.MessageApp;
import iubio.readseq.NotScfException;
import iubio.readseq.RsInput;
import iubio.readseq.SeqFileInfo;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Hashtable;

class ScfTraceReader
implements BioseqReaderIface {
    public static boolean verbose;
    static final boolean useBioseqBytes = true;
    protected int formatId;
    protected int seqlen;
    protected int seqoffset;
    protected int nseq;
    protected int err;
    protected int choice;
    protected int atseq;
    protected String idword = SeqFileInfo.gBlankSeqid;
    protected String seqid = SeqFileInfo.gBlankSeqid;
    private byte[] bases;
    protected Object seqdoc;
    private boolean fEof = false;
    private Reader fIns;
    private InputStream fByteIns;
    private int oslinei;
    private int oslen;
    private final int kMaxbuf = 8192;
    public static MessageApp messageapp;
    private static final long SCF_MAGIC = 779314022L;
    public static final int NONE = 0;
    public static final int BASES = 1;
    public static final int LEFTVEC = 2;
    public static final int LEFTQUAL = 3;
    public static final int RIGHTQUAL = 4;
    public static final int RIGHTVEC = 5;
    public short[][] data;
    public byte[][] data1;
    public int magic_number;
    public int samples;
    public int samples_offset;
    public int numbases;
    public int bases_left_clip;
    public int bases_right_clip;
    public int bases_offset;
    public int comments_size;
    public int comments_offset;
    public int sample_size;
    public int code_set;
    public int private_size;
    public int private_offset;
    public short max;
    public short qualmax;
    int[] spare = new int[18];
    char[] version = new char[4];
    char[] private_data;
    public int[] peaks;
    public short[] prob_A;
    public short[] prob_C;
    public short[] prob_G;
    public short[] prob_T;
    public short[] quality;
    short[][] basespare;
    short p_sample;
    byte p_sample1;
    public Hashtable commentHash;
    int leftqual;
    int rightqual;
    int leftvec;
    int rightvec;
    int leftqualbase;
    int leftvecbase;
    int rightqualbase;
    int rightvecbase;
    int insertpos;

    public ScfTraceReader() {
    }

    public ScfTraceReader(Reader reader) {
        this.setInput(reader);
    }

    public static void message(String string) {
        if (messageapp != null) {
            messageapp.infomessage(string);
        } else {
            System.err.println(string);
        }
    }

    public int formatID() {
        return this.formatId;
    }

    public void setFormatID(int n) {
        this.formatId = n;
    }

    public void setInput(Reader reader) {
        this.fIns = reader;
        this.fEof = false;
        this.setReaderBuf(this.fIns);
    }

    public boolean endOfFile() {
        return this.fEof;
    }

    public void reset() {
        this.err = 0;
        this.atseq = 0;
        this.nseq = 0;
        this.seqlen = 0;
        this.fEof = false;
        if (this.fIns != null) {
            try {
                this.fIns.reset();
                this.fEof = !this.fIns.ready();
                this.setReaderBuf(this.fIns);
            }
            catch (IOException iOException) {
                Debug.println(this.getClass().getName() + ".reset() err=" + iOException.getMessage());
            }
        }
    }

    void setReaderBuf(Reader reader) {
        this.oslinei = 0;
        this.oslen = 0;
        this.fByteIns = reader instanceof RsInput ? ((RsInput)reader).getByteStream() : null;
    }

    public void resetSeq() {
        this.seqlen = 0;
        this.idword = SeqFileInfo.gBlankSeqid;
        this.seqid = SeqFileInfo.gBlankSeqid;
    }

    public void setChoice(int n) {
        this.choice = n;
    }

    public int getNseq() {
        return this.nseq;
    }

    public void copyto(SeqFileInfo seqFileInfo) {
        if (seqFileInfo == null) {
            return;
        }
        if (seqFileInfo.err == 0) {
            seqFileInfo.err = this.err;
        }
        seqFileInfo.seqlen = this.seqlen;
        if (seqFileInfo.err == 0 && this.seqlen > 0) {
            seqFileInfo.atseq = this.atseq;
            if (this.atseq > seqFileInfo.nseq) {
                seqFileInfo.nseq = this.atseq;
            }
            seqFileInfo.seqid = this.seqid;
            seqFileInfo.seqdoc = this.seqdoc;
            seqFileInfo.checkSeqID();
            seqFileInfo.seq = new Bioseq(this.bases, 0, this.seqlen);
        }
    }

    public void skipPastHeader(int n) {
    }

    public void doRead() throws IOException {
        this.nseq = 0;
        if (this.fIns == null) {
            throw new FileNotFoundException();
        }
        this.getOsBuf();
        this.seqlen = this.getData();
        ++this.nseq;
        if (this.seqdoc == null) {
            this.seqdoc = new GenbankDoc(this.seqid.toString());
        }
    }

    public void readTo(BioseqWriterIface bioseqWriterIface, int n) throws IOException {
        int n2 = n;
        boolean bl = true;
        int n3 = 1;
        while (bl) {
            this.skipPastHeader(n2);
            n2 = 0;
            SeqFileInfo seqFileInfo = this.readOne(n3);
            if (seqFileInfo == null) {
                bl = false;
            } else {
                if (Debug.isOn || verbose) {
                    ScfTraceReader.message("read " + n3 + " id=" + seqFileInfo.seqid + " seqlen=" + seqFileInfo.seqlen);
                }
                if (bioseqWriterIface.setSeq(seqFileInfo)) {
                    bioseqWriterIface.writeSeqRecord();
                }
            }
            ++n3;
        }
    }

    public SeqFileInfo readOne(int n) throws IOException {
        this.resetSeq();
        if (this.endOfFile()) {
            return null;
        }
        this.setChoice(n);
        this.doRead();
        SeqFileInfo seqFileInfo = new SeqFileInfo();
        this.copyto(seqFileInfo);
        seqFileInfo.nseq = this.getNseq();
        return seqFileInfo;
    }

    private void getOsBuf() throws IOException {
    }

    private final int readByte() throws IOException {
        if (this.fByteIns != null) {
            int n = this.fByteIns.read();
            if (n < 0) {
                this.fEof = true;
                throw new EOFException();
            }
            return n;
        }
        int n = this.fIns.read();
        if (n < 0) {
            this.fEof = true;
            throw new EOFException();
        }
        return (byte)n;
    }

    private final int readUint4() throws IOException {
        int n = this.readByte();
        int n2 = this.readByte();
        int n3 = this.readByte();
        int n4 = this.readByte();
        return (n << 24) + (n2 << 16) + (n3 << 8) + (n4 << 0);
    }

    private final int readUint2() throws IOException {
        int n = this.readByte();
        int n2 = this.readByte();
        return (n << 8) + (n2 << 0);
    }

    private final short readSint2s() throws IOException {
        int n = this.readByte();
        int n2 = this.readByte();
        return (short)((n << 8) + (n2 << 0));
    }

    private final short readUint1() throws IOException {
        return (short)this.readByte();
    }

    protected int getData() throws IOException {
        int n;
        byte by;
        int n2;
        int n3;
        Debug.println("ScfTraceReader.getData");
        this.magic_number = this.readUint4();
        if ((long)this.magic_number != 779314022L) {
            throw new NotScfException("Input is not in SCF format.");
        }
        this.samples = this.readUint4();
        Debug.println("samples=" + this.samples);
        this.samples_offset = this.readUint4();
        this.numbases = this.readUint4();
        Debug.println("numbases=" + this.numbases);
        this.bases_left_clip = this.readUint4();
        this.bases_right_clip = this.readUint4();
        this.bases_offset = this.readUint4();
        this.comments_size = this.readUint4();
        this.comments_offset = this.readUint4();
        for (n3 = 0; n3 < 4; ++n3) {
            this.version[n3] = (char)this.readByte();
        }
        Debug.println("version=" + this.version[0]);
        this.sample_size = this.readUint4();
        Debug.println("sample_size=" + this.sample_size);
        this.code_set = this.readUint4();
        this.private_size = this.readUint4();
        this.private_offset = this.readUint4();
        for (n3 = 0; n3 < 18; ++n3) {
            this.spare[n3] = this.readUint4();
        }
        if (this.sample_size == 1 && this.version[0] == '3') {
            this.data1 = new byte[4][this.samples];
        }
        this.data = new short[4][this.samples];
        if (this.version[0] == '2' || this.version[0] == '1') {
            if (this.sample_size == 1) {
                for (n3 = 0; n3 < this.samples; ++n3) {
                    for (n2 = 0; n2 < 4; ++n2) {
                        this.data[n2][n3] = this.readUint1();
                    }
                }
            } else if (this.sample_size == 2) {
                for (n3 = 0; n3 < this.samples; ++n3) {
                    for (n2 = 0; n2 < 4; ++n2) {
                        this.data[n2][n3] = this.readSint2s();
                    }
                }
            }
        } else if (this.sample_size == 1) {
            for (n2 = 0; n2 < 4; ++n2) {
                for (n3 = 0; n3 < this.samples; ++n3) {
                    this.data1[n2][n3] = (byte)this.readByte();
                }
            }
            for (n2 = 0; n2 < 4; ++n2) {
                this.p_sample1 = 0;
                for (n3 = 0; n3 < this.samples; ++n3) {
                    byte[] byArray = this.data1[n2];
                    int n4 = n3;
                    byArray[n4] = (byte)(byArray[n4] + this.p_sample1);
                    this.p_sample1 = this.data1[n2][n3];
                }
                this.p_sample1 = 0;
                for (n3 = 0; n3 < this.samples; ++n3) {
                    byte[] byArray = this.data1[n2];
                    int n5 = n3;
                    byArray[n5] = (byte)(byArray[n5] + this.p_sample1);
                    this.p_sample1 = this.data1[n2][n3];
                    this.data[n2][n3] = this.data1[n2][n3];
                    if (this.data[n2][n3] >= 0) continue;
                    short[] sArray = this.data[n2];
                    int n6 = n3;
                    sArray[n6] = (short)(sArray[n6] + 256);
                }
            }
        } else if (this.sample_size == 2) {
            for (n2 = 0; n2 < 4; ++n2) {
                for (n3 = 0; n3 < this.samples; ++n3) {
                    this.data[n2][n3] = this.readSint2s();
                }
            }
            for (n2 = 0; n2 < 4; ++n2) {
                this.p_sample = 0;
                for (n3 = 0; n3 < this.samples; ++n3) {
                    this.data[n2][n3] = (short)(this.data[n2][n3] + this.p_sample);
                    this.p_sample = this.data[n2][n3];
                }
                this.p_sample = 0;
                for (n3 = 0; n3 < this.samples; ++n3) {
                    this.data[n2][n3] = (short)(this.data[n2][n3] + this.p_sample);
                    this.p_sample = this.data[n2][n3];
                }
            }
        }
        this.seqlen = 0;
        this.bases = new byte[this.numbases];
        this.peaks = new int[this.numbases];
        this.prob_A = new short[this.numbases];
        this.prob_C = new short[this.numbases];
        this.prob_G = new short[this.numbases];
        this.prob_T = new short[this.numbases];
        this.basespare = new short[this.numbases][3];
        this.quality = new short[this.samples];
        if (this.version[0] == '1' || this.version[0] == '2') {
            for (n3 = 0; n3 < this.numbases; ++n3) {
                this.peaks[n3] = this.readUint4();
                this.prob_A[n3] = this.readUint1();
                this.prob_C[n3] = this.readUint1();
                this.prob_G[n3] = this.readUint1();
                this.prob_T[n3] = this.readUint1();
                by = (byte)this.readByte();
                n = this.peaks[n3];
                this.bases[this.seqlen++] = by;
                for (n2 = 0; n2 < 3; ++n2) {
                    this.basespare[n3][n2] = this.readUint1();
                }
            }
        } else {
            for (n3 = 0; n3 < this.numbases; ++n3) {
                this.peaks[n3] = this.readUint4();
            }
            for (n3 = 0; n3 < this.numbases; ++n3) {
                this.prob_A[n3] = this.readUint1();
            }
            for (n3 = 0; n3 < this.numbases; ++n3) {
                this.prob_C[n3] = this.readUint1();
            }
            for (n3 = 0; n3 < this.numbases; ++n3) {
                this.prob_G[n3] = this.readUint1();
            }
            for (n3 = 0; n3 < this.numbases; ++n3) {
                this.prob_T[n3] = this.readUint1();
            }
            for (n3 = 0; n3 < this.numbases; ++n3) {
                by = (byte)this.readByte();
                n = this.peaks[n3];
                this.bases[this.seqlen++] = by;
            }
            for (n2 = 0; n2 < 3; ++n2) {
                for (n3 = 0; n3 < this.numbases; ++n3) {
                    this.basespare[n3][n2] = this.readUint1();
                }
            }
        }
        for (n3 = 0; n3 < this.numbases; ++n3) {
            by = this.bases[n3];
            switch (by) {
                case 65: {
                    this.quality[this.peaks[n3]] = this.prob_A[n3];
                    break;
                }
                case 67: {
                    this.quality[this.peaks[n3]] = this.prob_C[n3];
                    break;
                }
                case 71: {
                    this.quality[this.peaks[n3]] = this.prob_G[n3];
                    break;
                }
                case 84: {
                    this.quality[this.peaks[n3]] = this.prob_T[n3];
                    break;
                }
                default: {
                    this.quality[this.peaks[n3]] = 0;
                }
            }
            if (n3 == 0) continue;
            for (n2 = this.peaks[n3 - 1] + 1; n2 < this.peaks[n3]; ++n2) {
                this.quality[n2] = n2 < (this.peaks[n3 - 1] + this.peaks[n3]) / 2 ? this.quality[this.peaks[n3 - 1]] : this.quality[this.peaks[n3]];
            }
        }
        this.qualmax = (short)100;
        this.max = 0;
        for (n2 = 0; n2 < 4; ++n2) {
            for (n3 = 0; n3 < this.samples; ++n3) {
                if (this.data[n2][n3] <= this.max) continue;
                this.max = this.data[n2][n3];
            }
        }
        char[] cArray = new char[this.comments_size];
        for (n3 = 0; n3 < this.comments_size; ++n3) {
            cArray[n3] = (char)this.readByte();
        }
        Debug.println("comments=" + new String(cArray));
        this.commentHash = this.parseComments(cArray);
        if (this.commentHash.contains("PHRED")) {
            this.qualmax = (short)50;
        }
        if (this.commentHash.containsKey("QMAX")) {
            this.qualmax = (short)Integer.parseInt((String)this.commentHash.get("QMAX"));
        }
        this.leftvecbase = this.bases_left_clip;
        this.rightqualbase = this.bases_right_clip;
        this.leftqualbase = 0;
        this.rightvecbase = this.numbases + 1;
        if (this.commentHash.containsKey("CLIP") && ((String)this.commentHash.get("CLIP")).equals("LRQV1.0")) {
            if (this.commentHash.containsKey("LQCE")) {
                this.leftqualbase = Integer.parseInt((String)this.commentHash.get("LQCE"));
            }
            if (this.commentHash.containsKey("RQCB")) {
                this.rightqualbase = Integer.parseInt((String)this.commentHash.get("RQCB"));
            }
            if (this.commentHash.containsKey("LVCE")) {
                this.leftvecbase = Integer.parseInt((String)this.commentHash.get("LVCE"));
            }
            if (this.commentHash.containsKey("RVCB")) {
                this.rightvecbase = Integer.parseInt((String)this.commentHash.get("RVCB"));
            }
        }
        this.leftqual = this.leftqualbase <= 0 ? 0 : (this.leftqualbase >= this.numbases ? this.samples + 1 : (this.peaks[this.leftqualbase] + this.peaks[this.leftqualbase - 1]) / 2);
        this.leftvec = this.leftvecbase <= 0 ? 0 : (this.leftvecbase >= this.numbases ? this.samples + 1 : (this.peaks[this.leftvecbase] + this.peaks[this.leftvecbase - 1]) / 2);
        this.rightqual = this.rightqualbase <= 0 ? 0 : (this.rightqualbase >= this.numbases ? this.samples + 1 : (this.peaks[this.rightqualbase - 1] + this.peaks[this.rightqualbase - 2]) / 2);
        this.rightvec = this.rightvecbase <= 0 ? 0 : (this.rightvecbase >= this.numbases ? this.samples + 1 : (this.peaks[this.rightvecbase - 1] + this.peaks[this.rightvecbase - 2]) / 2);
        if (this.private_size > 0) {
            this.private_data = new char[this.private_size];
            for (n3 = 0; n3 < this.private_size; ++n3) {
                this.private_data[n3] = (char)this.readByte();
            }
        }
        return this.seqlen;
    }

    private Hashtable parseComments(char[] cArray) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(20, 1.0f);
        char[] cArray2 = new char[cArray.length];
        int n = 0;
        while (n < cArray.length) {
            int n2 = n;
            while (n < cArray.length && cArray[n] != '=' && cArray[n] != '\n') {
                cArray2[n - n2] = cArray[n++];
            }
            if (n >= cArray.length || cArray[n] == '\n') {
                ++n;
                continue;
            }
            ++n;
            int n3 = 0;
            while (Character.isSpace(cArray2[n3])) {
                ++n3;
            }
            String string = new String(cArray2, n3, 4);
            while (n < cArray.length && Character.isSpace(cArray[n])) {
                ++n;
            }
            n2 = n;
            while (n < cArray.length && cArray[n] != '\n') {
                cArray2[n - n2] = cArray[n++];
            }
            String string2 = new String(cArray2, 0, n - n2);
            hashtable.put(string, string2);
            ++n;
        }
        return hashtable;
    }

    static {
        messageapp = null;
    }
}

