/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.AppResources;
import flybase.Debug;
import iubio.bioseq.BaseKind;
import iubio.bioseq.Bioseq;
import iubio.bioseq.SeqInfo;
import iubio.bioseq.SeqRange;
import iubio.readseq.BioseqDoc;
import iubio.readseq.BioseqDocImpl;
import iubio.readseq.BioseqFormat;
import iubio.readseq.BioseqFormats;
import iubio.readseq.BioseqWriter;
import iubio.readseq.BioseqWriterIface;
import iubio.readseq.DocItem;
import iubio.readseq.OutBiobase;
import iubio.readseq.OutBiobaseIntf;
import iubio.readseq.SeqFileInfo;
import iubio.readseq.XmlDoc;
import iubio.readseq.XmlPrintWriter;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.zip.Adler32;
import java.util.zip.Checksum;

public class XmlSeqWriter
implements BioseqWriterIface {
    public boolean showErrors;
    public static boolean includeDTD = true;
    public static String dtdUrl;
    static final int kSeqwidth = 78;
    protected XmlPrintWriter xpr;
    protected int formatId;
    protected int err;
    protected int seqlen;
    protected int offset;
    protected int nseq;
    protected int atseq;
    protected long checksum = 0L;
    protected int fBasePart = 0;
    protected String seqid = SeqFileInfo.gBlankSeqid;
    protected String idword = SeqFileInfo.gBlankSeqid;
    protected Bioseq bioseq;
    protected Object seqdoc;
    protected Hashtable exfeatures;
    protected int level = 0;
    protected String dtdfile;
    protected String tagBioseqSet;
    protected String tagBioseq;
    protected String tagSeqdata;
    protected String tagName;
    protected String tagDescription;
    protected String tagChecksum;
    protected String tagSeqlen;
    protected String tagSeqkind;
    protected boolean dochecksum = true;
    protected boolean doReverse;
    protected static final int kUseTester = 1;
    protected static final int kAnyChar = 2;
    protected static final int kAlphaChar = 3;
    protected OutBiobaseIntf testbase = new OutBiobase(null);
    protected int testbaseKind = 3;
    protected Checksum summer;

    public XmlSeqWriter() {
        this.showErrors = Debug.isOn;
    }

    public int formatID() {
        return this.formatId;
    }

    public void setFormatID(int n) {
        this.formatId = n;
    }

    public boolean getChecksum() {
        return this.dochecksum;
    }

    public void setChecksum(boolean bl) {
        this.dochecksum = bl;
    }

    public boolean getReverseComplement() {
        return this.doReverse;
    }

    public void setReverseComplement(boolean bl) {
        this.doReverse = bl;
    }

    public final void setOutput(OutputStream outputStream) {
        this.setOutput(new OutputStreamWriter(outputStream));
    }

    public void setOutput(Writer writer) {
        if (writer instanceof XmlPrintWriter) {
            this.xpr = (XmlPrintWriter)writer;
        } else {
            BufferedWriter bufferedWriter = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
            this.xpr = new XmlPrintWriter(bufferedWriter);
        }
    }

    public void close() throws IOException {
        this.xpr.close();
        if (this.xpr.checkError()) {
            throw new IOException("close error");
        }
    }

    public int getError() {
        if (this.xpr != null && this.xpr.checkError()) {
            ++this.err;
        }
        return this.err;
    }

    public void setOutputTranslation(OutBiobaseIntf outBiobaseIntf) {
        this.testbase = outBiobaseIntf;
        this.testbaseKind = outBiobaseIntf == null ? 3 : 1;
    }

    public OutBiobaseIntf getOutputTranslation() {
        if (this.testbaseKind == 1) {
            return this.testbase;
        }
        return null;
    }

    public void setFeatureExtraction(Hashtable hashtable) {
        this.exfeatures = hashtable;
    }

    public boolean wantsDocument() {
        if (this.exfeatures != null) {
            return true;
        }
        BioseqFormat bioseqFormat = BioseqFormats.bioseqFormat(this.formatID());
        return bioseqFormat.hasdoc();
    }

    public int seqLen() {
        return this.seqlen;
    }

    public int getNseq() {
        return this.nseq;
    }

    public void setNseq(int n) {
        this.nseq = n;
    }

    public String getDTD(String string) {
        if ((string = AppResources.global.findPath(string)) == null) {
            return null;
        }
        return AppResources.global.getData(string);
    }

    public void writeHeader() throws IOException {
        String string;
        String string2;
        Object object;
        if (this.xpr == null) {
            throw new FileNotFoundException();
        }
        this.nseq = 0;
        this.level = 0;
        this.tagBioseqSet = XmlDoc.getXMLFieldName(1);
        this.tagBioseq = XmlDoc.getXMLFieldName(2);
        this.tagSeqdata = XmlDoc.getXMLFieldName(111);
        this.tagName = XmlDoc.getXMLFieldName(10);
        this.tagDescription = XmlDoc.getXMLFieldName(20);
        this.tagChecksum = XmlDoc.getXMLFieldName(114);
        this.tagSeqlen = XmlDoc.getXMLFieldName(112);
        this.tagSeqkind = XmlDoc.getXMLFieldName(113);
        this.xpr.header();
        if (includeDTD) {
            this.xpr.print("<!DOCTYPE ");
            this.xpr.print(this.tagBioseqSet);
            object = this.getDTD(this.tagBioseq + ".dtd");
            if (object != null) {
                this.xpr.println(" [");
                this.xpr.print((String)object);
                this.xpr.print("]");
            } else if (object == null) {
                string2 = "http://www.bioxml.info/dtd/Bioseq.dtd";
                this.xpr.print(" SYSTEM \"" + string2 + "\"" + "\n");
                string = "[\n<!ATTLIST Bioseq-set\n\txmlns:xlink    CDATA #FIXED \"http://www.w3.org/1999/xlink\">\n<!ATTLIST lineage\n\txlink:type     CDATA #IMPLIED\n\txlink:href     CDATA #IMPLIED>\n<!ATTLIST pubxref\n\txlink:type     CDATA #IMPLIED\n\txlink:href     CDATA #IMPLIED>\n<!ATTLIST dbxref\n\txlink:type     CDATA #IMPLIED\n\txlink:href     CDATA #IMPLIED>\n<!ATTLIST other\n\txlink:type     CDATA #IMPLIED\n\txlink:href     CDATA #IMPLIED>\n<!ATTLIST comment\n\txlink:type     CDATA #IMPLIED\n\txlink:href     CDATA #IMPLIED>\n<!ATTLIST fitem\n\txlink:type     CDATA #IMPLIED\n\txlink:href     CDATA #IMPLIED>\n<!ATTLIST fval\n\txlink:type     CDATA #IMPLIED\n\txlink:href     CDATA #IMPLIED>\n]\n";
                this.xpr.print(string);
            }
            this.xpr.println(">");
        }
        this.xpr.println();
        if (this.exfeatures != null) {
            this.xpr.commentStart();
            this.xpr.print("Sequence ");
            this.xpr.println(" extracted for these features:");
            object = this.exfeatures.keys();
            while (object.hasMoreElements()) {
                string2 = (String)object.nextElement();
                string = (String)this.exfeatures.get(string2);
                this.xpr.println(string2 + "=" + string);
            }
            this.xpr.commentEnd();
        }
        this.xpr.writeStartElement(this.tagBioseqSet, this.level);
        ++this.level;
    }

    public void writeTrailer() {
        --this.level;
        this.xpr.writeEndElement(this.tagBioseqSet, this.level);
        this.xpr.flush();
    }

    public boolean setSeq(SeqFileInfo seqFileInfo) {
        if (seqFileInfo.ismask) {
            return false;
        }
        return this.setSeq(seqFileInfo.seq, seqFileInfo.offset, seqFileInfo.seqlen, seqFileInfo.seqid, seqFileInfo.seqdoc, seqFileInfo.atseq, 0);
    }

    public boolean setMask(SeqFileInfo seqFileInfo, String string) {
        int n = 0;
        if (seqFileInfo.ismask) {
            n = 0;
        } else if (seqFileInfo.hasmask) {
            n = 3;
        } else {
            return false;
        }
        string = seqFileInfo.seqid.toString() + string;
        return this.setSeq(seqFileInfo.seq, seqFileInfo.offset, seqFileInfo.seqlen, string, seqFileInfo.seqdoc, seqFileInfo.atseq, n);
    }

    public boolean setSeq(Object object, int n, int n2, String string, Object object2, int n3, int n4) {
        if ((n2 < 1 || object == null) && object2 != null) {
            object = new byte[]{78};
            n2 = 1;
        }
        this.seqlen = n2;
        this.checksum = 0L;
        if (n2 > 0 && object != null) {
            if (object instanceof Bioseq) {
                this.bioseq = (Bioseq)object;
            } else if (object instanceof byte[]) {
                this.bioseq = new Bioseq();
                this.bioseq.setbases((byte[])object);
            }
            this.atseq = n3;
            this.offset = n;
            this.seqdoc = object2;
            this.setSeqName(string);
            this.setSeqPart(n4);
            if (this.exfeatures != null && object2 instanceof BioseqDocImpl) {
                BioseqDocImpl bioseqDocImpl = (BioseqDocImpl)object2;
                bioseqDocImpl.setWantedFeatures(this.exfeatures);
                SeqRange seqRange = bioseqDocImpl.getFeatureRanges(n, this.seqlen);
                if (this.extractBases(seqRange)) {
                    System.out.println("replaceDocItem called!");
                    bioseqDocImpl.replaceDocItem(112, new DocItem("length", String.valueOf(this.seqlen), 112, 1));
                }
            } else if (this.doReverse) {
                this.bioseq.reverseComplement(n, this.seqlen);
                if (object2 instanceof BioseqDocImpl) {
                    BioseqDocImpl bioseqDocImpl = (BioseqDocImpl)object2;
                    bioseqDocImpl.addComment("NOTE:  This is reverse-complement of original sequence.");
                }
            }
        }
        return this.seqlen > 0;
    }

    protected boolean extractBases(SeqRange seqRange) {
        if (seqRange == null) {
            return false;
        }
        int n = 0;
        boolean bl = seqRange.isComplement();
        int n2 = seqRange.start();
        int n3 = seqRange.max();
        int n4 = n3 - n2 + 1;
        for (SeqRange seqRange2 = seqRange; seqRange2 != null; seqRange2 = seqRange2.next()) {
            if (seqRange2.isRemote()) continue;
            n += seqRange2.nbases();
        }
        if (n > 0) {
            int n5 = 0;
            byte[] byArray = new byte[n];
            byte[] byArray2 = null;
            if (this.bioseq.isBytes()) {
                n2 = 0;
                byArray2 = this.bioseq.toBytes();
            } else {
                byArray2 = this.bioseq.toBytes(n2, n4, 0);
            }
            int n6 = this.bioseq.getSeqtype();
            boolean bl2 = n6 == 4;
            boolean bl3 = n6 == 2;
            for (SeqRange seqRange3 = seqRange; seqRange3 != null; seqRange3 = seqRange3.next()) {
                String string;
                if (seqRange3.isRemote()) continue;
                int n7 = seqRange3.start();
                int n8 = seqRange3.nbases();
                boolean bl4 = bl ? bl : seqRange3.isComplement();
                if ((string = (n7 -= n2) < 0 ? String.valueOf(n7) + " start<0" : (n7 + n8 > this.seqlen ? String.valueOf(n7 + n8) + " end>" + String.valueOf(this.seqlen) : (n5 + n8 > n ? String.valueOf(n5 + n8) + "  size>" + String.valueOf(n) : null))) != null) {
                    String string2 = this.idword + " seq range error: " + string + " for " + seqRange3;
                    System.err.println(string2);
                    return false;
                }
                if (bl4) {
                    int n9;
                    int n10 = n - n5 - 1;
                    if (bl2) {
                        for (n9 = 0; n9 < n8; ++n9) {
                            byArray[n10 - n9] = byArray2[n7 + n9];
                        }
                    } else {
                        for (n9 = 0; n9 < n8; ++n9) {
                            byArray[n10 - n9] = BaseKind.nucleicComplement(byArray2[n7 + n9], bl3);
                        }
                    }
                } else {
                    System.arraycopy(byArray2, n7, byArray, n5, n8);
                }
                n5 += n8;
            }
            this.bioseq.setbases(byArray);
        }
        this.seqlen = n;
        return true;
    }

    public void setSeqName(String string) {
        int n;
        if (string == null) {
            return;
        }
        if (string.equals(SeqFileInfo.gBlankSeqid)) {
            string = SeqFileInfo.getNextBlankID();
        }
        this.seqid = string;
        this.seqid = this.seqid.trim();
        if (this.seqid.indexOf("checksum") > 0 && (n = this.seqid.indexOf("bases")) > 0) {
            while (n > 0 && this.seqid.charAt(n) != ',') {
                --n;
            }
            if (n > 0) {
                this.seqid = this.seqid.substring(0, n);
            }
        }
        if ((n = this.seqid.indexOf(32)) <= 0) {
            this.idword = this.seqid;
        } else {
            if (n > 30) {
                n = 30;
            }
            this.idword = this.seqid.substring(0, n);
        }
    }

    public void setSeqPart(int n) {
        this.fBasePart = n;
    }

    public void writeSeqRecord() throws IOException {
        this.writeRecordStart();
        this.writeDoc();
        this.writeSeq();
        this.writeRecordEnd();
    }

    public void writeSeq() {
        this.xpr.writeStartElement(this.tagSeqdata, false, this.level);
        int n = 2 * this.level + this.tagSeqdata.length() + 2;
        if (this.bioseq.isBytes() && this.testbaseKind != 1) {
            byte[] byArray = this.bioseq.toBytes();
            int n2 = 78 - n;
            for (int i = 0; i < this.seqlen; i += n2) {
                if (n2 + i > this.seqlen) {
                    n2 = this.seqlen - i;
                }
                this.xpr.writeCharacters(byArray, this.offset + i, n2);
                if (this.seqlen >= 78) {
                    this.xpr.println();
                }
                n2 = 78;
            }
        } else {
            int n3 = 0;
            int n4 = 78 - n;
            for (int i = 0; i < this.seqlen; ++i) {
                char c = this.bioseq.base(this.offset + i, this.fBasePart);
                if (this.testbaseKind == 1) {
                    c = (char)this.testbase.outSeqChar(c);
                }
                if (c <= '\u0000') continue;
                this.xpr.printEncoded(c);
                if (++n3 < n4) continue;
                this.xpr.println();
                n3 = 0;
                n4 = 78;
            }
        }
        this.xpr.writeEndElement(this.tagSeqdata, false, this.level);
    }

    public void writeSeqEnd() {
    }

    public void writeRecordStart() {
        ++this.nseq;
        this.checksum = 0L;
        this.xpr.writeStartElement(this.tagBioseq, this.level);
        ++this.level;
        if (this.dochecksum && this.checksum == 0L) {
            this.checksum = this.calculateChecksum();
        }
    }

    public void writeRecordEnd() {
        --this.level;
        this.xpr.writeEndElement(this.tagBioseq, this.level);
        this.xpr.println();
    }

    protected void writeID() {
        this.xpr.writeTag(this.tagName, this.idword, this.level);
    }

    protected void writeStats() {
        this.xpr.writeTag(this.tagSeqlen, String.valueOf(this.seqlen), this.level);
        int n = this.bioseq.getSeqtype();
        String string = SeqInfo.getKindLabel(n);
        this.xpr.writeTag(this.tagSeqkind, string, this.level);
        String string2 = this.checksumString();
        if (string2.length() > 0) {
            this.xpr.writeTag(this.tagChecksum, string2, this.level);
        }
    }

    public void writeDoc() {
        if (this.seqdoc instanceof BioseqDoc) {
            XmlDoc xmlDoc = new XmlDoc((BioseqDoc)this.seqdoc);
            xmlDoc.setIndent(this.level);
            String string = xmlDoc.getID();
            if (string == null) {
                this.writeID();
                this.writeStats();
            }
            if (this.seqid.equals(string)) {
                xmlDoc.writeTo(this.xpr, true);
            } else {
                this.writeID();
            }
        } else {
            this.writeID();
            this.xpr.writeTag(this.tagDescription, this.seqid, this.level);
            this.writeStats();
        }
    }

    protected long calculateChecksum() {
        if (BioseqWriter.gJavaChecksum && this.summer == null) {
            this.summer = new Adler32();
        }
        return BioseqWriter.calculateChecksum(this.bioseq, this.offset, this.seqlen, this.summer);
    }

    protected String checksumString() {
        if (this.checksum == 0L) {
            return "";
        }
        return Long.toHexString(this.checksum).toUpperCase();
    }
}

