/*
 * Decompiled with CFR 0.152.
 */
package javax.help.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.help.DefaultHelpModel;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.HelpUtilities;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelpNavigator;
import javax.help.JHelpSearchNavigator;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.SearchHit;
import javax.help.SearchTOCItem;
import javax.help.SearchView;
import javax.help.TextHelpModel;
import javax.help.TreeItem;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;
import javax.help.plaf.HelpNavigatorUI;
import javax.help.plaf.basic.BasicHelpUI;
import javax.help.plaf.basic.BasicSearchCellRenderer;
import javax.help.search.MergingSearchEngine;
import javax.help.search.SearchEngine;
import javax.help.search.SearchEvent;
import javax.help.search.SearchItem;
import javax.help.search.SearchListener;
import javax.help.search.SearchQuery;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.RepaintManager;
import javax.swing.ScrollPaneLayout;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class BasicSearchNavigatorUI
extends HelpNavigatorUI
implements HelpModelListener,
SearchListener,
PropertyChangeListener,
TreeSelectionListener,
ComponentListener {
    protected JHelpSearchNavigator searchnav;
    protected JScrollPane sp;
    protected JTree tree;
    protected DefaultMutableTreeNode topNode;
    protected JTextField searchparams;
    protected boolean displayOptions;
    protected SearchEngine helpsearch;
    protected SearchQuery searchquery;
    protected DefaultMutableTreeNode lastTOCnode;
    private HelpSet newHelpSet;
    ActionListener searchAction = new SearchActionListener();
    private Cursor paramCursor;
    private Cursor treeCursor;
    private Cursor waitCursor = null;
    private static boolean debug = false;
    static /* synthetic */ Class class$javax$help$plaf$basic$BasicSearchNavigatorUI;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicSearchNavigatorUI((JHelpSearchNavigator)jComponent);
    }

    public BasicSearchNavigatorUI(JHelpSearchNavigator jHelpSearchNavigator) {
        ImageIcon imageIcon = this.getImageIcon(jHelpSearchNavigator.getNavigatorView());
        if (imageIcon != null) {
            this.setIcon(imageIcon);
        } else {
            this.setIcon(BasicHelpUI.getIcon(class$javax$help$plaf$basic$BasicSearchNavigatorUI == null ? (class$javax$help$plaf$basic$BasicSearchNavigatorUI = BasicSearchNavigatorUI.class$("javax.help.plaf.basic.BasicSearchNavigatorUI")) : class$javax$help$plaf$basic$BasicSearchNavigatorUI, "images/search.gif"));
        }
    }

    public void installUI(JComponent jComponent) {
        this.searchnav = (JHelpSearchNavigator)jComponent;
        HelpModel helpModel = this.searchnav.getModel();
        this.searchnav.setLayout(new BorderLayout());
        this.searchnav.addPropertyChangeListener(this);
        this.searchnav.addComponentListener(this);
        if (helpModel != null) {
            helpModel.addHelpModelListener(this);
        }
        JLabel jLabel = new JLabel(HelpUtilities.getString(HelpUtilities.getLocale(jComponent), "search.findLabel"));
        this.searchparams = new JTextField("", 20);
        jLabel.setLabelFor(this.searchparams);
        this.searchparams.addActionListener(this.searchAction);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jLabel);
        jPanel.add(this.searchparams);
        this.searchnav.add("North", jPanel);
        this.topNode = new DefaultMutableTreeNode();
        this.lastTOCnode = null;
        this.tree = new JTree(this.topNode);
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        treeSelectionModel.addTreeSelectionListener(this);
        this.tree.setShowsRootHandles(false);
        this.tree.setRootVisible(false);
        this.sp = new JScrollPane();
        this.sp.getViewport().add(this.tree);
        this.searchnav.add("Center", this.sp);
        this.reloadData();
    }

    public void uninstallUI(JComponent jComponent) {
        HelpModel helpModel = this.searchnav.getModel();
        this.searchnav.removeComponentListener(this);
        this.searchnav.removePropertyChangeListener(this);
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        treeSelectionModel.removeTreeSelectionListener(this);
        this.searchnav.setLayout(null);
        this.searchnav.removeAll();
        if (helpModel != null) {
            helpModel.removeHelpModelListener(this);
        }
        this.searchnav = null;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return new Dimension(200, 100);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (this.sp != null) {
            return ((ScrollPaneLayout)this.sp.getLayout()).minimumLayoutSize(this.sp);
        }
        return new Dimension(100, 100);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    private void reloadData() {
        this.helpsearch = null;
        this.setCellRenderer(this.searchnav.getNavigatorView(), this.tree);
        this.addSubHelpSets(this.searchnav.getModel().getHelpSet());
    }

    private void reloadData(HelpModel helpModel) {
        BasicSearchNavigatorUI.debug("reloadData using new model");
        this.helpsearch = null;
        SearchView searchView = null;
        this.newHelpSet = helpModel.getHelpSet();
        SearchView searchView2 = (SearchView)this.searchnav.getNavigatorView();
        String string = searchView2.getName();
        NavigatorView[] navigatorViewArray = this.newHelpSet.getNavigatorViews();
        int n = 0;
        while (n < navigatorViewArray.length) {
            NavigatorView navigatorView;
            if (navigatorViewArray[n].getName().equals(string) && (navigatorView = navigatorViewArray[n]) instanceof SearchView) {
                searchView = (SearchView)navigatorView;
                break;
            }
            ++n;
        }
        if (searchView == null) {
            return;
        }
        this.topNode.removeAllChildren();
        this.searchnav.setSearchEngine(new MergingSearchEngine(searchView));
        this.setCellRenderer(searchView, this.tree);
        this.addSubHelpSets(this.newHelpSet);
    }

    protected void addSubHelpSets(HelpSet helpSet) {
        Enumeration enumeration = helpSet.getHelpSets();
        while (enumeration.hasMoreElements()) {
            HelpSet helpSet2 = (HelpSet)enumeration.nextElement();
            NavigatorView[] navigatorViewArray = helpSet2.getNavigatorViews();
            int n = 0;
            while (n < navigatorViewArray.length) {
                if (this.searchnav.canMerge(navigatorViewArray[n])) {
                    this.merge(navigatorViewArray[n]);
                }
                ++n;
            }
            this.addSubHelpSets(helpSet2);
        }
    }

    public void merge(NavigatorView navigatorView) {
        BasicSearchNavigatorUI.debug("merging " + navigatorView);
        String string = this.searchparams.getText();
        if (string != null && string.length() != 0) {
            this.searchAction.actionPerformed(new ActionEvent(this.searchparams, 1001, ""));
        }
    }

    public void remove(NavigatorView navigatorView) {
        BasicSearchNavigatorUI.debug("removing " + navigatorView);
        if (this.searchparams.getText() != null) {
            this.searchAction.actionPerformed(new ActionEvent(this.searchparams, 1001, ""));
        }
    }

    protected void setCellRenderer(NavigatorView navigatorView, JTree jTree) {
        if (navigatorView == null) {
            return;
        }
        Map map = navigatorView.getHelpSet().getCombinedMap();
        jTree.setCellRenderer(new BasicSearchCellRenderer(map));
    }

    public void idChanged(HelpModelEvent helpModelEvent) {
        Map.ID iD;
        Serializable serializable;
        SearchTOCItem searchTOCItem;
        Object object;
        Map.ID iD2 = helpModelEvent.getID();
        URL uRL = helpModelEvent.getURL();
        HelpModel helpModel = this.searchnav.getModel();
        BasicSearchNavigatorUI.debug("idChanged(" + helpModelEvent + ")");
        if (helpModelEvent.getSource() != helpModel) {
            BasicSearchNavigatorUI.debug("Internal inconsistency!");
            BasicSearchNavigatorUI.debug("  " + helpModelEvent.getSource() + " != " + helpModel);
            throw new Error("Internal error");
        }
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null && (object = treePath.getLastPathComponent()) instanceof DefaultMutableTreeNode && (searchTOCItem = (SearchTOCItem)(serializable = (DefaultMutableTreeNode)object).getUserObject()) != null && (iD = searchTOCItem.getID()) != null && iD.equals(iD2)) {
            return;
        }
        object = this.findIDorURL(this.topNode, iD2, uRL);
        if (object == null) {
            BasicSearchNavigatorUI.debug("node didn't exist");
            this.tree.clearSelection();
            return;
        }
        serializable = new TreePath(((DefaultMutableTreeNode)object).getPath());
        this.tree.expandPath((TreePath)serializable);
        this.tree.setSelectionPath((TreePath)serializable);
        this.tree.scrollPathToVisible((TreePath)serializable);
    }

    protected JHelpNavigator getHelpNavigator() {
        return this.searchnav;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        SearchTOCItem searchTOCItem;
        TextHelpModel.Highlight[] highlightArray;
        JHelpNavigator jHelpNavigator = this.getHelpNavigator();
        HelpModel helpModel = jHelpNavigator.getModel();
        BasicSearchNavigatorUI.debug("ValueChanged: " + treeSelectionEvent);
        BasicSearchNavigatorUI.debug("  model: " + helpModel);
        TreeItem[] treeItemArray = null;
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray != null) {
            treeItemArray = new TreeItem[treePathArray.length];
            int n = 0;
            while (n < treePathArray.length) {
                if (treePathArray[n] != null) {
                    highlightArray = (TextHelpModel.Highlight[])treePathArray[n].getLastPathComponent();
                    treeItemArray[n] = (TreeItem)highlightArray.getUserObject();
                }
                ++n;
            }
        }
        jHelpNavigator.setSelectedItems(treeItemArray);
        if (treeItemArray != null && treeItemArray.length == 1 && (searchTOCItem = (SearchTOCItem)treeItemArray[0]) != null) {
            if (searchTOCItem.getID() != null) {
                try {
                    helpModel.setCurrentID(searchTOCItem.getID(), searchTOCItem.getName(), jHelpNavigator);
                }
                catch (InvalidHelpSetContextException invalidHelpSetContextException) {
                    System.err.println("BadID: " + searchTOCItem.getID());
                    return;
                }
            } else if (searchTOCItem.getURL() != null) {
                helpModel.setCurrentURL(searchTOCItem.getURL(), searchTOCItem.getName(), jHelpNavigator);
            } else {
                return;
            }
            if (helpModel instanceof TextHelpModel) {
                highlightArray = new DefaultHelpModel.DefaultHighlight[searchTOCItem.hitCount()];
                int n = 0;
                Enumeration enumeration = searchTOCItem.getSearchHits();
                while (enumeration.hasMoreElements()) {
                    SearchHit searchHit = (SearchHit)enumeration.nextElement();
                    highlightArray[n] = new DefaultHelpModel.DefaultHighlight(searchHit.getBegin(), searchHit.getEnd());
                    ++n;
                }
                ((TextHelpModel)helpModel).setHighlights(highlightArray);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        BasicSearchNavigatorUI.debug(this + " " + "propertyChange: " + propertyChangeEvent.getSource() + " " + propertyChangeEvent.getPropertyName());
        if (propertyChangeEvent.getSource() == this.searchnav) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("helpModel")) {
                this.reloadData((HelpModel)propertyChangeEvent.getNewValue());
            } else if (string.equals("font")) {
                BasicSearchNavigatorUI.debug("Font change");
                Font font = (Font)propertyChangeEvent.getNewValue();
                this.searchparams.setFont(font);
                RepaintManager.currentManager(this.searchparams).markCompletelyDirty(this.searchparams);
                this.tree.setFont(font);
                RepaintManager.currentManager(this.tree).markCompletelyDirty(this.tree);
            }
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.searchparams.selectAll();
        this.searchparams.requestFocus();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    private DefaultMutableTreeNode findIDorURL(DefaultMutableTreeNode defaultMutableTreeNode, Map.ID iD, URL uRL) {
        SearchTOCItem searchTOCItem = (SearchTOCItem)defaultMutableTreeNode.getUserObject();
        if (searchTOCItem != null) {
            Map.ID iD2 = searchTOCItem.getID();
            if (iD2 != null && iD != null && iD2.equals(iD)) {
                return defaultMutableTreeNode;
            }
            URL uRL2 = searchTOCItem.getURL();
            if (uRL2 != null && uRL != null && uRL.sameFile(uRL2)) {
                return defaultMutableTreeNode;
            }
        }
        int n = defaultMutableTreeNode.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
            DefaultMutableTreeNode defaultMutableTreeNode3 = this.findIDorURL(defaultMutableTreeNode2, iD, uRL);
            if (defaultMutableTreeNode3 != null) {
                return defaultMutableTreeNode3;
            }
            ++n2;
        }
        return null;
    }

    private void reorder(Vector vector) {
        BasicSearchNavigatorUI.debug("reorder nodes");
        this.topNode.removeAllChildren();
        Object[] objectArray = new DefaultMutableTreeNode[vector.size()];
        vector.copyInto(objectArray);
        this.quickSort((DefaultMutableTreeNode[])objectArray, 0, objectArray.length - 1);
        int n = 0;
        while (n < objectArray.length) {
            this.topNode.add((MutableTreeNode)objectArray[n]);
            ++n;
        }
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.tree.invalidate();
        this.tree.repaint();
    }

    /*
     * Unable to fully structure code
     */
    void quickSort(DefaultMutableTreeNode[] var1_1, int var2_2, int var3_3) {
        block5: {
            var4_4 = var2_2;
            var5_5 = var3_3;
            if (var3_3 <= var2_2) break block5;
            var6_6 = (var2_2 + var3_3) / 2;
            ** GOTO lbl16
            {
                ++var4_4;
                do {
                    if (var4_4 < var3_3 && this.compare(var1_1[var4_4], var1_1[var6_6]) > 0) continue block0;
                    while (var5_5 > var2_2 && this.compare(var1_1[var5_5], var1_1[var6_6]) < 0) {
                        --var5_5;
                    }
                    if (var4_4 > var5_5) continue;
                    this.swap(var1_1, var4_4, var5_5);
                    ++var4_4;
                    --var5_5;
lbl16:
                    // 3 sources

                } while (var4_4 <= var5_5);
            }
            if (var2_2 < var5_5) {
                this.quickSort(var1_1, var2_2, var5_5);
            }
            if (var4_4 < var3_3) {
                this.quickSort(var1_1, var4_4, var3_3);
            }
        }
    }

    private void swap(DefaultMutableTreeNode[] defaultMutableTreeNodeArray, int n, int n2) {
        DefaultMutableTreeNode defaultMutableTreeNode = defaultMutableTreeNodeArray[n];
        defaultMutableTreeNodeArray[n] = defaultMutableTreeNodeArray[n2];
        defaultMutableTreeNodeArray[n2] = defaultMutableTreeNode;
    }

    private int compare(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        SearchTOCItem searchTOCItem = (SearchTOCItem)defaultMutableTreeNode.getUserObject();
        double d = searchTOCItem.getConfidence();
        int n = searchTOCItem.hitCount();
        SearchTOCItem searchTOCItem2 = (SearchTOCItem)defaultMutableTreeNode2.getUserObject();
        double d2 = searchTOCItem2.getConfidence();
        int n2 = searchTOCItem2.hitCount();
        if (d > d2) {
            return -1;
        }
        if (d < d2) {
            return 1;
        }
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        return 0;
    }

    public synchronized void itemsFound(SearchEvent searchEvent) {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        Enumeration<TreeNode> enumeration = this.topNode.children();
        while (enumeration.hasMoreElements()) {
            object = (DefaultMutableTreeNode)enumeration.nextElement();
            vector.addElement(object);
        }
        BasicSearchNavigatorUI.debug("items found");
        object = this.searchnav.getModel();
        HelpSet helpSet = object.getHelpSet();
        BasicSearchNavigatorUI.debug("hs:" + helpSet.toString());
        Map map = helpSet.getCombinedMap();
        Enumeration enumeration2 = searchEvent.getSearchItems();
        while (enumeration2.hasMoreElements()) {
            SearchTOCItem searchTOCItem;
            URL uRL;
            SearchItem searchItem = (SearchItem)enumeration2.nextElement();
            BasicSearchNavigatorUI.debug("  item: " + searchItem);
            try {
                uRL = new URL(searchItem.getBase(), searchItem.getFilename());
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("Failed to create URL from " + searchItem.getBase() + "|" + searchItem.getFilename());
                continue;
            }
            boolean bl = false;
            DefaultMutableTreeNode defaultMutableTreeNode = null;
            Enumeration enumeration3 = vector.elements();
            while (enumeration3.hasMoreElements()) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration3.nextElement();
                searchTOCItem = (SearchTOCItem)defaultMutableTreeNode.getUserObject();
                URL uRL2 = searchTOCItem.getURL();
                if (uRL2 == null || uRL == null || !uRL.sameFile(uRL2)) continue;
                searchTOCItem = (SearchTOCItem)defaultMutableTreeNode.getUserObject();
                searchTOCItem.addSearchHit(new SearchHit(searchItem.getConfidence(), searchItem.getBegin(), searchItem.getEnd()));
                bl = true;
                break;
            }
            if (bl) continue;
            searchTOCItem = new SearchTOCItem(searchItem);
            defaultMutableTreeNode = new DefaultMutableTreeNode(searchTOCItem);
            vector.addElement(defaultMutableTreeNode);
        }
        this.reorder(vector);
        ((DefaultTreeModel)this.tree.getModel()).reload();
    }

    public synchronized void searchStarted(SearchEvent searchEvent) {
        BasicSearchNavigatorUI.debug("search Started");
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        treeSelectionModel.clearSelection();
        this.topNode.removeAllChildren();
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.tree.invalidate();
        this.tree.repaint();
    }

    public synchronized void searchFinished(SearchEvent searchEvent) {
        BasicSearchNavigatorUI.debug("search Finished");
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        if (this.lastTOCnode == null && this.topNode.getChildCount() > 0) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.topNode.getFirstChild();
            if (defaultMutableTreeNode != null) {
                treeSelectionModel.clearSelection();
                treeSelectionModel.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
            }
        } else {
            this.searchnav.getToolkit().beep();
        }
        this.searchparams.setCursor(this.paramCursor);
        this.tree.setCursor(this.treeCursor);
    }

    private static void debug(String string) {
        if (debug) {
            System.out.println("BasicSearchNavigatorUI: " + string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class SearchActionListener
    implements ActionListener {
        SearchActionListener() {
        }

        public synchronized void actionPerformed(ActionEvent actionEvent) {
            HelpModel helpModel = BasicSearchNavigatorUI.this.searchnav.getModel();
            BasicSearchNavigatorUI.debug("action:" + helpModel.getHelpSet().toString());
            try {
                if (BasicSearchNavigatorUI.this.paramCursor == null) {
                    BasicSearchNavigatorUI.this.paramCursor = BasicSearchNavigatorUI.this.searchparams.getCursor();
                }
                if (BasicSearchNavigatorUI.this.treeCursor == null) {
                    BasicSearchNavigatorUI.this.treeCursor = BasicSearchNavigatorUI.this.tree.getCursor();
                }
                if (BasicSearchNavigatorUI.this.waitCursor == null) {
                    BasicSearchNavigatorUI.this.waitCursor = Cursor.getPredefinedCursor(3);
                }
                BasicSearchNavigatorUI.this.searchparams.setCursor(BasicSearchNavigatorUI.this.waitCursor);
                BasicSearchNavigatorUI.this.tree.setCursor(BasicSearchNavigatorUI.this.waitCursor);
                if (BasicSearchNavigatorUI.this.helpsearch == null) {
                    BasicSearchNavigatorUI.debug("helpsearch is null");
                    BasicSearchNavigatorUI.this.helpsearch = BasicSearchNavigatorUI.this.searchnav.getSearchEngine();
                    BasicSearchNavigatorUI.this.searchquery = BasicSearchNavigatorUI.this.helpsearch.createQuery();
                    BasicSearchNavigatorUI.this.searchquery.addSearchListener(BasicSearchNavigatorUI.this);
                }
                BasicSearchNavigatorUI.debug("click on search w/: " + BasicSearchNavigatorUI.this.searchparams.getText());
                if (BasicSearchNavigatorUI.this.searchquery.isActive()) {
                    BasicSearchNavigatorUI.this.searchquery.stop();
                }
                BasicSearchNavigatorUI.this.searchquery.start(BasicSearchNavigatorUI.this.searchparams.getText(), BasicSearchNavigatorUI.this.searchnav.getLocale());
            }
            catch (Exception exception) {
                BasicSearchNavigatorUI.this.searchparams.setCursor(BasicSearchNavigatorUI.this.paramCursor);
                BasicSearchNavigatorUI.this.tree.setCursor(BasicSearchNavigatorUI.this.treeCursor);
                exception.printStackTrace();
                BasicSearchNavigatorUI.this.searchnav.getToolkit().beep();
                BasicSearchNavigatorUI.this.searchnav.getToolkit().beep();
            }
        }
    }
}

