/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.soap.SOAPException;

class FactoryFinder {
    FactoryFinder() {
    }

    private static Object newInstance(String string) throws SOAPException {
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception exception) {
            throw new SOAPException(exception.toString(), exception);
        }
        try {
            Class<?> clazz = null;
            if (classLoader == null) {
                clazz = Class.forName(string);
            } else {
                try {
                    clazz = classLoader.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (clazz == null) {
                classLoader = FactoryFinder.class.getClassLoader();
                clazz = classLoader.loadClass(string);
            }
            return clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SOAPException("Provider " + string + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            throw new SOAPException("Provider " + string + " could not be instantiated: " + exception, exception);
        }
    }

    static Object find(String string, String string2) throws SOAPException {
        Object object;
        String string3;
        try {
            string3 = System.getProperty(string);
            if (string3 != null) {
                return FactoryFinder.newInstance(string3);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            string3 = System.getProperty("java.home") + File.separator + "lib" + File.separator + "jaxm.properties";
            object = new File(string3);
            if (((File)object).exists()) {
                FileInputStream fileInputStream = new FileInputStream((File)object);
                Properties properties = new Properties();
                properties.load(fileInputStream);
                fileInputStream.close();
                String string4 = properties.getProperty(string);
                return FactoryFinder.newInstance(string4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        string3 = "META-INF/services/" + string;
        try {
            object = FactoryFinder.getResource(string3);
            if (object != null) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object, "UTF-8"));
                String string5 = bufferedReader.readLine();
                bufferedReader.close();
                if (string5 != null && !"".equals(string5)) {
                    return FactoryFinder.newInstance(string5);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string2 == null) {
            throw new SOAPException("Provider for " + string + " cannot be found", null);
        }
        return FactoryFinder.newInstance(string2);
    }

    private static InputStream getResource(String string) {
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        InputStream inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(string) : classLoader.getResourceAsStream(string);
        if (inputStream == null) {
            inputStream = FactoryFinder.class.getClassLoader().getResourceAsStream(string);
        }
        return inputStream;
    }
}

