/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.soap.SOAPFaultException;
import org.apache.axis.Constants;
import org.apache.axis.InternalException;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.NetworkUtils;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class AxisFault
extends RemoteException {
    protected static Log log = LogFactory.getLog(AxisFault.class.getName());
    protected QName faultCode;
    protected Vector faultSubCode;
    protected String faultString = "";
    protected String faultActor;
    protected Vector faultDetails;
    protected String faultNode;
    protected ArrayList faultHeaders = null;

    public static AxisFault makeFault(Exception exception) {
        Throwable throwable;
        if (exception instanceof InvocationTargetException && (throwable = ((InvocationTargetException)exception).getTargetException()) instanceof Exception) {
            exception = (Exception)throwable;
        }
        if (exception instanceof AxisFault) {
            return (AxisFault)exception;
        }
        return new AxisFault(exception);
    }

    public AxisFault(String string, String string2, String string3, Element[] elementArray) {
        this(new QName("http://xml.apache.org/axis/", string), string2, string3, elementArray);
    }

    public AxisFault(QName qName, String string, String string2, Element[] elementArray) {
        super(string);
        this.setFaultCode(qName);
        this.setFaultString(string);
        this.setFaultActor(string2);
        this.setFaultDetail(elementArray);
        if (elementArray == null) {
            this.initFromException(this);
        }
    }

    public AxisFault(QName qName, QName[] qNameArray, String string, String string2, String string3, Element[] elementArray) {
        super(string);
        this.setFaultCode(qName);
        if (qNameArray != null) {
            for (int i = 0; i < qNameArray.length; ++i) {
                this.addFaultSubCode(qNameArray[i]);
            }
        }
        this.setFaultString(string);
        this.setFaultActor(string2);
        this.setFaultNode(string3);
        this.setFaultDetail(elementArray);
        if (elementArray == null) {
            this.initFromException(this);
        }
    }

    protected AxisFault(Exception exception) {
        super("", exception);
        this.setFaultCodeAsString("Server.userException");
        this.initFromException(exception);
        if (exception instanceof SOAPFaultException) {
            this.removeHostname();
            this.initFromSOAPFaultException((SOAPFaultException)exception);
            this.addHostnameIfNeeded();
        }
    }

    public AxisFault(String string) {
        super(string);
        this.setFaultCodeAsString("Server.generalException");
        this.setFaultString(string);
        this.initFromException(this);
    }

    public AxisFault() {
        this.setFaultCodeAsString("Server.generalException");
        this.initFromException(this);
    }

    public AxisFault(String string, Throwable throwable) {
        super(string, throwable);
        this.setFaultCodeAsString("Server.generalException");
        this.setFaultString(this.getMessage());
        this.addHostnameIfNeeded();
    }

    private void initFromException(Exception exception) {
        Element element = this.lookupFaultDetail(Constants.QNAME_FAULTDETAIL_STACKTRACE);
        if (element != null) {
            return;
        }
        this.setFaultString(exception.toString());
        if (exception instanceof AxisFault && exception.getClass() != AxisFault.class) {
            this.addFaultDetail(Constants.QNAME_FAULTDETAIL_EXCEPTIONNAME, exception.getClass().getName());
        }
        if (exception == this) {
            this.addFaultDetail(Constants.QNAME_FAULTDETAIL_STACKTRACE, this.getPlainStackTrace());
        } else {
            this.addFaultDetail(Constants.QNAME_FAULTDETAIL_STACKTRACE, JavaUtils.stackToString(exception));
        }
        this.addHostnameIfNeeded();
    }

    private void initFromSOAPFaultException(SOAPFaultException sOAPFaultException) {
        if (sOAPFaultException.getFaultCode() != null) {
            this.setFaultCode(sOAPFaultException.getFaultCode());
        }
        if (sOAPFaultException.getFaultString() != null) {
            this.setFaultString(sOAPFaultException.getFaultString());
        }
        if (sOAPFaultException.getFaultActor() != null) {
            this.setFaultActor(sOAPFaultException.getFaultActor());
        }
        if (null == sOAPFaultException.getDetail()) {
            return;
        }
        Vector vector = new Vector();
        Iterator iterator = sOAPFaultException.getDetail().getChildElements();
        while (iterator.hasNext()) {
            vector.add(iterator.next());
        }
        this.setFaultDetail(XMLUtils.asElementArray(vector));
    }

    private void initFaultDetails() {
        if (this.faultDetails == null) {
            this.faultDetails = new Vector();
        }
    }

    public void clearFaultDetails() {
        this.faultDetails = null;
    }

    public void dump() {
        log.debug(this.dumpToString());
    }

    public String dumpToString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("AxisFault");
        stringBuffer.append(JavaUtils.LS);
        stringBuffer.append(" faultCode: ");
        stringBuffer.append(XMLUtils.xmlEncodeString(this.faultCode.toString()));
        stringBuffer.append(JavaUtils.LS);
        stringBuffer.append(" faultSubcode: ");
        if (this.faultSubCode != null) {
            for (n = 0; n < this.faultSubCode.size(); ++n) {
                stringBuffer.append(JavaUtils.LS);
                stringBuffer.append(this.faultSubCode.elementAt(n).toString());
            }
        }
        stringBuffer.append(JavaUtils.LS);
        stringBuffer.append(" faultString: ");
        stringBuffer.append(XMLUtils.xmlEncodeString(this.faultString));
        stringBuffer.append(JavaUtils.LS);
        stringBuffer.append(" faultActor: ");
        stringBuffer.append(XMLUtils.xmlEncodeString(this.faultActor));
        stringBuffer.append(JavaUtils.LS);
        stringBuffer.append(" faultNode: ");
        stringBuffer.append(XMLUtils.xmlEncodeString(this.faultNode));
        stringBuffer.append(JavaUtils.LS);
        stringBuffer.append(" faultDetail: ");
        if (this.faultDetails != null) {
            for (n = 0; n < this.faultDetails.size(); ++n) {
                Element element = (Element)this.faultDetails.get(n);
                stringBuffer.append(JavaUtils.LS);
                stringBuffer.append("\t{");
                stringBuffer.append(null == element.getNamespaceURI() ? "" : element.getNamespaceURI());
                stringBuffer.append("}");
                stringBuffer.append(null == element.getLocalName() ? "" : element.getLocalName());
                stringBuffer.append(":");
                stringBuffer.append(XMLUtils.getInnerXMLString(element));
            }
        }
        stringBuffer.append(JavaUtils.LS);
        return stringBuffer.toString();
    }

    public void setFaultCode(QName qName) {
        this.faultCode = qName;
    }

    public void setFaultCode(String string) {
        this.setFaultCodeAsString(string);
    }

    public void setFaultCodeAsString(String string) {
        SOAPConstants sOAPConstants = MessageContext.getCurrentContext() == null ? SOAPConstants.SOAP11_CONSTANTS : MessageContext.getCurrentContext().getSOAPConstants();
        this.faultCode = new QName(sOAPConstants.getEnvelopeURI(), string);
    }

    public QName getFaultCode() {
        return this.faultCode;
    }

    public void addFaultSubCodeAsString(String string) {
        this.initFaultSubCodes();
        this.faultSubCode.add(new QName("http://xml.apache.org/axis/", string));
    }

    protected void initFaultSubCodes() {
        if (this.faultSubCode == null) {
            this.faultSubCode = new Vector();
        }
    }

    public void addFaultSubCode(QName qName) {
        this.initFaultSubCodes();
        this.faultSubCode.add(qName);
    }

    public void clearFaultSubCodes() {
        this.faultSubCode = null;
    }

    public QName[] getFaultSubCodes() {
        if (this.faultSubCode == null) {
            return null;
        }
        QName[] qNameArray = new QName[this.faultSubCode.size()];
        return this.faultSubCode.toArray(qNameArray);
    }

    public void setFaultString(String string) {
        this.faultString = string != null ? string : "";
    }

    public String getFaultString() {
        return this.faultString;
    }

    public void setFaultReason(String string) {
        this.setFaultString(string);
    }

    public String getFaultReason() {
        return this.getFaultString();
    }

    public void setFaultActor(String string) {
        this.faultActor = string;
    }

    public String getFaultActor() {
        return this.faultActor;
    }

    public String getFaultRole() {
        return this.getFaultActor();
    }

    public void setFaultRole(String string) {
        this.setFaultActor(string);
    }

    public String getFaultNode() {
        return this.faultNode;
    }

    public void setFaultNode(String string) {
        this.faultNode = string;
    }

    public void setFaultDetail(Element[] elementArray) {
        if (elementArray == null) {
            this.faultDetails = null;
            return;
        }
        this.faultDetails = new Vector(elementArray.length);
        for (int i = 0; i < elementArray.length; ++i) {
            this.faultDetails.add(elementArray[i]);
        }
    }

    public void setFaultDetailString(String string) {
        this.clearFaultDetails();
        this.addFaultDetailString(string);
    }

    public void addFaultDetailString(String string) {
        this.initFaultDetails();
        try {
            Document document = XMLUtils.newDocument();
            Element element = document.createElement("string");
            Text text = document.createTextNode(string);
            element.appendChild(text);
            this.faultDetails.add(element);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new InternalException(parserConfigurationException);
        }
    }

    public void addFaultDetail(Element element) {
        this.initFaultDetails();
        this.faultDetails.add(element);
    }

    public void addFaultDetail(QName qName, String string) {
        Element element = XMLUtils.StringToElement(qName.getNamespaceURI(), qName.getLocalPart(), string);
        this.addFaultDetail(element);
    }

    public Element[] getFaultDetails() {
        if (this.faultDetails == null) {
            return null;
        }
        Element[] elementArray = new Element[this.faultDetails.size()];
        for (int i = 0; i < elementArray.length; ++i) {
            elementArray[i] = (Element)this.faultDetails.elementAt(i);
        }
        return elementArray;
    }

    public Element lookupFaultDetail(QName qName) {
        if (this.faultDetails != null) {
            String string = qName.getNamespaceURI();
            String string2 = qName.getLocalPart();
            for (Element element : this.faultDetails) {
                String string3;
                String string4 = element.getLocalName();
                if (string4 == null) {
                    string4 = element.getNodeName();
                }
                if ((string3 = element.getNamespaceURI()) == null) {
                    string3 = "";
                }
                if (!string.equals(string3) || !string2.equals(string4)) continue;
                return element;
            }
        }
        return null;
    }

    public boolean removeFaultDetail(QName qName) {
        Element element = this.lookupFaultDetail(qName);
        if (element == null) {
            return false;
        }
        return this.faultDetails.remove(element);
    }

    public void output(SerializationContext serializationContext) throws Exception {
        SOAPConstants sOAPConstants = Constants.DEFAULT_SOAP_VERSION;
        if (serializationContext.getMessageContext() != null) {
            sOAPConstants = serializationContext.getMessageContext().getSOAPConstants();
        }
        SOAPEnvelope sOAPEnvelope = new SOAPEnvelope(sOAPConstants);
        SOAPFault sOAPFault = new SOAPFault(this);
        sOAPEnvelope.addBodyElement(sOAPFault);
        if (this.faultHeaders != null) {
            for (SOAPHeaderElement sOAPHeaderElement : this.faultHeaders) {
                sOAPEnvelope.addHeader(sOAPHeaderElement);
            }
        }
        sOAPEnvelope.output(serializationContext);
    }

    public String toString() {
        return this.faultString;
    }

    private String getPlainStackTrace() {
        StringWriter stringWriter = new StringWriter(512);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.printStackTrace(printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    public void printStackTrace(PrintStream printStream) {
        printStream.println(this.dumpToString());
        super.printStackTrace(printStream);
    }

    public void printStackTrace(PrintWriter printWriter) {
        printWriter.println(this.dumpToString());
        super.printStackTrace(printWriter);
    }

    public void addHeader(SOAPHeaderElement sOAPHeaderElement) {
        if (this.faultHeaders == null) {
            this.faultHeaders = new ArrayList();
        }
        this.faultHeaders.add(sOAPHeaderElement);
    }

    public ArrayList getHeaders() {
        return this.faultHeaders;
    }

    public void clearHeaders() {
        this.faultHeaders = null;
    }

    public void writeDetails(QName qName, SerializationContext serializationContext) throws IOException {
        Throwable throwable = this.detail;
        if (throwable == null) {
            return;
        }
        boolean bl = false;
        try {
            if (serializationContext.getTypeMapping().getSerializer(throwable.getClass()) != null) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            boolean bl2 = serializationContext.getDoMultiRefs();
            serializationContext.setDoMultiRefs(false);
            serializationContext.serialize(qName, null, throwable);
            serializationContext.setDoMultiRefs(bl2);
        }
    }

    public void addHostnameIfNeeded() {
        if (this.lookupFaultDetail(Constants.QNAME_FAULTDETAIL_HOSTNAME) != null) {
            return;
        }
        this.addHostname(NetworkUtils.getLocalHostname());
    }

    public void addHostname(String string) {
        this.removeHostname();
        this.addFaultDetail(Constants.QNAME_FAULTDETAIL_HOSTNAME, string);
    }

    public void removeHostname() {
        this.removeFaultDetail(Constants.QNAME_FAULTDETAIL_HOSTNAME);
    }
}

