/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Handler;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class FaultableHandler
extends BasicHandler {
    protected static Log log = LogFactory.getLog(FaultableHandler.class.getName());
    protected static Log entLog = LogFactory.getLog("org.apache.axis.enterprise");
    protected Handler workHandler;

    public FaultableHandler(Handler handler) {
        this.workHandler = handler;
    }

    public void init() {
        this.workHandler.init();
    }

    public void cleanup() {
        this.workHandler.cleanup();
    }

    public void invoke(MessageContext messageContext) throws AxisFault {
        log.debug("Enter: FaultableHandler::invoke");
        try {
            this.workHandler.invoke(messageContext);
        }
        catch (Exception exception) {
            entLog.info(Messages.getMessage("toAxisFault00"), exception);
            AxisFault axisFault = AxisFault.makeFault(exception);
            Handler handler = null;
            Hashtable hashtable = this.getOptions();
            if (hashtable != null) {
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    if (!string.equals("fault-" + axisFault.getFaultCode().getLocalPart())) continue;
                    handler = (Handler)hashtable.get(string);
                }
            }
            if (handler != null) {
                handler.invoke(messageContext);
            }
            throw axisFault;
        }
        log.debug("Exit: FaultableHandler::invoke");
    }

    public void onFault(MessageContext messageContext) {
        log.debug("Enter: FaultableHandler::onFault");
        this.workHandler.onFault(messageContext);
        log.debug("Exit: FaultableHandler::onFault");
    }

    public boolean canHandleBlock(QName qName) {
        return this.workHandler.canHandleBlock(qName);
    }
}

