/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.attachments;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis.Part;
import org.apache.axis.attachments.ManagedMemoryDataSource;
import org.apache.axis.components.image.ImageIOFactory;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.utils.IOUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.SessionUtils;
import org.apache.commons.logging.Log;

public class AttachmentPart
extends javax.xml.soap.AttachmentPart
implements Part {
    protected static Log log = LogFactory.getLog(AttachmentPart.class.getName());
    DataHandler datahandler = null;
    private MimeHeaders mimeHeaders = new MimeHeaders();
    private Object contentObject;
    private String attachmentFile;

    public AttachmentPart() {
        this.setMimeHeader("Content-Id", SessionUtils.generateSessionId());
    }

    public AttachmentPart(DataHandler dataHandler) {
        this.setMimeHeader("Content-Id", SessionUtils.generateSessionId());
        this.datahandler = dataHandler;
        if (dataHandler != null) {
            this.setMimeHeader("Content-Type", dataHandler.getContentType());
            DataSource dataSource = dataHandler.getDataSource();
            if (dataSource instanceof ManagedMemoryDataSource) {
                this.extractFilename((ManagedMemoryDataSource)dataSource);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public DataHandler getActivationDataHandler() {
        return this.datahandler;
    }

    public String getContentType() {
        return this.getFirstMimeHeader("Content-Type");
    }

    public void addMimeHeader(String string, String string2) {
        this.mimeHeaders.addHeader(string, string2);
    }

    public String getFirstMimeHeader(String string) {
        String[] stringArray = this.mimeHeaders.getHeader(string.toLowerCase());
        if (stringArray != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public boolean matches(MimeHeaders mimeHeaders) {
        Iterator iterator = mimeHeaders.getAllHeaders();
        while (iterator.hasNext()) {
            MimeHeader mimeHeader = (MimeHeader)iterator.next();
            String[] stringArray = this.mimeHeaders.getHeader(mimeHeader.getName());
            boolean bl = false;
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!mimeHeader.getValue().equalsIgnoreCase(stringArray[i])) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public String getContentLocation() {
        return this.getFirstMimeHeader("Content-Location");
    }

    public void setContentLocation(String string) {
        this.setMimeHeader("Content-Location", string);
    }

    public void setContentId(String string) {
        this.setMimeHeader("Content-Id", string);
    }

    public String getContentId() {
        return this.getFirstMimeHeader("Content-Id");
    }

    public Iterator getMatchingMimeHeaders(String[] stringArray) {
        return this.mimeHeaders.getMatchingHeaders(stringArray);
    }

    public Iterator getNonMatchingMimeHeaders(String[] stringArray) {
        return this.mimeHeaders.getNonMatchingHeaders(stringArray);
    }

    public Iterator getAllMimeHeaders() {
        return this.mimeHeaders.getAllHeaders();
    }

    public void setMimeHeader(String string, String string2) {
        this.mimeHeaders.setHeader(string, string2);
    }

    public void removeAllMimeHeaders() {
        this.mimeHeaders.removeAllHeaders();
    }

    public void removeMimeHeader(String string) {
        this.mimeHeaders.removeHeader(string);
    }

    public DataHandler getDataHandler() throws SOAPException {
        if (this.datahandler == null) {
            throw new SOAPException(Messages.getMessage("noContent"));
        }
        return this.datahandler;
    }

    public void setDataHandler(DataHandler dataHandler) {
        if (dataHandler == null) {
            throw new IllegalArgumentException(Messages.getMessage("illegalArgumentException00"));
        }
        this.datahandler = dataHandler;
        this.setMimeHeader("Content-Type", dataHandler.getContentType());
        DataSource dataSource = dataHandler.getDataSource();
        if (dataSource instanceof ManagedMemoryDataSource) {
            this.extractFilename((ManagedMemoryDataSource)dataSource);
        }
    }

    public Object getContent() throws SOAPException {
        if (this.contentObject != null) {
            return this.contentObject;
        }
        if (this.datahandler == null) {
            throw new SOAPException(Messages.getMessage("noContent"));
        }
        DataSource dataSource = this.datahandler.getDataSource();
        InputStream inputStream = null;
        try {
            inputStream = dataSource.getInputStream();
        }
        catch (IOException iOException) {
            log.error(Messages.getMessage("javaIOException00"), iOException);
            throw new SOAPException(iOException);
        }
        if (dataSource.getContentType().equals("text/plain")) {
            try {
                byte[] byArray = new byte[inputStream.available()];
                IOUtils.readFully(inputStream, byArray);
                return new String(byArray);
            }
            catch (IOException iOException) {
                log.error(Messages.getMessage("javaIOException00"), iOException);
                throw new SOAPException(iOException);
            }
        }
        if (dataSource.getContentType().equals("text/xml")) {
            return new StreamSource(inputStream);
        }
        if (dataSource.getContentType().equals("image/gif") || dataSource.getContentType().equals("image/jpeg")) {
            try {
                return ImageIOFactory.getImageIO().loadImage(inputStream);
            }
            catch (Exception exception) {
                log.error(Messages.getMessage("javaIOException00"), exception);
                throw new SOAPException(exception);
            }
        }
        return inputStream;
    }

    public void setContent(Object object, String string) {
        ManagedMemoryDataSource managedMemoryDataSource = null;
        this.setMimeHeader("Content-Type", string);
        if (object instanceof String) {
            try {
                String string2 = (String)object;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
                managedMemoryDataSource = new ManagedMemoryDataSource(byteArrayInputStream, 16384, string, true);
                this.extractFilename(managedMemoryDataSource);
                this.datahandler = new DataHandler(managedMemoryDataSource);
                this.contentObject = object;
                return;
            }
            catch (IOException iOException) {
                log.error(Messages.getMessage("javaIOException00"), iOException);
                throw new IllegalArgumentException(Messages.getMessage("illegalArgumentException00"));
            }
        }
        if (object instanceof InputStream) {
            try {
                managedMemoryDataSource = new ManagedMemoryDataSource((InputStream)object, 16384, string, true);
                this.extractFilename(managedMemoryDataSource);
                this.datahandler = new DataHandler(managedMemoryDataSource);
                this.contentObject = null;
                return;
            }
            catch (IOException iOException) {
                log.error(Messages.getMessage("javaIOException00"), iOException);
                throw new IllegalArgumentException(Messages.getMessage("illegalArgumentException00"));
            }
        }
        if (object instanceof StreamSource) {
            try {
                managedMemoryDataSource = new ManagedMemoryDataSource(((StreamSource)object).getInputStream(), 16384, string, true);
                this.extractFilename(managedMemoryDataSource);
                this.datahandler = new DataHandler(managedMemoryDataSource);
                this.contentObject = null;
                return;
            }
            catch (IOException iOException) {
                log.error(Messages.getMessage("javaIOException00"), iOException);
                throw new IllegalArgumentException(Messages.getMessage("illegalArgumentException00"));
            }
        }
        throw new IllegalArgumentException(Messages.getMessage("illegalArgumentException00"));
    }

    public void clearContent() {
        this.datahandler = null;
        this.contentObject = null;
    }

    public int getSize() throws SOAPException {
        if (this.datahandler == null) {
            return 0;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.datahandler.writeTo(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            log.error(Messages.getMessage("javaIOException00"), iOException);
            throw new SOAPException(Messages.getMessage("javaIOException01", iOException.getMessage()), iOException);
        }
        return byteArrayOutputStream.size();
    }

    public String[] getMimeHeader(String string) {
        return this.mimeHeaders.getHeader(string);
    }

    public String getContentIdRef() {
        return "cid:" + this.getContentId();
    }

    private void extractFilename(ManagedMemoryDataSource managedMemoryDataSource) {
        if (managedMemoryDataSource.getDiskCacheFile() != null) {
            String string = managedMemoryDataSource.getDiskCacheFile().getAbsolutePath();
            this.setAttachmentFile(string);
        }
    }

    protected void setAttachmentFile(String string) {
        this.attachmentFile = string;
    }

    public void detachAttachmentFile() {
        this.attachmentFile = null;
    }

    public String getAttachmentFile() {
        return this.attachmentFile;
    }

    public synchronized void dispose() {
        if (this.attachmentFile != null) {
            DataSource dataSource = this.datahandler.getDataSource();
            if (dataSource instanceof ManagedMemoryDataSource) {
                ((ManagedMemoryDataSource)dataSource).delete();
            } else {
                File file = new File(this.attachmentFile);
                file.delete();
            }
            this.setAttachmentFile(null);
        }
        this.datahandler = null;
    }
}

