/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.Holder;
import org.apache.axis.client.Call;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.utils.JavaUtils;

public class AxisClientProxy
implements InvocationHandler {
    private Call call;
    private QName portName;

    AxisClientProxy(Call call, QName qName) {
        this.call = call;
        this.portName = qName;
    }

    private Object[] proxyParams2CallParams(Object[] objectArray) throws JavaUtils.HolderException {
        OperationDesc operationDesc = this.call.getOperation();
        if (operationDesc == null) {
            return objectArray;
        }
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
            Object object = objectArray[i];
            ParameterDesc parameterDesc = operationDesc.getParameter(i);
            if (parameterDesc.getMode() == 3) {
                vector.add(JavaUtils.getHolderValue((Holder)object));
                continue;
            }
            if (parameterDesc.getMode() != 1) continue;
            vector.add(object);
        }
        return vector.toArray();
    }

    private void callOutputParams2proxyParams(Object[] objectArray) throws JavaUtils.HolderException {
        OperationDesc operationDesc = this.call.getOperation();
        if (operationDesc == null) {
            return;
        }
        Map map = this.call.getOutputParams();
        for (int i = 0; i < operationDesc.getNumParams(); ++i) {
            Object object = objectArray[i];
            ParameterDesc parameterDesc = operationDesc.getParameter(i);
            if (parameterDesc.getMode() != 3 && parameterDesc.getMode() != 2) continue;
            JavaUtils.setHolderValue((Holder)object, map.get(parameterDesc.getQName()));
        }
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Object object2;
        if (method.getName().equals("_setProperty")) {
            this.call.setProperty((String)objectArray[0], objectArray[1]);
            return null;
        }
        if (method.getName().equals("_getProperty")) {
            return this.call.getProperty((String)objectArray[0]);
        }
        if (method.getName().equals("_getPropertyNames")) {
            return this.call.getPropertyNames();
        }
        if (Object.class.equals(method.getDeclaringClass())) {
            return method.invoke((Object)this.call, objectArray);
        }
        if (this.call.getTargetEndpointAddress() != null && this.call.getPortName() != null) {
            this.call.setOperation(method.getName());
            Object[] objectArray2 = this.proxyParams2CallParams(objectArray);
            object2 = this.call.invoke(objectArray2);
        } else if (this.portName != null) {
            this.call.setOperation(this.portName, method.getName());
            Object[] objectArray3 = this.proxyParams2CallParams(objectArray);
            object2 = this.call.invoke(objectArray3);
        } else {
            Object[] objectArray4 = objectArray;
            object2 = this.call.invoke(method.getName(), objectArray4);
        }
        this.callOutputParams2proxyParams(objectArray);
        return object2;
    }

    public Call getCall() {
        return this.call;
    }
}

