/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.components.net;

import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.X509TrustManager;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.components.net.SunJSSESocketFactory;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class SunFakeTrustSocketFactory
extends SunJSSESocketFactory {
    protected static Log log = LogFactory.getLog(SunFakeTrustSocketFactory.class.getName());

    public SunFakeTrustSocketFactory(Hashtable hashtable) {
        super(hashtable);
    }

    protected SSLContext getContext() throws Exception {
        try {
            SSLContext sSLContext = SSLContext.getInstance((String)"SSL");
            sSLContext.init(null, new TrustManager[]{new FakeX509TrustManager()}, new SecureRandom());
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("ftsf00"));
            }
            return sSLContext;
        }
        catch (Exception exception) {
            log.error(Messages.getMessage("ftsf01"), exception);
            throw new Exception(Messages.getMessage("ftsf02"));
        }
    }

    public static class FakeX509TrustManager
    implements X509TrustManager {
        protected static Log log = LogFactory.getLog(FakeX509TrustManager.class.getName());

        public boolean isClientTrusted(X509Certificate[] x509CertificateArray) {
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("ftsf03"));
            }
            return true;
        }

        public boolean isServerTrusted(X509Certificate[] x509CertificateArray) {
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("ftsf04"));
            }
            return true;
        }

        public X509Certificate[] getAcceptedIssuers() {
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("ftsf05"));
            }
            return null;
        }
    }
}

