/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.components.uuid;

import java.security.SecureRandom;
import java.util.Random;
import org.apache.axis.components.uuid.UUIDGen;

public class FastUUIDGen
implements UUIDGen {
    private static Random secureRandom;
    private static String nodeStr;
    private static int clockSequence;
    private long lastTime = 0L;

    private static String getNodeHexValue() {
        long l = 0L;
        long l2 = 0L;
        while ((l = FastUUIDGen.getBitsValue(l2, 47, 47)) == 0L) {
            l2 = secureRandom.nextLong();
        }
        return FastUUIDGen.leftZeroPadString(Long.toHexString(l |= 0x800000000000L), 12);
    }

    private static int getClockSequence() {
        return secureRandom.nextInt(16384);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String nextUUID() {
        long l = System.currentTimeMillis();
        long l2 = l * 10000L;
        l2 += 122192927672762368L;
        l2 += 327237632L;
        FastUUIDGen fastUUIDGen = this;
        synchronized (fastUUIDGen) {
            if (l - this.lastTime <= 0L) {
                clockSequence = clockSequence + 1 & 0x3FFF;
            }
            this.lastTime = l;
        }
        long l3 = FastUUIDGen.getBitsValue(l2, 32, 32);
        long l4 = FastUUIDGen.getBitsValue(l2, 48, 16);
        long l5 = FastUUIDGen.getBitsValue(l2, 64, 16) | 0x1000L;
        long l6 = FastUUIDGen.getBitsValue(clockSequence, 8, 8);
        long l7 = FastUUIDGen.getBitsValue(clockSequence, 16, 8) | 0x80L;
        String string = FastUUIDGen.leftZeroPadString(Long.toHexString(l3), 8);
        String string2 = FastUUIDGen.leftZeroPadString(Long.toHexString(l4), 4);
        String string3 = FastUUIDGen.leftZeroPadString(Long.toHexString(l5), 4);
        String string4 = FastUUIDGen.leftZeroPadString(Long.toHexString(l7), 2);
        String string5 = FastUUIDGen.leftZeroPadString(Long.toHexString(l6), 2);
        StringBuffer stringBuffer = new StringBuffer(36);
        stringBuffer.append(string).append("-");
        stringBuffer.append(string2).append("-");
        stringBuffer.append(string3).append("-");
        stringBuffer.append(string4).append(string5);
        stringBuffer.append("-").append(nodeStr);
        return stringBuffer.toString();
    }

    private static long getBitsValue(long l, int n, int n2) {
        return l << 64 - n >>> 64 - n2;
    }

    private static final String leftZeroPadString(String string, int n) {
        if (string.length() < n) {
            int n2 = n - string.length();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
            string = stringBuffer.toString();
        }
        return string;
    }

    static {
        try {
            secureRandom = SecureRandom.getInstance("SHA1PRNG", "SUN");
        }
        catch (Exception exception) {
            secureRandom = new Random();
        }
        nodeStr = FastUUIDGen.getNodeHexValue();
        clockSequence = FastUUIDGen.getClockSequence();
    }
}

